/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.services;

import com.google.ads.googleads.v15.services.KeywordPlanOperation;
import com.google.ads.googleads.v15.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v15.services.MutateKeywordPlansRequest;
import com.google.ads.googleads.v15.services.MutateKeywordPlansResponse;
import com.google.ads.googleads.v15.services.stub.KeywordPlanServiceStub;
import com.google.ads.googleads.v15.services.stub.KeywordPlanServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class KeywordPlanServiceClient
implements BackgroundResource {
    private final KeywordPlanServiceSettings settings;
    private final KeywordPlanServiceStub stub;

    public static final KeywordPlanServiceClient create() throws IOException {
        return KeywordPlanServiceClient.create(KeywordPlanServiceSettings.newBuilder().build());
    }

    public static final KeywordPlanServiceClient create(KeywordPlanServiceSettings settings) throws IOException {
        return new KeywordPlanServiceClient(settings);
    }

    public static final KeywordPlanServiceClient create(KeywordPlanServiceStub stub) {
        return new KeywordPlanServiceClient(stub);
    }

    protected KeywordPlanServiceClient(KeywordPlanServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeywordPlanServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected KeywordPlanServiceClient(KeywordPlanServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeywordPlanServiceSettings getSettings() {
        return this.settings;
    }

    public KeywordPlanServiceStub getStub() {
        return this.stub;
    }

    public final MutateKeywordPlansResponse mutateKeywordPlans(String customerId, List<KeywordPlanOperation> operations) {
        MutateKeywordPlansRequest request = MutateKeywordPlansRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateKeywordPlans(request);
    }

    public final MutateKeywordPlansResponse mutateKeywordPlans(MutateKeywordPlansRequest request) {
        return (MutateKeywordPlansResponse)this.mutateKeywordPlansCallable().call((Object)request);
    }

    public final UnaryCallable<MutateKeywordPlansRequest, MutateKeywordPlansResponse> mutateKeywordPlansCallable() {
        return this.stub.mutateKeywordPlansCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

