/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.services.stub;

import com.google.ads.googleads.v15.services.GenerateAdGroupThemesRequest;
import com.google.ads.googleads.v15.services.GenerateAdGroupThemesResponse;
import com.google.ads.googleads.v15.services.GenerateKeywordForecastMetricsRequest;
import com.google.ads.googleads.v15.services.GenerateKeywordForecastMetricsResponse;
import com.google.ads.googleads.v15.services.GenerateKeywordHistoricalMetricsRequest;
import com.google.ads.googleads.v15.services.GenerateKeywordHistoricalMetricsResponse;
import com.google.ads.googleads.v15.services.GenerateKeywordIdeaResponse;
import com.google.ads.googleads.v15.services.GenerateKeywordIdeaResult;
import com.google.ads.googleads.v15.services.GenerateKeywordIdeasRequest;
import com.google.ads.googleads.v15.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v15.services.stub.GrpcKeywordPlanIdeaServiceStub;
import com.google.ads.googleads.v15.services.stub.KeywordPlanIdeaServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class KeywordPlanIdeaServiceStubSettings
extends StubSettings<KeywordPlanIdeaServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final PagedCallSettings<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> generateKeywordIdeasSettings;
    private final UnaryCallSettings<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsSettings;
    private final UnaryCallSettings<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesSettings;
    private final UnaryCallSettings<GenerateKeywordForecastMetricsRequest, GenerateKeywordForecastMetricsResponse> generateKeywordForecastMetricsSettings;
    private static final PagedListDescriptor<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult> GENERATE_KEYWORD_IDEAS_PAGE_STR_DESC = new PagedListDescriptor<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult>(){

        public String emptyToken() {
            return "";
        }

        public GenerateKeywordIdeasRequest injectToken(GenerateKeywordIdeasRequest payload, String token) {
            return GenerateKeywordIdeasRequest.newBuilder(payload).setPageToken(token).build();
        }

        public GenerateKeywordIdeasRequest injectPageSize(GenerateKeywordIdeasRequest payload, int pageSize) {
            return GenerateKeywordIdeasRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(GenerateKeywordIdeasRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(GenerateKeywordIdeaResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GenerateKeywordIdeaResult> extractResources(GenerateKeywordIdeaResponse payload) {
            return payload.getResultsList() == null ? ImmutableList.of() : payload.getResultsList();
        }
    };
    private static final PagedListResponseFactory<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> GENERATE_KEYWORD_IDEAS_PAGE_STR_FACT = new PagedListResponseFactory<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse>(){

        public ApiFuture<KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> getFuturePagedResponse(UnaryCallable<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse> callable, GenerateKeywordIdeasRequest request, ApiCallContext context, ApiFuture<GenerateKeywordIdeaResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GENERATE_KEYWORD_IDEAS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse.createAsync((PageContext<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> generateKeywordIdeasSettings() {
        return this.generateKeywordIdeasSettings;
    }

    public UnaryCallSettings<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsSettings() {
        return this.generateKeywordHistoricalMetricsSettings;
    }

    public UnaryCallSettings<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesSettings() {
        return this.generateAdGroupThemesSettings;
    }

    public UnaryCallSettings<GenerateKeywordForecastMetricsRequest, GenerateKeywordForecastMetricsResponse> generateKeywordForecastMetricsSettings() {
        return this.generateKeywordForecastMetricsSettings;
    }

    public KeywordPlanIdeaServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcKeywordPlanIdeaServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return KeywordPlanIdeaServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KeywordPlanIdeaServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected KeywordPlanIdeaServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.generateKeywordIdeasSettings = settingsBuilder.generateKeywordIdeasSettings().build();
        this.generateKeywordHistoricalMetricsSettings = settingsBuilder.generateKeywordHistoricalMetricsSettings().build();
        this.generateAdGroupThemesSettings = settingsBuilder.generateAdGroupThemesSettings().build();
        this.generateKeywordForecastMetricsSettings = settingsBuilder.generateKeywordForecastMetricsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<KeywordPlanIdeaServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> generateKeywordIdeasSettings;
        private final UnaryCallSettings.Builder<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsSettings;
        private final UnaryCallSettings.Builder<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesSettings;
        private final UnaryCallSettings.Builder<GenerateKeywordForecastMetricsRequest, GenerateKeywordForecastMetricsResponse> generateKeywordForecastMetricsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.generateKeywordIdeasSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GENERATE_KEYWORD_IDEAS_PAGE_STR_FACT);
            this.generateKeywordHistoricalMetricsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateAdGroupThemesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateKeywordForecastMetricsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateKeywordIdeasSettings, this.generateKeywordHistoricalMetricsSettings, this.generateAdGroupThemesSettings, this.generateKeywordForecastMetricsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(KeywordPlanIdeaServiceStubSettings settings) {
            super((StubSettings)settings);
            this.generateKeywordIdeasSettings = settings.generateKeywordIdeasSettings.toBuilder();
            this.generateKeywordHistoricalMetricsSettings = settings.generateKeywordHistoricalMetricsSettings.toBuilder();
            this.generateAdGroupThemesSettings = settings.generateAdGroupThemesSettings.toBuilder();
            this.generateKeywordForecastMetricsSettings = settings.generateKeywordForecastMetricsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateKeywordIdeasSettings, this.generateKeywordHistoricalMetricsSettings, this.generateAdGroupThemesSettings, this.generateKeywordForecastMetricsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(KeywordPlanIdeaServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)KeywordPlanIdeaServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KeywordPlanIdeaServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(KeywordPlanIdeaServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(KeywordPlanIdeaServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.generateKeywordIdeasSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateKeywordHistoricalMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateAdGroupThemesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateKeywordForecastMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, KeywordPlanIdeaServiceClient.GenerateKeywordIdeasPagedResponse> generateKeywordIdeasSettings() {
            return this.generateKeywordIdeasSettings;
        }

        public UnaryCallSettings.Builder<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsSettings() {
            return this.generateKeywordHistoricalMetricsSettings;
        }

        public UnaryCallSettings.Builder<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesSettings() {
            return this.generateAdGroupThemesSettings;
        }

        public UnaryCallSettings.Builder<GenerateKeywordForecastMetricsRequest, GenerateKeywordForecastMetricsResponse> generateKeywordForecastMetricsSettings() {
            return this.generateKeywordForecastMetricsSettings;
        }

        public KeywordPlanIdeaServiceStubSettings build() throws IOException {
            return new KeywordPlanIdeaServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

