/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.services;

import com.google.ads.googleads.v15.services.MutateSharedSetsRequest;
import com.google.ads.googleads.v15.services.MutateSharedSetsResponse;
import com.google.ads.googleads.v15.services.SharedSetOperation;
import com.google.ads.googleads.v15.services.SharedSetServiceSettings;
import com.google.ads.googleads.v15.services.stub.SharedSetServiceStub;
import com.google.ads.googleads.v15.services.stub.SharedSetServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SharedSetServiceClient
implements BackgroundResource {
    private final SharedSetServiceSettings settings;
    private final SharedSetServiceStub stub;

    public static final SharedSetServiceClient create() throws IOException {
        return SharedSetServiceClient.create(SharedSetServiceSettings.newBuilder().build());
    }

    public static final SharedSetServiceClient create(SharedSetServiceSettings settings) throws IOException {
        return new SharedSetServiceClient(settings);
    }

    public static final SharedSetServiceClient create(SharedSetServiceStub stub) {
        return new SharedSetServiceClient(stub);
    }

    protected SharedSetServiceClient(SharedSetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SharedSetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SharedSetServiceClient(SharedSetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SharedSetServiceSettings getSettings() {
        return this.settings;
    }

    public SharedSetServiceStub getStub() {
        return this.stub;
    }

    public final MutateSharedSetsResponse mutateSharedSets(String customerId, List<SharedSetOperation> operations) {
        MutateSharedSetsRequest request = MutateSharedSetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateSharedSets(request);
    }

    public final MutateSharedSetsResponse mutateSharedSets(MutateSharedSetsRequest request) {
        return (MutateSharedSetsResponse)this.mutateSharedSetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateSharedSetsRequest, MutateSharedSetsResponse> mutateSharedSetsCallable() {
        return this.stub.mutateSharedSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

