/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.services.stub;

import com.google.ads.googleads.v15.resources.GoogleAdsField;
import com.google.ads.googleads.v15.services.GetGoogleAdsFieldRequest;
import com.google.ads.googleads.v15.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v15.services.SearchGoogleAdsFieldsRequest;
import com.google.ads.googleads.v15.services.SearchGoogleAdsFieldsResponse;
import com.google.ads.googleads.v15.services.stub.GoogleAdsFieldServiceStub;
import com.google.ads.googleads.v15.services.stub.GrpcGoogleAdsFieldServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class GoogleAdsFieldServiceStubSettings
extends StubSettings<GoogleAdsFieldServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldSettings;
    private final PagedCallSettings<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> searchGoogleAdsFieldsSettings;
    private static final PagedListDescriptor<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField> SEARCH_GOOGLE_ADS_FIELDS_PAGE_STR_DESC = new PagedListDescriptor<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField>(){

        public String emptyToken() {
            return "";
        }

        public SearchGoogleAdsFieldsRequest injectToken(SearchGoogleAdsFieldsRequest payload, String token) {
            return SearchGoogleAdsFieldsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public SearchGoogleAdsFieldsRequest injectPageSize(SearchGoogleAdsFieldsRequest payload, int pageSize) {
            return SearchGoogleAdsFieldsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchGoogleAdsFieldsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchGoogleAdsFieldsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GoogleAdsField> extractResources(SearchGoogleAdsFieldsResponse payload) {
            return payload.getResultsList() == null ? ImmutableList.of() : payload.getResultsList();
        }
    };
    private static final PagedListResponseFactory<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> SEARCH_GOOGLE_ADS_FIELDS_PAGE_STR_FACT = new PagedListResponseFactory<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse>(){

        public ApiFuture<GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse> callable, SearchGoogleAdsFieldsRequest request, ApiCallContext context, ApiFuture<SearchGoogleAdsFieldsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_GOOGLE_ADS_FIELDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse.createAsync((PageContext<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldSettings() {
        return this.getGoogleAdsFieldSettings;
    }

    public PagedCallSettings<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> searchGoogleAdsFieldsSettings() {
        return this.searchGoogleAdsFieldsSettings;
    }

    public GoogleAdsFieldServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGoogleAdsFieldServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return GoogleAdsFieldServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "googleads";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GoogleAdsFieldServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GoogleAdsFieldServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GoogleAdsFieldServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getGoogleAdsFieldSettings = settingsBuilder.getGoogleAdsFieldSettings().build();
        this.searchGoogleAdsFieldsSettings = settingsBuilder.searchGoogleAdsFieldsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GoogleAdsFieldServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldSettings;
        private final PagedCallSettings.Builder<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> searchGoogleAdsFieldsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getGoogleAdsFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchGoogleAdsFieldsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_GOOGLE_ADS_FIELDS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getGoogleAdsFieldSettings, this.searchGoogleAdsFieldsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GoogleAdsFieldServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getGoogleAdsFieldSettings = settings.getGoogleAdsFieldSettings.toBuilder();
            this.searchGoogleAdsFieldsSettings = settings.searchGoogleAdsFieldsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getGoogleAdsFieldSettings, this.searchGoogleAdsFieldsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GoogleAdsFieldServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GoogleAdsFieldServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GoogleAdsFieldServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GoogleAdsFieldServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getGoogleAdsFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchGoogleAdsFieldsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldSettings() {
            return this.getGoogleAdsFieldSettings;
        }

        public PagedCallSettings.Builder<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> searchGoogleAdsFieldsSettings() {
            return this.searchGoogleAdsFieldsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return GoogleAdsFieldServiceStubSettings.getDefaultEndpoint();
        }

        public GoogleAdsFieldServiceStubSettings build() throws IOException {
            return new GoogleAdsFieldServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

