/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetSetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_SET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetSets/{asset_set_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetSetId;

    @Deprecated
    protected AssetSetName() {
        this.customerId = null;
        this.assetSetId = null;
    }

    private AssetSetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetSetId = (String)Preconditions.checkNotNull((Object)builder.getAssetSetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetSetId() {
        return this.assetSetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetSetName of(String customerId, String assetSetId) {
        return AssetSetName.newBuilder().setCustomerId(customerId).setAssetSetId(assetSetId).build();
    }

    public static String format(String customerId, String assetSetId) {
        return AssetSetName.newBuilder().setCustomerId(customerId).setAssetSetId(assetSetId).build().toString();
    }

    public static AssetSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_SET_ID.validatedMatch(formattedString, "AssetSetName.parse: formattedString not in valid format");
        return AssetSetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_set_id"));
    }

    public static List<AssetSetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetSetName> list = new ArrayList<AssetSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_SET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetSetName assetSetName = this;
            synchronized (assetSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetSetId != null) {
                        fieldMapBuilder.put((Object)"asset_set_id", (Object)this.assetSetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_SET_ID.instantiate(new String[]{"customer_id", this.customerId, "asset_set_id", this.assetSetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetSetName that = (AssetSetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetSetId, that.assetSetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetSetId);
    }

    public static class Builder {
        private String customerId;
        private String assetSetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetSetId() {
            return this.assetSetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetSetId(String assetSetId) {
            this.assetSetId = assetSetId;
            return this;
        }

        private Builder(AssetSetName assetSetName) {
            this.customerId = assetSetName.customerId;
            this.assetSetId = assetSetName.assetSetId;
        }

        public AssetSetName build() {
            return new AssetSetName(this);
        }
    }
}

