/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerSkAdNetworkConversionValueSchemaName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ACCOUNT_LINK_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerSkAdNetworkConversionValueSchemas/{account_link_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String accountLinkId;

    @Deprecated
    protected CustomerSkAdNetworkConversionValueSchemaName() {
        this.customerId = null;
        this.accountLinkId = null;
    }

    private CustomerSkAdNetworkConversionValueSchemaName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.accountLinkId = (String)Preconditions.checkNotNull((Object)builder.getAccountLinkId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAccountLinkId() {
        return this.accountLinkId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerSkAdNetworkConversionValueSchemaName of(String customerId, String accountLinkId) {
        return CustomerSkAdNetworkConversionValueSchemaName.newBuilder().setCustomerId(customerId).setAccountLinkId(accountLinkId).build();
    }

    public static String format(String customerId, String accountLinkId) {
        return CustomerSkAdNetworkConversionValueSchemaName.newBuilder().setCustomerId(customerId).setAccountLinkId(accountLinkId).build().toString();
    }

    public static CustomerSkAdNetworkConversionValueSchemaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ACCOUNT_LINK_ID.validatedMatch(formattedString, "CustomerSkAdNetworkConversionValueSchemaName.parse: formattedString not in valid format");
        return CustomerSkAdNetworkConversionValueSchemaName.of((String)matchMap.get("customer_id"), (String)matchMap.get("account_link_id"));
    }

    public static List<CustomerSkAdNetworkConversionValueSchemaName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerSkAdNetworkConversionValueSchemaName> list = new ArrayList<CustomerSkAdNetworkConversionValueSchemaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerSkAdNetworkConversionValueSchemaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerSkAdNetworkConversionValueSchemaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerSkAdNetworkConversionValueSchemaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ACCOUNT_LINK_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerSkAdNetworkConversionValueSchemaName customerSkAdNetworkConversionValueSchemaName = this;
            synchronized (customerSkAdNetworkConversionValueSchemaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.accountLinkId != null) {
                        fieldMapBuilder.put((Object)"account_link_id", (Object)this.accountLinkId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ACCOUNT_LINK_ID.instantiate(new String[]{"customer_id", this.customerId, "account_link_id", this.accountLinkId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomerSkAdNetworkConversionValueSchemaName that = (CustomerSkAdNetworkConversionValueSchemaName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.accountLinkId, that.accountLinkId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.accountLinkId);
    }

    public static class Builder {
        private String customerId;
        private String accountLinkId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAccountLinkId() {
            return this.accountLinkId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAccountLinkId(String accountLinkId) {
            this.accountLinkId = accountLinkId;
            return this;
        }

        private Builder(CustomerSkAdNetworkConversionValueSchemaName customerSkAdNetworkConversionValueSchemaName) {
            this.customerId = customerSkAdNetworkConversionValueSchemaName.customerId;
            this.accountLinkId = customerSkAdNetworkConversionValueSchemaName.accountLinkId;
        }

        public CustomerSkAdNetworkConversionValueSchemaName build() {
            return new CustomerSkAdNetworkConversionValueSchemaName(this);
        }
    }
}

