/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.services;

import com.google.ads.googleads.v15.services.CustomerCustomizerOperation;
import com.google.ads.googleads.v15.services.CustomerCustomizerServiceSettings;
import com.google.ads.googleads.v15.services.MutateCustomerCustomizersRequest;
import com.google.ads.googleads.v15.services.MutateCustomerCustomizersResponse;
import com.google.ads.googleads.v15.services.stub.CustomerCustomizerServiceStub;
import com.google.ads.googleads.v15.services.stub.CustomerCustomizerServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerCustomizerServiceClient
implements BackgroundResource {
    private final CustomerCustomizerServiceSettings settings;
    private final CustomerCustomizerServiceStub stub;

    public static final CustomerCustomizerServiceClient create() throws IOException {
        return CustomerCustomizerServiceClient.create(CustomerCustomizerServiceSettings.newBuilder().build());
    }

    public static final CustomerCustomizerServiceClient create(CustomerCustomizerServiceSettings settings) throws IOException {
        return new CustomerCustomizerServiceClient(settings);
    }

    public static final CustomerCustomizerServiceClient create(CustomerCustomizerServiceStub stub) {
        return new CustomerCustomizerServiceClient(stub);
    }

    protected CustomerCustomizerServiceClient(CustomerCustomizerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerCustomizerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomerCustomizerServiceClient(CustomerCustomizerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerCustomizerServiceSettings getSettings() {
        return this.settings;
    }

    public CustomerCustomizerServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomerCustomizersResponse mutateCustomerCustomizers(String customerId, List<CustomerCustomizerOperation> operations) {
        MutateCustomerCustomizersRequest request = MutateCustomerCustomizersRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerCustomizers(request);
    }

    public final MutateCustomerCustomizersResponse mutateCustomerCustomizers(MutateCustomerCustomizersRequest request) {
        return (MutateCustomerCustomizersResponse)this.mutateCustomerCustomizersCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerCustomizersRequest, MutateCustomerCustomizersResponse> mutateCustomerCustomizersCallable() {
        return this.stub.mutateCustomerCustomizersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

