/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.ads.googleads.v15.common.AudienceDimension;
import com.google.ads.googleads.v15.common.AudienceDimensionOrBuilder;
import com.google.ads.googleads.v15.common.AudienceExclusionDimension;
import com.google.ads.googleads.v15.common.AudienceExclusionDimensionOrBuilder;
import com.google.ads.googleads.v15.enums.AudienceScopeEnum;
import com.google.ads.googleads.v15.enums.AudienceStatusEnum;
import com.google.ads.googleads.v15.resources.AudienceOrBuilder;
import com.google.ads.googleads.v15.resources.AudienceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Audience
extends GeneratedMessageV3
implements AudienceOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ID_FIELD_NUMBER = 2;
    private long id_ = 0L;
    public static final int STATUS_FIELD_NUMBER = 3;
    private int status_ = 0;
    public static final int NAME_FIELD_NUMBER = 10;
    private volatile Object name_ = "";
    public static final int DESCRIPTION_FIELD_NUMBER = 5;
    private volatile Object description_ = "";
    public static final int DIMENSIONS_FIELD_NUMBER = 6;
    private List<AudienceDimension> dimensions_;
    public static final int EXCLUSION_DIMENSION_FIELD_NUMBER = 7;
    private AudienceExclusionDimension exclusionDimension_;
    public static final int SCOPE_FIELD_NUMBER = 8;
    private int scope_ = 0;
    public static final int ASSET_GROUP_FIELD_NUMBER = 9;
    private volatile Object assetGroup_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final Audience DEFAULT_INSTANCE = new Audience();
    private static final Parser<Audience> PARSER = new AbstractParser<Audience>(){

        public Audience parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Audience.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Audience(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Audience() {
        this.resourceName_ = "";
        this.status_ = 0;
        this.name_ = "";
        this.description_ = "";
        this.dimensions_ = Collections.emptyList();
        this.scope_ = 0;
        this.assetGroup_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Audience();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AudienceProto.internal_static_google_ads_googleads_v15_resources_Audience_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AudienceProto.internal_static_google_ads_googleads_v15_resources_Audience_fieldAccessorTable.ensureFieldAccessorsInitialized(Audience.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public AudienceStatusEnum.AudienceStatus getStatus() {
        AudienceStatusEnum.AudienceStatus result = AudienceStatusEnum.AudienceStatus.forNumber(this.status_);
        return result == null ? AudienceStatusEnum.AudienceStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasName() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AudienceDimension> getDimensionsList() {
        return this.dimensions_;
    }

    @Override
    public List<? extends AudienceDimensionOrBuilder> getDimensionsOrBuilderList() {
        return this.dimensions_;
    }

    @Override
    public int getDimensionsCount() {
        return this.dimensions_.size();
    }

    @Override
    public AudienceDimension getDimensions(int index) {
        return this.dimensions_.get(index);
    }

    @Override
    public AudienceDimensionOrBuilder getDimensionsOrBuilder(int index) {
        return this.dimensions_.get(index);
    }

    @Override
    public boolean hasExclusionDimension() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public AudienceExclusionDimension getExclusionDimension() {
        return this.exclusionDimension_ == null ? AudienceExclusionDimension.getDefaultInstance() : this.exclusionDimension_;
    }

    @Override
    public AudienceExclusionDimensionOrBuilder getExclusionDimensionOrBuilder() {
        return this.exclusionDimension_ == null ? AudienceExclusionDimension.getDefaultInstance() : this.exclusionDimension_;
    }

    @Override
    public int getScopeValue() {
        return this.scope_;
    }

    @Override
    public AudienceScopeEnum.AudienceScope getScope() {
        AudienceScopeEnum.AudienceScope result = AudienceScopeEnum.AudienceScope.forNumber(this.scope_);
        return result == null ? AudienceScopeEnum.AudienceScope.UNRECOGNIZED : result;
    }

    @Override
    public String getAssetGroup() {
        Object ref = this.assetGroup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.assetGroup_ = s;
        return s;
    }

    @Override
    public ByteString getAssetGroupBytes() {
        Object ref = this.assetGroup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.assetGroup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.id_ != 0L) {
            output.writeInt64(2, this.id_);
        }
        if (this.status_ != AudienceStatusEnum.AudienceStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.description_);
        }
        for (int i = 0; i < this.dimensions_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.dimensions_.get(i));
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(7, (MessageLite)this.getExclusionDimension());
        }
        if (this.scope_ != AudienceScopeEnum.AudienceScope.UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.scope_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.assetGroup_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.assetGroup_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.name_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.id_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)2, (long)this.id_);
        }
        if (this.status_ != AudienceStatusEnum.AudienceStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.description_);
        }
        for (int i = 0; i < this.dimensions_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.dimensions_.get(i)));
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getExclusionDimension());
        }
        if (this.scope_ != AudienceScopeEnum.AudienceScope.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.scope_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.assetGroup_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.assetGroup_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.name_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Audience)) {
            return super.equals(obj);
        }
        Audience other = (Audience)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.hasName() != other.hasName()) {
            return false;
        }
        if (this.hasName() && !this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getDimensionsList().equals(other.getDimensionsList())) {
            return false;
        }
        if (this.hasExclusionDimension() != other.hasExclusionDimension()) {
            return false;
        }
        if (this.hasExclusionDimension() && !this.getExclusionDimension().equals(other.getExclusionDimension())) {
            return false;
        }
        if (this.scope_ != other.scope_) {
            return false;
        }
        if (!this.getAssetGroup().equals(other.getAssetGroup())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Audience.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + Internal.hashLong((long)this.getId());
        hash = 37 * hash + 3;
        hash = 53 * hash + this.status_;
        if (this.hasName()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getName().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getDescription().hashCode();
        if (this.getDimensionsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getDimensionsList().hashCode();
        }
        if (this.hasExclusionDimension()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getExclusionDimension().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + this.scope_;
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getAssetGroup().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Audience parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Audience)PARSER.parseFrom(data);
    }

    public static Audience parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Audience)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Audience parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Audience)PARSER.parseFrom(data);
    }

    public static Audience parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Audience)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Audience parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Audience)PARSER.parseFrom(data);
    }

    public static Audience parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Audience)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Audience parseFrom(InputStream input) throws IOException {
        return (Audience)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Audience parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Audience)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Audience parseDelimitedFrom(InputStream input) throws IOException {
        return (Audience)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Audience parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Audience)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Audience parseFrom(CodedInputStream input) throws IOException {
        return (Audience)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Audience parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Audience)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Audience.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Audience prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Audience getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Audience> parser() {
        return PARSER;
    }

    public Parser<Audience> getParserForType() {
        return PARSER;
    }

    public Audience getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AudienceOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private long id_;
        private int status_ = 0;
        private Object name_ = "";
        private Object description_ = "";
        private List<AudienceDimension> dimensions_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AudienceDimension, AudienceDimension.Builder, AudienceDimensionOrBuilder> dimensionsBuilder_;
        private AudienceExclusionDimension exclusionDimension_;
        private SingleFieldBuilderV3<AudienceExclusionDimension, AudienceExclusionDimension.Builder, AudienceExclusionDimensionOrBuilder> exclusionDimensionBuilder_;
        private int scope_ = 0;
        private Object assetGroup_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return AudienceProto.internal_static_google_ads_googleads_v15_resources_Audience_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AudienceProto.internal_static_google_ads_googleads_v15_resources_Audience_fieldAccessorTable.ensureFieldAccessorsInitialized(Audience.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getDimensionsFieldBuilder();
                this.getExclusionDimensionFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.id_ = 0L;
            this.status_ = 0;
            this.name_ = "";
            this.description_ = "";
            if (this.dimensionsBuilder_ == null) {
                this.dimensions_ = Collections.emptyList();
            } else {
                this.dimensions_ = null;
                this.dimensionsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            this.exclusionDimension_ = null;
            if (this.exclusionDimensionBuilder_ != null) {
                this.exclusionDimensionBuilder_.dispose();
                this.exclusionDimensionBuilder_ = null;
            }
            this.scope_ = 0;
            this.assetGroup_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AudienceProto.internal_static_google_ads_googleads_v15_resources_Audience_descriptor;
        }

        public Audience getDefaultInstanceForType() {
            return Audience.getDefaultInstance();
        }

        public Audience build() {
            Audience result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Audience buildPartial() {
            Audience result = new Audience(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Audience result) {
            if (this.dimensionsBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.dimensions_ = Collections.unmodifiableList(this.dimensions_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.dimensions_ = this.dimensions_;
            } else {
                result.dimensions_ = this.dimensionsBuilder_.build();
            }
        }

        private void buildPartial0(Audience result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.id_ = this.id_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.status_ = this.status_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 8) != 0) {
                result.name_ = this.name_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.exclusionDimension_ = this.exclusionDimensionBuilder_ == null ? this.exclusionDimension_ : (AudienceExclusionDimension)this.exclusionDimensionBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.scope_ = this.scope_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.assetGroup_ = this.assetGroup_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Audience) {
                return this.mergeFrom((Audience)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Audience other) {
            if (other == Audience.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.getId() != 0L) {
                this.setId(other.getId());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.hasName()) {
                this.name_ = other.name_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (this.dimensionsBuilder_ == null) {
                if (!other.dimensions_.isEmpty()) {
                    if (this.dimensions_.isEmpty()) {
                        this.dimensions_ = other.dimensions_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureDimensionsIsMutable();
                        this.dimensions_.addAll(other.dimensions_);
                    }
                    this.onChanged();
                }
            } else if (!other.dimensions_.isEmpty()) {
                if (this.dimensionsBuilder_.isEmpty()) {
                    this.dimensionsBuilder_.dispose();
                    this.dimensionsBuilder_ = null;
                    this.dimensions_ = other.dimensions_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.dimensionsBuilder_ = alwaysUseFieldBuilders ? this.getDimensionsFieldBuilder() : null;
                } else {
                    this.dimensionsBuilder_.addAllMessages((Iterable)other.dimensions_);
                }
            }
            if (other.hasExclusionDimension()) {
                this.mergeExclusionDimension(other.getExclusionDimension());
            }
            if (other.scope_ != 0) {
                this.setScopeValue(other.getScopeValue());
            }
            if (!other.getAssetGroup().isEmpty()) {
                this.assetGroup_ = other.assetGroup_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 16: {
                            this.id_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 24: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 42: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 50: {
                            AudienceDimension m = (AudienceDimension)input.readMessage(AudienceDimension.parser(), extensionRegistry);
                            if (this.dimensionsBuilder_ == null) {
                                this.ensureDimensionsIsMutable();
                                this.dimensions_.add(m);
                                continue block17;
                            }
                            this.dimensionsBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getExclusionDimensionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block17;
                        }
                        case 64: {
                            this.scope_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                        case 74: {
                            this.assetGroup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block17;
                        }
                        case 82: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = Audience.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Audience.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public long getId() {
            return this.id_;
        }

        public Builder setId(long value) {
            this.id_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.id_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public AudienceStatusEnum.AudienceStatus getStatus() {
            AudienceStatusEnum.AudienceStatus result = AudienceStatusEnum.AudienceStatus.forNumber(this.status_);
            return result == null ? AudienceStatusEnum.AudienceStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(AudienceStatusEnum.AudienceStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasName() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Audience.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Audience.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = Audience.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Audience.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        private void ensureDimensionsIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.dimensions_ = new ArrayList<AudienceDimension>(this.dimensions_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<AudienceDimension> getDimensionsList() {
            if (this.dimensionsBuilder_ == null) {
                return Collections.unmodifiableList(this.dimensions_);
            }
            return this.dimensionsBuilder_.getMessageList();
        }

        @Override
        public int getDimensionsCount() {
            if (this.dimensionsBuilder_ == null) {
                return this.dimensions_.size();
            }
            return this.dimensionsBuilder_.getCount();
        }

        @Override
        public AudienceDimension getDimensions(int index) {
            if (this.dimensionsBuilder_ == null) {
                return this.dimensions_.get(index);
            }
            return (AudienceDimension)this.dimensionsBuilder_.getMessage(index);
        }

        public Builder setDimensions(int index, AudienceDimension value) {
            if (this.dimensionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDimensionsIsMutable();
                this.dimensions_.set(index, value);
                this.onChanged();
            } else {
                this.dimensionsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setDimensions(int index, AudienceDimension.Builder builderForValue) {
            if (this.dimensionsBuilder_ == null) {
                this.ensureDimensionsIsMutable();
                this.dimensions_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.dimensionsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDimensions(AudienceDimension value) {
            if (this.dimensionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDimensionsIsMutable();
                this.dimensions_.add(value);
                this.onChanged();
            } else {
                this.dimensionsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addDimensions(int index, AudienceDimension value) {
            if (this.dimensionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDimensionsIsMutable();
                this.dimensions_.add(index, value);
                this.onChanged();
            } else {
                this.dimensionsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addDimensions(AudienceDimension.Builder builderForValue) {
            if (this.dimensionsBuilder_ == null) {
                this.ensureDimensionsIsMutable();
                this.dimensions_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.dimensionsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDimensions(int index, AudienceDimension.Builder builderForValue) {
            if (this.dimensionsBuilder_ == null) {
                this.ensureDimensionsIsMutable();
                this.dimensions_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.dimensionsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDimensions(Iterable<? extends AudienceDimension> values) {
            if (this.dimensionsBuilder_ == null) {
                this.ensureDimensionsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.dimensions_);
                this.onChanged();
            } else {
                this.dimensionsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDimensions() {
            if (this.dimensionsBuilder_ == null) {
                this.dimensions_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.dimensionsBuilder_.clear();
            }
            return this;
        }

        public Builder removeDimensions(int index) {
            if (this.dimensionsBuilder_ == null) {
                this.ensureDimensionsIsMutable();
                this.dimensions_.remove(index);
                this.onChanged();
            } else {
                this.dimensionsBuilder_.remove(index);
            }
            return this;
        }

        public AudienceDimension.Builder getDimensionsBuilder(int index) {
            return (AudienceDimension.Builder)this.getDimensionsFieldBuilder().getBuilder(index);
        }

        @Override
        public AudienceDimensionOrBuilder getDimensionsOrBuilder(int index) {
            if (this.dimensionsBuilder_ == null) {
                return this.dimensions_.get(index);
            }
            return (AudienceDimensionOrBuilder)this.dimensionsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AudienceDimensionOrBuilder> getDimensionsOrBuilderList() {
            if (this.dimensionsBuilder_ != null) {
                return this.dimensionsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.dimensions_);
        }

        public AudienceDimension.Builder addDimensionsBuilder() {
            return (AudienceDimension.Builder)this.getDimensionsFieldBuilder().addBuilder((AbstractMessage)AudienceDimension.getDefaultInstance());
        }

        public AudienceDimension.Builder addDimensionsBuilder(int index) {
            return (AudienceDimension.Builder)this.getDimensionsFieldBuilder().addBuilder(index, (AbstractMessage)AudienceDimension.getDefaultInstance());
        }

        public List<AudienceDimension.Builder> getDimensionsBuilderList() {
            return this.getDimensionsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AudienceDimension, AudienceDimension.Builder, AudienceDimensionOrBuilder> getDimensionsFieldBuilder() {
            if (this.dimensionsBuilder_ == null) {
                this.dimensionsBuilder_ = new RepeatedFieldBuilderV3(this.dimensions_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dimensions_ = null;
            }
            return this.dimensionsBuilder_;
        }

        @Override
        public boolean hasExclusionDimension() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public AudienceExclusionDimension getExclusionDimension() {
            if (this.exclusionDimensionBuilder_ == null) {
                return this.exclusionDimension_ == null ? AudienceExclusionDimension.getDefaultInstance() : this.exclusionDimension_;
            }
            return (AudienceExclusionDimension)this.exclusionDimensionBuilder_.getMessage();
        }

        public Builder setExclusionDimension(AudienceExclusionDimension value) {
            if (this.exclusionDimensionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.exclusionDimension_ = value;
            } else {
                this.exclusionDimensionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setExclusionDimension(AudienceExclusionDimension.Builder builderForValue) {
            if (this.exclusionDimensionBuilder_ == null) {
                this.exclusionDimension_ = builderForValue.build();
            } else {
                this.exclusionDimensionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeExclusionDimension(AudienceExclusionDimension value) {
            if (this.exclusionDimensionBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.exclusionDimension_ != null && this.exclusionDimension_ != AudienceExclusionDimension.getDefaultInstance()) {
                    this.getExclusionDimensionBuilder().mergeFrom(value);
                } else {
                    this.exclusionDimension_ = value;
                }
            } else {
                this.exclusionDimensionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.exclusionDimension_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExclusionDimension() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.exclusionDimension_ = null;
            if (this.exclusionDimensionBuilder_ != null) {
                this.exclusionDimensionBuilder_.dispose();
                this.exclusionDimensionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AudienceExclusionDimension.Builder getExclusionDimensionBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (AudienceExclusionDimension.Builder)this.getExclusionDimensionFieldBuilder().getBuilder();
        }

        @Override
        public AudienceExclusionDimensionOrBuilder getExclusionDimensionOrBuilder() {
            if (this.exclusionDimensionBuilder_ != null) {
                return (AudienceExclusionDimensionOrBuilder)this.exclusionDimensionBuilder_.getMessageOrBuilder();
            }
            return this.exclusionDimension_ == null ? AudienceExclusionDimension.getDefaultInstance() : this.exclusionDimension_;
        }

        private SingleFieldBuilderV3<AudienceExclusionDimension, AudienceExclusionDimension.Builder, AudienceExclusionDimensionOrBuilder> getExclusionDimensionFieldBuilder() {
            if (this.exclusionDimensionBuilder_ == null) {
                this.exclusionDimensionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExclusionDimension(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.exclusionDimension_ = null;
            }
            return this.exclusionDimensionBuilder_;
        }

        @Override
        public int getScopeValue() {
            return this.scope_;
        }

        public Builder setScopeValue(int value) {
            this.scope_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public AudienceScopeEnum.AudienceScope getScope() {
            AudienceScopeEnum.AudienceScope result = AudienceScopeEnum.AudienceScope.forNumber(this.scope_);
            return result == null ? AudienceScopeEnum.AudienceScope.UNRECOGNIZED : result;
        }

        public Builder setScope(AudienceScopeEnum.AudienceScope value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.scope_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearScope() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.scope_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getAssetGroup() {
            Object ref = this.assetGroup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.assetGroup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAssetGroupBytes() {
            Object ref = this.assetGroup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.assetGroup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAssetGroup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.assetGroup_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearAssetGroup() {
            this.assetGroup_ = Audience.getDefaultInstance().getAssetGroup();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setAssetGroupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Audience.checkByteStringIsUtf8((ByteString)value);
            this.assetGroup_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

