/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChangeStatusName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CHANGE_STATUS_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/changeStatus/{change_status_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String changeStatusId;

    @Deprecated
    protected ChangeStatusName() {
        this.customerId = null;
        this.changeStatusId = null;
    }

    private ChangeStatusName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.changeStatusId = (String)Preconditions.checkNotNull((Object)builder.getChangeStatusId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getChangeStatusId() {
        return this.changeStatusId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChangeStatusName of(String customerId, String changeStatusId) {
        return ChangeStatusName.newBuilder().setCustomerId(customerId).setChangeStatusId(changeStatusId).build();
    }

    public static String format(String customerId, String changeStatusId) {
        return ChangeStatusName.newBuilder().setCustomerId(customerId).setChangeStatusId(changeStatusId).build().toString();
    }

    public static ChangeStatusName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CHANGE_STATUS_ID.validatedMatch(formattedString, "ChangeStatusName.parse: formattedString not in valid format");
        return ChangeStatusName.of((String)matchMap.get("customer_id"), (String)matchMap.get("change_status_id"));
    }

    public static List<ChangeStatusName> parseList(List<String> formattedStrings) {
        ArrayList<ChangeStatusName> list = new ArrayList<ChangeStatusName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChangeStatusName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChangeStatusName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChangeStatusName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CHANGE_STATUS_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChangeStatusName changeStatusName = this;
            synchronized (changeStatusName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.changeStatusId != null) {
                        fieldMapBuilder.put((Object)"change_status_id", (Object)this.changeStatusId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CHANGE_STATUS_ID.instantiate(new String[]{"customer_id", this.customerId, "change_status_id", this.changeStatusId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ChangeStatusName that = (ChangeStatusName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.changeStatusId, that.changeStatusId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.changeStatusId);
    }

    public static class Builder {
        private String customerId;
        private String changeStatusId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getChangeStatusId() {
            return this.changeStatusId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setChangeStatusId(String changeStatusId) {
            this.changeStatusId = changeStatusId;
            return this;
        }

        private Builder(ChangeStatusName changeStatusName) {
            this.customerId = changeStatusName.customerId;
            this.changeStatusId = changeStatusName.changeStatusId;
        }

        public ChangeStatusName build() {
            return new ChangeStatusName(this);
        }
    }
}

