/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeedPlaceholderViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_PLACEHOLDER_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/feedPlaceholderViews/{placeholder_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String placeholderType;

    @Deprecated
    protected FeedPlaceholderViewName() {
        this.customerId = null;
        this.placeholderType = null;
    }

    private FeedPlaceholderViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.placeholderType = (String)Preconditions.checkNotNull((Object)builder.getPlaceholderType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getPlaceholderType() {
        return this.placeholderType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeedPlaceholderViewName of(String customerId, String placeholderType) {
        return FeedPlaceholderViewName.newBuilder().setCustomerId(customerId).setPlaceholderType(placeholderType).build();
    }

    public static String format(String customerId, String placeholderType) {
        return FeedPlaceholderViewName.newBuilder().setCustomerId(customerId).setPlaceholderType(placeholderType).build().toString();
    }

    public static FeedPlaceholderViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_PLACEHOLDER_TYPE.validatedMatch(formattedString, "FeedPlaceholderViewName.parse: formattedString not in valid format");
        return FeedPlaceholderViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("placeholder_type"));
    }

    public static List<FeedPlaceholderViewName> parseList(List<String> formattedStrings) {
        ArrayList<FeedPlaceholderViewName> list = new ArrayList<FeedPlaceholderViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedPlaceholderViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedPlaceholderViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedPlaceholderViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_PLACEHOLDER_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedPlaceholderViewName feedPlaceholderViewName = this;
            synchronized (feedPlaceholderViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.placeholderType != null) {
                        fieldMapBuilder.put((Object)"placeholder_type", (Object)this.placeholderType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_PLACEHOLDER_TYPE.instantiate(new String[]{"customer_id", this.customerId, "placeholder_type", this.placeholderType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeedPlaceholderViewName that = (FeedPlaceholderViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.placeholderType, that.placeholderType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.placeholderType);
    }

    public static class Builder {
        private String customerId;
        private String placeholderType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getPlaceholderType() {
            return this.placeholderType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setPlaceholderType(String placeholderType) {
            this.placeholderType = placeholderType;
            return this;
        }

        private Builder(FeedPlaceholderViewName feedPlaceholderViewName) {
            this.customerId = feedPlaceholderViewName.customerId;
            this.placeholderType = feedPlaceholderViewName.placeholderType;
        }

        public FeedPlaceholderViewName build() {
            return new FeedPlaceholderViewName(this);
        }
    }
}

