/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QualifyingQuestionName
implements ResourceName {
    private static final PathTemplate QUALIFYING_QUESTION_ID = PathTemplate.createWithoutUrlEncoding((String)"qualifyingQuestions/{qualifying_question_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String qualifyingQuestionId;

    @Deprecated
    protected QualifyingQuestionName() {
        this.qualifyingQuestionId = null;
    }

    private QualifyingQuestionName(Builder builder) {
        this.qualifyingQuestionId = (String)Preconditions.checkNotNull((Object)builder.getQualifyingQuestionId());
    }

    public String getQualifyingQuestionId() {
        return this.qualifyingQuestionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QualifyingQuestionName of(String qualifyingQuestionId) {
        return QualifyingQuestionName.newBuilder().setQualifyingQuestionId(qualifyingQuestionId).build();
    }

    public static String format(String qualifyingQuestionId) {
        return QualifyingQuestionName.newBuilder().setQualifyingQuestionId(qualifyingQuestionId).build().toString();
    }

    public static QualifyingQuestionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = QUALIFYING_QUESTION_ID.validatedMatch(formattedString, "QualifyingQuestionName.parse: formattedString not in valid format");
        return QualifyingQuestionName.of((String)matchMap.get("qualifying_question_id"));
    }

    public static List<QualifyingQuestionName> parseList(List<String> formattedStrings) {
        ArrayList<QualifyingQuestionName> list = new ArrayList<QualifyingQuestionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QualifyingQuestionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QualifyingQuestionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QualifyingQuestionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return QUALIFYING_QUESTION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QualifyingQuestionName qualifyingQuestionName = this;
            synchronized (qualifyingQuestionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.qualifyingQuestionId != null) {
                        fieldMapBuilder.put((Object)"qualifying_question_id", (Object)this.qualifyingQuestionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return QUALIFYING_QUESTION_ID.instantiate(new String[]{"qualifying_question_id", this.qualifyingQuestionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QualifyingQuestionName that = (QualifyingQuestionName)o;
            return Objects.equals(this.qualifyingQuestionId, that.qualifyingQuestionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.qualifyingQuestionId);
    }

    public static class Builder {
        private String qualifyingQuestionId;

        protected Builder() {
        }

        public String getQualifyingQuestionId() {
            return this.qualifyingQuestionId;
        }

        public Builder setQualifyingQuestionId(String qualifyingQuestionId) {
            this.qualifyingQuestionId = qualifyingQuestionId;
            return this;
        }

        private Builder(QualifyingQuestionName qualifyingQuestionName) {
            this.qualifyingQuestionId = qualifyingQuestionName.qualifyingQuestionId;
        }

        public QualifyingQuestionName build() {
            return new QualifyingQuestionName(this);
        }
    }
}

