/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.services;

import com.google.ads.googleads.v15.services.AssetGroupOperation;
import com.google.ads.googleads.v15.services.AssetGroupServiceSettings;
import com.google.ads.googleads.v15.services.MutateAssetGroupsRequest;
import com.google.ads.googleads.v15.services.MutateAssetGroupsResponse;
import com.google.ads.googleads.v15.services.stub.AssetGroupServiceStub;
import com.google.ads.googleads.v15.services.stub.AssetGroupServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AssetGroupServiceClient
implements BackgroundResource {
    private final AssetGroupServiceSettings settings;
    private final AssetGroupServiceStub stub;

    public static final AssetGroupServiceClient create() throws IOException {
        return AssetGroupServiceClient.create(AssetGroupServiceSettings.newBuilder().build());
    }

    public static final AssetGroupServiceClient create(AssetGroupServiceSettings settings) throws IOException {
        return new AssetGroupServiceClient(settings);
    }

    public static final AssetGroupServiceClient create(AssetGroupServiceStub stub) {
        return new AssetGroupServiceClient(stub);
    }

    protected AssetGroupServiceClient(AssetGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetGroupServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AssetGroupServiceClient(AssetGroupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AssetGroupServiceSettings getSettings() {
        return this.settings;
    }

    public AssetGroupServiceStub getStub() {
        return this.stub;
    }

    public final MutateAssetGroupsResponse mutateAssetGroups(String customerId, List<AssetGroupOperation> operations) {
        MutateAssetGroupsRequest request = MutateAssetGroupsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAssetGroups(request);
    }

    public final MutateAssetGroupsResponse mutateAssetGroups(MutateAssetGroupsRequest request) {
        return (MutateAssetGroupsResponse)this.mutateAssetGroupsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAssetGroupsRequest, MutateAssetGroupsResponse> mutateAssetGroupsCallable() {
        return this.stub.mutateAssetGroupsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

