// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v16/resources/asset_group.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v16.resources;

/**
 * <pre>
 * An asset group.
 * AssetGroupAsset is used to link an asset to the asset group.
 * AssetGroupSignal is used to associate a signal to an asset group.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v16.resources.AssetGroup}
 */
public final class AssetGroup extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v16.resources.AssetGroup)
    AssetGroupOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AssetGroup.newBuilder() to construct.
  private AssetGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AssetGroup() {
    resourceName_ = "";
    campaign_ = "";
    name_ = "";
    finalUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    finalMobileUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    status_ = 0;
    primaryStatus_ = 0;
    primaryStatusReasons_ = java.util.Collections.emptyList();
    path1_ = "";
    path2_ = "";
    adStrength_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new AssetGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v16.resources.AssetGroupProto.internal_static_google_ads_googleads_v16_resources_AssetGroup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v16.resources.AssetGroupProto.internal_static_google_ads_googleads_v16_resources_AssetGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v16.resources.AssetGroup.class, com.google.ads.googleads.v16.resources.AssetGroup.Builder.class);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the asset group.
   * Asset group resource names have the form:
   *
   * `customers/{customer_id}/assetGroups/{asset_group_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the asset group.
   * Asset group resource names have the form:
   *
   * `customers/{customer_id}/assetGroups/{asset_group_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 9;
  private long id_ = 0L;
  /**
   * <pre>
   * Output only. The ID of the asset group.
   * </pre>
   *
   * <code>int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int CAMPAIGN_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object campaign_ = "";
  /**
   * <pre>
   * Immutable. The campaign with which this asset group is associated.
   * The asset which is linked to the asset group.
   * </pre>
   *
   * <code>string campaign = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The campaign.
   */
  @java.lang.Override
  public java.lang.String getCampaign() {
    java.lang.Object ref = campaign_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      campaign_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The campaign with which this asset group is associated.
   * The asset which is linked to the asset group.
   * </pre>
   *
   * <code>string campaign = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for campaign.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCampaignBytes() {
    java.lang.Object ref = campaign_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      campaign_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * Required. Name of the asset group. Required. It must have a minimum length
   * of 1 and maximum length of 128. It must be unique under a campaign.
   * </pre>
   *
   * <code>string name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Required. Name of the asset group. Required. It must have a minimum length
   * of 1 and maximum length of 128. It must be unique under a campaign.
   * </pre>
   *
   * <code>string name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINAL_URLS_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList finalUrls_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * A list of final URLs after all cross domain redirects. In performance max,
   * by default, the urls are eligible for expansion unless opted out.
   * </pre>
   *
   * <code>repeated string final_urls = 4;</code>
   * @return A list containing the finalUrls.
   */
  public com.google.protobuf.ProtocolStringList
      getFinalUrlsList() {
    return finalUrls_;
  }
  /**
   * <pre>
   * A list of final URLs after all cross domain redirects. In performance max,
   * by default, the urls are eligible for expansion unless opted out.
   * </pre>
   *
   * <code>repeated string final_urls = 4;</code>
   * @return The count of finalUrls.
   */
  public int getFinalUrlsCount() {
    return finalUrls_.size();
  }
  /**
   * <pre>
   * A list of final URLs after all cross domain redirects. In performance max,
   * by default, the urls are eligible for expansion unless opted out.
   * </pre>
   *
   * <code>repeated string final_urls = 4;</code>
   * @param index The index of the element to return.
   * @return The finalUrls at the given index.
   */
  public java.lang.String getFinalUrls(int index) {
    return finalUrls_.get(index);
  }
  /**
   * <pre>
   * A list of final URLs after all cross domain redirects. In performance max,
   * by default, the urls are eligible for expansion unless opted out.
   * </pre>
   *
   * <code>repeated string final_urls = 4;</code>
   * @param index The index of the value to return.
   * @return The bytes of the finalUrls at the given index.
   */
  public com.google.protobuf.ByteString
      getFinalUrlsBytes(int index) {
    return finalUrls_.getByteString(index);
  }

  public static final int FINAL_MOBILE_URLS_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList finalMobileUrls_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * A list of final mobile URLs after all cross domain redirects. In
   * performance max, by default, the urls are eligible for expansion
   * unless opted out.
   * </pre>
   *
   * <code>repeated string final_mobile_urls = 5;</code>
   * @return A list containing the finalMobileUrls.
   */
  public com.google.protobuf.ProtocolStringList
      getFinalMobileUrlsList() {
    return finalMobileUrls_;
  }
  /**
   * <pre>
   * A list of final mobile URLs after all cross domain redirects. In
   * performance max, by default, the urls are eligible for expansion
   * unless opted out.
   * </pre>
   *
   * <code>repeated string final_mobile_urls = 5;</code>
   * @return The count of finalMobileUrls.
   */
  public int getFinalMobileUrlsCount() {
    return finalMobileUrls_.size();
  }
  /**
   * <pre>
   * A list of final mobile URLs after all cross domain redirects. In
   * performance max, by default, the urls are eligible for expansion
   * unless opted out.
   * </pre>
   *
   * <code>repeated string final_mobile_urls = 5;</code>
   * @param index The index of the element to return.
   * @return The finalMobileUrls at the given index.
   */
  public java.lang.String getFinalMobileUrls(int index) {
    return finalMobileUrls_.get(index);
  }
  /**
   * <pre>
   * A list of final mobile URLs after all cross domain redirects. In
   * performance max, by default, the urls are eligible for expansion
   * unless opted out.
   * </pre>
   *
   * <code>repeated string final_mobile_urls = 5;</code>
   * @param index The index of the value to return.
   * @return The bytes of the finalMobileUrls at the given index.
   */
  public com.google.protobuf.ByteString
      getFinalMobileUrlsBytes(int index) {
    return finalMobileUrls_.getByteString(index);
  }

  public static final int STATUS_FIELD_NUMBER = 6;
  private int status_ = 0;
  /**
   * <pre>
   * The status of the asset group.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus status = 6;</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * The status of the asset group.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus status = 6;</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus getStatus() {
    com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus result = com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus.UNRECOGNIZED : result;
  }

  public static final int PRIMARY_STATUS_FIELD_NUMBER = 11;
  private int primaryStatus_ = 0;
  /**
   * <pre>
   * Output only. The primary status of the asset group. Provides insights into
   * why an asset group is not serving or not serving optimally.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus primary_status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for primaryStatus.
   */
  @java.lang.Override public int getPrimaryStatusValue() {
    return primaryStatus_;
  }
  /**
   * <pre>
   * Output only. The primary status of the asset group. Provides insights into
   * why an asset group is not serving or not serving optimally.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus primary_status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The primaryStatus.
   */
  @java.lang.Override public com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus getPrimaryStatus() {
    com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus result = com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.forNumber(primaryStatus_);
    return result == null ? com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNRECOGNIZED : result;
  }

  public static final int PRIMARY_STATUS_REASONS_FIELD_NUMBER = 12;
  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> primaryStatusReasons_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> primaryStatusReasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason>() {
            public com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason convert(java.lang.Integer from) {
              com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason result = com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason.forNumber(from);
              return result == null ? com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Output only. Provides reasons into why an asset group is not serving or not
   * serving optimally. It will be empty when the asset group is serving without
   * issues.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return A list containing the primaryStatusReasons.
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> getPrimaryStatusReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason>(primaryStatusReasons_, primaryStatusReasons_converter_);
  }
  /**
   * <pre>
   * Output only. Provides reasons into why an asset group is not serving or not
   * serving optimally. It will be empty when the asset group is serving without
   * issues.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The count of primaryStatusReasons.
   */
  @java.lang.Override
  public int getPrimaryStatusReasonsCount() {
    return primaryStatusReasons_.size();
  }
  /**
   * <pre>
   * Output only. Provides reasons into why an asset group is not serving or not
   * serving optimally. It will be empty when the asset group is serving without
   * issues.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the element to return.
   * @return The primaryStatusReasons at the given index.
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason getPrimaryStatusReasons(int index) {
    return primaryStatusReasons_converter_.convert(primaryStatusReasons_.get(index));
  }
  /**
   * <pre>
   * Output only. Provides reasons into why an asset group is not serving or not
   * serving optimally. It will be empty when the asset group is serving without
   * issues.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return A list containing the enum numeric values on the wire for primaryStatusReasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
  getPrimaryStatusReasonsValueList() {
    return primaryStatusReasons_;
  }
  /**
   * <pre>
   * Output only. Provides reasons into why an asset group is not serving or not
   * serving optimally. It will be empty when the asset group is serving without
   * issues.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of primaryStatusReasons at the given index.
   */
  @java.lang.Override
  public int getPrimaryStatusReasonsValue(int index) {
    return primaryStatusReasons_.get(index);
  }
  private int primaryStatusReasonsMemoizedSerializedSize;

  public static final int PATH1_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private volatile java.lang.Object path1_ = "";
  /**
   * <pre>
   * First part of text that may appear appended to the url displayed in
   * the ad.
   * </pre>
   *
   * <code>string path1 = 7;</code>
   * @return The path1.
   */
  @java.lang.Override
  public java.lang.String getPath1() {
    java.lang.Object ref = path1_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path1_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * First part of text that may appear appended to the url displayed in
   * the ad.
   * </pre>
   *
   * <code>string path1 = 7;</code>
   * @return The bytes for path1.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPath1Bytes() {
    java.lang.Object ref = path1_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      path1_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATH2_FIELD_NUMBER = 8;
  @SuppressWarnings("serial")
  private volatile java.lang.Object path2_ = "";
  /**
   * <pre>
   * Second part of text that may appear appended to the url displayed in
   * the ad. This field can only be set when path1 is set.
   * </pre>
   *
   * <code>string path2 = 8;</code>
   * @return The path2.
   */
  @java.lang.Override
  public java.lang.String getPath2() {
    java.lang.Object ref = path2_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path2_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Second part of text that may appear appended to the url displayed in
   * the ad. This field can only be set when path1 is set.
   * </pre>
   *
   * <code>string path2 = 8;</code>
   * @return The bytes for path2.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPath2Bytes() {
    java.lang.Object ref = path2_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      path2_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AD_STRENGTH_FIELD_NUMBER = 10;
  private int adStrength_ = 0;
  /**
   * <pre>
   * Output only. Overall ad strength of this asset group.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength ad_strength = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for adStrength.
   */
  @java.lang.Override public int getAdStrengthValue() {
    return adStrength_;
  }
  /**
   * <pre>
   * Output only. Overall ad strength of this asset group.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength ad_strength = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The adStrength.
   */
  @java.lang.Override public com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength getAdStrength() {
    com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength result = com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength.forNumber(adStrength_);
    return result == null ? com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(campaign_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, campaign_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
    }
    for (int i = 0; i < finalUrls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, finalUrls_.getRaw(i));
    }
    for (int i = 0; i < finalMobileUrls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, finalMobileUrls_.getRaw(i));
    }
    if (status_ != com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(6, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path1_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, path1_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path2_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, path2_);
    }
    if (id_ != 0L) {
      output.writeInt64(9, id_);
    }
    if (adStrength_ != com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
      output.writeEnum(10, adStrength_);
    }
    if (primaryStatus_ != com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(11, primaryStatus_);
    }
    if (getPrimaryStatusReasonsList().size() > 0) {
      output.writeUInt32NoTag(98);
      output.writeUInt32NoTag(primaryStatusReasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < primaryStatusReasons_.size(); i++) {
      output.writeEnumNoTag(primaryStatusReasons_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(campaign_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, campaign_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < finalUrls_.size(); i++) {
        dataSize += computeStringSizeNoTag(finalUrls_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFinalUrlsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < finalMobileUrls_.size(); i++) {
        dataSize += computeStringSizeNoTag(finalMobileUrls_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFinalMobileUrlsList().size();
    }
    if (status_ != com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path1_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, path1_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path2_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, path2_);
    }
    if (id_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(9, id_);
    }
    if (adStrength_ != com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(10, adStrength_);
    }
    if (primaryStatus_ != com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(11, primaryStatus_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < primaryStatusReasons_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(primaryStatusReasons_.get(i));
      }
      size += dataSize;
      if (!getPrimaryStatusReasonsList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }primaryStatusReasonsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v16.resources.AssetGroup)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v16.resources.AssetGroup other = (com.google.ads.googleads.v16.resources.AssetGroup) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (getId()
        != other.getId()) return false;
    if (!getCampaign()
        .equals(other.getCampaign())) return false;
    if (!getName()
        .equals(other.getName())) return false;
    if (!getFinalUrlsList()
        .equals(other.getFinalUrlsList())) return false;
    if (!getFinalMobileUrlsList()
        .equals(other.getFinalMobileUrlsList())) return false;
    if (status_ != other.status_) return false;
    if (primaryStatus_ != other.primaryStatus_) return false;
    if (!primaryStatusReasons_.equals(other.primaryStatusReasons_)) return false;
    if (!getPath1()
        .equals(other.getPath1())) return false;
    if (!getPath2()
        .equals(other.getPath2())) return false;
    if (adStrength_ != other.adStrength_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getId());
    hash = (37 * hash) + CAMPAIGN_FIELD_NUMBER;
    hash = (53 * hash) + getCampaign().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getFinalUrlsCount() > 0) {
      hash = (37 * hash) + FINAL_URLS_FIELD_NUMBER;
      hash = (53 * hash) + getFinalUrlsList().hashCode();
    }
    if (getFinalMobileUrlsCount() > 0) {
      hash = (37 * hash) + FINAL_MOBILE_URLS_FIELD_NUMBER;
      hash = (53 * hash) + getFinalMobileUrlsList().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + PRIMARY_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + primaryStatus_;
    if (getPrimaryStatusReasonsCount() > 0) {
      hash = (37 * hash) + PRIMARY_STATUS_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + primaryStatusReasons_.hashCode();
    }
    hash = (37 * hash) + PATH1_FIELD_NUMBER;
    hash = (53 * hash) + getPath1().hashCode();
    hash = (37 * hash) + PATH2_FIELD_NUMBER;
    hash = (53 * hash) + getPath2().hashCode();
    hash = (37 * hash) + AD_STRENGTH_FIELD_NUMBER;
    hash = (53 * hash) + adStrength_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v16.resources.AssetGroup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v16.resources.AssetGroup parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v16.resources.AssetGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v16.resources.AssetGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An asset group.
   * AssetGroupAsset is used to link an asset to the asset group.
   * AssetGroupSignal is used to associate a signal to an asset group.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v16.resources.AssetGroup}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v16.resources.AssetGroup)
      com.google.ads.googleads.v16.resources.AssetGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v16.resources.AssetGroupProto.internal_static_google_ads_googleads_v16_resources_AssetGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v16.resources.AssetGroupProto.internal_static_google_ads_googleads_v16_resources_AssetGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v16.resources.AssetGroup.class, com.google.ads.googleads.v16.resources.AssetGroup.Builder.class);
    }

    // Construct using com.google.ads.googleads.v16.resources.AssetGroup.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      id_ = 0L;
      campaign_ = "";
      name_ = "";
      finalUrls_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      finalMobileUrls_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      status_ = 0;
      primaryStatus_ = 0;
      primaryStatusReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      path1_ = "";
      path2_ = "";
      adStrength_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v16.resources.AssetGroupProto.internal_static_google_ads_googleads_v16_resources_AssetGroup_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.resources.AssetGroup getDefaultInstanceForType() {
      return com.google.ads.googleads.v16.resources.AssetGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.resources.AssetGroup build() {
      com.google.ads.googleads.v16.resources.AssetGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.resources.AssetGroup buildPartial() {
      com.google.ads.googleads.v16.resources.AssetGroup result = new com.google.ads.googleads.v16.resources.AssetGroup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v16.resources.AssetGroup result) {
      if (((bitField0_ & 0x00000100) != 0)) {
        primaryStatusReasons_ = java.util.Collections.unmodifiableList(primaryStatusReasons_);
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.primaryStatusReasons_ = primaryStatusReasons_;
    }

    private void buildPartial0(com.google.ads.googleads.v16.resources.AssetGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.campaign_ = campaign_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        finalUrls_.makeImmutable();
        result.finalUrls_ = finalUrls_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        finalMobileUrls_.makeImmutable();
        result.finalMobileUrls_ = finalMobileUrls_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.primaryStatus_ = primaryStatus_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.path1_ = path1_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.path2_ = path2_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.adStrength_ = adStrength_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v16.resources.AssetGroup) {
        return mergeFrom((com.google.ads.googleads.v16.resources.AssetGroup)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v16.resources.AssetGroup other) {
      if (other == com.google.ads.googleads.v16.resources.AssetGroup.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getId() != 0L) {
        setId(other.getId());
      }
      if (!other.getCampaign().isEmpty()) {
        campaign_ = other.campaign_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.finalUrls_.isEmpty()) {
        if (finalUrls_.isEmpty()) {
          finalUrls_ = other.finalUrls_;
          bitField0_ |= 0x00000010;
        } else {
          ensureFinalUrlsIsMutable();
          finalUrls_.addAll(other.finalUrls_);
        }
        onChanged();
      }
      if (!other.finalMobileUrls_.isEmpty()) {
        if (finalMobileUrls_.isEmpty()) {
          finalMobileUrls_ = other.finalMobileUrls_;
          bitField0_ |= 0x00000020;
        } else {
          ensureFinalMobileUrlsIsMutable();
          finalMobileUrls_.addAll(other.finalMobileUrls_);
        }
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.primaryStatus_ != 0) {
        setPrimaryStatusValue(other.getPrimaryStatusValue());
      }
      if (!other.primaryStatusReasons_.isEmpty()) {
        if (primaryStatusReasons_.isEmpty()) {
          primaryStatusReasons_ = other.primaryStatusReasons_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensurePrimaryStatusReasonsIsMutable();
          primaryStatusReasons_.addAll(other.primaryStatusReasons_);
        }
        onChanged();
      }
      if (!other.getPath1().isEmpty()) {
        path1_ = other.path1_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getPath2().isEmpty()) {
        path2_ = other.path2_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.adStrength_ != 0) {
        setAdStrengthValue(other.getAdStrengthValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              campaign_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 18
            case 26: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 26
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureFinalUrlsIsMutable();
              finalUrls_.add(s);
              break;
            } // case 34
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureFinalMobileUrlsIsMutable();
              finalMobileUrls_.add(s);
              break;
            } // case 42
            case 48: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000040;
              break;
            } // case 48
            case 58: {
              path1_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000200;
              break;
            } // case 58
            case 66: {
              path2_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000400;
              break;
            } // case 66
            case 72: {
              id_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 72
            case 80: {
              adStrength_ = input.readEnum();
              bitField0_ |= 0x00000800;
              break;
            } // case 80
            case 88: {
              primaryStatus_ = input.readEnum();
              bitField0_ |= 0x00000080;
              break;
            } // case 88
            case 96: {
              int tmpRaw = input.readEnum();
              ensurePrimaryStatusReasonsIsMutable();
              primaryStatusReasons_.add(tmpRaw);
              break;
            } // case 96
            case 98: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int tmpRaw = input.readEnum();
                ensurePrimaryStatusReasonsIsMutable();
                primaryStatusReasons_.add(tmpRaw);
              }
              input.popLimit(oldLimit);
              break;
            } // case 98
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the asset group.
     * Asset group resource names have the form:
     *
     * `customers/{customer_id}/assetGroups/{asset_group_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group.
     * Asset group resource names have the form:
     *
     * `customers/{customer_id}/assetGroups/{asset_group_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group.
     * Asset group resource names have the form:
     *
     * `customers/{customer_id}/assetGroups/{asset_group_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group.
     * Asset group resource names have the form:
     *
     * `customers/{customer_id}/assetGroups/{asset_group_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group.
     * Asset group resource names have the form:
     *
     * `customers/{customer_id}/assetGroups/{asset_group_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long id_ ;
    /**
     * <pre>
     * Output only. The ID of the asset group.
     * </pre>
     *
     * <code>int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     * <pre>
     * Output only. The ID of the asset group.
     * </pre>
     *
     * <code>int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the asset group.
     * </pre>
     *
     * <code>int64 id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object campaign_ = "";
    /**
     * <pre>
     * Immutable. The campaign with which this asset group is associated.
     * The asset which is linked to the asset group.
     * </pre>
     *
     * <code>string campaign = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The campaign.
     */
    public java.lang.String getCampaign() {
      java.lang.Object ref = campaign_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaign_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The campaign with which this asset group is associated.
     * The asset which is linked to the asset group.
     * </pre>
     *
     * <code>string campaign = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for campaign.
     */
    public com.google.protobuf.ByteString
        getCampaignBytes() {
      java.lang.Object ref = campaign_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaign_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The campaign with which this asset group is associated.
     * The asset which is linked to the asset group.
     * </pre>
     *
     * <code>string campaign = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The campaign to set.
     * @return This builder for chaining.
     */
    public Builder setCampaign(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      campaign_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The campaign with which this asset group is associated.
     * The asset which is linked to the asset group.
     * </pre>
     *
     * <code>string campaign = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCampaign() {
      campaign_ = getDefaultInstance().getCampaign();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The campaign with which this asset group is associated.
     * The asset which is linked to the asset group.
     * </pre>
     *
     * <code>string campaign = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for campaign to set.
     * @return This builder for chaining.
     */
    public Builder setCampaignBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      campaign_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Required. Name of the asset group. Required. It must have a minimum length
     * of 1 and maximum length of 128. It must be unique under a campaign.
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Required. Name of the asset group. Required. It must have a minimum length
     * of 1 and maximum length of 128. It must be unique under a campaign.
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Required. Name of the asset group. Required. It must have a minimum length
     * of 1 and maximum length of 128. It must be unique under a campaign.
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. Name of the asset group. Required. It must have a minimum length
     * of 1 and maximum length of 128. It must be unique under a campaign.
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. Name of the asset group. Required. It must have a minimum length
     * of 1 and maximum length of 128. It must be unique under a campaign.
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList finalUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureFinalUrlsIsMutable() {
      if (!finalUrls_.isModifiable()) {
        finalUrls_ = new com.google.protobuf.LazyStringArrayList(finalUrls_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @return A list containing the finalUrls.
     */
    public com.google.protobuf.ProtocolStringList
        getFinalUrlsList() {
      finalUrls_.makeImmutable();
      return finalUrls_;
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @return The count of finalUrls.
     */
    public int getFinalUrlsCount() {
      return finalUrls_.size();
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @param index The index of the element to return.
     * @return The finalUrls at the given index.
     */
    public java.lang.String getFinalUrls(int index) {
      return finalUrls_.get(index);
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @param index The index of the value to return.
     * @return The bytes of the finalUrls at the given index.
     */
    public com.google.protobuf.ByteString
        getFinalUrlsBytes(int index) {
      return finalUrls_.getByteString(index);
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @param index The index to set the value at.
     * @param value The finalUrls to set.
     * @return This builder for chaining.
     */
    public Builder setFinalUrls(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFinalUrlsIsMutable();
      finalUrls_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @param value The finalUrls to add.
     * @return This builder for chaining.
     */
    public Builder addFinalUrls(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFinalUrlsIsMutable();
      finalUrls_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @param values The finalUrls to add.
     * @return This builder for chaining.
     */
    public Builder addAllFinalUrls(
        java.lang.Iterable<java.lang.String> values) {
      ensureFinalUrlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, finalUrls_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearFinalUrls() {
      finalUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final URLs after all cross domain redirects. In performance max,
     * by default, the urls are eligible for expansion unless opted out.
     * </pre>
     *
     * <code>repeated string final_urls = 4;</code>
     * @param value The bytes of the finalUrls to add.
     * @return This builder for chaining.
     */
    public Builder addFinalUrlsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureFinalUrlsIsMutable();
      finalUrls_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList finalMobileUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureFinalMobileUrlsIsMutable() {
      if (!finalMobileUrls_.isModifiable()) {
        finalMobileUrls_ = new com.google.protobuf.LazyStringArrayList(finalMobileUrls_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @return A list containing the finalMobileUrls.
     */
    public com.google.protobuf.ProtocolStringList
        getFinalMobileUrlsList() {
      finalMobileUrls_.makeImmutable();
      return finalMobileUrls_;
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @return The count of finalMobileUrls.
     */
    public int getFinalMobileUrlsCount() {
      return finalMobileUrls_.size();
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @param index The index of the element to return.
     * @return The finalMobileUrls at the given index.
     */
    public java.lang.String getFinalMobileUrls(int index) {
      return finalMobileUrls_.get(index);
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the finalMobileUrls at the given index.
     */
    public com.google.protobuf.ByteString
        getFinalMobileUrlsBytes(int index) {
      return finalMobileUrls_.getByteString(index);
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @param index The index to set the value at.
     * @param value The finalMobileUrls to set.
     * @return This builder for chaining.
     */
    public Builder setFinalMobileUrls(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFinalMobileUrlsIsMutable();
      finalMobileUrls_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @param value The finalMobileUrls to add.
     * @return This builder for chaining.
     */
    public Builder addFinalMobileUrls(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFinalMobileUrlsIsMutable();
      finalMobileUrls_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @param values The finalMobileUrls to add.
     * @return This builder for chaining.
     */
    public Builder addAllFinalMobileUrls(
        java.lang.Iterable<java.lang.String> values) {
      ensureFinalMobileUrlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, finalMobileUrls_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearFinalMobileUrls() {
      finalMobileUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of final mobile URLs after all cross domain redirects. In
     * performance max, by default, the urls are eligible for expansion
     * unless opted out.
     * </pre>
     *
     * <code>repeated string final_mobile_urls = 5;</code>
     * @param value The bytes of the finalMobileUrls to add.
     * @return This builder for chaining.
     */
    public Builder addFinalMobileUrlsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureFinalMobileUrlsIsMutable();
      finalMobileUrls_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * The status of the asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus status = 6;</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * The status of the asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus status = 6;</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus status = 6;</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus getStatus() {
      com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus result = com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The status of the asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus status = 6;</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupStatusEnum.AssetGroupStatus status = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      status_ = 0;
      onChanged();
      return this;
    }

    private int primaryStatus_ = 0;
    /**
     * <pre>
     * Output only. The primary status of the asset group. Provides insights into
     * why an asset group is not serving or not serving optimally.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus primary_status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for primaryStatus.
     */
    @java.lang.Override public int getPrimaryStatusValue() {
      return primaryStatus_;
    }
    /**
     * <pre>
     * Output only. The primary status of the asset group. Provides insights into
     * why an asset group is not serving or not serving optimally.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus primary_status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for primaryStatus to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryStatusValue(int value) {
      primaryStatus_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The primary status of the asset group. Provides insights into
     * why an asset group is not serving or not serving optimally.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus primary_status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The primaryStatus.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus getPrimaryStatus() {
      com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus result = com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.forNumber(primaryStatus_);
      return result == null ? com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The primary status of the asset group. Provides insights into
     * why an asset group is not serving or not serving optimally.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus primary_status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The primaryStatus to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryStatus(com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      primaryStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The primary status of the asset group. Provides insights into
     * why an asset group is not serving or not serving optimally.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus primary_status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearPrimaryStatus() {
      bitField0_ = (bitField0_ & ~0x00000080);
      primaryStatus_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> primaryStatusReasons_ =
      java.util.Collections.emptyList();
    private void ensurePrimaryStatusReasonsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        primaryStatusReasons_ = new java.util.ArrayList<java.lang.Integer>(primaryStatusReasons_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return A list containing the primaryStatusReasons.
     */
    public java.util.List<com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> getPrimaryStatusReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason>(primaryStatusReasons_, primaryStatusReasons_converter_);
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The count of primaryStatusReasons.
     */
    public int getPrimaryStatusReasonsCount() {
      return primaryStatusReasons_.size();
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the element to return.
     * @return The primaryStatusReasons at the given index.
     */
    public com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason getPrimaryStatusReasons(int index) {
      return primaryStatusReasons_converter_.convert(primaryStatusReasons_.get(index));
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index to set the value at.
     * @param value The primaryStatusReasons to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryStatusReasons(
        int index, com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrimaryStatusReasonsIsMutable();
      primaryStatusReasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The primaryStatusReasons to add.
     * @return This builder for chaining.
     */
    public Builder addPrimaryStatusReasons(com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrimaryStatusReasonsIsMutable();
      primaryStatusReasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param values The primaryStatusReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllPrimaryStatusReasons(
        java.lang.Iterable<? extends com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> values) {
      ensurePrimaryStatusReasonsIsMutable();
      for (com.google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason value : values) {
        primaryStatusReasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearPrimaryStatusReasons() {
      primaryStatusReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return A list containing the enum numeric values on the wire for primaryStatusReasons.
     */
    public java.util.List<java.lang.Integer>
    getPrimaryStatusReasonsValueList() {
      return java.util.Collections.unmodifiableList(primaryStatusReasons_);
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of primaryStatusReasons at the given index.
     */
    public int getPrimaryStatusReasonsValue(int index) {
      return primaryStatusReasons_.get(index);
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for primaryStatusReasons to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryStatusReasonsValue(
        int index, int value) {
      ensurePrimaryStatusReasonsIsMutable();
      primaryStatusReasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for primaryStatusReasons to add.
     * @return This builder for chaining.
     */
    public Builder addPrimaryStatusReasonsValue(int value) {
      ensurePrimaryStatusReasonsIsMutable();
      primaryStatusReasons_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Provides reasons into why an asset group is not serving or not
     * serving optimally. It will be empty when the asset group is serving without
     * issues.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.enums.AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason primary_status_reasons = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param values The enum numeric values on the wire for primaryStatusReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllPrimaryStatusReasonsValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensurePrimaryStatusReasonsIsMutable();
      for (int value : values) {
        primaryStatusReasons_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object path1_ = "";
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in
     * the ad.
     * </pre>
     *
     * <code>string path1 = 7;</code>
     * @return The path1.
     */
    public java.lang.String getPath1() {
      java.lang.Object ref = path1_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path1_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in
     * the ad.
     * </pre>
     *
     * <code>string path1 = 7;</code>
     * @return The bytes for path1.
     */
    public com.google.protobuf.ByteString
        getPath1Bytes() {
      java.lang.Object ref = path1_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path1_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in
     * the ad.
     * </pre>
     *
     * <code>string path1 = 7;</code>
     * @param value The path1 to set.
     * @return This builder for chaining.
     */
    public Builder setPath1(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      path1_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in
     * the ad.
     * </pre>
     *
     * <code>string path1 = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearPath1() {
      path1_ = getDefaultInstance().getPath1();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in
     * the ad.
     * </pre>
     *
     * <code>string path1 = 7;</code>
     * @param value The bytes for path1 to set.
     * @return This builder for chaining.
     */
    public Builder setPath1Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      path1_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object path2_ = "";
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in
     * the ad. This field can only be set when path1 is set.
     * </pre>
     *
     * <code>string path2 = 8;</code>
     * @return The path2.
     */
    public java.lang.String getPath2() {
      java.lang.Object ref = path2_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path2_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in
     * the ad. This field can only be set when path1 is set.
     * </pre>
     *
     * <code>string path2 = 8;</code>
     * @return The bytes for path2.
     */
    public com.google.protobuf.ByteString
        getPath2Bytes() {
      java.lang.Object ref = path2_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path2_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in
     * the ad. This field can only be set when path1 is set.
     * </pre>
     *
     * <code>string path2 = 8;</code>
     * @param value The path2 to set.
     * @return This builder for chaining.
     */
    public Builder setPath2(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      path2_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in
     * the ad. This field can only be set when path1 is set.
     * </pre>
     *
     * <code>string path2 = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearPath2() {
      path2_ = getDefaultInstance().getPath2();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in
     * the ad. This field can only be set when path1 is set.
     * </pre>
     *
     * <code>string path2 = 8;</code>
     * @param value The bytes for path2 to set.
     * @return This builder for chaining.
     */
    public Builder setPath2Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      path2_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int adStrength_ = 0;
    /**
     * <pre>
     * Output only. Overall ad strength of this asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength ad_strength = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for adStrength.
     */
    @java.lang.Override public int getAdStrengthValue() {
      return adStrength_;
    }
    /**
     * <pre>
     * Output only. Overall ad strength of this asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength ad_strength = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for adStrength to set.
     * @return This builder for chaining.
     */
    public Builder setAdStrengthValue(int value) {
      adStrength_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Overall ad strength of this asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength ad_strength = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adStrength.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength getAdStrength() {
      com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength result = com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength.forNumber(adStrength_);
      return result == null ? com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Overall ad strength of this asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength ad_strength = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The adStrength to set.
     * @return This builder for chaining.
     */
    public Builder setAdStrength(com.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      adStrength_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Overall ad strength of this asset group.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.AdStrengthEnum.AdStrength ad_strength = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAdStrength() {
      bitField0_ = (bitField0_ & ~0x00000800);
      adStrength_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v16.resources.AssetGroup)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v16.resources.AssetGroup)
  private static final com.google.ads.googleads.v16.resources.AssetGroup DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v16.resources.AssetGroup();
  }

  public static com.google.ads.googleads.v16.resources.AssetGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AssetGroup>
      PARSER = new com.google.protobuf.AbstractParser<AssetGroup>() {
    @java.lang.Override
    public AssetGroup parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<AssetGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AssetGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v16.resources.AssetGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

