// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v16/resources/bidding_strategy_simulation.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v16.resources;

/**
 * <pre>
 * A bidding strategy simulation. Supported combinations of simulation type
 * and simulation modification method are detailed below respectively.
 *
 * 1. TARGET_CPA - UNIFORM
 * 2. TARGET_ROAS - UNIFORM
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v16.resources.BiddingStrategySimulation}
 */
public final class BiddingStrategySimulation extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v16.resources.BiddingStrategySimulation)
    BiddingStrategySimulationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use BiddingStrategySimulation.newBuilder() to construct.
  private BiddingStrategySimulation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private BiddingStrategySimulation() {
    resourceName_ = "";
    type_ = 0;
    modificationMethod_ = 0;
    startDate_ = "";
    endDate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new BiddingStrategySimulation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v16.resources.BiddingStrategySimulationProto.internal_static_google_ads_googleads_v16_resources_BiddingStrategySimulation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v16.resources.BiddingStrategySimulationProto.internal_static_google_ads_googleads_v16_resources_BiddingStrategySimulation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v16.resources.BiddingStrategySimulation.class, com.google.ads.googleads.v16.resources.BiddingStrategySimulation.Builder.class);
  }

  private int pointListCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object pointList_;
  public enum PointListCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TARGET_CPA_POINT_LIST(7),
    TARGET_ROAS_POINT_LIST(8),
    POINTLIST_NOT_SET(0);
    private final int value;
    private PointListCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PointListCase valueOf(int value) {
      return forNumber(value);
    }

    public static PointListCase forNumber(int value) {
      switch (value) {
        case 7: return TARGET_CPA_POINT_LIST;
        case 8: return TARGET_ROAS_POINT_LIST;
        case 0: return POINTLIST_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public PointListCase
  getPointListCase() {
    return PointListCase.forNumber(
        pointListCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Output only. The resource name of the bidding strategy simulation.
   * Bidding strategy simulation resource names have the form:
   *
   * `customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the bidding strategy simulation.
   * Bidding strategy simulation resource names have the form:
   *
   * `customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BIDDING_STRATEGY_ID_FIELD_NUMBER = 2;
  private long biddingStrategyId_ = 0L;
  /**
   * <pre>
   * Output only. Bidding strategy shared set id of the simulation.
   * </pre>
   *
   * <code>int64 bidding_strategy_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The biddingStrategyId.
   */
  @java.lang.Override
  public long getBiddingStrategyId() {
    return biddingStrategyId_;
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType getType() {
    com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
  }

  public static final int MODIFICATION_METHOD_FIELD_NUMBER = 4;
  private int modificationMethod_ = 0;
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for modificationMethod.
   */
  @java.lang.Override public int getModificationMethodValue() {
    return modificationMethod_;
  }
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The modificationMethod.
   */
  @java.lang.Override public com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
    com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod.forNumber(modificationMethod_);
    return result == null ? com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
  }

  public static final int START_DATE_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object startDate_ = "";
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The startDate.
   */
  @java.lang.Override
  public java.lang.String getStartDate() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for startDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getStartDateBytes() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      startDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_DATE_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private volatile java.lang.Object endDate_ = "";
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD
   * format
   * </pre>
   *
   * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The endDate.
   */
  @java.lang.Override
  public java.lang.String getEndDate() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD
   * format
   * </pre>
   *
   * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for endDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getEndDateBytes() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      endDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_CPA_POINT_LIST_FIELD_NUMBER = 7;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the targetCpaPointList field is set.
   */
  @java.lang.Override
  public boolean hasTargetCpaPointList() {
    return pointListCase_ == 7;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The targetCpaPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.common.TargetCpaSimulationPointList getTargetCpaPointList() {
    if (pointListCase_ == 7) {
       return (com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.common.TargetCpaSimulationPointListOrBuilder getTargetCpaPointListOrBuilder() {
    if (pointListCase_ == 7) {
       return (com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.getDefaultInstance();
  }

  public static final int TARGET_ROAS_POINT_LIST_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the targetRoasPointList field is set.
   */
  @java.lang.Override
  public boolean hasTargetRoasPointList() {
    return pointListCase_ == 8;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The targetRoasPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.common.TargetRoasSimulationPointList getTargetRoasPointList() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.common.TargetRoasSimulationPointListOrBuilder getTargetRoasPointListOrBuilder() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (biddingStrategyId_ != 0L) {
      output.writeInt64(2, biddingStrategyId_);
    }
    if (type_ != com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, modificationMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startDate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, startDate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endDate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, endDate_);
    }
    if (pointListCase_ == 7) {
      output.writeMessage(7, (com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_);
    }
    if (pointListCase_ == 8) {
      output.writeMessage(8, (com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (biddingStrategyId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, biddingStrategyId_);
    }
    if (type_ != com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, modificationMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startDate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, startDate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endDate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, endDate_);
    }
    if (pointListCase_ == 7) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, (com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_);
    }
    if (pointListCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v16.resources.BiddingStrategySimulation)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v16.resources.BiddingStrategySimulation other = (com.google.ads.googleads.v16.resources.BiddingStrategySimulation) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (getBiddingStrategyId()
        != other.getBiddingStrategyId()) return false;
    if (type_ != other.type_) return false;
    if (modificationMethod_ != other.modificationMethod_) return false;
    if (!getStartDate()
        .equals(other.getStartDate())) return false;
    if (!getEndDate()
        .equals(other.getEndDate())) return false;
    if (!getPointListCase().equals(other.getPointListCase())) return false;
    switch (pointListCase_) {
      case 7:
        if (!getTargetCpaPointList()
            .equals(other.getTargetCpaPointList())) return false;
        break;
      case 8:
        if (!getTargetRoasPointList()
            .equals(other.getTargetRoasPointList())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + BIDDING_STRATEGY_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getBiddingStrategyId());
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + MODIFICATION_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + modificationMethod_;
    hash = (37 * hash) + START_DATE_FIELD_NUMBER;
    hash = (53 * hash) + getStartDate().hashCode();
    hash = (37 * hash) + END_DATE_FIELD_NUMBER;
    hash = (53 * hash) + getEndDate().hashCode();
    switch (pointListCase_) {
      case 7:
        hash = (37 * hash) + TARGET_CPA_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getTargetCpaPointList().hashCode();
        break;
      case 8:
        hash = (37 * hash) + TARGET_ROAS_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getTargetRoasPointList().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v16.resources.BiddingStrategySimulation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A bidding strategy simulation. Supported combinations of simulation type
   * and simulation modification method are detailed below respectively.
   *
   * 1. TARGET_CPA - UNIFORM
   * 2. TARGET_ROAS - UNIFORM
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v16.resources.BiddingStrategySimulation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v16.resources.BiddingStrategySimulation)
      com.google.ads.googleads.v16.resources.BiddingStrategySimulationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v16.resources.BiddingStrategySimulationProto.internal_static_google_ads_googleads_v16_resources_BiddingStrategySimulation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v16.resources.BiddingStrategySimulationProto.internal_static_google_ads_googleads_v16_resources_BiddingStrategySimulation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v16.resources.BiddingStrategySimulation.class, com.google.ads.googleads.v16.resources.BiddingStrategySimulation.Builder.class);
    }

    // Construct using com.google.ads.googleads.v16.resources.BiddingStrategySimulation.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      biddingStrategyId_ = 0L;
      type_ = 0;
      modificationMethod_ = 0;
      startDate_ = "";
      endDate_ = "";
      if (targetCpaPointListBuilder_ != null) {
        targetCpaPointListBuilder_.clear();
      }
      if (targetRoasPointListBuilder_ != null) {
        targetRoasPointListBuilder_.clear();
      }
      pointListCase_ = 0;
      pointList_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v16.resources.BiddingStrategySimulationProto.internal_static_google_ads_googleads_v16_resources_BiddingStrategySimulation_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.resources.BiddingStrategySimulation getDefaultInstanceForType() {
      return com.google.ads.googleads.v16.resources.BiddingStrategySimulation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.resources.BiddingStrategySimulation build() {
      com.google.ads.googleads.v16.resources.BiddingStrategySimulation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.resources.BiddingStrategySimulation buildPartial() {
      com.google.ads.googleads.v16.resources.BiddingStrategySimulation result = new com.google.ads.googleads.v16.resources.BiddingStrategySimulation(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v16.resources.BiddingStrategySimulation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.biddingStrategyId_ = biddingStrategyId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modificationMethod_ = modificationMethod_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.startDate_ = startDate_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endDate_ = endDate_;
      }
    }

    private void buildPartialOneofs(com.google.ads.googleads.v16.resources.BiddingStrategySimulation result) {
      result.pointListCase_ = pointListCase_;
      result.pointList_ = this.pointList_;
      if (pointListCase_ == 7 &&
          targetCpaPointListBuilder_ != null) {
        result.pointList_ = targetCpaPointListBuilder_.build();
      }
      if (pointListCase_ == 8 &&
          targetRoasPointListBuilder_ != null) {
        result.pointList_ = targetRoasPointListBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v16.resources.BiddingStrategySimulation) {
        return mergeFrom((com.google.ads.googleads.v16.resources.BiddingStrategySimulation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v16.resources.BiddingStrategySimulation other) {
      if (other == com.google.ads.googleads.v16.resources.BiddingStrategySimulation.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getBiddingStrategyId() != 0L) {
        setBiddingStrategyId(other.getBiddingStrategyId());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.modificationMethod_ != 0) {
        setModificationMethodValue(other.getModificationMethodValue());
      }
      if (!other.getStartDate().isEmpty()) {
        startDate_ = other.startDate_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getEndDate().isEmpty()) {
        endDate_ = other.endDate_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getPointListCase()) {
        case TARGET_CPA_POINT_LIST: {
          mergeTargetCpaPointList(other.getTargetCpaPointList());
          break;
        }
        case TARGET_ROAS_POINT_LIST: {
          mergeTargetRoasPointList(other.getTargetRoasPointList());
          break;
        }
        case POINTLIST_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              biddingStrategyId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 32: {
              modificationMethod_ = input.readEnum();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 42: {
              startDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            case 50: {
              endDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000020;
              break;
            } // case 50
            case 58: {
              input.readMessage(
                  getTargetCpaPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 7;
              break;
            } // case 58
            case 66: {
              input.readMessage(
                  getTargetRoasPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 8;
              break;
            } // case 66
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int pointListCase_ = 0;
    private java.lang.Object pointList_;
    public PointListCase
        getPointListCase() {
      return PointListCase.forNumber(
          pointListCase_);
    }

    public Builder clearPointList() {
      pointListCase_ = 0;
      pointList_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the bidding strategy simulation.
     * Bidding strategy simulation resource names have the form:
     *
     * `customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the bidding strategy simulation.
     * Bidding strategy simulation resource names have the form:
     *
     * `customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the bidding strategy simulation.
     * Bidding strategy simulation resource names have the form:
     *
     * `customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the bidding strategy simulation.
     * Bidding strategy simulation resource names have the form:
     *
     * `customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the bidding strategy simulation.
     * Bidding strategy simulation resource names have the form:
     *
     * `customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long biddingStrategyId_ ;
    /**
     * <pre>
     * Output only. Bidding strategy shared set id of the simulation.
     * </pre>
     *
     * <code>int64 bidding_strategy_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The biddingStrategyId.
     */
    @java.lang.Override
    public long getBiddingStrategyId() {
      return biddingStrategyId_;
    }
    /**
     * <pre>
     * Output only. Bidding strategy shared set id of the simulation.
     * </pre>
     *
     * <code>int64 bidding_strategy_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The biddingStrategyId to set.
     * @return This builder for chaining.
     */
    public Builder setBiddingStrategyId(long value) {

      biddingStrategyId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Bidding strategy shared set id of the simulation.
     * </pre>
     *
     * <code>int64 bidding_strategy_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearBiddingStrategyId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      biddingStrategyId_ = 0L;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType getType() {
      com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private int modificationMethod_ = 0;
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for modificationMethod.
     */
    @java.lang.Override public int getModificationMethodValue() {
      return modificationMethod_;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethodValue(int value) {
      modificationMethod_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The modificationMethod.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
      com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod.forNumber(modificationMethod_);
      return result == null ? com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethod(com.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      modificationMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearModificationMethod() {
      bitField0_ = (bitField0_ & ~0x00000008);
      modificationMethod_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object startDate_ = "";
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The startDate.
     */
    public java.lang.String getStartDate() {
      java.lang.Object ref = startDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for startDate.
     */
    public com.google.protobuf.ByteString
        getStartDateBytes() {
      java.lang.Object ref = startDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      startDate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStartDate() {
      startDate_ = getDefaultInstance().getStartDate();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      startDate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object endDate_ = "";
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endDate.
     */
    public java.lang.String getEndDate() {
      java.lang.Object ref = endDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for endDate.
     */
    public com.google.protobuf.ByteString
        getEndDateBytes() {
      java.lang.Object ref = endDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        endDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      endDate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearEndDate() {
      endDate_ = getDefaultInstance().getEndDate();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      endDate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v16.common.TargetCpaSimulationPointList, com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v16.common.TargetCpaSimulationPointListOrBuilder> targetCpaPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the targetCpaPointList field is set.
     */
    @java.lang.Override
    public boolean hasTargetCpaPointList() {
      return pointListCase_ == 7;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The targetCpaPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.common.TargetCpaSimulationPointList getTargetCpaPointList() {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 7) {
          return (com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 7) {
          return targetCpaPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetCpaPointList(com.google.ads.googleads.v16.common.TargetCpaSimulationPointList value) {
      if (targetCpaPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        targetCpaPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetCpaPointList(
        com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.Builder builderForValue) {
      if (targetCpaPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        targetCpaPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTargetCpaPointList(com.google.ads.googleads.v16.common.TargetCpaSimulationPointList value) {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 7 &&
            pointList_ != com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.newBuilder((com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 7) {
          targetCpaPointListBuilder_.mergeFrom(value);
        } else {
          targetCpaPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTargetCpaPointList() {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 7) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 7) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        targetCpaPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.Builder getTargetCpaPointListBuilder() {
      return getTargetCpaPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.common.TargetCpaSimulationPointListOrBuilder getTargetCpaPointListOrBuilder() {
      if ((pointListCase_ == 7) && (targetCpaPointListBuilder_ != null)) {
        return targetCpaPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 7) {
          return (com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetCpaSimulationPointList target_cpa_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v16.common.TargetCpaSimulationPointList, com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v16.common.TargetCpaSimulationPointListOrBuilder> 
        getTargetCpaPointListFieldBuilder() {
      if (targetCpaPointListBuilder_ == null) {
        if (!(pointListCase_ == 7)) {
          pointList_ = com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.getDefaultInstance();
        }
        targetCpaPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v16.common.TargetCpaSimulationPointList, com.google.ads.googleads.v16.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v16.common.TargetCpaSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v16.common.TargetCpaSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 7;
      onChanged();
      return targetCpaPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v16.common.TargetRoasSimulationPointList, com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v16.common.TargetRoasSimulationPointListOrBuilder> targetRoasPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the targetRoasPointList field is set.
     */
    @java.lang.Override
    public boolean hasTargetRoasPointList() {
      return pointListCase_ == 8;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The targetRoasPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.common.TargetRoasSimulationPointList getTargetRoasPointList() {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 8) {
          return targetRoasPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetRoasPointList(com.google.ads.googleads.v16.common.TargetRoasSimulationPointList value) {
      if (targetRoasPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        targetRoasPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetRoasPointList(
        com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.Builder builderForValue) {
      if (targetRoasPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        targetRoasPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTargetRoasPointList(com.google.ads.googleads.v16.common.TargetRoasSimulationPointList value) {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 8 &&
            pointList_ != com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.newBuilder((com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 8) {
          targetRoasPointListBuilder_.mergeFrom(value);
        } else {
          targetRoasPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTargetRoasPointList() {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        targetRoasPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.Builder getTargetRoasPointListBuilder() {
      return getTargetRoasPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.common.TargetRoasSimulationPointListOrBuilder getTargetRoasPointListOrBuilder() {
      if ((pointListCase_ == 8) && (targetRoasPointListBuilder_ != null)) {
        return targetRoasPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.common.TargetRoasSimulationPointList target_roas_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v16.common.TargetRoasSimulationPointList, com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v16.common.TargetRoasSimulationPointListOrBuilder> 
        getTargetRoasPointListFieldBuilder() {
      if (targetRoasPointListBuilder_ == null) {
        if (!(pointListCase_ == 8)) {
          pointList_ = com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.getDefaultInstance();
        }
        targetRoasPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v16.common.TargetRoasSimulationPointList, com.google.ads.googleads.v16.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v16.common.TargetRoasSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v16.common.TargetRoasSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 8;
      onChanged();
      return targetRoasPointListBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v16.resources.BiddingStrategySimulation)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v16.resources.BiddingStrategySimulation)
  private static final com.google.ads.googleads.v16.resources.BiddingStrategySimulation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v16.resources.BiddingStrategySimulation();
  }

  public static com.google.ads.googleads.v16.resources.BiddingStrategySimulation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BiddingStrategySimulation>
      PARSER = new com.google.protobuf.AbstractParser<BiddingStrategySimulation>() {
    @java.lang.Override
    public BiddingStrategySimulation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<BiddingStrategySimulation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BiddingStrategySimulation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v16.resources.BiddingStrategySimulation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

