// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v16/services/travel_asset_suggestion_service.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v16.services;

/**
 * <pre>
 * Message containing the asset suggestions for a hotel.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v16.services.HotelAssetSuggestion}
 */
public final class HotelAssetSuggestion extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v16.services.HotelAssetSuggestion)
    HotelAssetSuggestionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use HotelAssetSuggestion.newBuilder() to construct.
  private HotelAssetSuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HotelAssetSuggestion() {
    placeId_ = "";
    finalUrl_ = "";
    hotelName_ = "";
    callToAction_ = 0;
    textAssets_ = java.util.Collections.emptyList();
    imageAssets_ = java.util.Collections.emptyList();
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new HotelAssetSuggestion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v16.services.TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v16_services_HotelAssetSuggestion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v16.services.TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v16_services_HotelAssetSuggestion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v16.services.HotelAssetSuggestion.class, com.google.ads.googleads.v16.services.HotelAssetSuggestion.Builder.class);
  }

  public static final int PLACE_ID_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object placeId_ = "";
  /**
   * <pre>
   * Google Places ID of the hotel.
   * </pre>
   *
   * <code>string place_id = 1;</code>
   * @return The placeId.
   */
  @java.lang.Override
  public java.lang.String getPlaceId() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      placeId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Google Places ID of the hotel.
   * </pre>
   *
   * <code>string place_id = 1;</code>
   * @return The bytes for placeId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPlaceIdBytes() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      placeId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINAL_URL_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object finalUrl_ = "";
  /**
   * <pre>
   * Suggested final URL for an AssetGroup.
   * </pre>
   *
   * <code>string final_url = 2;</code>
   * @return The finalUrl.
   */
  @java.lang.Override
  public java.lang.String getFinalUrl() {
    java.lang.Object ref = finalUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      finalUrl_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Suggested final URL for an AssetGroup.
   * </pre>
   *
   * <code>string final_url = 2;</code>
   * @return The bytes for finalUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getFinalUrlBytes() {
    java.lang.Object ref = finalUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      finalUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOTEL_NAME_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private volatile java.lang.Object hotelName_ = "";
  /**
   * <pre>
   * Hotel name in requested language.
   * </pre>
   *
   * <code>string hotel_name = 3;</code>
   * @return The hotelName.
   */
  @java.lang.Override
  public java.lang.String getHotelName() {
    java.lang.Object ref = hotelName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hotelName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Hotel name in requested language.
   * </pre>
   *
   * <code>string hotel_name = 3;</code>
   * @return The bytes for hotelName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getHotelNameBytes() {
    java.lang.Object ref = hotelName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      hotelName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALL_TO_ACTION_FIELD_NUMBER = 4;
  private int callToAction_ = 0;
  /**
   * <pre>
   * Call to action type.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType call_to_action = 4;</code>
   * @return The enum numeric value on the wire for callToAction.
   */
  @java.lang.Override public int getCallToActionValue() {
    return callToAction_;
  }
  /**
   * <pre>
   * Call to action type.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType call_to_action = 4;</code>
   * @return The callToAction.
   */
  @java.lang.Override public com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType getCallToAction() {
    com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType result = com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType.forNumber(callToAction_);
    return result == null ? com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType.UNRECOGNIZED : result;
  }

  public static final int TEXT_ASSETS_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v16.services.HotelTextAsset> textAssets_;
  /**
   * <pre>
   * Text assets such as headline, description, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v16.services.HotelTextAsset> getTextAssetsList() {
    return textAssets_;
  }
  /**
   * <pre>
   * Text assets such as headline, description, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v16.services.HotelTextAssetOrBuilder> 
      getTextAssetsOrBuilderList() {
    return textAssets_;
  }
  /**
   * <pre>
   * Text assets such as headline, description, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
   */
  @java.lang.Override
  public int getTextAssetsCount() {
    return textAssets_.size();
  }
  /**
   * <pre>
   * Text assets such as headline, description, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.services.HotelTextAsset getTextAssets(int index) {
    return textAssets_.get(index);
  }
  /**
   * <pre>
   * Text assets such as headline, description, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.services.HotelTextAssetOrBuilder getTextAssetsOrBuilder(
      int index) {
    return textAssets_.get(index);
  }

  public static final int IMAGE_ASSETS_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v16.services.HotelImageAsset> imageAssets_;
  /**
   * <pre>
   * Image assets such as landscape/portrait/square, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v16.services.HotelImageAsset> getImageAssetsList() {
    return imageAssets_;
  }
  /**
   * <pre>
   * Image assets such as landscape/portrait/square, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v16.services.HotelImageAssetOrBuilder> 
      getImageAssetsOrBuilderList() {
    return imageAssets_;
  }
  /**
   * <pre>
   * Image assets such as landscape/portrait/square, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
   */
  @java.lang.Override
  public int getImageAssetsCount() {
    return imageAssets_.size();
  }
  /**
   * <pre>
   * Image assets such as landscape/portrait/square, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.services.HotelImageAsset getImageAssets(int index) {
    return imageAssets_.get(index);
  }
  /**
   * <pre>
   * Image assets such as landscape/portrait/square, etc.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v16.services.HotelImageAssetOrBuilder getImageAssetsOrBuilder(
      int index) {
    return imageAssets_.get(index);
  }

  public static final int STATUS_FIELD_NUMBER = 7;
  private int status_ = 0;
  /**
   * <pre>
   * The status of the hotel asset suggestion.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus status = 7;</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * The status of the hotel asset suggestion.
   * </pre>
   *
   * <code>.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus status = 7;</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus getStatus() {
    com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus result = com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, placeId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, finalUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hotelName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, hotelName_);
    }
    if (callToAction_ != com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, callToAction_);
    }
    for (int i = 0; i < textAssets_.size(); i++) {
      output.writeMessage(5, textAssets_.get(i));
    }
    for (int i = 0; i < imageAssets_.size(); i++) {
      output.writeMessage(6, imageAssets_.get(i));
    }
    if (status_ != com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(7, status_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, placeId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, finalUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hotelName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, hotelName_);
    }
    if (callToAction_ != com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, callToAction_);
    }
    for (int i = 0; i < textAssets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, textAssets_.get(i));
    }
    for (int i = 0; i < imageAssets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, imageAssets_.get(i));
    }
    if (status_ != com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(7, status_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v16.services.HotelAssetSuggestion)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v16.services.HotelAssetSuggestion other = (com.google.ads.googleads.v16.services.HotelAssetSuggestion) obj;

    if (!getPlaceId()
        .equals(other.getPlaceId())) return false;
    if (!getFinalUrl()
        .equals(other.getFinalUrl())) return false;
    if (!getHotelName()
        .equals(other.getHotelName())) return false;
    if (callToAction_ != other.callToAction_) return false;
    if (!getTextAssetsList()
        .equals(other.getTextAssetsList())) return false;
    if (!getImageAssetsList()
        .equals(other.getImageAssetsList())) return false;
    if (status_ != other.status_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PLACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPlaceId().hashCode();
    hash = (37 * hash) + FINAL_URL_FIELD_NUMBER;
    hash = (53 * hash) + getFinalUrl().hashCode();
    hash = (37 * hash) + HOTEL_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getHotelName().hashCode();
    hash = (37 * hash) + CALL_TO_ACTION_FIELD_NUMBER;
    hash = (53 * hash) + callToAction_;
    if (getTextAssetsCount() > 0) {
      hash = (37 * hash) + TEXT_ASSETS_FIELD_NUMBER;
      hash = (53 * hash) + getTextAssetsList().hashCode();
    }
    if (getImageAssetsCount() > 0) {
      hash = (37 * hash) + IMAGE_ASSETS_FIELD_NUMBER;
      hash = (53 * hash) + getImageAssetsList().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v16.services.HotelAssetSuggestion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Message containing the asset suggestions for a hotel.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v16.services.HotelAssetSuggestion}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v16.services.HotelAssetSuggestion)
      com.google.ads.googleads.v16.services.HotelAssetSuggestionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v16.services.TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v16_services_HotelAssetSuggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v16.services.TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v16_services_HotelAssetSuggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v16.services.HotelAssetSuggestion.class, com.google.ads.googleads.v16.services.HotelAssetSuggestion.Builder.class);
    }

    // Construct using com.google.ads.googleads.v16.services.HotelAssetSuggestion.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      placeId_ = "";
      finalUrl_ = "";
      hotelName_ = "";
      callToAction_ = 0;
      if (textAssetsBuilder_ == null) {
        textAssets_ = java.util.Collections.emptyList();
      } else {
        textAssets_ = null;
        textAssetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (imageAssetsBuilder_ == null) {
        imageAssets_ = java.util.Collections.emptyList();
      } else {
        imageAssets_ = null;
        imageAssetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      status_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v16.services.TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v16_services_HotelAssetSuggestion_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.services.HotelAssetSuggestion getDefaultInstanceForType() {
      return com.google.ads.googleads.v16.services.HotelAssetSuggestion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.services.HotelAssetSuggestion build() {
      com.google.ads.googleads.v16.services.HotelAssetSuggestion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v16.services.HotelAssetSuggestion buildPartial() {
      com.google.ads.googleads.v16.services.HotelAssetSuggestion result = new com.google.ads.googleads.v16.services.HotelAssetSuggestion(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v16.services.HotelAssetSuggestion result) {
      if (textAssetsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          textAssets_ = java.util.Collections.unmodifiableList(textAssets_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.textAssets_ = textAssets_;
      } else {
        result.textAssets_ = textAssetsBuilder_.build();
      }
      if (imageAssetsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          imageAssets_ = java.util.Collections.unmodifiableList(imageAssets_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.imageAssets_ = imageAssets_;
      } else {
        result.imageAssets_ = imageAssetsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ads.googleads.v16.services.HotelAssetSuggestion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.placeId_ = placeId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.finalUrl_ = finalUrl_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.hotelName_ = hotelName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.callToAction_ = callToAction_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.status_ = status_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v16.services.HotelAssetSuggestion) {
        return mergeFrom((com.google.ads.googleads.v16.services.HotelAssetSuggestion)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v16.services.HotelAssetSuggestion other) {
      if (other == com.google.ads.googleads.v16.services.HotelAssetSuggestion.getDefaultInstance()) return this;
      if (!other.getPlaceId().isEmpty()) {
        placeId_ = other.placeId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFinalUrl().isEmpty()) {
        finalUrl_ = other.finalUrl_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getHotelName().isEmpty()) {
        hotelName_ = other.hotelName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.callToAction_ != 0) {
        setCallToActionValue(other.getCallToActionValue());
      }
      if (textAssetsBuilder_ == null) {
        if (!other.textAssets_.isEmpty()) {
          if (textAssets_.isEmpty()) {
            textAssets_ = other.textAssets_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureTextAssetsIsMutable();
            textAssets_.addAll(other.textAssets_);
          }
          onChanged();
        }
      } else {
        if (!other.textAssets_.isEmpty()) {
          if (textAssetsBuilder_.isEmpty()) {
            textAssetsBuilder_.dispose();
            textAssetsBuilder_ = null;
            textAssets_ = other.textAssets_;
            bitField0_ = (bitField0_ & ~0x00000010);
            textAssetsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getTextAssetsFieldBuilder() : null;
          } else {
            textAssetsBuilder_.addAllMessages(other.textAssets_);
          }
        }
      }
      if (imageAssetsBuilder_ == null) {
        if (!other.imageAssets_.isEmpty()) {
          if (imageAssets_.isEmpty()) {
            imageAssets_ = other.imageAssets_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureImageAssetsIsMutable();
            imageAssets_.addAll(other.imageAssets_);
          }
          onChanged();
        }
      } else {
        if (!other.imageAssets_.isEmpty()) {
          if (imageAssetsBuilder_.isEmpty()) {
            imageAssetsBuilder_.dispose();
            imageAssetsBuilder_ = null;
            imageAssets_ = other.imageAssets_;
            bitField0_ = (bitField0_ & ~0x00000020);
            imageAssetsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getImageAssetsFieldBuilder() : null;
          } else {
            imageAssetsBuilder_.addAllMessages(other.imageAssets_);
          }
        }
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              placeId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              finalUrl_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 26: {
              hotelName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 26
            case 32: {
              callToAction_ = input.readEnum();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 42: {
              com.google.ads.googleads.v16.services.HotelTextAsset m =
                  input.readMessage(
                      com.google.ads.googleads.v16.services.HotelTextAsset.parser(),
                      extensionRegistry);
              if (textAssetsBuilder_ == null) {
                ensureTextAssetsIsMutable();
                textAssets_.add(m);
              } else {
                textAssetsBuilder_.addMessage(m);
              }
              break;
            } // case 42
            case 50: {
              com.google.ads.googleads.v16.services.HotelImageAsset m =
                  input.readMessage(
                      com.google.ads.googleads.v16.services.HotelImageAsset.parser(),
                      extensionRegistry);
              if (imageAssetsBuilder_ == null) {
                ensureImageAssetsIsMutable();
                imageAssets_.add(m);
              } else {
                imageAssetsBuilder_.addMessage(m);
              }
              break;
            } // case 50
            case 56: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000040;
              break;
            } // case 56
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object placeId_ = "";
    /**
     * <pre>
     * Google Places ID of the hotel.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     * @return The placeId.
     */
    public java.lang.String getPlaceId() {
      java.lang.Object ref = placeId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        placeId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Google Places ID of the hotel.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     * @return The bytes for placeId.
     */
    public com.google.protobuf.ByteString
        getPlaceIdBytes() {
      java.lang.Object ref = placeId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        placeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Google Places ID of the hotel.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     * @param value The placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      placeId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Google Places ID of the hotel.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearPlaceId() {
      placeId_ = getDefaultInstance().getPlaceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Google Places ID of the hotel.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     * @param value The bytes for placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      placeId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object finalUrl_ = "";
    /**
     * <pre>
     * Suggested final URL for an AssetGroup.
     * </pre>
     *
     * <code>string final_url = 2;</code>
     * @return The finalUrl.
     */
    public java.lang.String getFinalUrl() {
      java.lang.Object ref = finalUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        finalUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Suggested final URL for an AssetGroup.
     * </pre>
     *
     * <code>string final_url = 2;</code>
     * @return The bytes for finalUrl.
     */
    public com.google.protobuf.ByteString
        getFinalUrlBytes() {
      java.lang.Object ref = finalUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        finalUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Suggested final URL for an AssetGroup.
     * </pre>
     *
     * <code>string final_url = 2;</code>
     * @param value The finalUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFinalUrl(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      finalUrl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Suggested final URL for an AssetGroup.
     * </pre>
     *
     * <code>string final_url = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearFinalUrl() {
      finalUrl_ = getDefaultInstance().getFinalUrl();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Suggested final URL for an AssetGroup.
     * </pre>
     *
     * <code>string final_url = 2;</code>
     * @param value The bytes for finalUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFinalUrlBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      finalUrl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object hotelName_ = "";
    /**
     * <pre>
     * Hotel name in requested language.
     * </pre>
     *
     * <code>string hotel_name = 3;</code>
     * @return The hotelName.
     */
    public java.lang.String getHotelName() {
      java.lang.Object ref = hotelName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hotelName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Hotel name in requested language.
     * </pre>
     *
     * <code>string hotel_name = 3;</code>
     * @return The bytes for hotelName.
     */
    public com.google.protobuf.ByteString
        getHotelNameBytes() {
      java.lang.Object ref = hotelName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        hotelName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Hotel name in requested language.
     * </pre>
     *
     * <code>string hotel_name = 3;</code>
     * @param value The hotelName to set.
     * @return This builder for chaining.
     */
    public Builder setHotelName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      hotelName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hotel name in requested language.
     * </pre>
     *
     * <code>string hotel_name = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearHotelName() {
      hotelName_ = getDefaultInstance().getHotelName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hotel name in requested language.
     * </pre>
     *
     * <code>string hotel_name = 3;</code>
     * @param value The bytes for hotelName to set.
     * @return This builder for chaining.
     */
    public Builder setHotelNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      hotelName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int callToAction_ = 0;
    /**
     * <pre>
     * Call to action type.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType call_to_action = 4;</code>
     * @return The enum numeric value on the wire for callToAction.
     */
    @java.lang.Override public int getCallToActionValue() {
      return callToAction_;
    }
    /**
     * <pre>
     * Call to action type.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType call_to_action = 4;</code>
     * @param value The enum numeric value on the wire for callToAction to set.
     * @return This builder for chaining.
     */
    public Builder setCallToActionValue(int value) {
      callToAction_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Call to action type.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType call_to_action = 4;</code>
     * @return The callToAction.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType getCallToAction() {
      com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType result = com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType.forNumber(callToAction_);
      return result == null ? com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Call to action type.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType call_to_action = 4;</code>
     * @param value The callToAction to set.
     * @return This builder for chaining.
     */
    public Builder setCallToAction(com.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      callToAction_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Call to action type.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.CallToActionTypeEnum.CallToActionType call_to_action = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearCallToAction() {
      bitField0_ = (bitField0_ & ~0x00000008);
      callToAction_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ads.googleads.v16.services.HotelTextAsset> textAssets_ =
      java.util.Collections.emptyList();
    private void ensureTextAssetsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        textAssets_ = new java.util.ArrayList<com.google.ads.googleads.v16.services.HotelTextAsset>(textAssets_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v16.services.HotelTextAsset, com.google.ads.googleads.v16.services.HotelTextAsset.Builder, com.google.ads.googleads.v16.services.HotelTextAssetOrBuilder> textAssetsBuilder_;

    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public java.util.List<com.google.ads.googleads.v16.services.HotelTextAsset> getTextAssetsList() {
      if (textAssetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(textAssets_);
      } else {
        return textAssetsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public int getTextAssetsCount() {
      if (textAssetsBuilder_ == null) {
        return textAssets_.size();
      } else {
        return textAssetsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public com.google.ads.googleads.v16.services.HotelTextAsset getTextAssets(int index) {
      if (textAssetsBuilder_ == null) {
        return textAssets_.get(index);
      } else {
        return textAssetsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder setTextAssets(
        int index, com.google.ads.googleads.v16.services.HotelTextAsset value) {
      if (textAssetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAssetsIsMutable();
        textAssets_.set(index, value);
        onChanged();
      } else {
        textAssetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder setTextAssets(
        int index, com.google.ads.googleads.v16.services.HotelTextAsset.Builder builderForValue) {
      if (textAssetsBuilder_ == null) {
        ensureTextAssetsIsMutable();
        textAssets_.set(index, builderForValue.build());
        onChanged();
      } else {
        textAssetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder addTextAssets(com.google.ads.googleads.v16.services.HotelTextAsset value) {
      if (textAssetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAssetsIsMutable();
        textAssets_.add(value);
        onChanged();
      } else {
        textAssetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder addTextAssets(
        int index, com.google.ads.googleads.v16.services.HotelTextAsset value) {
      if (textAssetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAssetsIsMutable();
        textAssets_.add(index, value);
        onChanged();
      } else {
        textAssetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder addTextAssets(
        com.google.ads.googleads.v16.services.HotelTextAsset.Builder builderForValue) {
      if (textAssetsBuilder_ == null) {
        ensureTextAssetsIsMutable();
        textAssets_.add(builderForValue.build());
        onChanged();
      } else {
        textAssetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder addTextAssets(
        int index, com.google.ads.googleads.v16.services.HotelTextAsset.Builder builderForValue) {
      if (textAssetsBuilder_ == null) {
        ensureTextAssetsIsMutable();
        textAssets_.add(index, builderForValue.build());
        onChanged();
      } else {
        textAssetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder addAllTextAssets(
        java.lang.Iterable<? extends com.google.ads.googleads.v16.services.HotelTextAsset> values) {
      if (textAssetsBuilder_ == null) {
        ensureTextAssetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, textAssets_);
        onChanged();
      } else {
        textAssetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder clearTextAssets() {
      if (textAssetsBuilder_ == null) {
        textAssets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        textAssetsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public Builder removeTextAssets(int index) {
      if (textAssetsBuilder_ == null) {
        ensureTextAssetsIsMutable();
        textAssets_.remove(index);
        onChanged();
      } else {
        textAssetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public com.google.ads.googleads.v16.services.HotelTextAsset.Builder getTextAssetsBuilder(
        int index) {
      return getTextAssetsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public com.google.ads.googleads.v16.services.HotelTextAssetOrBuilder getTextAssetsOrBuilder(
        int index) {
      if (textAssetsBuilder_ == null) {
        return textAssets_.get(index);  } else {
        return textAssetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v16.services.HotelTextAssetOrBuilder> 
         getTextAssetsOrBuilderList() {
      if (textAssetsBuilder_ != null) {
        return textAssetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(textAssets_);
      }
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public com.google.ads.googleads.v16.services.HotelTextAsset.Builder addTextAssetsBuilder() {
      return getTextAssetsFieldBuilder().addBuilder(
          com.google.ads.googleads.v16.services.HotelTextAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public com.google.ads.googleads.v16.services.HotelTextAsset.Builder addTextAssetsBuilder(
        int index) {
      return getTextAssetsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v16.services.HotelTextAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * Text assets such as headline, description, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelTextAsset text_assets = 5;</code>
     */
    public java.util.List<com.google.ads.googleads.v16.services.HotelTextAsset.Builder> 
         getTextAssetsBuilderList() {
      return getTextAssetsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v16.services.HotelTextAsset, com.google.ads.googleads.v16.services.HotelTextAsset.Builder, com.google.ads.googleads.v16.services.HotelTextAssetOrBuilder> 
        getTextAssetsFieldBuilder() {
      if (textAssetsBuilder_ == null) {
        textAssetsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v16.services.HotelTextAsset, com.google.ads.googleads.v16.services.HotelTextAsset.Builder, com.google.ads.googleads.v16.services.HotelTextAssetOrBuilder>(
                textAssets_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        textAssets_ = null;
      }
      return textAssetsBuilder_;
    }

    private java.util.List<com.google.ads.googleads.v16.services.HotelImageAsset> imageAssets_ =
      java.util.Collections.emptyList();
    private void ensureImageAssetsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        imageAssets_ = new java.util.ArrayList<com.google.ads.googleads.v16.services.HotelImageAsset>(imageAssets_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v16.services.HotelImageAsset, com.google.ads.googleads.v16.services.HotelImageAsset.Builder, com.google.ads.googleads.v16.services.HotelImageAssetOrBuilder> imageAssetsBuilder_;

    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public java.util.List<com.google.ads.googleads.v16.services.HotelImageAsset> getImageAssetsList() {
      if (imageAssetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(imageAssets_);
      } else {
        return imageAssetsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public int getImageAssetsCount() {
      if (imageAssetsBuilder_ == null) {
        return imageAssets_.size();
      } else {
        return imageAssetsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public com.google.ads.googleads.v16.services.HotelImageAsset getImageAssets(int index) {
      if (imageAssetsBuilder_ == null) {
        return imageAssets_.get(index);
      } else {
        return imageAssetsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder setImageAssets(
        int index, com.google.ads.googleads.v16.services.HotelImageAsset value) {
      if (imageAssetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImageAssetsIsMutable();
        imageAssets_.set(index, value);
        onChanged();
      } else {
        imageAssetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder setImageAssets(
        int index, com.google.ads.googleads.v16.services.HotelImageAsset.Builder builderForValue) {
      if (imageAssetsBuilder_ == null) {
        ensureImageAssetsIsMutable();
        imageAssets_.set(index, builderForValue.build());
        onChanged();
      } else {
        imageAssetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder addImageAssets(com.google.ads.googleads.v16.services.HotelImageAsset value) {
      if (imageAssetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImageAssetsIsMutable();
        imageAssets_.add(value);
        onChanged();
      } else {
        imageAssetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder addImageAssets(
        int index, com.google.ads.googleads.v16.services.HotelImageAsset value) {
      if (imageAssetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImageAssetsIsMutable();
        imageAssets_.add(index, value);
        onChanged();
      } else {
        imageAssetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder addImageAssets(
        com.google.ads.googleads.v16.services.HotelImageAsset.Builder builderForValue) {
      if (imageAssetsBuilder_ == null) {
        ensureImageAssetsIsMutable();
        imageAssets_.add(builderForValue.build());
        onChanged();
      } else {
        imageAssetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder addImageAssets(
        int index, com.google.ads.googleads.v16.services.HotelImageAsset.Builder builderForValue) {
      if (imageAssetsBuilder_ == null) {
        ensureImageAssetsIsMutable();
        imageAssets_.add(index, builderForValue.build());
        onChanged();
      } else {
        imageAssetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder addAllImageAssets(
        java.lang.Iterable<? extends com.google.ads.googleads.v16.services.HotelImageAsset> values) {
      if (imageAssetsBuilder_ == null) {
        ensureImageAssetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, imageAssets_);
        onChanged();
      } else {
        imageAssetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder clearImageAssets() {
      if (imageAssetsBuilder_ == null) {
        imageAssets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        imageAssetsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public Builder removeImageAssets(int index) {
      if (imageAssetsBuilder_ == null) {
        ensureImageAssetsIsMutable();
        imageAssets_.remove(index);
        onChanged();
      } else {
        imageAssetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public com.google.ads.googleads.v16.services.HotelImageAsset.Builder getImageAssetsBuilder(
        int index) {
      return getImageAssetsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public com.google.ads.googleads.v16.services.HotelImageAssetOrBuilder getImageAssetsOrBuilder(
        int index) {
      if (imageAssetsBuilder_ == null) {
        return imageAssets_.get(index);  } else {
        return imageAssetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v16.services.HotelImageAssetOrBuilder> 
         getImageAssetsOrBuilderList() {
      if (imageAssetsBuilder_ != null) {
        return imageAssetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(imageAssets_);
      }
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public com.google.ads.googleads.v16.services.HotelImageAsset.Builder addImageAssetsBuilder() {
      return getImageAssetsFieldBuilder().addBuilder(
          com.google.ads.googleads.v16.services.HotelImageAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public com.google.ads.googleads.v16.services.HotelImageAsset.Builder addImageAssetsBuilder(
        int index) {
      return getImageAssetsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v16.services.HotelImageAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * Image assets such as landscape/portrait/square, etc.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v16.services.HotelImageAsset image_assets = 6;</code>
     */
    public java.util.List<com.google.ads.googleads.v16.services.HotelImageAsset.Builder> 
         getImageAssetsBuilderList() {
      return getImageAssetsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v16.services.HotelImageAsset, com.google.ads.googleads.v16.services.HotelImageAsset.Builder, com.google.ads.googleads.v16.services.HotelImageAssetOrBuilder> 
        getImageAssetsFieldBuilder() {
      if (imageAssetsBuilder_ == null) {
        imageAssetsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v16.services.HotelImageAsset, com.google.ads.googleads.v16.services.HotelImageAsset.Builder, com.google.ads.googleads.v16.services.HotelImageAssetOrBuilder>(
                imageAssets_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        imageAssets_ = null;
      }
      return imageAssetsBuilder_;
    }

    private int status_ = 0;
    /**
     * <pre>
     * The status of the hotel asset suggestion.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus status = 7;</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * The status of the hotel asset suggestion.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus status = 7;</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the hotel asset suggestion.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus status = 7;</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus getStatus() {
      com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus result = com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The status of the hotel asset suggestion.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus status = 7;</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the hotel asset suggestion.
     * </pre>
     *
     * <code>.google.ads.googleads.v16.enums.HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus status = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      status_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v16.services.HotelAssetSuggestion)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v16.services.HotelAssetSuggestion)
  private static final com.google.ads.googleads.v16.services.HotelAssetSuggestion DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v16.services.HotelAssetSuggestion();
  }

  public static com.google.ads.googleads.v16.services.HotelAssetSuggestion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HotelAssetSuggestion>
      PARSER = new com.google.protobuf.AbstractParser<HotelAssetSuggestion>() {
    @java.lang.Override
    public HotelAssetSuggestion parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<HotelAssetSuggestion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HotelAssetSuggestion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v16.services.HotelAssetSuggestion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

