/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupCriterionCustomizerName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_CUSTOMIZER_ATTRIBUTE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupCriterionCustomizers/{ad_group_id}~{criterion_id}~{customizer_attribute_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String criterionId;
    private final String customizerAttributeId;

    @Deprecated
    protected AdGroupCriterionCustomizerName() {
        this.customerId = null;
        this.adGroupId = null;
        this.criterionId = null;
        this.customizerAttributeId = null;
    }

    private AdGroupCriterionCustomizerName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
        this.customizerAttributeId = (String)Preconditions.checkNotNull((Object)builder.getCustomizerAttributeId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public String getCustomizerAttributeId() {
        return this.customizerAttributeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupCriterionCustomizerName of(String customerId, String adGroupId, String criterionId, String customizerAttributeId) {
        return AdGroupCriterionCustomizerName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).setCustomizerAttributeId(customizerAttributeId).build();
    }

    public static String format(String customerId, String adGroupId, String criterionId, String customizerAttributeId) {
        return AdGroupCriterionCustomizerName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).setCustomizerAttributeId(customizerAttributeId).build().toString();
    }

    public static AdGroupCriterionCustomizerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_CUSTOMIZER_ATTRIBUTE_ID.validatedMatch(formattedString, "AdGroupCriterionCustomizerName.parse: formattedString not in valid format");
        return AdGroupCriterionCustomizerName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("criterion_id"), (String)matchMap.get("customizer_attribute_id"));
    }

    public static List<AdGroupCriterionCustomizerName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupCriterionCustomizerName> list = new ArrayList<AdGroupCriterionCustomizerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupCriterionCustomizerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupCriterionCustomizerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupCriterionCustomizerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_CUSTOMIZER_ATTRIBUTE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupCriterionCustomizerName adGroupCriterionCustomizerName = this;
            synchronized (adGroupCriterionCustomizerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    if (this.customizerAttributeId != null) {
                        fieldMapBuilder.put((Object)"customizer_attribute_id", (Object)this.customizerAttributeId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_CUSTOMIZER_ATTRIBUTE_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "criterion_id", this.criterionId, "customizer_attribute_id", this.customizerAttributeId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdGroupCriterionCustomizerName that = (AdGroupCriterionCustomizerName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.criterionId, that.criterionId) && Objects.equals(this.customizerAttributeId, that.customizerAttributeId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.criterionId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customizerAttributeId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String criterionId;
        private String customizerAttributeId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public String getCustomizerAttributeId() {
            return this.customizerAttributeId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        public Builder setCustomizerAttributeId(String customizerAttributeId) {
            this.customizerAttributeId = customizerAttributeId;
            return this;
        }

        private Builder(AdGroupCriterionCustomizerName adGroupCriterionCustomizerName) {
            this.customerId = adGroupCriterionCustomizerName.customerId;
            this.adGroupId = adGroupCriterionCustomizerName.adGroupId;
            this.criterionId = adGroupCriterionCustomizerName.criterionId;
            this.customizerAttributeId = adGroupCriterionCustomizerName.customizerAttributeId;
        }

        public AdGroupCriterionCustomizerName build() {
            return new AdGroupCriterionCustomizerName(this);
        }
    }
}

