/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.services.stub;

import com.google.ads.googleads.v16.services.EndExperimentRequest;
import com.google.ads.googleads.v16.services.ExperimentServiceClient;
import com.google.ads.googleads.v16.services.GraduateExperimentRequest;
import com.google.ads.googleads.v16.services.ListExperimentAsyncErrorsRequest;
import com.google.ads.googleads.v16.services.ListExperimentAsyncErrorsResponse;
import com.google.ads.googleads.v16.services.MutateExperimentsRequest;
import com.google.ads.googleads.v16.services.MutateExperimentsResponse;
import com.google.ads.googleads.v16.services.PromoteExperimentMetadata;
import com.google.ads.googleads.v16.services.PromoteExperimentRequest;
import com.google.ads.googleads.v16.services.ScheduleExperimentMetadata;
import com.google.ads.googleads.v16.services.ScheduleExperimentRequest;
import com.google.ads.googleads.v16.services.stub.ExperimentServiceStub;
import com.google.ads.googleads.v16.services.stub.ExperimentServiceStubSettings;
import com.google.ads.googleads.v16.services.stub.GrpcExperimentServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcExperimentServiceStub
extends ExperimentServiceStub {
    private static final MethodDescriptor<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.ExperimentService/MutateExperiments").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateExperimentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateExperimentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<EndExperimentRequest, Empty> endExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.ExperimentService/EndExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)EndExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse> listExperimentAsyncErrorsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.ExperimentService/ListExperimentAsyncErrors").setRequestMarshaller(ProtoUtils.marshaller((Message)ListExperimentAsyncErrorsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListExperimentAsyncErrorsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GraduateExperimentRequest, Empty> graduateExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.ExperimentService/GraduateExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)GraduateExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ScheduleExperimentRequest, Operation> scheduleExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.ExperimentService/ScheduleExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)ScheduleExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<PromoteExperimentRequest, Operation> promoteExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.ExperimentService/PromoteExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)PromoteExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsCallable;
    private final UnaryCallable<EndExperimentRequest, Empty> endExperimentCallable;
    private final UnaryCallable<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse> listExperimentAsyncErrorsCallable;
    private final UnaryCallable<ListExperimentAsyncErrorsRequest, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> listExperimentAsyncErrorsPagedCallable;
    private final UnaryCallable<GraduateExperimentRequest, Empty> graduateExperimentCallable;
    private final UnaryCallable<ScheduleExperimentRequest, Operation> scheduleExperimentCallable;
    private final OperationCallable<ScheduleExperimentRequest, Empty, ScheduleExperimentMetadata> scheduleExperimentOperationCallable;
    private final UnaryCallable<PromoteExperimentRequest, Operation> promoteExperimentCallable;
    private final OperationCallable<PromoteExperimentRequest, Empty, PromoteExperimentMetadata> promoteExperimentOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcExperimentServiceStub create(ExperimentServiceStubSettings settings) throws IOException {
        return new GrpcExperimentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcExperimentServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcExperimentServiceStub(ExperimentServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcExperimentServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcExperimentServiceStub(ExperimentServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcExperimentServiceStub(ExperimentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcExperimentServiceCallableFactory());
    }

    protected GrpcExperimentServiceStub(ExperimentServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings mutateExperimentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateExperimentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings endExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(endExperimentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("experiment", String.valueOf(request.getExperiment()));
            return builder.build();
        }).build();
        GrpcCallSettings listExperimentAsyncErrorsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listExperimentAsyncErrorsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_name", String.valueOf(request.getResourceName()));
            return builder.build();
        }).build();
        GrpcCallSettings graduateExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(graduateExperimentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("experiment", String.valueOf(request.getExperiment()));
            return builder.build();
        }).build();
        GrpcCallSettings scheduleExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(scheduleExperimentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_name", String.valueOf(request.getResourceName()));
            return builder.build();
        }).build();
        GrpcCallSettings promoteExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(promoteExperimentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_name", String.valueOf(request.getResourceName()));
            return builder.build();
        }).build();
        this.mutateExperimentsCallable = callableFactory.createUnaryCallable(mutateExperimentsTransportSettings, settings.mutateExperimentsSettings(), clientContext);
        this.endExperimentCallable = callableFactory.createUnaryCallable(endExperimentTransportSettings, settings.endExperimentSettings(), clientContext);
        this.listExperimentAsyncErrorsCallable = callableFactory.createUnaryCallable(listExperimentAsyncErrorsTransportSettings, settings.listExperimentAsyncErrorsSettings(), clientContext);
        this.listExperimentAsyncErrorsPagedCallable = callableFactory.createPagedCallable(listExperimentAsyncErrorsTransportSettings, settings.listExperimentAsyncErrorsSettings(), clientContext);
        this.graduateExperimentCallable = callableFactory.createUnaryCallable(graduateExperimentTransportSettings, settings.graduateExperimentSettings(), clientContext);
        this.scheduleExperimentCallable = callableFactory.createUnaryCallable(scheduleExperimentTransportSettings, settings.scheduleExperimentSettings(), clientContext);
        this.scheduleExperimentOperationCallable = callableFactory.createOperationCallable(scheduleExperimentTransportSettings, settings.scheduleExperimentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.promoteExperimentCallable = callableFactory.createUnaryCallable(promoteExperimentTransportSettings, settings.promoteExperimentSettings(), clientContext);
        this.promoteExperimentOperationCallable = callableFactory.createOperationCallable(promoteExperimentTransportSettings, settings.promoteExperimentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsCallable() {
        return this.mutateExperimentsCallable;
    }

    @Override
    public UnaryCallable<EndExperimentRequest, Empty> endExperimentCallable() {
        return this.endExperimentCallable;
    }

    @Override
    public UnaryCallable<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse> listExperimentAsyncErrorsCallable() {
        return this.listExperimentAsyncErrorsCallable;
    }

    @Override
    public UnaryCallable<ListExperimentAsyncErrorsRequest, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> listExperimentAsyncErrorsPagedCallable() {
        return this.listExperimentAsyncErrorsPagedCallable;
    }

    @Override
    public UnaryCallable<GraduateExperimentRequest, Empty> graduateExperimentCallable() {
        return this.graduateExperimentCallable;
    }

    @Override
    public UnaryCallable<ScheduleExperimentRequest, Operation> scheduleExperimentCallable() {
        return this.scheduleExperimentCallable;
    }

    @Override
    public OperationCallable<ScheduleExperimentRequest, Empty, ScheduleExperimentMetadata> scheduleExperimentOperationCallable() {
        return this.scheduleExperimentOperationCallable;
    }

    @Override
    public UnaryCallable<PromoteExperimentRequest, Operation> promoteExperimentCallable() {
        return this.promoteExperimentCallable;
    }

    @Override
    public OperationCallable<PromoteExperimentRequest, Empty, PromoteExperimentMetadata> promoteExperimentOperationCallable() {
        return this.promoteExperimentOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

