/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DetailPlacementViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_BASE64_PLACEMENT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/detailPlacementViews/{ad_group_id}~{base64_placement}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String base64Placement;

    @Deprecated
    protected DetailPlacementViewName() {
        this.customerId = null;
        this.adGroupId = null;
        this.base64Placement = null;
    }

    private DetailPlacementViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.base64Placement = (String)Preconditions.checkNotNull((Object)builder.getBase64Placement());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getBase64Placement() {
        return this.base64Placement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DetailPlacementViewName of(String customerId, String adGroupId, String base64Placement) {
        return DetailPlacementViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setBase64Placement(base64Placement).build();
    }

    public static String format(String customerId, String adGroupId, String base64Placement) {
        return DetailPlacementViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setBase64Placement(base64Placement).build().toString();
    }

    public static DetailPlacementViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_BASE64_PLACEMENT.validatedMatch(formattedString, "DetailPlacementViewName.parse: formattedString not in valid format");
        return DetailPlacementViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("base64_placement"));
    }

    public static List<DetailPlacementViewName> parseList(List<String> formattedStrings) {
        ArrayList<DetailPlacementViewName> list = new ArrayList<DetailPlacementViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DetailPlacementViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DetailPlacementViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DetailPlacementViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_BASE64_PLACEMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DetailPlacementViewName detailPlacementViewName = this;
            synchronized (detailPlacementViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.base64Placement != null) {
                        fieldMapBuilder.put((Object)"base64_placement", (Object)this.base64Placement);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_BASE64_PLACEMENT.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "base64_placement", this.base64Placement});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DetailPlacementViewName that = (DetailPlacementViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.base64Placement, that.base64Placement);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.base64Placement);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String base64Placement;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getBase64Placement() {
            return this.base64Placement;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setBase64Placement(String base64Placement) {
            this.base64Placement = base64Placement;
            return this;
        }

        private Builder(DetailPlacementViewName detailPlacementViewName) {
            this.customerId = detailPlacementViewName.customerId;
            this.adGroupId = detailPlacementViewName.adGroupId;
            this.base64Placement = detailPlacementViewName.base64Placement;
        }

        public DetailPlacementViewName build() {
            return new DetailPlacementViewName(this);
        }
    }
}

