/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HotelPerformanceViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/hotelPerformanceView");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;

    @Deprecated
    protected HotelPerformanceViewName() {
        this.customerId = null;
    }

    private HotelPerformanceViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HotelPerformanceViewName of(String customerId) {
        return HotelPerformanceViewName.newBuilder().setCustomerId(customerId).build();
    }

    public static String format(String customerId) {
        return HotelPerformanceViewName.newBuilder().setCustomerId(customerId).build().toString();
    }

    public static HotelPerformanceViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID.validatedMatch(formattedString, "HotelPerformanceViewName.parse: formattedString not in valid format");
        return HotelPerformanceViewName.of((String)matchMap.get("customer_id"));
    }

    public static List<HotelPerformanceViewName> parseList(List<String> formattedStrings) {
        ArrayList<HotelPerformanceViewName> list = new ArrayList<HotelPerformanceViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HotelPerformanceViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HotelPerformanceViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HotelPerformanceViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HotelPerformanceViewName hotelPerformanceViewName = this;
            synchronized (hotelPerformanceViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID.instantiate(new String[]{"customer_id", this.customerId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HotelPerformanceViewName that = (HotelPerformanceViewName)o;
            return Objects.equals(this.customerId, that.customerId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.customerId);
    }

    public static class Builder {
        private String customerId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        private Builder(HotelPerformanceViewName hotelPerformanceViewName) {
            this.customerId = hotelPerformanceViewName.customerId;
        }

        public HotelPerformanceViewName build() {
            return new HotelPerformanceViewName(this);
        }
    }
}

