/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MobileAppCategoryConstantName
implements ResourceName {
    private static final PathTemplate MOBILE_APP_CATEGORY_ID = PathTemplate.createWithoutUrlEncoding((String)"mobileAppCategoryConstants/{mobile_app_category_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String mobileAppCategoryId;

    @Deprecated
    protected MobileAppCategoryConstantName() {
        this.mobileAppCategoryId = null;
    }

    private MobileAppCategoryConstantName(Builder builder) {
        this.mobileAppCategoryId = (String)Preconditions.checkNotNull((Object)builder.getMobileAppCategoryId());
    }

    public String getMobileAppCategoryId() {
        return this.mobileAppCategoryId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MobileAppCategoryConstantName of(String mobileAppCategoryId) {
        return MobileAppCategoryConstantName.newBuilder().setMobileAppCategoryId(mobileAppCategoryId).build();
    }

    public static String format(String mobileAppCategoryId) {
        return MobileAppCategoryConstantName.newBuilder().setMobileAppCategoryId(mobileAppCategoryId).build().toString();
    }

    public static MobileAppCategoryConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = MOBILE_APP_CATEGORY_ID.validatedMatch(formattedString, "MobileAppCategoryConstantName.parse: formattedString not in valid format");
        return MobileAppCategoryConstantName.of((String)matchMap.get("mobile_app_category_id"));
    }

    public static List<MobileAppCategoryConstantName> parseList(List<String> formattedStrings) {
        ArrayList<MobileAppCategoryConstantName> list = new ArrayList<MobileAppCategoryConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MobileAppCategoryConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MobileAppCategoryConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MobileAppCategoryConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return MOBILE_APP_CATEGORY_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MobileAppCategoryConstantName mobileAppCategoryConstantName = this;
            synchronized (mobileAppCategoryConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.mobileAppCategoryId != null) {
                        fieldMapBuilder.put((Object)"mobile_app_category_id", (Object)this.mobileAppCategoryId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return MOBILE_APP_CATEGORY_ID.instantiate(new String[]{"mobile_app_category_id", this.mobileAppCategoryId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MobileAppCategoryConstantName that = (MobileAppCategoryConstantName)o;
            return Objects.equals(this.mobileAppCategoryId, that.mobileAppCategoryId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.mobileAppCategoryId);
    }

    public static class Builder {
        private String mobileAppCategoryId;

        protected Builder() {
        }

        public String getMobileAppCategoryId() {
            return this.mobileAppCategoryId;
        }

        public Builder setMobileAppCategoryId(String mobileAppCategoryId) {
            this.mobileAppCategoryId = mobileAppCategoryId;
            return this;
        }

        private Builder(MobileAppCategoryConstantName mobileAppCategoryConstantName) {
            this.mobileAppCategoryId = mobileAppCategoryConstantName.mobileAppCategoryId;
        }

        public MobileAppCategoryConstantName build() {
            return new MobileAppCategoryConstantName(this);
        }
    }
}

