/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.services;

import com.google.ads.googleads.v16.services.AudienceOperation;
import com.google.ads.googleads.v16.services.AudienceServiceSettings;
import com.google.ads.googleads.v16.services.MutateAudiencesRequest;
import com.google.ads.googleads.v16.services.MutateAudiencesResponse;
import com.google.ads.googleads.v16.services.stub.AudienceServiceStub;
import com.google.ads.googleads.v16.services.stub.AudienceServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AudienceServiceClient
implements BackgroundResource {
    private final AudienceServiceSettings settings;
    private final AudienceServiceStub stub;

    public static final AudienceServiceClient create() throws IOException {
        return AudienceServiceClient.create(AudienceServiceSettings.newBuilder().build());
    }

    public static final AudienceServiceClient create(AudienceServiceSettings settings) throws IOException {
        return new AudienceServiceClient(settings);
    }

    public static final AudienceServiceClient create(AudienceServiceStub stub) {
        return new AudienceServiceClient(stub);
    }

    protected AudienceServiceClient(AudienceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AudienceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AudienceServiceClient(AudienceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AudienceServiceSettings getSettings() {
        return this.settings;
    }

    public AudienceServiceStub getStub() {
        return this.stub;
    }

    public final MutateAudiencesResponse mutateAudiences(String customerId, List<AudienceOperation> operations) {
        MutateAudiencesRequest request = MutateAudiencesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAudiences(request);
    }

    public final MutateAudiencesResponse mutateAudiences(MutateAudiencesRequest request) {
        return (MutateAudiencesResponse)this.mutateAudiencesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAudiencesRequest, MutateAudiencesResponse> mutateAudiencesCallable() {
        return this.stub.mutateAudiencesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

