/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.services;

import com.google.ads.googleads.v16.services.CampaignOperation;
import com.google.ads.googleads.v16.services.CampaignServiceSettings;
import com.google.ads.googleads.v16.services.MutateCampaignsRequest;
import com.google.ads.googleads.v16.services.MutateCampaignsResponse;
import com.google.ads.googleads.v16.services.stub.CampaignServiceStub;
import com.google.ads.googleads.v16.services.stub.CampaignServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CampaignServiceClient
implements BackgroundResource {
    private final CampaignServiceSettings settings;
    private final CampaignServiceStub stub;

    public static final CampaignServiceClient create() throws IOException {
        return CampaignServiceClient.create(CampaignServiceSettings.newBuilder().build());
    }

    public static final CampaignServiceClient create(CampaignServiceSettings settings) throws IOException {
        return new CampaignServiceClient(settings);
    }

    public static final CampaignServiceClient create(CampaignServiceStub stub) {
        return new CampaignServiceClient(stub);
    }

    protected CampaignServiceClient(CampaignServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CampaignServiceClient(CampaignServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CampaignServiceSettings getSettings() {
        return this.settings;
    }

    public CampaignServiceStub getStub() {
        return this.stub;
    }

    public final MutateCampaignsResponse mutateCampaigns(String customerId, List<CampaignOperation> operations) {
        MutateCampaignsRequest request = MutateCampaignsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaigns(request);
    }

    public final MutateCampaignsResponse mutateCampaigns(MutateCampaignsRequest request) {
        return (MutateCampaignsResponse)this.mutateCampaignsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignsRequest, MutateCampaignsResponse> mutateCampaignsCallable() {
        return this.stub.mutateCampaignsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

