/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.services;

import com.google.ads.googleads.v16.services.CustomInterestOperation;
import com.google.ads.googleads.v16.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v16.services.MutateCustomInterestsRequest;
import com.google.ads.googleads.v16.services.MutateCustomInterestsResponse;
import com.google.ads.googleads.v16.services.stub.CustomInterestServiceStub;
import com.google.ads.googleads.v16.services.stub.CustomInterestServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomInterestServiceClient
implements BackgroundResource {
    private final CustomInterestServiceSettings settings;
    private final CustomInterestServiceStub stub;

    public static final CustomInterestServiceClient create() throws IOException {
        return CustomInterestServiceClient.create(CustomInterestServiceSettings.newBuilder().build());
    }

    public static final CustomInterestServiceClient create(CustomInterestServiceSettings settings) throws IOException {
        return new CustomInterestServiceClient(settings);
    }

    public static final CustomInterestServiceClient create(CustomInterestServiceStub stub) {
        return new CustomInterestServiceClient(stub);
    }

    protected CustomInterestServiceClient(CustomInterestServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomInterestServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomInterestServiceClient(CustomInterestServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomInterestServiceSettings getSettings() {
        return this.settings;
    }

    public CustomInterestServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomInterestsResponse mutateCustomInterests(String customerId, List<CustomInterestOperation> operations) {
        MutateCustomInterestsRequest request = MutateCustomInterestsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomInterests(request);
    }

    public final MutateCustomInterestsResponse mutateCustomInterests(MutateCustomInterestsRequest request) {
        return (MutateCustomInterestsResponse)this.mutateCustomInterestsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomInterestsRequest, MutateCustomInterestsResponse> mutateCustomInterestsCallable() {
        return this.stub.mutateCustomInterestsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

