/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversionActionName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CONVERSION_ACTION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/conversionActions/{conversion_action_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String conversionActionId;

    @Deprecated
    protected ConversionActionName() {
        this.customerId = null;
        this.conversionActionId = null;
    }

    private ConversionActionName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.conversionActionId = (String)Preconditions.checkNotNull((Object)builder.getConversionActionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getConversionActionId() {
        return this.conversionActionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversionActionName of(String customerId, String conversionActionId) {
        return ConversionActionName.newBuilder().setCustomerId(customerId).setConversionActionId(conversionActionId).build();
    }

    public static String format(String customerId, String conversionActionId) {
        return ConversionActionName.newBuilder().setCustomerId(customerId).setConversionActionId(conversionActionId).build().toString();
    }

    public static ConversionActionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CONVERSION_ACTION_ID.validatedMatch(formattedString, "ConversionActionName.parse: formattedString not in valid format");
        return ConversionActionName.of((String)matchMap.get("customer_id"), (String)matchMap.get("conversion_action_id"));
    }

    public static List<ConversionActionName> parseList(List<String> formattedStrings) {
        ArrayList<ConversionActionName> list = new ArrayList<ConversionActionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversionActionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversionActionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversionActionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CONVERSION_ACTION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversionActionName conversionActionName = this;
            synchronized (conversionActionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.conversionActionId != null) {
                        fieldMapBuilder.put((Object)"conversion_action_id", (Object)this.conversionActionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CONVERSION_ACTION_ID.instantiate(new String[]{"customer_id", this.customerId, "conversion_action_id", this.conversionActionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversionActionName that = (ConversionActionName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.conversionActionId, that.conversionActionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversionActionId);
    }

    public static class Builder {
        private String customerId;
        private String conversionActionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getConversionActionId() {
            return this.conversionActionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setConversionActionId(String conversionActionId) {
            this.conversionActionId = conversionActionId;
            return this;
        }

        private Builder(ConversionActionName conversionActionName) {
            this.customerId = conversionActionName.customerId;
            this.conversionActionId = conversionActionName.conversionActionId;
        }

        public ConversionActionName build() {
            return new ConversionActionName(this);
        }
    }
}

