/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DynamicSearchAdsSearchTermViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_FINGERPRINT_HEADLINE_FINGERPRINT_LANDING_PAGE_FINGERPRINT_PAGE_URL_FINGERPRINT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/dynamicSearchAdsSearchTermViews/{ad_group_id}~{search_term_fingerprint}~{headline_fingerprint}~{landing_page_fingerprint}~{page_url_fingerprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String searchTermFingerprint;
    private final String headlineFingerprint;
    private final String landingPageFingerprint;
    private final String pageUrlFingerprint;

    @Deprecated
    protected DynamicSearchAdsSearchTermViewName() {
        this.customerId = null;
        this.adGroupId = null;
        this.searchTermFingerprint = null;
        this.headlineFingerprint = null;
        this.landingPageFingerprint = null;
        this.pageUrlFingerprint = null;
    }

    private DynamicSearchAdsSearchTermViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.searchTermFingerprint = (String)Preconditions.checkNotNull((Object)builder.getSearchTermFingerprint());
        this.headlineFingerprint = (String)Preconditions.checkNotNull((Object)builder.getHeadlineFingerprint());
        this.landingPageFingerprint = (String)Preconditions.checkNotNull((Object)builder.getLandingPageFingerprint());
        this.pageUrlFingerprint = (String)Preconditions.checkNotNull((Object)builder.getPageUrlFingerprint());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getSearchTermFingerprint() {
        return this.searchTermFingerprint;
    }

    public String getHeadlineFingerprint() {
        return this.headlineFingerprint;
    }

    public String getLandingPageFingerprint() {
        return this.landingPageFingerprint;
    }

    public String getPageUrlFingerprint() {
        return this.pageUrlFingerprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DynamicSearchAdsSearchTermViewName of(String customerId, String adGroupId, String searchTermFingerprint, String headlineFingerprint, String landingPageFingerprint, String pageUrlFingerprint) {
        return DynamicSearchAdsSearchTermViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setSearchTermFingerprint(searchTermFingerprint).setHeadlineFingerprint(headlineFingerprint).setLandingPageFingerprint(landingPageFingerprint).setPageUrlFingerprint(pageUrlFingerprint).build();
    }

    public static String format(String customerId, String adGroupId, String searchTermFingerprint, String headlineFingerprint, String landingPageFingerprint, String pageUrlFingerprint) {
        return DynamicSearchAdsSearchTermViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setSearchTermFingerprint(searchTermFingerprint).setHeadlineFingerprint(headlineFingerprint).setLandingPageFingerprint(landingPageFingerprint).setPageUrlFingerprint(pageUrlFingerprint).build().toString();
    }

    public static DynamicSearchAdsSearchTermViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_FINGERPRINT_HEADLINE_FINGERPRINT_LANDING_PAGE_FINGERPRINT_PAGE_URL_FINGERPRINT.validatedMatch(formattedString, "DynamicSearchAdsSearchTermViewName.parse: formattedString not in valid format");
        return DynamicSearchAdsSearchTermViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("search_term_fingerprint"), (String)matchMap.get("headline_fingerprint"), (String)matchMap.get("landing_page_fingerprint"), (String)matchMap.get("page_url_fingerprint"));
    }

    public static List<DynamicSearchAdsSearchTermViewName> parseList(List<String> formattedStrings) {
        ArrayList<DynamicSearchAdsSearchTermViewName> list = new ArrayList<DynamicSearchAdsSearchTermViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DynamicSearchAdsSearchTermViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DynamicSearchAdsSearchTermViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DynamicSearchAdsSearchTermViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_FINGERPRINT_HEADLINE_FINGERPRINT_LANDING_PAGE_FINGERPRINT_PAGE_URL_FINGERPRINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DynamicSearchAdsSearchTermViewName dynamicSearchAdsSearchTermViewName = this;
            synchronized (dynamicSearchAdsSearchTermViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.searchTermFingerprint != null) {
                        fieldMapBuilder.put((Object)"search_term_fingerprint", (Object)this.searchTermFingerprint);
                    }
                    if (this.headlineFingerprint != null) {
                        fieldMapBuilder.put((Object)"headline_fingerprint", (Object)this.headlineFingerprint);
                    }
                    if (this.landingPageFingerprint != null) {
                        fieldMapBuilder.put((Object)"landing_page_fingerprint", (Object)this.landingPageFingerprint);
                    }
                    if (this.pageUrlFingerprint != null) {
                        fieldMapBuilder.put((Object)"page_url_fingerprint", (Object)this.pageUrlFingerprint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_FINGERPRINT_HEADLINE_FINGERPRINT_LANDING_PAGE_FINGERPRINT_PAGE_URL_FINGERPRINT.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "search_term_fingerprint", this.searchTermFingerprint, "headline_fingerprint", this.headlineFingerprint, "landing_page_fingerprint", this.landingPageFingerprint, "page_url_fingerprint", this.pageUrlFingerprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DynamicSearchAdsSearchTermViewName that = (DynamicSearchAdsSearchTermViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.searchTermFingerprint, that.searchTermFingerprint) && Objects.equals(this.headlineFingerprint, that.headlineFingerprint) && Objects.equals(this.landingPageFingerprint, that.landingPageFingerprint) && Objects.equals(this.pageUrlFingerprint, that.pageUrlFingerprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.searchTermFingerprint);
        h *= 1000003;
        h ^= Objects.hashCode(this.headlineFingerprint);
        h *= 1000003;
        h ^= Objects.hashCode(this.landingPageFingerprint);
        h *= 1000003;
        return h ^= Objects.hashCode(this.pageUrlFingerprint);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String searchTermFingerprint;
        private String headlineFingerprint;
        private String landingPageFingerprint;
        private String pageUrlFingerprint;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getSearchTermFingerprint() {
            return this.searchTermFingerprint;
        }

        public String getHeadlineFingerprint() {
            return this.headlineFingerprint;
        }

        public String getLandingPageFingerprint() {
            return this.landingPageFingerprint;
        }

        public String getPageUrlFingerprint() {
            return this.pageUrlFingerprint;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setSearchTermFingerprint(String searchTermFingerprint) {
            this.searchTermFingerprint = searchTermFingerprint;
            return this;
        }

        public Builder setHeadlineFingerprint(String headlineFingerprint) {
            this.headlineFingerprint = headlineFingerprint;
            return this;
        }

        public Builder setLandingPageFingerprint(String landingPageFingerprint) {
            this.landingPageFingerprint = landingPageFingerprint;
            return this;
        }

        public Builder setPageUrlFingerprint(String pageUrlFingerprint) {
            this.pageUrlFingerprint = pageUrlFingerprint;
            return this;
        }

        private Builder(DynamicSearchAdsSearchTermViewName dynamicSearchAdsSearchTermViewName) {
            this.customerId = dynamicSearchAdsSearchTermViewName.customerId;
            this.adGroupId = dynamicSearchAdsSearchTermViewName.adGroupId;
            this.searchTermFingerprint = dynamicSearchAdsSearchTermViewName.searchTermFingerprint;
            this.headlineFingerprint = dynamicSearchAdsSearchTermViewName.headlineFingerprint;
            this.landingPageFingerprint = dynamicSearchAdsSearchTermViewName.landingPageFingerprint;
            this.pageUrlFingerprint = dynamicSearchAdsSearchTermViewName.pageUrlFingerprint;
        }

        public DynamicSearchAdsSearchTermViewName build() {
            return new DynamicSearchAdsSearchTermViewName(this);
        }
    }
}

