/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductCategoryConstantName
implements ResourceName {
    private static final PathTemplate LEVEL_CATEGORY_ID = PathTemplate.createWithoutUrlEncoding((String)"productCategoryConstants/{level}~{category_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String level;
    private final String categoryId;

    @Deprecated
    protected ProductCategoryConstantName() {
        this.level = null;
        this.categoryId = null;
    }

    private ProductCategoryConstantName(Builder builder) {
        this.level = (String)Preconditions.checkNotNull((Object)builder.getLevel());
        this.categoryId = (String)Preconditions.checkNotNull((Object)builder.getCategoryId());
    }

    public String getLevel() {
        return this.level;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProductCategoryConstantName of(String level, String categoryId) {
        return ProductCategoryConstantName.newBuilder().setLevel(level).setCategoryId(categoryId).build();
    }

    public static String format(String level, String categoryId) {
        return ProductCategoryConstantName.newBuilder().setLevel(level).setCategoryId(categoryId).build().toString();
    }

    public static ProductCategoryConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = LEVEL_CATEGORY_ID.validatedMatch(formattedString, "ProductCategoryConstantName.parse: formattedString not in valid format");
        return ProductCategoryConstantName.of((String)matchMap.get("level"), (String)matchMap.get("category_id"));
    }

    public static List<ProductCategoryConstantName> parseList(List<String> formattedStrings) {
        ArrayList<ProductCategoryConstantName> list = new ArrayList<ProductCategoryConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductCategoryConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductCategoryConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductCategoryConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return LEVEL_CATEGORY_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductCategoryConstantName productCategoryConstantName = this;
            synchronized (productCategoryConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.level != null) {
                        fieldMapBuilder.put((Object)"level", (Object)this.level);
                    }
                    if (this.categoryId != null) {
                        fieldMapBuilder.put((Object)"category_id", (Object)this.categoryId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return LEVEL_CATEGORY_ID.instantiate(new String[]{"level", this.level, "category_id", this.categoryId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProductCategoryConstantName that = (ProductCategoryConstantName)o;
            return Objects.equals(this.level, that.level) && Objects.equals(this.categoryId, that.categoryId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.level);
        h *= 1000003;
        return h ^= Objects.hashCode(this.categoryId);
    }

    public static class Builder {
        private String level;
        private String categoryId;

        protected Builder() {
        }

        public String getLevel() {
            return this.level;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public Builder setLevel(String level) {
            this.level = level;
            return this;
        }

        public Builder setCategoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        private Builder(ProductCategoryConstantName productCategoryConstantName) {
            this.level = productCategoryConstantName.level;
            this.categoryId = productCategoryConstantName.categoryId;
        }

        public ProductCategoryConstantName build() {
            return new ProductCategoryConstantName(this);
        }
    }
}

