/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecommendationSubscriptionName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_RECOMMENDATION_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/recommendationSubscriptions/{recommendation_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String recommendationType;

    @Deprecated
    protected RecommendationSubscriptionName() {
        this.customerId = null;
        this.recommendationType = null;
    }

    private RecommendationSubscriptionName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.recommendationType = (String)Preconditions.checkNotNull((Object)builder.getRecommendationType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getRecommendationType() {
        return this.recommendationType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecommendationSubscriptionName of(String customerId, String recommendationType) {
        return RecommendationSubscriptionName.newBuilder().setCustomerId(customerId).setRecommendationType(recommendationType).build();
    }

    public static String format(String customerId, String recommendationType) {
        return RecommendationSubscriptionName.newBuilder().setCustomerId(customerId).setRecommendationType(recommendationType).build().toString();
    }

    public static RecommendationSubscriptionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_RECOMMENDATION_TYPE.validatedMatch(formattedString, "RecommendationSubscriptionName.parse: formattedString not in valid format");
        return RecommendationSubscriptionName.of((String)matchMap.get("customer_id"), (String)matchMap.get("recommendation_type"));
    }

    public static List<RecommendationSubscriptionName> parseList(List<String> formattedStrings) {
        ArrayList<RecommendationSubscriptionName> list = new ArrayList<RecommendationSubscriptionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecommendationSubscriptionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecommendationSubscriptionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecommendationSubscriptionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_RECOMMENDATION_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecommendationSubscriptionName recommendationSubscriptionName = this;
            synchronized (recommendationSubscriptionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.recommendationType != null) {
                        fieldMapBuilder.put((Object)"recommendation_type", (Object)this.recommendationType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_RECOMMENDATION_TYPE.instantiate(new String[]{"customer_id", this.customerId, "recommendation_type", this.recommendationType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RecommendationSubscriptionName that = (RecommendationSubscriptionName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.recommendationType, that.recommendationType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.recommendationType);
    }

    public static class Builder {
        private String customerId;
        private String recommendationType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getRecommendationType() {
            return this.recommendationType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setRecommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        private Builder(RecommendationSubscriptionName recommendationSubscriptionName) {
            this.customerId = recommendationSubscriptionName.customerId;
            this.recommendationType = recommendationSubscriptionName.recommendationType;
        }

        public RecommendationSubscriptionName build() {
            return new RecommendationSubscriptionName(this);
        }
    }
}

