/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.services;

import com.google.ads.googleads.v16.enums.ResponseContentTypeEnum;
import com.google.ads.googleads.v16.services.AssetGroupListingGroupFilterOperation;
import com.google.ads.googleads.v16.services.AssetGroupListingGroupFilterOperationOrBuilder;
import com.google.ads.googleads.v16.services.AssetGroupListingGroupFilterServiceProto;
import com.google.ads.googleads.v16.services.MutateAssetGroupListingGroupFiltersRequestOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MutateAssetGroupListingGroupFiltersRequest
extends GeneratedMessageV3
implements MutateAssetGroupListingGroupFiltersRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int OPERATIONS_FIELD_NUMBER = 2;
    private List<AssetGroupListingGroupFilterOperation> operations_;
    public static final int VALIDATE_ONLY_FIELD_NUMBER = 3;
    private boolean validateOnly_ = false;
    public static final int RESPONSE_CONTENT_TYPE_FIELD_NUMBER = 4;
    private int responseContentType_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final MutateAssetGroupListingGroupFiltersRequest DEFAULT_INSTANCE = new MutateAssetGroupListingGroupFiltersRequest();
    private static final Parser<MutateAssetGroupListingGroupFiltersRequest> PARSER = new AbstractParser<MutateAssetGroupListingGroupFiltersRequest>(){

        public MutateAssetGroupListingGroupFiltersRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = MutateAssetGroupListingGroupFiltersRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private MutateAssetGroupListingGroupFiltersRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private MutateAssetGroupListingGroupFiltersRequest() {
        this.customerId_ = "";
        this.operations_ = Collections.emptyList();
        this.responseContentType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new MutateAssetGroupListingGroupFiltersRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetGroupListingGroupFilterServiceProto.internal_static_google_ads_googleads_v16_services_MutateAssetGroupListingGroupFiltersRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetGroupListingGroupFilterServiceProto.internal_static_google_ads_googleads_v16_services_MutateAssetGroupListingGroupFiltersRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(MutateAssetGroupListingGroupFiltersRequest.class, Builder.class);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AssetGroupListingGroupFilterOperation> getOperationsList() {
        return this.operations_;
    }

    @Override
    public List<? extends AssetGroupListingGroupFilterOperationOrBuilder> getOperationsOrBuilderList() {
        return this.operations_;
    }

    @Override
    public int getOperationsCount() {
        return this.operations_.size();
    }

    @Override
    public AssetGroupListingGroupFilterOperation getOperations(int index) {
        return this.operations_.get(index);
    }

    @Override
    public AssetGroupListingGroupFilterOperationOrBuilder getOperationsOrBuilder(int index) {
        return this.operations_.get(index);
    }

    @Override
    public boolean getValidateOnly() {
        return this.validateOnly_;
    }

    @Override
    public int getResponseContentTypeValue() {
        return this.responseContentType_;
    }

    @Override
    public ResponseContentTypeEnum.ResponseContentType getResponseContentType() {
        ResponseContentTypeEnum.ResponseContentType result = ResponseContentTypeEnum.ResponseContentType.forNumber(this.responseContentType_);
        return result == null ? ResponseContentTypeEnum.ResponseContentType.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        for (int i = 0; i < this.operations_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.operations_.get(i));
        }
        if (this.validateOnly_) {
            output.writeBool(3, this.validateOnly_);
        }
        if (this.responseContentType_ != ResponseContentTypeEnum.ResponseContentType.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.responseContentType_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        for (int i = 0; i < this.operations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.operations_.get(i)));
        }
        if (this.validateOnly_) {
            size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.validateOnly_);
        }
        if (this.responseContentType_ != ResponseContentTypeEnum.ResponseContentType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.responseContentType_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MutateAssetGroupListingGroupFiltersRequest)) {
            return super.equals(obj);
        }
        MutateAssetGroupListingGroupFiltersRequest other = (MutateAssetGroupListingGroupFiltersRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (!this.getOperationsList().equals(other.getOperationsList())) {
            return false;
        }
        if (this.getValidateOnly() != other.getValidateOnly()) {
            return false;
        }
        if (this.responseContentType_ != other.responseContentType_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + MutateAssetGroupListingGroupFiltersRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.getOperationsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getOperationsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getValidateOnly());
        hash = 37 * hash + 4;
        hash = 53 * hash + this.responseContentType_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (MutateAssetGroupListingGroupFiltersRequest)PARSER.parseFrom(data);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MutateAssetGroupListingGroupFiltersRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (MutateAssetGroupListingGroupFiltersRequest)PARSER.parseFrom(data);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MutateAssetGroupListingGroupFiltersRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (MutateAssetGroupListingGroupFiltersRequest)PARSER.parseFrom(data);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MutateAssetGroupListingGroupFiltersRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(InputStream input) throws IOException {
        return (MutateAssetGroupListingGroupFiltersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MutateAssetGroupListingGroupFiltersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (MutateAssetGroupListingGroupFiltersRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MutateAssetGroupListingGroupFiltersRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(CodedInputStream input) throws IOException {
        return (MutateAssetGroupListingGroupFiltersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static MutateAssetGroupListingGroupFiltersRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MutateAssetGroupListingGroupFiltersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return MutateAssetGroupListingGroupFiltersRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MutateAssetGroupListingGroupFiltersRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static MutateAssetGroupListingGroupFiltersRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<MutateAssetGroupListingGroupFiltersRequest> parser() {
        return PARSER;
    }

    public Parser<MutateAssetGroupListingGroupFiltersRequest> getParserForType() {
        return PARSER;
    }

    public MutateAssetGroupListingGroupFiltersRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements MutateAssetGroupListingGroupFiltersRequestOrBuilder {
        private int bitField0_;
        private Object customerId_ = "";
        private List<AssetGroupListingGroupFilterOperation> operations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AssetGroupListingGroupFilterOperation, AssetGroupListingGroupFilterOperation.Builder, AssetGroupListingGroupFilterOperationOrBuilder> operationsBuilder_;
        private boolean validateOnly_;
        private int responseContentType_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetGroupListingGroupFilterServiceProto.internal_static_google_ads_googleads_v16_services_MutateAssetGroupListingGroupFiltersRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetGroupListingGroupFilterServiceProto.internal_static_google_ads_googleads_v16_services_MutateAssetGroupListingGroupFiltersRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(MutateAssetGroupListingGroupFiltersRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            if (this.operationsBuilder_ == null) {
                this.operations_ = Collections.emptyList();
            } else {
                this.operations_ = null;
                this.operationsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.validateOnly_ = false;
            this.responseContentType_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetGroupListingGroupFilterServiceProto.internal_static_google_ads_googleads_v16_services_MutateAssetGroupListingGroupFiltersRequest_descriptor;
        }

        public MutateAssetGroupListingGroupFiltersRequest getDefaultInstanceForType() {
            return MutateAssetGroupListingGroupFiltersRequest.getDefaultInstance();
        }

        public MutateAssetGroupListingGroupFiltersRequest build() {
            MutateAssetGroupListingGroupFiltersRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public MutateAssetGroupListingGroupFiltersRequest buildPartial() {
            MutateAssetGroupListingGroupFiltersRequest result = new MutateAssetGroupListingGroupFiltersRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(MutateAssetGroupListingGroupFiltersRequest result) {
            if (this.operationsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.operations_ = Collections.unmodifiableList(this.operations_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.operations_ = this.operations_;
            } else {
                result.operations_ = this.operationsBuilder_.build();
            }
        }

        private void buildPartial0(MutateAssetGroupListingGroupFiltersRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.validateOnly_ = this.validateOnly_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.responseContentType_ = this.responseContentType_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof MutateAssetGroupListingGroupFiltersRequest) {
                return this.mergeFrom((MutateAssetGroupListingGroupFiltersRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(MutateAssetGroupListingGroupFiltersRequest other) {
            if (other == MutateAssetGroupListingGroupFiltersRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (this.operationsBuilder_ == null) {
                if (!other.operations_.isEmpty()) {
                    if (this.operations_.isEmpty()) {
                        this.operations_ = other.operations_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureOperationsIsMutable();
                        this.operations_.addAll(other.operations_);
                    }
                    this.onChanged();
                }
            } else if (!other.operations_.isEmpty()) {
                if (this.operationsBuilder_.isEmpty()) {
                    this.operationsBuilder_.dispose();
                    this.operationsBuilder_ = null;
                    this.operations_ = other.operations_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.operationsBuilder_ = alwaysUseFieldBuilders ? this.getOperationsFieldBuilder() : null;
                } else {
                    this.operationsBuilder_.addAllMessages((Iterable)other.operations_);
                }
            }
            if (other.getValidateOnly()) {
                this.setValidateOnly(other.getValidateOnly());
            }
            if (other.responseContentType_ != 0) {
                this.setResponseContentTypeValue(other.getResponseContentTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block12;
                        }
                        case 18: {
                            AssetGroupListingGroupFilterOperation m = (AssetGroupListingGroupFilterOperation)input.readMessage(AssetGroupListingGroupFilterOperation.parser(), extensionRegistry);
                            if (this.operationsBuilder_ == null) {
                                this.ensureOperationsIsMutable();
                                this.operations_.add(m);
                                continue block12;
                            }
                            this.operationsBuilder_.addMessage((AbstractMessage)m);
                            continue block12;
                        }
                        case 24: {
                            this.validateOnly_ = input.readBool();
                            this.bitField0_ |= 4;
                            continue block12;
                        }
                        case 32: {
                            this.responseContentType_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block12;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = MutateAssetGroupListingGroupFiltersRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            MutateAssetGroupListingGroupFiltersRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureOperationsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.operations_ = new ArrayList<AssetGroupListingGroupFilterOperation>(this.operations_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<AssetGroupListingGroupFilterOperation> getOperationsList() {
            if (this.operationsBuilder_ == null) {
                return Collections.unmodifiableList(this.operations_);
            }
            return this.operationsBuilder_.getMessageList();
        }

        @Override
        public int getOperationsCount() {
            if (this.operationsBuilder_ == null) {
                return this.operations_.size();
            }
            return this.operationsBuilder_.getCount();
        }

        @Override
        public AssetGroupListingGroupFilterOperation getOperations(int index) {
            if (this.operationsBuilder_ == null) {
                return this.operations_.get(index);
            }
            return (AssetGroupListingGroupFilterOperation)this.operationsBuilder_.getMessage(index);
        }

        public Builder setOperations(int index, AssetGroupListingGroupFilterOperation value) {
            if (this.operationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOperationsIsMutable();
                this.operations_.set(index, value);
                this.onChanged();
            } else {
                this.operationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setOperations(int index, AssetGroupListingGroupFilterOperation.Builder builderForValue) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.operationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addOperations(AssetGroupListingGroupFilterOperation value) {
            if (this.operationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOperationsIsMutable();
                this.operations_.add(value);
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addOperations(int index, AssetGroupListingGroupFilterOperation value) {
            if (this.operationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOperationsIsMutable();
                this.operations_.add(index, value);
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addOperations(AssetGroupListingGroupFilterOperation.Builder builderForValue) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addOperations(int index, AssetGroupListingGroupFilterOperation.Builder builderForValue) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.operationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllOperations(Iterable<? extends AssetGroupListingGroupFilterOperation> values) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.operations_);
                this.onChanged();
            } else {
                this.operationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearOperations() {
            if (this.operationsBuilder_ == null) {
                this.operations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.operationsBuilder_.clear();
            }
            return this;
        }

        public Builder removeOperations(int index) {
            if (this.operationsBuilder_ == null) {
                this.ensureOperationsIsMutable();
                this.operations_.remove(index);
                this.onChanged();
            } else {
                this.operationsBuilder_.remove(index);
            }
            return this;
        }

        public AssetGroupListingGroupFilterOperation.Builder getOperationsBuilder(int index) {
            return (AssetGroupListingGroupFilterOperation.Builder)this.getOperationsFieldBuilder().getBuilder(index);
        }

        @Override
        public AssetGroupListingGroupFilterOperationOrBuilder getOperationsOrBuilder(int index) {
            if (this.operationsBuilder_ == null) {
                return this.operations_.get(index);
            }
            return (AssetGroupListingGroupFilterOperationOrBuilder)this.operationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AssetGroupListingGroupFilterOperationOrBuilder> getOperationsOrBuilderList() {
            if (this.operationsBuilder_ != null) {
                return this.operationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.operations_);
        }

        public AssetGroupListingGroupFilterOperation.Builder addOperationsBuilder() {
            return (AssetGroupListingGroupFilterOperation.Builder)this.getOperationsFieldBuilder().addBuilder((AbstractMessage)AssetGroupListingGroupFilterOperation.getDefaultInstance());
        }

        public AssetGroupListingGroupFilterOperation.Builder addOperationsBuilder(int index) {
            return (AssetGroupListingGroupFilterOperation.Builder)this.getOperationsFieldBuilder().addBuilder(index, (AbstractMessage)AssetGroupListingGroupFilterOperation.getDefaultInstance());
        }

        public List<AssetGroupListingGroupFilterOperation.Builder> getOperationsBuilderList() {
            return this.getOperationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AssetGroupListingGroupFilterOperation, AssetGroupListingGroupFilterOperation.Builder, AssetGroupListingGroupFilterOperationOrBuilder> getOperationsFieldBuilder() {
            if (this.operationsBuilder_ == null) {
                this.operationsBuilder_ = new RepeatedFieldBuilderV3(this.operations_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.operations_ = null;
            }
            return this.operationsBuilder_;
        }

        @Override
        public boolean getValidateOnly() {
            return this.validateOnly_;
        }

        public Builder setValidateOnly(boolean value) {
            this.validateOnly_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearValidateOnly() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.validateOnly_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getResponseContentTypeValue() {
            return this.responseContentType_;
        }

        public Builder setResponseContentTypeValue(int value) {
            this.responseContentType_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public ResponseContentTypeEnum.ResponseContentType getResponseContentType() {
            ResponseContentTypeEnum.ResponseContentType result = ResponseContentTypeEnum.ResponseContentType.forNumber(this.responseContentType_);
            return result == null ? ResponseContentTypeEnum.ResponseContentType.UNRECOGNIZED : result;
        }

        public Builder setResponseContentType(ResponseContentTypeEnum.ResponseContentType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.responseContentType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearResponseContentType() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.responseContentType_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

