/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v16.services.stub;

import com.google.ads.googleads.v16.services.GoogleAdsServiceClient;
import com.google.ads.googleads.v16.services.MutateGoogleAdsRequest;
import com.google.ads.googleads.v16.services.MutateGoogleAdsResponse;
import com.google.ads.googleads.v16.services.SearchGoogleAdsRequest;
import com.google.ads.googleads.v16.services.SearchGoogleAdsResponse;
import com.google.ads.googleads.v16.services.SearchGoogleAdsStreamRequest;
import com.google.ads.googleads.v16.services.SearchGoogleAdsStreamResponse;
import com.google.ads.googleads.v16.services.stub.GoogleAdsServiceStub;
import com.google.ads.googleads.v16.services.stub.GoogleAdsServiceStubSettings;
import com.google.ads.googleads.v16.services.stub.GrpcGoogleAdsServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcGoogleAdsServiceStub
extends GoogleAdsServiceStub {
    private static final MethodDescriptor<SearchGoogleAdsRequest, SearchGoogleAdsResponse> searchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.GoogleAdsService/Search").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchGoogleAdsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchGoogleAdsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchGoogleAdsStreamRequest, SearchGoogleAdsStreamResponse> searchStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.ads.googleads.v16.services.GoogleAdsService/SearchStream").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchGoogleAdsStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchGoogleAdsStreamResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateGoogleAdsRequest, MutateGoogleAdsResponse> mutateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v16.services.GoogleAdsService/Mutate").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateGoogleAdsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateGoogleAdsResponse.getDefaultInstance())).build();
    private final UnaryCallable<SearchGoogleAdsRequest, SearchGoogleAdsResponse> searchCallable;
    private final UnaryCallable<SearchGoogleAdsRequest, GoogleAdsServiceClient.SearchPagedResponse> searchPagedCallable;
    private final ServerStreamingCallable<SearchGoogleAdsStreamRequest, SearchGoogleAdsStreamResponse> searchStreamCallable;
    private final UnaryCallable<MutateGoogleAdsRequest, MutateGoogleAdsResponse> mutateCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcGoogleAdsServiceStub create(GoogleAdsServiceStubSettings settings) throws IOException {
        return new GrpcGoogleAdsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcGoogleAdsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcGoogleAdsServiceStub(GoogleAdsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcGoogleAdsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcGoogleAdsServiceStub(GoogleAdsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcGoogleAdsServiceStub(GoogleAdsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcGoogleAdsServiceCallableFactory());
    }

    protected GrpcGoogleAdsServiceStub(GoogleAdsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings searchStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings mutateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.searchCallable = callableFactory.createUnaryCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.searchPagedCallable = callableFactory.createPagedCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.searchStreamCallable = callableFactory.createServerStreamingCallable(searchStreamTransportSettings, settings.searchStreamSettings(), clientContext);
        this.mutateCallable = callableFactory.createUnaryCallable(mutateTransportSettings, settings.mutateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchGoogleAdsRequest, SearchGoogleAdsResponse> searchCallable() {
        return this.searchCallable;
    }

    @Override
    public UnaryCallable<SearchGoogleAdsRequest, GoogleAdsServiceClient.SearchPagedResponse> searchPagedCallable() {
        return this.searchPagedCallable;
    }

    @Override
    public ServerStreamingCallable<SearchGoogleAdsStreamRequest, SearchGoogleAdsStreamResponse> searchStreamCallable() {
        return this.searchStreamCallable;
    }

    @Override
    public UnaryCallable<MutateGoogleAdsRequest, MutateGoogleAdsResponse> mutateCallable() {
        return this.mutateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

