/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.services.CustomerClientLinkOperation;
import com.google.ads.googleads.v17.services.CustomerClientLinkServiceSettings;
import com.google.ads.googleads.v17.services.MutateCustomerClientLinkRequest;
import com.google.ads.googleads.v17.services.MutateCustomerClientLinkResponse;
import com.google.ads.googleads.v17.services.stub.CustomerClientLinkServiceStub;
import com.google.ads.googleads.v17.services.stub.CustomerClientLinkServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CustomerClientLinkServiceClient
implements BackgroundResource {
    private final CustomerClientLinkServiceSettings settings;
    private final CustomerClientLinkServiceStub stub;

    public static final CustomerClientLinkServiceClient create() throws IOException {
        return CustomerClientLinkServiceClient.create(CustomerClientLinkServiceSettings.newBuilder().build());
    }

    public static final CustomerClientLinkServiceClient create(CustomerClientLinkServiceSettings settings) throws IOException {
        return new CustomerClientLinkServiceClient(settings);
    }

    public static final CustomerClientLinkServiceClient create(CustomerClientLinkServiceStub stub) {
        return new CustomerClientLinkServiceClient(stub);
    }

    protected CustomerClientLinkServiceClient(CustomerClientLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerClientLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomerClientLinkServiceClient(CustomerClientLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerClientLinkServiceSettings getSettings() {
        return this.settings;
    }

    public CustomerClientLinkServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomerClientLinkResponse mutateCustomerClientLink(String customerId, CustomerClientLinkOperation operation) {
        MutateCustomerClientLinkRequest request = MutateCustomerClientLinkRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateCustomerClientLink(request);
    }

    public final MutateCustomerClientLinkResponse mutateCustomerClientLink(MutateCustomerClientLinkRequest request) {
        return (MutateCustomerClientLinkResponse)this.mutateCustomerClientLinkCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerClientLinkRequest, MutateCustomerClientLinkResponse> mutateCustomerClientLinkCallable() {
        return this.stub.mutateCustomerClientLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

