/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.common.KeywordInfo;
import com.google.ads.googleads.v17.common.KeywordInfoOrBuilder;
import com.google.ads.googleads.v17.enums.AdGroupTypeEnum;
import com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum;
import com.google.ads.googleads.v17.enums.BiddingStrategyTypeEnum;
import com.google.ads.googleads.v17.enums.ConversionTrackingStatusEnum;
import com.google.ads.googleads.v17.enums.RecommendationTypeEnum;
import com.google.ads.googleads.v17.services.GenerateRecommendationsRequestOrBuilder;
import com.google.ads.googleads.v17.services.RecommendationServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GenerateRecommendationsRequest
extends GeneratedMessageV3
implements GenerateRecommendationsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int RECOMMENDATION_TYPES_FIELD_NUMBER = 2;
    private List<Integer> recommendationTypes_;
    private static final Internal.ListAdapter.Converter<Integer, RecommendationTypeEnum.RecommendationType> recommendationTypes_converter_ = new Internal.ListAdapter.Converter<Integer, RecommendationTypeEnum.RecommendationType>(){

        public RecommendationTypeEnum.RecommendationType convert(Integer from) {
            RecommendationTypeEnum.RecommendationType result = RecommendationTypeEnum.RecommendationType.forNumber(from);
            return result == null ? RecommendationTypeEnum.RecommendationType.UNRECOGNIZED : result;
        }
    };
    private int recommendationTypesMemoizedSerializedSize;
    public static final int ADVERTISING_CHANNEL_TYPE_FIELD_NUMBER = 3;
    private int advertisingChannelType_ = 0;
    public static final int CAMPAIGN_SITELINK_COUNT_FIELD_NUMBER = 4;
    private int campaignSitelinkCount_ = 0;
    public static final int CONVERSION_TRACKING_STATUS_FIELD_NUMBER = 5;
    private int conversionTrackingStatus_ = 0;
    public static final int BIDDING_INFO_FIELD_NUMBER = 6;
    private BiddingInfo biddingInfo_;
    public static final int AD_GROUP_INFO_FIELD_NUMBER = 7;
    private List<AdGroupInfo> adGroupInfo_;
    public static final int SEED_INFO_FIELD_NUMBER = 8;
    private SeedInfo seedInfo_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateRecommendationsRequest DEFAULT_INSTANCE = new GenerateRecommendationsRequest();
    private static final Parser<GenerateRecommendationsRequest> PARSER = new AbstractParser<GenerateRecommendationsRequest>(){

        public GenerateRecommendationsRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateRecommendationsRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateRecommendationsRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateRecommendationsRequest() {
        this.customerId_ = "";
        this.recommendationTypes_ = Collections.emptyList();
        this.advertisingChannelType_ = 0;
        this.conversionTrackingStatus_ = 0;
        this.adGroupInfo_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateRecommendationsRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateRecommendationsRequest.class, Builder.class);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<RecommendationTypeEnum.RecommendationType> getRecommendationTypesList() {
        return new Internal.ListAdapter(this.recommendationTypes_, recommendationTypes_converter_);
    }

    @Override
    public int getRecommendationTypesCount() {
        return this.recommendationTypes_.size();
    }

    @Override
    public RecommendationTypeEnum.RecommendationType getRecommendationTypes(int index) {
        return (RecommendationTypeEnum.RecommendationType)((Object)recommendationTypes_converter_.convert((Object)this.recommendationTypes_.get(index)));
    }

    @Override
    public List<Integer> getRecommendationTypesValueList() {
        return this.recommendationTypes_;
    }

    @Override
    public int getRecommendationTypesValue(int index) {
        return this.recommendationTypes_.get(index);
    }

    @Override
    public int getAdvertisingChannelTypeValue() {
        return this.advertisingChannelType_;
    }

    @Override
    public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
        AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber(this.advertisingChannelType_);
        return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasCampaignSitelinkCount() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public int getCampaignSitelinkCount() {
        return this.campaignSitelinkCount_;
    }

    @Override
    public boolean hasConversionTrackingStatus() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public int getConversionTrackingStatusValue() {
        return this.conversionTrackingStatus_;
    }

    @Override
    public ConversionTrackingStatusEnum.ConversionTrackingStatus getConversionTrackingStatus() {
        ConversionTrackingStatusEnum.ConversionTrackingStatus result = ConversionTrackingStatusEnum.ConversionTrackingStatus.forNumber(this.conversionTrackingStatus_);
        return result == null ? ConversionTrackingStatusEnum.ConversionTrackingStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasBiddingInfo() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public BiddingInfo getBiddingInfo() {
        return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
    }

    @Override
    public BiddingInfoOrBuilder getBiddingInfoOrBuilder() {
        return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
    }

    @Override
    public List<AdGroupInfo> getAdGroupInfoList() {
        return this.adGroupInfo_;
    }

    @Override
    public List<? extends AdGroupInfoOrBuilder> getAdGroupInfoOrBuilderList() {
        return this.adGroupInfo_;
    }

    @Override
    public int getAdGroupInfoCount() {
        return this.adGroupInfo_.size();
    }

    @Override
    public AdGroupInfo getAdGroupInfo(int index) {
        return this.adGroupInfo_.get(index);
    }

    @Override
    public AdGroupInfoOrBuilder getAdGroupInfoOrBuilder(int index) {
        return this.adGroupInfo_.get(index);
    }

    @Override
    public boolean hasSeedInfo() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public SeedInfo getSeedInfo() {
        return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
    }

    @Override
    public SeedInfoOrBuilder getSeedInfoOrBuilder() {
        return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        if (this.getRecommendationTypesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.recommendationTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.recommendationTypes_.size(); ++i) {
            output.writeEnumNoTag(this.recommendationTypes_.get(i).intValue());
        }
        if (this.advertisingChannelType_ != AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.advertisingChannelType_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt32(4, this.campaignSitelinkCount_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeEnum(5, this.conversionTrackingStatus_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(6, (MessageLite)this.getBiddingInfo());
        }
        for (i = 0; i < this.adGroupInfo_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.adGroupInfo_.get(i));
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(8, (MessageLite)this.getSeedInfo());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.recommendationTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.recommendationTypes_.get(i));
        }
        size += dataSize;
        if (!this.getRecommendationTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.recommendationTypesMemoizedSerializedSize = dataSize;
        if (this.advertisingChannelType_ != AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.advertisingChannelType_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt32Size((int)4, (int)this.campaignSitelinkCount_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.conversionTrackingStatus_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getBiddingInfo());
        }
        for (int i = 0; i < this.adGroupInfo_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.adGroupInfo_.get(i)));
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getSeedInfo());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateRecommendationsRequest)) {
            return super.equals(obj);
        }
        GenerateRecommendationsRequest other = (GenerateRecommendationsRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (!this.recommendationTypes_.equals(other.recommendationTypes_)) {
            return false;
        }
        if (this.advertisingChannelType_ != other.advertisingChannelType_) {
            return false;
        }
        if (this.hasCampaignSitelinkCount() != other.hasCampaignSitelinkCount()) {
            return false;
        }
        if (this.hasCampaignSitelinkCount() && this.getCampaignSitelinkCount() != other.getCampaignSitelinkCount()) {
            return false;
        }
        if (this.hasConversionTrackingStatus() != other.hasConversionTrackingStatus()) {
            return false;
        }
        if (this.hasConversionTrackingStatus() && this.conversionTrackingStatus_ != other.conversionTrackingStatus_) {
            return false;
        }
        if (this.hasBiddingInfo() != other.hasBiddingInfo()) {
            return false;
        }
        if (this.hasBiddingInfo() && !this.getBiddingInfo().equals(other.getBiddingInfo())) {
            return false;
        }
        if (!this.getAdGroupInfoList().equals(other.getAdGroupInfoList())) {
            return false;
        }
        if (this.hasSeedInfo() != other.hasSeedInfo()) {
            return false;
        }
        if (this.hasSeedInfo() && !this.getSeedInfo().equals(other.getSeedInfo())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateRecommendationsRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.getRecommendationTypesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.recommendationTypes_.hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.advertisingChannelType_;
        if (this.hasCampaignSitelinkCount()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getCampaignSitelinkCount();
        }
        if (this.hasConversionTrackingStatus()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.conversionTrackingStatus_;
        }
        if (this.hasBiddingInfo()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getBiddingInfo().hashCode();
        }
        if (this.getAdGroupInfoCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getAdGroupInfoList().hashCode();
        }
        if (this.hasSeedInfo()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getSeedInfo().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateRecommendationsRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data);
    }

    public static GenerateRecommendationsRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data);
    }

    public static GenerateRecommendationsRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data);
    }

    public static GenerateRecommendationsRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateRecommendationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(InputStream input) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateRecommendationsRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateRecommendationsRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateRecommendationsRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateRecommendationsRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateRecommendationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateRecommendationsRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateRecommendationsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateRecommendationsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateRecommendationsRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateRecommendationsRequest> getParserForType() {
        return PARSER;
    }

    public GenerateRecommendationsRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class SeedInfo
    extends GeneratedMessageV3
    implements SeedInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int URL_SEED_FIELD_NUMBER = 2;
        private volatile Object urlSeed_ = "";
        public static final int KEYWORD_SEEDS_FIELD_NUMBER = 3;
        private LazyStringArrayList keywordSeeds_ = LazyStringArrayList.emptyList();
        private byte memoizedIsInitialized = (byte)-1;
        private static final SeedInfo DEFAULT_INSTANCE = new SeedInfo();
        private static final Parser<SeedInfo> PARSER = new AbstractParser<SeedInfo>(){

            public SeedInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = SeedInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private SeedInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private SeedInfo() {
            this.urlSeed_ = "";
            this.keywordSeeds_ = LazyStringArrayList.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new SeedInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_SeedInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_SeedInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(SeedInfo.class, Builder.class);
        }

        @Override
        public boolean hasUrlSeed() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getUrlSeed() {
            Object ref = this.urlSeed_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.urlSeed_ = s;
            return s;
        }

        @Override
        public ByteString getUrlSeedBytes() {
            Object ref = this.urlSeed_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.urlSeed_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public ProtocolStringList getKeywordSeedsList() {
            return this.keywordSeeds_;
        }

        @Override
        public int getKeywordSeedsCount() {
            return this.keywordSeeds_.size();
        }

        @Override
        public String getKeywordSeeds(int index) {
            return this.keywordSeeds_.get(index);
        }

        @Override
        public ByteString getKeywordSeedsBytes(int index) {
            return this.keywordSeeds_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.urlSeed_);
            }
            for (int i = 0; i < this.keywordSeeds_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.keywordSeeds_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.urlSeed_);
            }
            int dataSize = 0;
            for (int i = 0; i < this.keywordSeeds_.size(); ++i) {
                dataSize += SeedInfo.computeStringSizeNoTag((Object)this.keywordSeeds_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getKeywordSeedsList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SeedInfo)) {
                return super.equals(obj);
            }
            SeedInfo other = (SeedInfo)obj;
            if (this.hasUrlSeed() != other.hasUrlSeed()) {
                return false;
            }
            if (this.hasUrlSeed() && !this.getUrlSeed().equals(other.getUrlSeed())) {
                return false;
            }
            if (!this.getKeywordSeedsList().equals(other.getKeywordSeedsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + SeedInfo.getDescriptor().hashCode();
            if (this.hasUrlSeed()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getUrlSeed().hashCode();
            }
            if (this.getKeywordSeedsCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getKeywordSeedsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static SeedInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data);
        }

        public static SeedInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SeedInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data);
        }

        public static SeedInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SeedInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data);
        }

        public static SeedInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SeedInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SeedInfo parseFrom(InputStream input) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static SeedInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SeedInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static SeedInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SeedInfo parseFrom(CodedInputStream input) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static SeedInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SeedInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return SeedInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(SeedInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static SeedInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<SeedInfo> parser() {
            return PARSER;
        }

        public Parser<SeedInfo> getParserForType() {
            return PARSER;
        }

        public SeedInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements SeedInfoOrBuilder {
            private int bitField0_;
            private Object urlSeed_ = "";
            private LazyStringArrayList keywordSeeds_ = LazyStringArrayList.emptyList();

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_SeedInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_SeedInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(SeedInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.urlSeed_ = "";
                this.keywordSeeds_ = LazyStringArrayList.emptyList();
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_SeedInfo_descriptor;
            }

            public SeedInfo getDefaultInstanceForType() {
                return SeedInfo.getDefaultInstance();
            }

            public SeedInfo build() {
                SeedInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public SeedInfo buildPartial() {
                SeedInfo result = new SeedInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(SeedInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.urlSeed_ = this.urlSeed_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    this.keywordSeeds_.makeImmutable();
                    result.keywordSeeds_ = this.keywordSeeds_;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof SeedInfo) {
                    return this.mergeFrom((SeedInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(SeedInfo other) {
                if (other == SeedInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasUrlSeed()) {
                    this.urlSeed_ = other.urlSeed_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (!other.keywordSeeds_.isEmpty()) {
                    if (this.keywordSeeds_.isEmpty()) {
                        this.keywordSeeds_ = other.keywordSeeds_;
                        this.bitField0_ |= 2;
                    } else {
                        this.ensureKeywordSeedsIsMutable();
                        this.keywordSeeds_.addAll((Collection)other.keywordSeeds_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 18: {
                                this.urlSeed_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 26: {
                                String s = input.readStringRequireUtf8();
                                this.ensureKeywordSeedsIsMutable();
                                this.keywordSeeds_.add((Object)s);
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasUrlSeed() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getUrlSeed() {
                Object ref = this.urlSeed_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.urlSeed_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getUrlSeedBytes() {
                Object ref = this.urlSeed_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.urlSeed_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setUrlSeed(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.urlSeed_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearUrlSeed() {
                this.urlSeed_ = SeedInfo.getDefaultInstance().getUrlSeed();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setUrlSeedBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                SeedInfo.checkByteStringIsUtf8((ByteString)value);
                this.urlSeed_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            private void ensureKeywordSeedsIsMutable() {
                if (!this.keywordSeeds_.isModifiable()) {
                    this.keywordSeeds_ = new LazyStringArrayList((LazyStringList)this.keywordSeeds_);
                }
                this.bitField0_ |= 2;
            }

            public ProtocolStringList getKeywordSeedsList() {
                this.keywordSeeds_.makeImmutable();
                return this.keywordSeeds_;
            }

            @Override
            public int getKeywordSeedsCount() {
                return this.keywordSeeds_.size();
            }

            @Override
            public String getKeywordSeeds(int index) {
                return this.keywordSeeds_.get(index);
            }

            @Override
            public ByteString getKeywordSeedsBytes(int index) {
                return this.keywordSeeds_.getByteString(index);
            }

            public Builder setKeywordSeeds(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureKeywordSeedsIsMutable();
                this.keywordSeeds_.set(index, value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addKeywordSeeds(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureKeywordSeedsIsMutable();
                this.keywordSeeds_.add((Object)value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addAllKeywordSeeds(Iterable<String> values) {
                this.ensureKeywordSeedsIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.keywordSeeds_);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearKeywordSeeds() {
                this.keywordSeeds_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder addKeywordSeedsBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                SeedInfo.checkByteStringIsUtf8((ByteString)value);
                this.ensureKeywordSeedsIsMutable();
                this.keywordSeeds_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static final class BiddingInfo
    extends GeneratedMessageV3
    implements BiddingInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        private int biddingStrategyTargetInfoCase_ = 0;
        private Object biddingStrategyTargetInfo_;
        public static final int BIDDING_STRATEGY_TYPE_FIELD_NUMBER = 1;
        private int biddingStrategyType_ = 0;
        public static final int TARGET_CPA_MICROS_FIELD_NUMBER = 2;
        public static final int TARGET_ROAS_FIELD_NUMBER = 3;
        private byte memoizedIsInitialized = (byte)-1;
        private static final BiddingInfo DEFAULT_INSTANCE = new BiddingInfo();
        private static final Parser<BiddingInfo> PARSER = new AbstractParser<BiddingInfo>(){

            public BiddingInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = BiddingInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private BiddingInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private BiddingInfo() {
            this.biddingStrategyType_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new BiddingInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_BiddingInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_BiddingInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(BiddingInfo.class, Builder.class);
        }

        @Override
        public BiddingStrategyTargetInfoCase getBiddingStrategyTargetInfoCase() {
            return BiddingStrategyTargetInfoCase.forNumber(this.biddingStrategyTargetInfoCase_);
        }

        @Override
        public boolean hasBiddingStrategyType() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getBiddingStrategyTypeValue() {
            return this.biddingStrategyType_;
        }

        @Override
        public BiddingStrategyTypeEnum.BiddingStrategyType getBiddingStrategyType() {
            BiddingStrategyTypeEnum.BiddingStrategyType result = BiddingStrategyTypeEnum.BiddingStrategyType.forNumber(this.biddingStrategyType_);
            return result == null ? BiddingStrategyTypeEnum.BiddingStrategyType.UNRECOGNIZED : result;
        }

        @Override
        public boolean hasTargetCpaMicros() {
            return this.biddingStrategyTargetInfoCase_ == 2;
        }

        @Override
        public long getTargetCpaMicros() {
            if (this.biddingStrategyTargetInfoCase_ == 2) {
                return (Long)this.biddingStrategyTargetInfo_;
            }
            return 0L;
        }

        @Override
        public boolean hasTargetRoas() {
            return this.biddingStrategyTargetInfoCase_ == 3;
        }

        @Override
        public double getTargetRoas() {
            if (this.biddingStrategyTargetInfoCase_ == 3) {
                return (Double)this.biddingStrategyTargetInfo_;
            }
            return 0.0;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(1, this.biddingStrategyType_);
            }
            if (this.biddingStrategyTargetInfoCase_ == 2) {
                output.writeInt64(2, ((Long)this.biddingStrategyTargetInfo_).longValue());
            }
            if (this.biddingStrategyTargetInfoCase_ == 3) {
                output.writeDouble(3, ((Double)this.biddingStrategyTargetInfo_).doubleValue());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.biddingStrategyType_);
            }
            if (this.biddingStrategyTargetInfoCase_ == 2) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)((Long)this.biddingStrategyTargetInfo_));
            }
            if (this.biddingStrategyTargetInfoCase_ == 3) {
                size += CodedOutputStream.computeDoubleSize((int)3, (double)((Double)this.biddingStrategyTargetInfo_));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BiddingInfo)) {
                return super.equals(obj);
            }
            BiddingInfo other = (BiddingInfo)obj;
            if (this.hasBiddingStrategyType() != other.hasBiddingStrategyType()) {
                return false;
            }
            if (this.hasBiddingStrategyType() && this.biddingStrategyType_ != other.biddingStrategyType_) {
                return false;
            }
            if (!this.getBiddingStrategyTargetInfoCase().equals((Object)other.getBiddingStrategyTargetInfoCase())) {
                return false;
            }
            switch (this.biddingStrategyTargetInfoCase_) {
                case 2: {
                    if (this.getTargetCpaMicros() == other.getTargetCpaMicros()) break;
                    return false;
                }
                case 3: {
                    if (Double.doubleToLongBits(this.getTargetRoas()) == Double.doubleToLongBits(other.getTargetRoas())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + BiddingInfo.getDescriptor().hashCode();
            if (this.hasBiddingStrategyType()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.biddingStrategyType_;
            }
            switch (this.biddingStrategyTargetInfoCase_) {
                case 2: {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + Internal.hashLong((long)this.getTargetCpaMicros());
                    break;
                }
                case 3: {
                    hash = 37 * hash + 3;
                    hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getTargetRoas()));
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static BiddingInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data);
        }

        public static BiddingInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BiddingInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data);
        }

        public static BiddingInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BiddingInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data);
        }

        public static BiddingInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BiddingInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BiddingInfo parseFrom(InputStream input) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static BiddingInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BiddingInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static BiddingInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BiddingInfo parseFrom(CodedInputStream input) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static BiddingInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BiddingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return BiddingInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(BiddingInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static BiddingInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<BiddingInfo> parser() {
            return PARSER;
        }

        public Parser<BiddingInfo> getParserForType() {
            return PARSER;
        }

        public BiddingInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements BiddingInfoOrBuilder {
            private int biddingStrategyTargetInfoCase_ = 0;
            private Object biddingStrategyTargetInfo_;
            private int bitField0_;
            private int biddingStrategyType_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_BiddingInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_BiddingInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(BiddingInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.biddingStrategyType_ = 0;
                this.biddingStrategyTargetInfoCase_ = 0;
                this.biddingStrategyTargetInfo_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_BiddingInfo_descriptor;
            }

            public BiddingInfo getDefaultInstanceForType() {
                return BiddingInfo.getDefaultInstance();
            }

            public BiddingInfo build() {
                BiddingInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public BiddingInfo buildPartial() {
                BiddingInfo result = new BiddingInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(BiddingInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.biddingStrategyType_ = this.biddingStrategyType_;
                    to_bitField0_ |= 1;
                }
                result.bitField0_ |= to_bitField0_;
            }

            private void buildPartialOneofs(BiddingInfo result) {
                result.biddingStrategyTargetInfoCase_ = this.biddingStrategyTargetInfoCase_;
                result.biddingStrategyTargetInfo_ = this.biddingStrategyTargetInfo_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof BiddingInfo) {
                    return this.mergeFrom((BiddingInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(BiddingInfo other) {
                if (other == BiddingInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasBiddingStrategyType()) {
                    this.setBiddingStrategyType(other.getBiddingStrategyType());
                }
                switch (other.getBiddingStrategyTargetInfoCase()) {
                    case TARGET_CPA_MICROS: {
                        this.setTargetCpaMicros(other.getTargetCpaMicros());
                        break;
                    }
                    case TARGET_ROAS: {
                        this.setTargetRoas(other.getTargetRoas());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 8: {
                                this.biddingStrategyType_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 16: {
                                this.biddingStrategyTargetInfo_ = input.readInt64();
                                this.biddingStrategyTargetInfoCase_ = 2;
                                continue block11;
                            }
                            case 25: {
                                this.biddingStrategyTargetInfo_ = input.readDouble();
                                this.biddingStrategyTargetInfoCase_ = 3;
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public BiddingStrategyTargetInfoCase getBiddingStrategyTargetInfoCase() {
                return BiddingStrategyTargetInfoCase.forNumber(this.biddingStrategyTargetInfoCase_);
            }

            public Builder clearBiddingStrategyTargetInfo() {
                this.biddingStrategyTargetInfoCase_ = 0;
                this.biddingStrategyTargetInfo_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBiddingStrategyType() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getBiddingStrategyTypeValue() {
                return this.biddingStrategyType_;
            }

            public Builder setBiddingStrategyTypeValue(int value) {
                this.biddingStrategyType_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public BiddingStrategyTypeEnum.BiddingStrategyType getBiddingStrategyType() {
                BiddingStrategyTypeEnum.BiddingStrategyType result = BiddingStrategyTypeEnum.BiddingStrategyType.forNumber(this.biddingStrategyType_);
                return result == null ? BiddingStrategyTypeEnum.BiddingStrategyType.UNRECOGNIZED : result;
            }

            public Builder setBiddingStrategyType(BiddingStrategyTypeEnum.BiddingStrategyType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.biddingStrategyType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearBiddingStrategyType() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.biddingStrategyType_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasTargetCpaMicros() {
                return this.biddingStrategyTargetInfoCase_ == 2;
            }

            @Override
            public long getTargetCpaMicros() {
                if (this.biddingStrategyTargetInfoCase_ == 2) {
                    return (Long)this.biddingStrategyTargetInfo_;
                }
                return 0L;
            }

            public Builder setTargetCpaMicros(long value) {
                this.biddingStrategyTargetInfoCase_ = 2;
                this.biddingStrategyTargetInfo_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearTargetCpaMicros() {
                if (this.biddingStrategyTargetInfoCase_ == 2) {
                    this.biddingStrategyTargetInfoCase_ = 0;
                    this.biddingStrategyTargetInfo_ = null;
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasTargetRoas() {
                return this.biddingStrategyTargetInfoCase_ == 3;
            }

            @Override
            public double getTargetRoas() {
                if (this.biddingStrategyTargetInfoCase_ == 3) {
                    return (Double)this.biddingStrategyTargetInfo_;
                }
                return 0.0;
            }

            public Builder setTargetRoas(double value) {
                this.biddingStrategyTargetInfoCase_ = 3;
                this.biddingStrategyTargetInfo_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearTargetRoas() {
                if (this.biddingStrategyTargetInfoCase_ == 3) {
                    this.biddingStrategyTargetInfoCase_ = 0;
                    this.biddingStrategyTargetInfo_ = null;
                    this.onChanged();
                }
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum BiddingStrategyTargetInfoCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            TARGET_CPA_MICROS(2),
            TARGET_ROAS(3),
            BIDDINGSTRATEGYTARGETINFO_NOT_SET(0);

            private final int value;

            private BiddingStrategyTargetInfoCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static BiddingStrategyTargetInfoCase valueOf(int value) {
                return BiddingStrategyTargetInfoCase.forNumber(value);
            }

            public static BiddingStrategyTargetInfoCase forNumber(int value) {
                switch (value) {
                    case 2: {
                        return TARGET_CPA_MICROS;
                    }
                    case 3: {
                        return TARGET_ROAS;
                    }
                    case 0: {
                        return BIDDINGSTRATEGYTARGETINFO_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateRecommendationsRequestOrBuilder {
        private int bitField0_;
        private Object customerId_ = "";
        private List<Integer> recommendationTypes_ = Collections.emptyList();
        private int advertisingChannelType_ = 0;
        private int campaignSitelinkCount_;
        private int conversionTrackingStatus_ = 0;
        private BiddingInfo biddingInfo_;
        private SingleFieldBuilderV3<BiddingInfo, BiddingInfo.Builder, BiddingInfoOrBuilder> biddingInfoBuilder_;
        private List<AdGroupInfo> adGroupInfo_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AdGroupInfo, AdGroupInfo.Builder, AdGroupInfoOrBuilder> adGroupInfoBuilder_;
        private SeedInfo seedInfo_;
        private SingleFieldBuilderV3<SeedInfo, SeedInfo.Builder, SeedInfoOrBuilder> seedInfoBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateRecommendationsRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getBiddingInfoFieldBuilder();
                this.getAdGroupInfoFieldBuilder();
                this.getSeedInfoFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.recommendationTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.advertisingChannelType_ = 0;
            this.campaignSitelinkCount_ = 0;
            this.conversionTrackingStatus_ = 0;
            this.biddingInfo_ = null;
            if (this.biddingInfoBuilder_ != null) {
                this.biddingInfoBuilder_.dispose();
                this.biddingInfoBuilder_ = null;
            }
            if (this.adGroupInfoBuilder_ == null) {
                this.adGroupInfo_ = Collections.emptyList();
            } else {
                this.adGroupInfo_ = null;
                this.adGroupInfoBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            this.seedInfo_ = null;
            if (this.seedInfoBuilder_ != null) {
                this.seedInfoBuilder_.dispose();
                this.seedInfoBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_descriptor;
        }

        public GenerateRecommendationsRequest getDefaultInstanceForType() {
            return GenerateRecommendationsRequest.getDefaultInstance();
        }

        public GenerateRecommendationsRequest build() {
            GenerateRecommendationsRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateRecommendationsRequest buildPartial() {
            GenerateRecommendationsRequest result = new GenerateRecommendationsRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GenerateRecommendationsRequest result) {
            if ((this.bitField0_ & 2) != 0) {
                this.recommendationTypes_ = Collections.unmodifiableList(this.recommendationTypes_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.recommendationTypes_ = this.recommendationTypes_;
            if (this.adGroupInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.adGroupInfo_ = Collections.unmodifiableList(this.adGroupInfo_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.adGroupInfo_ = this.adGroupInfo_;
            } else {
                result.adGroupInfo_ = this.adGroupInfoBuilder_.build();
            }
        }

        private void buildPartial0(GenerateRecommendationsRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.advertisingChannelType_ = this.advertisingChannelType_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 8) != 0) {
                result.campaignSitelinkCount_ = this.campaignSitelinkCount_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.conversionTrackingStatus_ = this.conversionTrackingStatus_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.biddingInfo_ = this.biddingInfoBuilder_ == null ? this.biddingInfo_ : (BiddingInfo)this.biddingInfoBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.seedInfo_ = this.seedInfoBuilder_ == null ? this.seedInfo_ : (SeedInfo)this.seedInfoBuilder_.build();
                to_bitField0_ |= 8;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateRecommendationsRequest) {
                return this.mergeFrom((GenerateRecommendationsRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateRecommendationsRequest other) {
            if (other == GenerateRecommendationsRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.recommendationTypes_.isEmpty()) {
                if (this.recommendationTypes_.isEmpty()) {
                    this.recommendationTypes_ = other.recommendationTypes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureRecommendationTypesIsMutable();
                    this.recommendationTypes_.addAll(other.recommendationTypes_);
                }
                this.onChanged();
            }
            if (other.advertisingChannelType_ != 0) {
                this.setAdvertisingChannelTypeValue(other.getAdvertisingChannelTypeValue());
            }
            if (other.hasCampaignSitelinkCount()) {
                this.setCampaignSitelinkCount(other.getCampaignSitelinkCount());
            }
            if (other.hasConversionTrackingStatus()) {
                this.setConversionTrackingStatus(other.getConversionTrackingStatus());
            }
            if (other.hasBiddingInfo()) {
                this.mergeBiddingInfo(other.getBiddingInfo());
            }
            if (this.adGroupInfoBuilder_ == null) {
                if (!other.adGroupInfo_.isEmpty()) {
                    if (this.adGroupInfo_.isEmpty()) {
                        this.adGroupInfo_ = other.adGroupInfo_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensureAdGroupInfoIsMutable();
                        this.adGroupInfo_.addAll(other.adGroupInfo_);
                    }
                    this.onChanged();
                }
            } else if (!other.adGroupInfo_.isEmpty()) {
                if (this.adGroupInfoBuilder_.isEmpty()) {
                    this.adGroupInfoBuilder_.dispose();
                    this.adGroupInfoBuilder_ = null;
                    this.adGroupInfo_ = other.adGroupInfo_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.adGroupInfoBuilder_ = alwaysUseFieldBuilders ? this.getAdGroupInfoFieldBuilder() : null;
                } else {
                    this.adGroupInfoBuilder_.addAllMessages((Iterable)other.adGroupInfo_);
                }
            }
            if (other.hasSeedInfo()) {
                this.mergeSeedInfo(other.getSeedInfo());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensureRecommendationTypesIsMutable();
                            this.recommendationTypes_.add(tmpRaw);
                            continue block17;
                        }
                        case 18: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureRecommendationTypesIsMutable();
                                this.recommendationTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block17;
                        }
                        case 24: {
                            this.advertisingChannelType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 32: {
                            this.campaignSitelinkCount_ = input.readInt32();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 40: {
                            this.conversionTrackingStatus_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getBiddingInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                        case 58: {
                            AdGroupInfo m = (AdGroupInfo)input.readMessage(AdGroupInfo.parser(), extensionRegistry);
                            if (this.adGroupInfoBuilder_ == null) {
                                this.ensureAdGroupInfoIsMutable();
                                this.adGroupInfo_.add(m);
                                continue block17;
                            }
                            this.adGroupInfoBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getSeedInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = GenerateRecommendationsRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateRecommendationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureRecommendationTypesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.recommendationTypes_ = new ArrayList<Integer>(this.recommendationTypes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<RecommendationTypeEnum.RecommendationType> getRecommendationTypesList() {
            return new Internal.ListAdapter(this.recommendationTypes_, recommendationTypes_converter_);
        }

        @Override
        public int getRecommendationTypesCount() {
            return this.recommendationTypes_.size();
        }

        @Override
        public RecommendationTypeEnum.RecommendationType getRecommendationTypes(int index) {
            return (RecommendationTypeEnum.RecommendationType)((Object)recommendationTypes_converter_.convert((Object)this.recommendationTypes_.get(index)));
        }

        public Builder setRecommendationTypes(int index, RecommendationTypeEnum.RecommendationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addRecommendationTypes(RecommendationTypeEnum.RecommendationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllRecommendationTypes(Iterable<? extends RecommendationTypeEnum.RecommendationType> values) {
            this.ensureRecommendationTypesIsMutable();
            for (RecommendationTypeEnum.RecommendationType recommendationType : values) {
                this.recommendationTypes_.add(recommendationType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearRecommendationTypes() {
            this.recommendationTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getRecommendationTypesValueList() {
            return Collections.unmodifiableList(this.recommendationTypes_);
        }

        @Override
        public int getRecommendationTypesValue(int index) {
            return this.recommendationTypes_.get(index);
        }

        public Builder setRecommendationTypesValue(int index, int value) {
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addRecommendationTypesValue(int value) {
            this.ensureRecommendationTypesIsMutable();
            this.recommendationTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllRecommendationTypesValue(Iterable<Integer> values) {
            this.ensureRecommendationTypesIsMutable();
            for (int value : values) {
                this.recommendationTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public int getAdvertisingChannelTypeValue() {
            return this.advertisingChannelType_;
        }

        public Builder setAdvertisingChannelTypeValue(int value) {
            this.advertisingChannelType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
            AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber(this.advertisingChannelType_);
            return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
        }

        public Builder setAdvertisingChannelType(AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.advertisingChannelType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdvertisingChannelType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.advertisingChannelType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCampaignSitelinkCount() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public int getCampaignSitelinkCount() {
            return this.campaignSitelinkCount_;
        }

        public Builder setCampaignSitelinkCount(int value) {
            this.campaignSitelinkCount_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearCampaignSitelinkCount() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.campaignSitelinkCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasConversionTrackingStatus() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public int getConversionTrackingStatusValue() {
            return this.conversionTrackingStatus_;
        }

        public Builder setConversionTrackingStatusValue(int value) {
            this.conversionTrackingStatus_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public ConversionTrackingStatusEnum.ConversionTrackingStatus getConversionTrackingStatus() {
            ConversionTrackingStatusEnum.ConversionTrackingStatus result = ConversionTrackingStatusEnum.ConversionTrackingStatus.forNumber(this.conversionTrackingStatus_);
            return result == null ? ConversionTrackingStatusEnum.ConversionTrackingStatus.UNRECOGNIZED : result;
        }

        public Builder setConversionTrackingStatus(ConversionTrackingStatusEnum.ConversionTrackingStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.conversionTrackingStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearConversionTrackingStatus() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.conversionTrackingStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBiddingInfo() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public BiddingInfo getBiddingInfo() {
            if (this.biddingInfoBuilder_ == null) {
                return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
            }
            return (BiddingInfo)this.biddingInfoBuilder_.getMessage();
        }

        public Builder setBiddingInfo(BiddingInfo value) {
            if (this.biddingInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.biddingInfo_ = value;
            } else {
                this.biddingInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setBiddingInfo(BiddingInfo.Builder builderForValue) {
            if (this.biddingInfoBuilder_ == null) {
                this.biddingInfo_ = builderForValue.build();
            } else {
                this.biddingInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeBiddingInfo(BiddingInfo value) {
            if (this.biddingInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.biddingInfo_ != null && this.biddingInfo_ != BiddingInfo.getDefaultInstance()) {
                    this.getBiddingInfoBuilder().mergeFrom(value);
                } else {
                    this.biddingInfo_ = value;
                }
            } else {
                this.biddingInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.biddingInfo_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearBiddingInfo() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.biddingInfo_ = null;
            if (this.biddingInfoBuilder_ != null) {
                this.biddingInfoBuilder_.dispose();
                this.biddingInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public BiddingInfo.Builder getBiddingInfoBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (BiddingInfo.Builder)this.getBiddingInfoFieldBuilder().getBuilder();
        }

        @Override
        public BiddingInfoOrBuilder getBiddingInfoOrBuilder() {
            if (this.biddingInfoBuilder_ != null) {
                return (BiddingInfoOrBuilder)this.biddingInfoBuilder_.getMessageOrBuilder();
            }
            return this.biddingInfo_ == null ? BiddingInfo.getDefaultInstance() : this.biddingInfo_;
        }

        private SingleFieldBuilderV3<BiddingInfo, BiddingInfo.Builder, BiddingInfoOrBuilder> getBiddingInfoFieldBuilder() {
            if (this.biddingInfoBuilder_ == null) {
                this.biddingInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getBiddingInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.biddingInfo_ = null;
            }
            return this.biddingInfoBuilder_;
        }

        private void ensureAdGroupInfoIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.adGroupInfo_ = new ArrayList<AdGroupInfo>(this.adGroupInfo_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<AdGroupInfo> getAdGroupInfoList() {
            if (this.adGroupInfoBuilder_ == null) {
                return Collections.unmodifiableList(this.adGroupInfo_);
            }
            return this.adGroupInfoBuilder_.getMessageList();
        }

        @Override
        public int getAdGroupInfoCount() {
            if (this.adGroupInfoBuilder_ == null) {
                return this.adGroupInfo_.size();
            }
            return this.adGroupInfoBuilder_.getCount();
        }

        @Override
        public AdGroupInfo getAdGroupInfo(int index) {
            if (this.adGroupInfoBuilder_ == null) {
                return this.adGroupInfo_.get(index);
            }
            return (AdGroupInfo)this.adGroupInfoBuilder_.getMessage(index);
        }

        public Builder setAdGroupInfo(int index, AdGroupInfo value) {
            if (this.adGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.set(index, value);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdGroupInfo(int index, AdGroupInfo.Builder builderForValue) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdGroupInfo(AdGroupInfo value) {
            if (this.adGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(value);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdGroupInfo(int index, AdGroupInfo value) {
            if (this.adGroupInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(index, value);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdGroupInfo(AdGroupInfo.Builder builderForValue) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdGroupInfo(int index, AdGroupInfo.Builder builderForValue) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdGroupInfo(Iterable<? extends AdGroupInfo> values) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.adGroupInfo_);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdGroupInfo() {
            if (this.adGroupInfoBuilder_ == null) {
                this.adGroupInfo_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdGroupInfo(int index) {
            if (this.adGroupInfoBuilder_ == null) {
                this.ensureAdGroupInfoIsMutable();
                this.adGroupInfo_.remove(index);
                this.onChanged();
            } else {
                this.adGroupInfoBuilder_.remove(index);
            }
            return this;
        }

        public AdGroupInfo.Builder getAdGroupInfoBuilder(int index) {
            return (AdGroupInfo.Builder)this.getAdGroupInfoFieldBuilder().getBuilder(index);
        }

        @Override
        public AdGroupInfoOrBuilder getAdGroupInfoOrBuilder(int index) {
            if (this.adGroupInfoBuilder_ == null) {
                return this.adGroupInfo_.get(index);
            }
            return (AdGroupInfoOrBuilder)this.adGroupInfoBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AdGroupInfoOrBuilder> getAdGroupInfoOrBuilderList() {
            if (this.adGroupInfoBuilder_ != null) {
                return this.adGroupInfoBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.adGroupInfo_);
        }

        public AdGroupInfo.Builder addAdGroupInfoBuilder() {
            return (AdGroupInfo.Builder)this.getAdGroupInfoFieldBuilder().addBuilder((AbstractMessage)AdGroupInfo.getDefaultInstance());
        }

        public AdGroupInfo.Builder addAdGroupInfoBuilder(int index) {
            return (AdGroupInfo.Builder)this.getAdGroupInfoFieldBuilder().addBuilder(index, (AbstractMessage)AdGroupInfo.getDefaultInstance());
        }

        public List<AdGroupInfo.Builder> getAdGroupInfoBuilderList() {
            return this.getAdGroupInfoFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AdGroupInfo, AdGroupInfo.Builder, AdGroupInfoOrBuilder> getAdGroupInfoFieldBuilder() {
            if (this.adGroupInfoBuilder_ == null) {
                this.adGroupInfoBuilder_ = new RepeatedFieldBuilderV3(this.adGroupInfo_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.adGroupInfo_ = null;
            }
            return this.adGroupInfoBuilder_;
        }

        @Override
        public boolean hasSeedInfo() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public SeedInfo getSeedInfo() {
            if (this.seedInfoBuilder_ == null) {
                return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
            }
            return (SeedInfo)this.seedInfoBuilder_.getMessage();
        }

        public Builder setSeedInfo(SeedInfo value) {
            if (this.seedInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.seedInfo_ = value;
            } else {
                this.seedInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setSeedInfo(SeedInfo.Builder builderForValue) {
            if (this.seedInfoBuilder_ == null) {
                this.seedInfo_ = builderForValue.build();
            } else {
                this.seedInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeSeedInfo(SeedInfo value) {
            if (this.seedInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.seedInfo_ != null && this.seedInfo_ != SeedInfo.getDefaultInstance()) {
                    this.getSeedInfoBuilder().mergeFrom(value);
                } else {
                    this.seedInfo_ = value;
                }
            } else {
                this.seedInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.seedInfo_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSeedInfo() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.seedInfo_ = null;
            if (this.seedInfoBuilder_ != null) {
                this.seedInfoBuilder_.dispose();
                this.seedInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public SeedInfo.Builder getSeedInfoBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (SeedInfo.Builder)this.getSeedInfoFieldBuilder().getBuilder();
        }

        @Override
        public SeedInfoOrBuilder getSeedInfoOrBuilder() {
            if (this.seedInfoBuilder_ != null) {
                return (SeedInfoOrBuilder)this.seedInfoBuilder_.getMessageOrBuilder();
            }
            return this.seedInfo_ == null ? SeedInfo.getDefaultInstance() : this.seedInfo_;
        }

        private SingleFieldBuilderV3<SeedInfo, SeedInfo.Builder, SeedInfoOrBuilder> getSeedInfoFieldBuilder() {
            if (this.seedInfoBuilder_ == null) {
                this.seedInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSeedInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.seedInfo_ = null;
            }
            return this.seedInfoBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AdGroupInfo
    extends GeneratedMessageV3
    implements AdGroupInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int AD_GROUP_TYPE_FIELD_NUMBER = 1;
        private int adGroupType_ = 0;
        public static final int KEYWORDS_FIELD_NUMBER = 2;
        private List<KeywordInfo> keywords_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AdGroupInfo DEFAULT_INSTANCE = new AdGroupInfo();
        private static final Parser<AdGroupInfo> PARSER = new AbstractParser<AdGroupInfo>(){

            public AdGroupInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AdGroupInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AdGroupInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AdGroupInfo() {
            this.adGroupType_ = 0;
            this.keywords_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AdGroupInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_AdGroupInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_AdGroupInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupInfo.class, Builder.class);
        }

        @Override
        public boolean hasAdGroupType() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getAdGroupTypeValue() {
            return this.adGroupType_;
        }

        @Override
        public AdGroupTypeEnum.AdGroupType getAdGroupType() {
            AdGroupTypeEnum.AdGroupType result = AdGroupTypeEnum.AdGroupType.forNumber(this.adGroupType_);
            return result == null ? AdGroupTypeEnum.AdGroupType.UNRECOGNIZED : result;
        }

        @Override
        public List<KeywordInfo> getKeywordsList() {
            return this.keywords_;
        }

        @Override
        public List<? extends KeywordInfoOrBuilder> getKeywordsOrBuilderList() {
            return this.keywords_;
        }

        @Override
        public int getKeywordsCount() {
            return this.keywords_.size();
        }

        @Override
        public KeywordInfo getKeywords(int index) {
            return this.keywords_.get(index);
        }

        @Override
        public KeywordInfoOrBuilder getKeywordsOrBuilder(int index) {
            return this.keywords_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(1, this.adGroupType_);
            }
            for (int i = 0; i < this.keywords_.size(); ++i) {
                output.writeMessage(2, (MessageLite)this.keywords_.get(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.adGroupType_);
            }
            for (int i = 0; i < this.keywords_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.keywords_.get(i)));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AdGroupInfo)) {
                return super.equals(obj);
            }
            AdGroupInfo other = (AdGroupInfo)obj;
            if (this.hasAdGroupType() != other.hasAdGroupType()) {
                return false;
            }
            if (this.hasAdGroupType() && this.adGroupType_ != other.adGroupType_) {
                return false;
            }
            if (!this.getKeywordsList().equals(other.getKeywordsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AdGroupInfo.getDescriptor().hashCode();
            if (this.hasAdGroupType()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.adGroupType_;
            }
            if (this.getKeywordsCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getKeywordsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AdGroupInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data);
        }

        public static AdGroupInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AdGroupInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data);
        }

        public static AdGroupInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AdGroupInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data);
        }

        public static AdGroupInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AdGroupInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AdGroupInfo parseFrom(InputStream input) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AdGroupInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AdGroupInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AdGroupInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AdGroupInfo parseFrom(CodedInputStream input) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AdGroupInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AdGroupInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AdGroupInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AdGroupInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AdGroupInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AdGroupInfo> parser() {
            return PARSER;
        }

        public Parser<AdGroupInfo> getParserForType() {
            return PARSER;
        }

        public AdGroupInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AdGroupInfoOrBuilder {
            private int bitField0_;
            private int adGroupType_ = 0;
            private List<KeywordInfo> keywords_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<KeywordInfo, KeywordInfo.Builder, KeywordInfoOrBuilder> keywordsBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_AdGroupInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_AdGroupInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.adGroupType_ = 0;
                if (this.keywordsBuilder_ == null) {
                    this.keywords_ = Collections.emptyList();
                } else {
                    this.keywords_ = null;
                    this.keywordsBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFD;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationServiceProto.internal_static_google_ads_googleads_v17_services_GenerateRecommendationsRequest_AdGroupInfo_descriptor;
            }

            public AdGroupInfo getDefaultInstanceForType() {
                return AdGroupInfo.getDefaultInstance();
            }

            public AdGroupInfo build() {
                AdGroupInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AdGroupInfo buildPartial() {
                AdGroupInfo result = new AdGroupInfo(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(AdGroupInfo result) {
                if (this.keywordsBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0) {
                        this.keywords_ = Collections.unmodifiableList(this.keywords_);
                        this.bitField0_ &= 0xFFFFFFFD;
                    }
                    result.keywords_ = this.keywords_;
                } else {
                    result.keywords_ = this.keywordsBuilder_.build();
                }
            }

            private void buildPartial0(AdGroupInfo result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.adGroupType_ = this.adGroupType_;
                    to_bitField0_ |= 1;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AdGroupInfo) {
                    return this.mergeFrom((AdGroupInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AdGroupInfo other) {
                if (other == AdGroupInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.hasAdGroupType()) {
                    this.setAdGroupType(other.getAdGroupType());
                }
                if (this.keywordsBuilder_ == null) {
                    if (!other.keywords_.isEmpty()) {
                        if (this.keywords_.isEmpty()) {
                            this.keywords_ = other.keywords_;
                            this.bitField0_ &= 0xFFFFFFFD;
                        } else {
                            this.ensureKeywordsIsMutable();
                            this.keywords_.addAll(other.keywords_);
                        }
                        this.onChanged();
                    }
                } else if (!other.keywords_.isEmpty()) {
                    if (this.keywordsBuilder_.isEmpty()) {
                        this.keywordsBuilder_.dispose();
                        this.keywordsBuilder_ = null;
                        this.keywords_ = other.keywords_;
                        this.bitField0_ &= 0xFFFFFFFD;
                        this.keywordsBuilder_ = alwaysUseFieldBuilders ? this.getKeywordsFieldBuilder() : null;
                    } else {
                        this.keywordsBuilder_.addAllMessages((Iterable)other.keywords_);
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.adGroupType_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                KeywordInfo m = (KeywordInfo)input.readMessage(KeywordInfo.parser(), extensionRegistry);
                                if (this.keywordsBuilder_ == null) {
                                    this.ensureKeywordsIsMutable();
                                    this.keywords_.add(m);
                                    continue block10;
                                }
                                this.keywordsBuilder_.addMessage((AbstractMessage)m);
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasAdGroupType() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getAdGroupTypeValue() {
                return this.adGroupType_;
            }

            public Builder setAdGroupTypeValue(int value) {
                this.adGroupType_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public AdGroupTypeEnum.AdGroupType getAdGroupType() {
                AdGroupTypeEnum.AdGroupType result = AdGroupTypeEnum.AdGroupType.forNumber(this.adGroupType_);
                return result == null ? AdGroupTypeEnum.AdGroupType.UNRECOGNIZED : result;
            }

            public Builder setAdGroupType(AdGroupTypeEnum.AdGroupType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.adGroupType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearAdGroupType() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.adGroupType_ = 0;
                this.onChanged();
                return this;
            }

            private void ensureKeywordsIsMutable() {
                if ((this.bitField0_ & 2) == 0) {
                    this.keywords_ = new ArrayList<KeywordInfo>(this.keywords_);
                    this.bitField0_ |= 2;
                }
            }

            @Override
            public List<KeywordInfo> getKeywordsList() {
                if (this.keywordsBuilder_ == null) {
                    return Collections.unmodifiableList(this.keywords_);
                }
                return this.keywordsBuilder_.getMessageList();
            }

            @Override
            public int getKeywordsCount() {
                if (this.keywordsBuilder_ == null) {
                    return this.keywords_.size();
                }
                return this.keywordsBuilder_.getCount();
            }

            @Override
            public KeywordInfo getKeywords(int index) {
                if (this.keywordsBuilder_ == null) {
                    return this.keywords_.get(index);
                }
                return (KeywordInfo)this.keywordsBuilder_.getMessage(index);
            }

            public Builder setKeywords(int index, KeywordInfo value) {
                if (this.keywordsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureKeywordsIsMutable();
                    this.keywords_.set(index, value);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setKeywords(int index, KeywordInfo.Builder builderForValue) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addKeywords(KeywordInfo value) {
                if (this.keywordsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(value);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addKeywords(int index, KeywordInfo value) {
                if (this.keywordsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(index, value);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addKeywords(KeywordInfo.Builder builderForValue) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addKeywords(int index, KeywordInfo.Builder builderForValue) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllKeywords(Iterable<? extends KeywordInfo> values) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.keywords_);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearKeywords() {
                if (this.keywordsBuilder_ == null) {
                    this.keywords_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.clear();
                }
                return this;
            }

            public Builder removeKeywords(int index) {
                if (this.keywordsBuilder_ == null) {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.remove(index);
                    this.onChanged();
                } else {
                    this.keywordsBuilder_.remove(index);
                }
                return this;
            }

            public KeywordInfo.Builder getKeywordsBuilder(int index) {
                return (KeywordInfo.Builder)this.getKeywordsFieldBuilder().getBuilder(index);
            }

            @Override
            public KeywordInfoOrBuilder getKeywordsOrBuilder(int index) {
                if (this.keywordsBuilder_ == null) {
                    return this.keywords_.get(index);
                }
                return (KeywordInfoOrBuilder)this.keywordsBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends KeywordInfoOrBuilder> getKeywordsOrBuilderList() {
                if (this.keywordsBuilder_ != null) {
                    return this.keywordsBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.keywords_);
            }

            public KeywordInfo.Builder addKeywordsBuilder() {
                return (KeywordInfo.Builder)this.getKeywordsFieldBuilder().addBuilder((AbstractMessage)KeywordInfo.getDefaultInstance());
            }

            public KeywordInfo.Builder addKeywordsBuilder(int index) {
                return (KeywordInfo.Builder)this.getKeywordsFieldBuilder().addBuilder(index, (AbstractMessage)KeywordInfo.getDefaultInstance());
            }

            public List<KeywordInfo.Builder> getKeywordsBuilderList() {
                return this.getKeywordsFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<KeywordInfo, KeywordInfo.Builder, KeywordInfoOrBuilder> getKeywordsFieldBuilder() {
                if (this.keywordsBuilder_ == null) {
                    this.keywordsBuilder_ = new RepeatedFieldBuilderV3(this.keywords_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.keywords_ = null;
                }
                return this.keywordsBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AdGroupInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasAdGroupType();

        public int getAdGroupTypeValue();

        public AdGroupTypeEnum.AdGroupType getAdGroupType();

        public List<KeywordInfo> getKeywordsList();

        public KeywordInfo getKeywords(int var1);

        public int getKeywordsCount();

        public List<? extends KeywordInfoOrBuilder> getKeywordsOrBuilderList();

        public KeywordInfoOrBuilder getKeywordsOrBuilder(int var1);
    }

    public static interface SeedInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasUrlSeed();

        public String getUrlSeed();

        public ByteString getUrlSeedBytes();

        public List<String> getKeywordSeedsList();

        public int getKeywordSeedsCount();

        public String getKeywordSeeds(int var1);

        public ByteString getKeywordSeedsBytes(int var1);
    }

    public static interface BiddingInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasBiddingStrategyType();

        public int getBiddingStrategyTypeValue();

        public BiddingStrategyTypeEnum.BiddingStrategyType getBiddingStrategyType();

        public boolean hasTargetCpaMicros();

        public long getTargetCpaMicros();

        public boolean hasTargetRoas();

        public double getTargetRoas();

        public BiddingInfo.BiddingStrategyTargetInfoCase getBiddingStrategyTargetInfoCase();
    }
}

