/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services.stub;

import com.google.ads.googleads.v17.resources.BatchJob;
import com.google.ads.googleads.v17.services.AddBatchJobOperationsRequest;
import com.google.ads.googleads.v17.services.AddBatchJobOperationsResponse;
import com.google.ads.googleads.v17.services.BatchJobResult;
import com.google.ads.googleads.v17.services.BatchJobServiceClient;
import com.google.ads.googleads.v17.services.ListBatchJobResultsRequest;
import com.google.ads.googleads.v17.services.ListBatchJobResultsResponse;
import com.google.ads.googleads.v17.services.MutateBatchJobRequest;
import com.google.ads.googleads.v17.services.MutateBatchJobResponse;
import com.google.ads.googleads.v17.services.RunBatchJobRequest;
import com.google.ads.googleads.v17.services.stub.BatchJobServiceStub;
import com.google.ads.googleads.v17.services.stub.GrpcBatchJobServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class BatchJobServiceStubSettings
extends StubSettings<BatchJobServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobSettings;
    private final PagedCallSettings<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobServiceClient.ListBatchJobResultsPagedResponse> listBatchJobResultsSettings;
    private final UnaryCallSettings<RunBatchJobRequest, Operation> runBatchJobSettings;
    private final OperationCallSettings<RunBatchJobRequest, Empty, BatchJob.BatchJobMetadata> runBatchJobOperationSettings;
    private final UnaryCallSettings<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsSettings;
    private static final PagedListDescriptor<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult> LIST_BATCH_JOB_RESULTS_PAGE_STR_DESC = new PagedListDescriptor<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult>(){

        public String emptyToken() {
            return "";
        }

        public ListBatchJobResultsRequest injectToken(ListBatchJobResultsRequest payload, String token) {
            return ListBatchJobResultsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListBatchJobResultsRequest injectPageSize(ListBatchJobResultsRequest payload, int pageSize) {
            return ListBatchJobResultsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBatchJobResultsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBatchJobResultsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BatchJobResult> extractResources(ListBatchJobResultsResponse payload) {
            return payload.getResultsList() == null ? ImmutableList.of() : payload.getResultsList();
        }
    };
    private static final PagedListResponseFactory<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobServiceClient.ListBatchJobResultsPagedResponse> LIST_BATCH_JOB_RESULTS_PAGE_STR_FACT = new PagedListResponseFactory<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobServiceClient.ListBatchJobResultsPagedResponse>(){

        public ApiFuture<BatchJobServiceClient.ListBatchJobResultsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBatchJobResultsRequest, ListBatchJobResultsResponse> callable, ListBatchJobResultsRequest request, ApiCallContext context, ApiFuture<ListBatchJobResultsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BATCH_JOB_RESULTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BatchJobServiceClient.ListBatchJobResultsPagedResponse.createAsync((PageContext<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobSettings() {
        return this.mutateBatchJobSettings;
    }

    public PagedCallSettings<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobServiceClient.ListBatchJobResultsPagedResponse> listBatchJobResultsSettings() {
        return this.listBatchJobResultsSettings;
    }

    public UnaryCallSettings<RunBatchJobRequest, Operation> runBatchJobSettings() {
        return this.runBatchJobSettings;
    }

    public OperationCallSettings<RunBatchJobRequest, Empty, BatchJob.BatchJobMetadata> runBatchJobOperationSettings() {
        return this.runBatchJobOperationSettings;
    }

    public UnaryCallSettings<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsSettings() {
        return this.addBatchJobOperationsSettings;
    }

    public BatchJobServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBatchJobServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "googleads";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BatchJobServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BatchJobServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BatchJobServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.mutateBatchJobSettings = settingsBuilder.mutateBatchJobSettings().build();
        this.listBatchJobResultsSettings = settingsBuilder.listBatchJobResultsSettings().build();
        this.runBatchJobSettings = settingsBuilder.runBatchJobSettings().build();
        this.runBatchJobOperationSettings = settingsBuilder.runBatchJobOperationSettings().build();
        this.addBatchJobOperationsSettings = settingsBuilder.addBatchJobOperationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BatchJobServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobSettings;
        private final PagedCallSettings.Builder<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobServiceClient.ListBatchJobResultsPagedResponse> listBatchJobResultsSettings;
        private final UnaryCallSettings.Builder<RunBatchJobRequest, Operation> runBatchJobSettings;
        private final OperationCallSettings.Builder<RunBatchJobRequest, Empty, BatchJob.BatchJobMetadata> runBatchJobOperationSettings;
        private final UnaryCallSettings.Builder<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.mutateBatchJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBatchJobResultsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BATCH_JOB_RESULTS_PAGE_STR_FACT);
            this.runBatchJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runBatchJobOperationSettings = OperationCallSettings.newBuilder();
            this.addBatchJobOperationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateBatchJobSettings, this.listBatchJobResultsSettings, this.runBatchJobSettings, this.addBatchJobOperationsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BatchJobServiceStubSettings settings) {
            super((StubSettings)settings);
            this.mutateBatchJobSettings = settings.mutateBatchJobSettings.toBuilder();
            this.listBatchJobResultsSettings = settings.listBatchJobResultsSettings.toBuilder();
            this.runBatchJobSettings = settings.runBatchJobSettings.toBuilder();
            this.runBatchJobOperationSettings = settings.runBatchJobOperationSettings.toBuilder();
            this.addBatchJobOperationsSettings = settings.addBatchJobOperationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateBatchJobSettings, this.listBatchJobResultsSettings, this.runBatchJobSettings, this.addBatchJobOperationsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BatchJobServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BatchJobServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BatchJobServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BatchJobServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.mutateBatchJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listBatchJobResultsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runBatchJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.addBatchJobOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runBatchJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchJob.BatchJobMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobSettings() {
            return this.mutateBatchJobSettings;
        }

        public PagedCallSettings.Builder<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobServiceClient.ListBatchJobResultsPagedResponse> listBatchJobResultsSettings() {
            return this.listBatchJobResultsSettings;
        }

        public UnaryCallSettings.Builder<RunBatchJobRequest, Operation> runBatchJobSettings() {
            return this.runBatchJobSettings;
        }

        public OperationCallSettings.Builder<RunBatchJobRequest, Empty, BatchJob.BatchJobMetadata> runBatchJobOperationSettings() {
            return this.runBatchJobOperationSettings;
        }

        public UnaryCallSettings.Builder<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsSettings() {
            return this.addBatchJobOperationsSettings;
        }

        public BatchJobServiceStubSettings build() throws IOException {
            return new BatchJobServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

