// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v17/resources/asset_group_signal.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v17.resources;

/**
 * <pre>
 * AssetGroupSignal represents a signal in an asset group. The existence of a
 * signal tells the performance max campaign who's most likely to convert.
 * Performance Max uses the signal to look for new people with similar or
 * stronger intent to find conversions across Search, Display, Video, and more.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v17.resources.AssetGroupSignal}
 */
public final class AssetGroupSignal extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v17.resources.AssetGroupSignal)
    AssetGroupSignalOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AssetGroupSignal.newBuilder() to construct.
  private AssetGroupSignal(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AssetGroupSignal() {
    resourceName_ = "";
    assetGroup_ = "";
    approvalStatus_ = 0;
    disapprovalReasons_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new AssetGroupSignal();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v17.resources.AssetGroupSignalProto.internal_static_google_ads_googleads_v17_resources_AssetGroupSignal_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v17.resources.AssetGroupSignalProto.internal_static_google_ads_googleads_v17_resources_AssetGroupSignal_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v17.resources.AssetGroupSignal.class, com.google.ads.googleads.v17.resources.AssetGroupSignal.Builder.class);
  }

  private int signalCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object signal_;
  public enum SignalCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUDIENCE(4),
    SEARCH_THEME(5),
    SIGNAL_NOT_SET(0);
    private final int value;
    private SignalCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SignalCase valueOf(int value) {
      return forNumber(value);
    }

    public static SignalCase forNumber(int value) {
      switch (value) {
        case 4: return AUDIENCE;
        case 5: return SEARCH_THEME;
        case 0: return SIGNAL_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public SignalCase
  getSignalCase() {
    return SignalCase.forNumber(
        signalCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the asset group signal.
   * Asset group signal resource name have the form:
   *
   * `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the asset group signal.
   * Asset group signal resource name have the form:
   *
   * `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSET_GROUP_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object assetGroup_ = "";
  /**
   * <pre>
   * Immutable. The asset group which this asset group signal belongs to.
   * </pre>
   *
   * <code>string asset_group = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The assetGroup.
   */
  @java.lang.Override
  public java.lang.String getAssetGroup() {
    java.lang.Object ref = assetGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assetGroup_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The asset group which this asset group signal belongs to.
   * </pre>
   *
   * <code>string asset_group = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for assetGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAssetGroupBytes() {
    java.lang.Object ref = assetGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      assetGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPROVAL_STATUS_FIELD_NUMBER = 6;
  private int approvalStatus_ = 0;
  /**
   * <pre>
   * Output only. Approval status is the output value for search theme signal
   * after Google ads policy review. When using Audience signal, this field is
   * not used and will be absent.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus approval_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for approvalStatus.
   */
  @java.lang.Override public int getApprovalStatusValue() {
    return approvalStatus_;
  }
  /**
   * <pre>
   * Output only. Approval status is the output value for search theme signal
   * after Google ads policy review. When using Audience signal, this field is
   * not used and will be absent.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus approval_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The approvalStatus.
   */
  @java.lang.Override public com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus getApprovalStatus() {
    com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus result = com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus.forNumber(approvalStatus_);
    return result == null ? com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus.UNRECOGNIZED : result;
  }

  public static final int DISAPPROVAL_REASONS_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList disapprovalReasons_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Output only. Computed for SearchTheme signals.
   * When using Audience signal, this field is not used and will be absent.
   * </pre>
   *
   * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return A list containing the disapprovalReasons.
   */
  public com.google.protobuf.ProtocolStringList
      getDisapprovalReasonsList() {
    return disapprovalReasons_;
  }
  /**
   * <pre>
   * Output only. Computed for SearchTheme signals.
   * When using Audience signal, this field is not used and will be absent.
   * </pre>
   *
   * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The count of disapprovalReasons.
   */
  public int getDisapprovalReasonsCount() {
    return disapprovalReasons_.size();
  }
  /**
   * <pre>
   * Output only. Computed for SearchTheme signals.
   * When using Audience signal, this field is not used and will be absent.
   * </pre>
   *
   * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the element to return.
   * @return The disapprovalReasons at the given index.
   */
  public java.lang.String getDisapprovalReasons(int index) {
    return disapprovalReasons_.get(index);
  }
  /**
   * <pre>
   * Output only. Computed for SearchTheme signals.
   * When using Audience signal, this field is not used and will be absent.
   * </pre>
   *
   * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the value to return.
   * @return The bytes of the disapprovalReasons at the given index.
   */
  public com.google.protobuf.ByteString
      getDisapprovalReasonsBytes(int index) {
    return disapprovalReasons_.getByteString(index);
  }

  public static final int AUDIENCE_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Immutable. The audience signal to be used by the performance max
   * campaign.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the audience field is set.
   */
  @java.lang.Override
  public boolean hasAudience() {
    return signalCase_ == 4;
  }
  /**
   * <pre>
   * Immutable. The audience signal to be used by the performance max
   * campaign.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The audience.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.AudienceInfo getAudience() {
    if (signalCase_ == 4) {
       return (com.google.ads.googleads.v17.common.AudienceInfo) signal_;
    }
    return com.google.ads.googleads.v17.common.AudienceInfo.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. The audience signal to be used by the performance max
   * campaign.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.AudienceInfoOrBuilder getAudienceOrBuilder() {
    if (signalCase_ == 4) {
       return (com.google.ads.googleads.v17.common.AudienceInfo) signal_;
    }
    return com.google.ads.googleads.v17.common.AudienceInfo.getDefaultInstance();
  }

  public static final int SEARCH_THEME_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Immutable. The search_theme signal to be used by the performance max
   * campaign.
   * Mutate errors of search_theme criterion includes
   * AssetGroupSignalError.UNSPECIFIED
   * AssetGroupSignalError.UNKNOWN
   * AssetGroupSignalError.TOO_MANY_WORDS
   * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
   * FieldError.REQUIRED
   * StringFormatError.ILLEGAL_CHARS
   * StringLengthError.TOO_LONG
   * ResourceCountLimitExceededError.RESOURCE_LIMIT
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the searchTheme field is set.
   */
  @java.lang.Override
  public boolean hasSearchTheme() {
    return signalCase_ == 5;
  }
  /**
   * <pre>
   * Immutable. The search_theme signal to be used by the performance max
   * campaign.
   * Mutate errors of search_theme criterion includes
   * AssetGroupSignalError.UNSPECIFIED
   * AssetGroupSignalError.UNKNOWN
   * AssetGroupSignalError.TOO_MANY_WORDS
   * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
   * FieldError.REQUIRED
   * StringFormatError.ILLEGAL_CHARS
   * StringLengthError.TOO_LONG
   * ResourceCountLimitExceededError.RESOURCE_LIMIT
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The searchTheme.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.SearchThemeInfo getSearchTheme() {
    if (signalCase_ == 5) {
       return (com.google.ads.googleads.v17.common.SearchThemeInfo) signal_;
    }
    return com.google.ads.googleads.v17.common.SearchThemeInfo.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. The search_theme signal to be used by the performance max
   * campaign.
   * Mutate errors of search_theme criterion includes
   * AssetGroupSignalError.UNSPECIFIED
   * AssetGroupSignalError.UNKNOWN
   * AssetGroupSignalError.TOO_MANY_WORDS
   * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
   * FieldError.REQUIRED
   * StringFormatError.ILLEGAL_CHARS
   * StringLengthError.TOO_LONG
   * ResourceCountLimitExceededError.RESOURCE_LIMIT
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.SearchThemeInfoOrBuilder getSearchThemeOrBuilder() {
    if (signalCase_ == 5) {
       return (com.google.ads.googleads.v17.common.SearchThemeInfo) signal_;
    }
    return com.google.ads.googleads.v17.common.SearchThemeInfo.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetGroup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, assetGroup_);
    }
    if (signalCase_ == 4) {
      output.writeMessage(4, (com.google.ads.googleads.v17.common.AudienceInfo) signal_);
    }
    if (signalCase_ == 5) {
      output.writeMessage(5, (com.google.ads.googleads.v17.common.SearchThemeInfo) signal_);
    }
    if (approvalStatus_ != com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(6, approvalStatus_);
    }
    for (int i = 0; i < disapprovalReasons_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, disapprovalReasons_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetGroup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, assetGroup_);
    }
    if (signalCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, (com.google.ads.googleads.v17.common.AudienceInfo) signal_);
    }
    if (signalCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, (com.google.ads.googleads.v17.common.SearchThemeInfo) signal_);
    }
    if (approvalStatus_ != com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, approvalStatus_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < disapprovalReasons_.size(); i++) {
        dataSize += computeStringSizeNoTag(disapprovalReasons_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDisapprovalReasonsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v17.resources.AssetGroupSignal)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v17.resources.AssetGroupSignal other = (com.google.ads.googleads.v17.resources.AssetGroupSignal) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (!getAssetGroup()
        .equals(other.getAssetGroup())) return false;
    if (approvalStatus_ != other.approvalStatus_) return false;
    if (!getDisapprovalReasonsList()
        .equals(other.getDisapprovalReasonsList())) return false;
    if (!getSignalCase().equals(other.getSignalCase())) return false;
    switch (signalCase_) {
      case 4:
        if (!getAudience()
            .equals(other.getAudience())) return false;
        break;
      case 5:
        if (!getSearchTheme()
            .equals(other.getSearchTheme())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + ASSET_GROUP_FIELD_NUMBER;
    hash = (53 * hash) + getAssetGroup().hashCode();
    hash = (37 * hash) + APPROVAL_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + approvalStatus_;
    if (getDisapprovalReasonsCount() > 0) {
      hash = (37 * hash) + DISAPPROVAL_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + getDisapprovalReasonsList().hashCode();
    }
    switch (signalCase_) {
      case 4:
        hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
        hash = (53 * hash) + getAudience().hashCode();
        break;
      case 5:
        hash = (37 * hash) + SEARCH_THEME_FIELD_NUMBER;
        hash = (53 * hash) + getSearchTheme().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.AssetGroupSignal parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v17.resources.AssetGroupSignal prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * AssetGroupSignal represents a signal in an asset group. The existence of a
   * signal tells the performance max campaign who's most likely to convert.
   * Performance Max uses the signal to look for new people with similar or
   * stronger intent to find conversions across Search, Display, Video, and more.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v17.resources.AssetGroupSignal}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v17.resources.AssetGroupSignal)
      com.google.ads.googleads.v17.resources.AssetGroupSignalOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v17.resources.AssetGroupSignalProto.internal_static_google_ads_googleads_v17_resources_AssetGroupSignal_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v17.resources.AssetGroupSignalProto.internal_static_google_ads_googleads_v17_resources_AssetGroupSignal_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v17.resources.AssetGroupSignal.class, com.google.ads.googleads.v17.resources.AssetGroupSignal.Builder.class);
    }

    // Construct using com.google.ads.googleads.v17.resources.AssetGroupSignal.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      assetGroup_ = "";
      approvalStatus_ = 0;
      disapprovalReasons_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      if (audienceBuilder_ != null) {
        audienceBuilder_.clear();
      }
      if (searchThemeBuilder_ != null) {
        searchThemeBuilder_.clear();
      }
      signalCase_ = 0;
      signal_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v17.resources.AssetGroupSignalProto.internal_static_google_ads_googleads_v17_resources_AssetGroupSignal_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.AssetGroupSignal getDefaultInstanceForType() {
      return com.google.ads.googleads.v17.resources.AssetGroupSignal.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.AssetGroupSignal build() {
      com.google.ads.googleads.v17.resources.AssetGroupSignal result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.AssetGroupSignal buildPartial() {
      com.google.ads.googleads.v17.resources.AssetGroupSignal result = new com.google.ads.googleads.v17.resources.AssetGroupSignal(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v17.resources.AssetGroupSignal result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.assetGroup_ = assetGroup_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.approvalStatus_ = approvalStatus_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        disapprovalReasons_.makeImmutable();
        result.disapprovalReasons_ = disapprovalReasons_;
      }
    }

    private void buildPartialOneofs(com.google.ads.googleads.v17.resources.AssetGroupSignal result) {
      result.signalCase_ = signalCase_;
      result.signal_ = this.signal_;
      if (signalCase_ == 4 &&
          audienceBuilder_ != null) {
        result.signal_ = audienceBuilder_.build();
      }
      if (signalCase_ == 5 &&
          searchThemeBuilder_ != null) {
        result.signal_ = searchThemeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v17.resources.AssetGroupSignal) {
        return mergeFrom((com.google.ads.googleads.v17.resources.AssetGroupSignal)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v17.resources.AssetGroupSignal other) {
      if (other == com.google.ads.googleads.v17.resources.AssetGroupSignal.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAssetGroup().isEmpty()) {
        assetGroup_ = other.assetGroup_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.approvalStatus_ != 0) {
        setApprovalStatusValue(other.getApprovalStatusValue());
      }
      if (!other.disapprovalReasons_.isEmpty()) {
        if (disapprovalReasons_.isEmpty()) {
          disapprovalReasons_ = other.disapprovalReasons_;
          bitField0_ |= 0x00000008;
        } else {
          ensureDisapprovalReasonsIsMutable();
          disapprovalReasons_.addAll(other.disapprovalReasons_);
        }
        onChanged();
      }
      switch (other.getSignalCase()) {
        case AUDIENCE: {
          mergeAudience(other.getAudience());
          break;
        }
        case SEARCH_THEME: {
          mergeSearchTheme(other.getSearchTheme());
          break;
        }
        case SIGNAL_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              assetGroup_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 34: {
              input.readMessage(
                  getAudienceFieldBuilder().getBuilder(),
                  extensionRegistry);
              signalCase_ = 4;
              break;
            } // case 34
            case 42: {
              input.readMessage(
                  getSearchThemeFieldBuilder().getBuilder(),
                  extensionRegistry);
              signalCase_ = 5;
              break;
            } // case 42
            case 48: {
              approvalStatus_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 48
            case 58: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureDisapprovalReasonsIsMutable();
              disapprovalReasons_.add(s);
              break;
            } // case 58
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int signalCase_ = 0;
    private java.lang.Object signal_;
    public SignalCase
        getSignalCase() {
      return SignalCase.forNumber(
          signalCase_);
    }

    public Builder clearSignal() {
      signalCase_ = 0;
      signal_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the asset group signal.
     * Asset group signal resource name have the form:
     *
     * `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group signal.
     * Asset group signal resource name have the form:
     *
     * `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group signal.
     * Asset group signal resource name have the form:
     *
     * `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group signal.
     * Asset group signal resource name have the form:
     *
     * `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the asset group signal.
     * Asset group signal resource name have the form:
     *
     * `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object assetGroup_ = "";
    /**
     * <pre>
     * Immutable. The asset group which this asset group signal belongs to.
     * </pre>
     *
     * <code>string asset_group = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The assetGroup.
     */
    public java.lang.String getAssetGroup() {
      java.lang.Object ref = assetGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assetGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The asset group which this asset group signal belongs to.
     * </pre>
     *
     * <code>string asset_group = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for assetGroup.
     */
    public com.google.protobuf.ByteString
        getAssetGroupBytes() {
      java.lang.Object ref = assetGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        assetGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The asset group which this asset group signal belongs to.
     * </pre>
     *
     * <code>string asset_group = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The assetGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAssetGroup(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      assetGroup_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The asset group which this asset group signal belongs to.
     * </pre>
     *
     * <code>string asset_group = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearAssetGroup() {
      assetGroup_ = getDefaultInstance().getAssetGroup();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The asset group which this asset group signal belongs to.
     * </pre>
     *
     * <code>string asset_group = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for assetGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAssetGroupBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      assetGroup_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int approvalStatus_ = 0;
    /**
     * <pre>
     * Output only. Approval status is the output value for search theme signal
     * after Google ads policy review. When using Audience signal, this field is
     * not used and will be absent.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus approval_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for approvalStatus.
     */
    @java.lang.Override public int getApprovalStatusValue() {
      return approvalStatus_;
    }
    /**
     * <pre>
     * Output only. Approval status is the output value for search theme signal
     * after Google ads policy review. When using Audience signal, this field is
     * not used and will be absent.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus approval_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for approvalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setApprovalStatusValue(int value) {
      approvalStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Approval status is the output value for search theme signal
     * after Google ads policy review. When using Audience signal, this field is
     * not used and will be absent.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus approval_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The approvalStatus.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus getApprovalStatus() {
      com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus result = com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus.forNumber(approvalStatus_);
      return result == null ? com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Approval status is the output value for search theme signal
     * after Google ads policy review. When using Audience signal, this field is
     * not used and will be absent.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus approval_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The approvalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setApprovalStatus(com.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      approvalStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Approval status is the output value for search theme signal
     * after Google ads policy review. When using Audience signal, this field is
     * not used and will be absent.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.AssetGroupSignalApprovalStatusEnum.AssetGroupSignalApprovalStatus approval_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearApprovalStatus() {
      bitField0_ = (bitField0_ & ~0x00000004);
      approvalStatus_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList disapprovalReasons_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureDisapprovalReasonsIsMutable() {
      if (!disapprovalReasons_.isModifiable()) {
        disapprovalReasons_ = new com.google.protobuf.LazyStringArrayList(disapprovalReasons_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return A list containing the disapprovalReasons.
     */
    public com.google.protobuf.ProtocolStringList
        getDisapprovalReasonsList() {
      disapprovalReasons_.makeImmutable();
      return disapprovalReasons_;
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The count of disapprovalReasons.
     */
    public int getDisapprovalReasonsCount() {
      return disapprovalReasons_.size();
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the element to return.
     * @return The disapprovalReasons at the given index.
     */
    public java.lang.String getDisapprovalReasons(int index) {
      return disapprovalReasons_.get(index);
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the value to return.
     * @return The bytes of the disapprovalReasons at the given index.
     */
    public com.google.protobuf.ByteString
        getDisapprovalReasonsBytes(int index) {
      return disapprovalReasons_.getByteString(index);
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index to set the value at.
     * @param value The disapprovalReasons to set.
     * @return This builder for chaining.
     */
    public Builder setDisapprovalReasons(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureDisapprovalReasonsIsMutable();
      disapprovalReasons_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The disapprovalReasons to add.
     * @return This builder for chaining.
     */
    public Builder addDisapprovalReasons(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureDisapprovalReasonsIsMutable();
      disapprovalReasons_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param values The disapprovalReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllDisapprovalReasons(
        java.lang.Iterable<java.lang.String> values) {
      ensureDisapprovalReasonsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, disapprovalReasons_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearDisapprovalReasons() {
      disapprovalReasons_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Computed for SearchTheme signals.
     * When using Audience signal, this field is not used and will be absent.
     * </pre>
     *
     * <code>repeated string disapproval_reasons = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes of the disapprovalReasons to add.
     * @return This builder for chaining.
     */
    public Builder addDisapprovalReasonsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureDisapprovalReasonsIsMutable();
      disapprovalReasons_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.AudienceInfo, com.google.ads.googleads.v17.common.AudienceInfo.Builder, com.google.ads.googleads.v17.common.AudienceInfoOrBuilder> audienceBuilder_;
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the audience field is set.
     */
    @java.lang.Override
    public boolean hasAudience() {
      return signalCase_ == 4;
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The audience.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.AudienceInfo getAudience() {
      if (audienceBuilder_ == null) {
        if (signalCase_ == 4) {
          return (com.google.ads.googleads.v17.common.AudienceInfo) signal_;
        }
        return com.google.ads.googleads.v17.common.AudienceInfo.getDefaultInstance();
      } else {
        if (signalCase_ == 4) {
          return audienceBuilder_.getMessage();
        }
        return com.google.ads.googleads.v17.common.AudienceInfo.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setAudience(com.google.ads.googleads.v17.common.AudienceInfo value) {
      if (audienceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signal_ = value;
        onChanged();
      } else {
        audienceBuilder_.setMessage(value);
      }
      signalCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setAudience(
        com.google.ads.googleads.v17.common.AudienceInfo.Builder builderForValue) {
      if (audienceBuilder_ == null) {
        signal_ = builderForValue.build();
        onChanged();
      } else {
        audienceBuilder_.setMessage(builderForValue.build());
      }
      signalCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeAudience(com.google.ads.googleads.v17.common.AudienceInfo value) {
      if (audienceBuilder_ == null) {
        if (signalCase_ == 4 &&
            signal_ != com.google.ads.googleads.v17.common.AudienceInfo.getDefaultInstance()) {
          signal_ = com.google.ads.googleads.v17.common.AudienceInfo.newBuilder((com.google.ads.googleads.v17.common.AudienceInfo) signal_)
              .mergeFrom(value).buildPartial();
        } else {
          signal_ = value;
        }
        onChanged();
      } else {
        if (signalCase_ == 4) {
          audienceBuilder_.mergeFrom(value);
        } else {
          audienceBuilder_.setMessage(value);
        }
      }
      signalCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearAudience() {
      if (audienceBuilder_ == null) {
        if (signalCase_ == 4) {
          signalCase_ = 0;
          signal_ = null;
          onChanged();
        }
      } else {
        if (signalCase_ == 4) {
          signalCase_ = 0;
          signal_ = null;
        }
        audienceBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v17.common.AudienceInfo.Builder getAudienceBuilder() {
      return getAudienceFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.AudienceInfoOrBuilder getAudienceOrBuilder() {
      if ((signalCase_ == 4) && (audienceBuilder_ != null)) {
        return audienceBuilder_.getMessageOrBuilder();
      } else {
        if (signalCase_ == 4) {
          return (com.google.ads.googleads.v17.common.AudienceInfo) signal_;
        }
        return com.google.ads.googleads.v17.common.AudienceInfo.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. The audience signal to be used by the performance max
     * campaign.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.AudienceInfo audience = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.AudienceInfo, com.google.ads.googleads.v17.common.AudienceInfo.Builder, com.google.ads.googleads.v17.common.AudienceInfoOrBuilder> 
        getAudienceFieldBuilder() {
      if (audienceBuilder_ == null) {
        if (!(signalCase_ == 4)) {
          signal_ = com.google.ads.googleads.v17.common.AudienceInfo.getDefaultInstance();
        }
        audienceBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v17.common.AudienceInfo, com.google.ads.googleads.v17.common.AudienceInfo.Builder, com.google.ads.googleads.v17.common.AudienceInfoOrBuilder>(
                (com.google.ads.googleads.v17.common.AudienceInfo) signal_,
                getParentForChildren(),
                isClean());
        signal_ = null;
      }
      signalCase_ = 4;
      onChanged();
      return audienceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.SearchThemeInfo, com.google.ads.googleads.v17.common.SearchThemeInfo.Builder, com.google.ads.googleads.v17.common.SearchThemeInfoOrBuilder> searchThemeBuilder_;
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the searchTheme field is set.
     */
    @java.lang.Override
    public boolean hasSearchTheme() {
      return signalCase_ == 5;
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The searchTheme.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.SearchThemeInfo getSearchTheme() {
      if (searchThemeBuilder_ == null) {
        if (signalCase_ == 5) {
          return (com.google.ads.googleads.v17.common.SearchThemeInfo) signal_;
        }
        return com.google.ads.googleads.v17.common.SearchThemeInfo.getDefaultInstance();
      } else {
        if (signalCase_ == 5) {
          return searchThemeBuilder_.getMessage();
        }
        return com.google.ads.googleads.v17.common.SearchThemeInfo.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setSearchTheme(com.google.ads.googleads.v17.common.SearchThemeInfo value) {
      if (searchThemeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signal_ = value;
        onChanged();
      } else {
        searchThemeBuilder_.setMessage(value);
      }
      signalCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setSearchTheme(
        com.google.ads.googleads.v17.common.SearchThemeInfo.Builder builderForValue) {
      if (searchThemeBuilder_ == null) {
        signal_ = builderForValue.build();
        onChanged();
      } else {
        searchThemeBuilder_.setMessage(builderForValue.build());
      }
      signalCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeSearchTheme(com.google.ads.googleads.v17.common.SearchThemeInfo value) {
      if (searchThemeBuilder_ == null) {
        if (signalCase_ == 5 &&
            signal_ != com.google.ads.googleads.v17.common.SearchThemeInfo.getDefaultInstance()) {
          signal_ = com.google.ads.googleads.v17.common.SearchThemeInfo.newBuilder((com.google.ads.googleads.v17.common.SearchThemeInfo) signal_)
              .mergeFrom(value).buildPartial();
        } else {
          signal_ = value;
        }
        onChanged();
      } else {
        if (signalCase_ == 5) {
          searchThemeBuilder_.mergeFrom(value);
        } else {
          searchThemeBuilder_.setMessage(value);
        }
      }
      signalCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearSearchTheme() {
      if (searchThemeBuilder_ == null) {
        if (signalCase_ == 5) {
          signalCase_ = 0;
          signal_ = null;
          onChanged();
        }
      } else {
        if (signalCase_ == 5) {
          signalCase_ = 0;
          signal_ = null;
        }
        searchThemeBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v17.common.SearchThemeInfo.Builder getSearchThemeBuilder() {
      return getSearchThemeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.SearchThemeInfoOrBuilder getSearchThemeOrBuilder() {
      if ((signalCase_ == 5) && (searchThemeBuilder_ != null)) {
        return searchThemeBuilder_.getMessageOrBuilder();
      } else {
        if (signalCase_ == 5) {
          return (com.google.ads.googleads.v17.common.SearchThemeInfo) signal_;
        }
        return com.google.ads.googleads.v17.common.SearchThemeInfo.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. The search_theme signal to be used by the performance max
     * campaign.
     * Mutate errors of search_theme criterion includes
     * AssetGroupSignalError.UNSPECIFIED
     * AssetGroupSignalError.UNKNOWN
     * AssetGroupSignalError.TOO_MANY_WORDS
     * AssetGroupSignalError.SEARCH_THEME_POLICY_VIOLATION
     * FieldError.REQUIRED
     * StringFormatError.ILLEGAL_CHARS
     * StringLengthError.TOO_LONG
     * ResourceCountLimitExceededError.RESOURCE_LIMIT
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.SearchThemeInfo search_theme = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.SearchThemeInfo, com.google.ads.googleads.v17.common.SearchThemeInfo.Builder, com.google.ads.googleads.v17.common.SearchThemeInfoOrBuilder> 
        getSearchThemeFieldBuilder() {
      if (searchThemeBuilder_ == null) {
        if (!(signalCase_ == 5)) {
          signal_ = com.google.ads.googleads.v17.common.SearchThemeInfo.getDefaultInstance();
        }
        searchThemeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v17.common.SearchThemeInfo, com.google.ads.googleads.v17.common.SearchThemeInfo.Builder, com.google.ads.googleads.v17.common.SearchThemeInfoOrBuilder>(
                (com.google.ads.googleads.v17.common.SearchThemeInfo) signal_,
                getParentForChildren(),
                isClean());
        signal_ = null;
      }
      signalCase_ = 5;
      onChanged();
      return searchThemeBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v17.resources.AssetGroupSignal)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v17.resources.AssetGroupSignal)
  private static final com.google.ads.googleads.v17.resources.AssetGroupSignal DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v17.resources.AssetGroupSignal();
  }

  public static com.google.ads.googleads.v17.resources.AssetGroupSignal getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AssetGroupSignal>
      PARSER = new com.google.protobuf.AbstractParser<AssetGroupSignal>() {
    @java.lang.Override
    public AssetGroupSignal parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<AssetGroupSignal> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AssetGroupSignal> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v17.resources.AssetGroupSignal getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

