// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v17/resources/bidding_data_exclusion.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v17.resources;

/**
 * <pre>
 * Represents a bidding data exclusion.
 *
 * See "About data exclusions" at
 * https://support.google.com/google-ads/answer/10370710.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v17.resources.BiddingDataExclusion}
 */
public final class BiddingDataExclusion extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v17.resources.BiddingDataExclusion)
    BiddingDataExclusionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use BiddingDataExclusion.newBuilder() to construct.
  private BiddingDataExclusion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private BiddingDataExclusion() {
    resourceName_ = "";
    scope_ = 0;
    status_ = 0;
    startDateTime_ = "";
    endDateTime_ = "";
    name_ = "";
    description_ = "";
    devices_ = java.util.Collections.emptyList();
    campaigns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    advertisingChannelTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new BiddingDataExclusion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v17.resources.BiddingDataExclusionProto.internal_static_google_ads_googleads_v17_resources_BiddingDataExclusion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v17.resources.BiddingDataExclusionProto.internal_static_google_ads_googleads_v17_resources_BiddingDataExclusion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v17.resources.BiddingDataExclusion.class, com.google.ads.googleads.v17.resources.BiddingDataExclusion.Builder.class);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the data exclusion.
   * Data exclusion resource names have the form:
   *
   * `customers/{customer_id}/biddingDataExclusions/{data_exclusion_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the data exclusion.
   * Data exclusion resource names have the form:
   *
   * `customers/{customer_id}/biddingDataExclusions/{data_exclusion_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_EXCLUSION_ID_FIELD_NUMBER = 2;
  private long dataExclusionId_ = 0L;
  /**
   * <pre>
   * Output only. The ID of the data exclusion.
   * </pre>
   *
   * <code>int64 data_exclusion_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The dataExclusionId.
   */
  @java.lang.Override
  public long getDataExclusionId() {
    return dataExclusionId_;
  }

  public static final int SCOPE_FIELD_NUMBER = 3;
  private int scope_ = 0;
  /**
   * <pre>
   * The scope of the data exclusion.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope scope = 3;</code>
   * @return The enum numeric value on the wire for scope.
   */
  @java.lang.Override public int getScopeValue() {
    return scope_;
  }
  /**
   * <pre>
   * The scope of the data exclusion.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope scope = 3;</code>
   * @return The scope.
   */
  @java.lang.Override public com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope getScope() {
    com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope result = com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope.forNumber(scope_);
    return result == null ? com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope.UNRECOGNIZED : result;
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private int status_ = 0;
  /**
   * <pre>
   * Output only. The status of the data exclusion.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Output only. The status of the data exclusion.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus getStatus() {
    com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus result = com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus.UNRECOGNIZED : result;
  }

  public static final int START_DATE_TIME_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object startDateTime_ = "";
  /**
   * <pre>
   * Required. The inclusive start time of the data exclusion in yyyy-MM-dd
   * HH:mm:ss format.
   *
   * A data exclusion is backward looking and should be used for events that
   * start in the past and end either in the past or future.
   * </pre>
   *
   * <code>string start_date_time = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The startDateTime.
   */
  @java.lang.Override
  public java.lang.String getStartDateTime() {
    java.lang.Object ref = startDateTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startDateTime_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Required. The inclusive start time of the data exclusion in yyyy-MM-dd
   * HH:mm:ss format.
   *
   * A data exclusion is backward looking and should be used for events that
   * start in the past and end either in the past or future.
   * </pre>
   *
   * <code>string start_date_time = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The bytes for startDateTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getStartDateTimeBytes() {
    java.lang.Object ref = startDateTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      startDateTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_DATE_TIME_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private volatile java.lang.Object endDateTime_ = "";
  /**
   * <pre>
   * Required. The exclusive end time of the data exclusion in yyyy-MM-dd
   * HH:mm:ss format.
   *
   * The length of [start_date_time, end_date_time) interval must be
   * within (0, 14 days].
   * </pre>
   *
   * <code>string end_date_time = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The endDateTime.
   */
  @java.lang.Override
  public java.lang.String getEndDateTime() {
    java.lang.Object ref = endDateTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endDateTime_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Required. The exclusive end time of the data exclusion in yyyy-MM-dd
   * HH:mm:ss format.
   *
   * The length of [start_date_time, end_date_time) interval must be
   * within (0, 14 days].
   * </pre>
   *
   * <code>string end_date_time = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The bytes for endDateTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getEndDateTimeBytes() {
    java.lang.Object ref = endDateTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      endDateTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * The name of the data exclusion. The name can be at most 255
   * characters.
   * </pre>
   *
   * <code>string name = 7;</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The name of the data exclusion. The name can be at most 255
   * characters.
   * </pre>
   *
   * <code>string name = 7;</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;
  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   * <pre>
   * The description of the data exclusion. The description can be at
   * most 2048 characters.
   * </pre>
   *
   * <code>string description = 8;</code>
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The description of the data exclusion. The description can be at
   * most 2048 characters.
   * </pre>
   *
   * <code>string description = 8;</code>
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEVICES_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> devices_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, com.google.ads.googleads.v17.enums.DeviceEnum.Device> devices_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.ads.googleads.v17.enums.DeviceEnum.Device>() {
            public com.google.ads.googleads.v17.enums.DeviceEnum.Device convert(java.lang.Integer from) {
              com.google.ads.googleads.v17.enums.DeviceEnum.Device result = com.google.ads.googleads.v17.enums.DeviceEnum.Device.forNumber(from);
              return result == null ? com.google.ads.googleads.v17.enums.DeviceEnum.Device.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * If not specified, all devices will be included in this exclusion.
   * Otherwise, only the specified targeted devices will be included in this
   * exclusion.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
   * @return A list containing the devices.
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v17.enums.DeviceEnum.Device> getDevicesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.ads.googleads.v17.enums.DeviceEnum.Device>(devices_, devices_converter_);
  }
  /**
   * <pre>
   * If not specified, all devices will be included in this exclusion.
   * Otherwise, only the specified targeted devices will be included in this
   * exclusion.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
   * @return The count of devices.
   */
  @java.lang.Override
  public int getDevicesCount() {
    return devices_.size();
  }
  /**
   * <pre>
   * If not specified, all devices will be included in this exclusion.
   * Otherwise, only the specified targeted devices will be included in this
   * exclusion.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
   * @param index The index of the element to return.
   * @return The devices at the given index.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.enums.DeviceEnum.Device getDevices(int index) {
    return devices_converter_.convert(devices_.get(index));
  }
  /**
   * <pre>
   * If not specified, all devices will be included in this exclusion.
   * Otherwise, only the specified targeted devices will be included in this
   * exclusion.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
   * @return A list containing the enum numeric values on the wire for devices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
  getDevicesValueList() {
    return devices_;
  }
  /**
   * <pre>
   * If not specified, all devices will be included in this exclusion.
   * Otherwise, only the specified targeted devices will be included in this
   * exclusion.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of devices at the given index.
   */
  @java.lang.Override
  public int getDevicesValue(int index) {
    return devices_.get(index);
  }
  private int devicesMemoizedSerializedSize;

  public static final int CAMPAIGNS_FIELD_NUMBER = 10;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList campaigns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * The data exclusion will apply to the campaigns listed when the scope of
   * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
   * 2000.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
   * @return A list containing the campaigns.
   */
  public com.google.protobuf.ProtocolStringList
      getCampaignsList() {
    return campaigns_;
  }
  /**
   * <pre>
   * The data exclusion will apply to the campaigns listed when the scope of
   * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
   * 2000.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
   * @return The count of campaigns.
   */
  public int getCampaignsCount() {
    return campaigns_.size();
  }
  /**
   * <pre>
   * The data exclusion will apply to the campaigns listed when the scope of
   * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
   * 2000.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
   * @param index The index of the element to return.
   * @return The campaigns at the given index.
   */
  public java.lang.String getCampaigns(int index) {
    return campaigns_.get(index);
  }
  /**
   * <pre>
   * The data exclusion will apply to the campaigns listed when the scope of
   * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
   * 2000.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
   * @param index The index of the value to return.
   * @return The bytes of the campaigns at the given index.
   */
  public com.google.protobuf.ByteString
      getCampaignsBytes(int index) {
    return campaigns_.getByteString(index);
  }

  public static final int ADVERTISING_CHANNEL_TYPES_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> advertisingChannelTypes_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType> advertisingChannelTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType>() {
            public com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType convert(java.lang.Integer from) {
              com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType result = com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber(from);
              return result == null ? com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * The data_exclusion will apply to all the campaigns under the listed
   * channels retroactively as well as going forward when the scope of this
   * exclusion is CHANNEL.
   * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
   * @return A list containing the advertisingChannelTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType> getAdvertisingChannelTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType>(advertisingChannelTypes_, advertisingChannelTypes_converter_);
  }
  /**
   * <pre>
   * The data_exclusion will apply to all the campaigns under the listed
   * channels retroactively as well as going forward when the scope of this
   * exclusion is CHANNEL.
   * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
   * @return The count of advertisingChannelTypes.
   */
  @java.lang.Override
  public int getAdvertisingChannelTypesCount() {
    return advertisingChannelTypes_.size();
  }
  /**
   * <pre>
   * The data_exclusion will apply to all the campaigns under the listed
   * channels retroactively as well as going forward when the scope of this
   * exclusion is CHANNEL.
   * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
   * @param index The index of the element to return.
   * @return The advertisingChannelTypes at the given index.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelTypes(int index) {
    return advertisingChannelTypes_converter_.convert(advertisingChannelTypes_.get(index));
  }
  /**
   * <pre>
   * The data_exclusion will apply to all the campaigns under the listed
   * channels retroactively as well as going forward when the scope of this
   * exclusion is CHANNEL.
   * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
   * @return A list containing the enum numeric values on the wire for advertisingChannelTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
  getAdvertisingChannelTypesValueList() {
    return advertisingChannelTypes_;
  }
  /**
   * <pre>
   * The data_exclusion will apply to all the campaigns under the listed
   * channels retroactively as well as going forward when the scope of this
   * exclusion is CHANNEL.
   * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
   * Note: a data exclusion with both advertising_channel_types and
   * campaign_ids is not supported.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of advertisingChannelTypes at the given index.
   */
  @java.lang.Override
  public int getAdvertisingChannelTypesValue(int index) {
    return advertisingChannelTypes_.get(index);
  }
  private int advertisingChannelTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (dataExclusionId_ != 0L) {
      output.writeInt64(2, dataExclusionId_);
    }
    if (scope_ != com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, scope_);
    }
    if (status_ != com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startDateTime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, startDateTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endDateTime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, endDateTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    if (getDevicesList().size() > 0) {
      output.writeUInt32NoTag(74);
      output.writeUInt32NoTag(devicesMemoizedSerializedSize);
    }
    for (int i = 0; i < devices_.size(); i++) {
      output.writeEnumNoTag(devices_.get(i));
    }
    for (int i = 0; i < campaigns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, campaigns_.getRaw(i));
    }
    if (getAdvertisingChannelTypesList().size() > 0) {
      output.writeUInt32NoTag(90);
      output.writeUInt32NoTag(advertisingChannelTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < advertisingChannelTypes_.size(); i++) {
      output.writeEnumNoTag(advertisingChannelTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (dataExclusionId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, dataExclusionId_);
    }
    if (scope_ != com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, scope_);
    }
    if (status_ != com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startDateTime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, startDateTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endDateTime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, endDateTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < devices_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(devices_.get(i));
      }
      size += dataSize;
      if (!getDevicesList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }devicesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < campaigns_.size(); i++) {
        dataSize += computeStringSizeNoTag(campaigns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCampaignsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < advertisingChannelTypes_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(advertisingChannelTypes_.get(i));
      }
      size += dataSize;
      if (!getAdvertisingChannelTypesList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }advertisingChannelTypesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v17.resources.BiddingDataExclusion)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v17.resources.BiddingDataExclusion other = (com.google.ads.googleads.v17.resources.BiddingDataExclusion) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (getDataExclusionId()
        != other.getDataExclusionId()) return false;
    if (scope_ != other.scope_) return false;
    if (status_ != other.status_) return false;
    if (!getStartDateTime()
        .equals(other.getStartDateTime())) return false;
    if (!getEndDateTime()
        .equals(other.getEndDateTime())) return false;
    if (!getName()
        .equals(other.getName())) return false;
    if (!getDescription()
        .equals(other.getDescription())) return false;
    if (!devices_.equals(other.devices_)) return false;
    if (!getCampaignsList()
        .equals(other.getCampaignsList())) return false;
    if (!advertisingChannelTypes_.equals(other.advertisingChannelTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + DATA_EXCLUSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getDataExclusionId());
    hash = (37 * hash) + SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + scope_;
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + START_DATE_TIME_FIELD_NUMBER;
    hash = (53 * hash) + getStartDateTime().hashCode();
    hash = (37 * hash) + END_DATE_TIME_FIELD_NUMBER;
    hash = (53 * hash) + getEndDateTime().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getDevicesCount() > 0) {
      hash = (37 * hash) + DEVICES_FIELD_NUMBER;
      hash = (53 * hash) + devices_.hashCode();
    }
    if (getCampaignsCount() > 0) {
      hash = (37 * hash) + CAMPAIGNS_FIELD_NUMBER;
      hash = (53 * hash) + getCampaignsList().hashCode();
    }
    if (getAdvertisingChannelTypesCount() > 0) {
      hash = (37 * hash) + ADVERTISING_CHANNEL_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + advertisingChannelTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v17.resources.BiddingDataExclusion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents a bidding data exclusion.
   *
   * See "About data exclusions" at
   * https://support.google.com/google-ads/answer/10370710.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v17.resources.BiddingDataExclusion}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v17.resources.BiddingDataExclusion)
      com.google.ads.googleads.v17.resources.BiddingDataExclusionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v17.resources.BiddingDataExclusionProto.internal_static_google_ads_googleads_v17_resources_BiddingDataExclusion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v17.resources.BiddingDataExclusionProto.internal_static_google_ads_googleads_v17_resources_BiddingDataExclusion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v17.resources.BiddingDataExclusion.class, com.google.ads.googleads.v17.resources.BiddingDataExclusion.Builder.class);
    }

    // Construct using com.google.ads.googleads.v17.resources.BiddingDataExclusion.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      dataExclusionId_ = 0L;
      scope_ = 0;
      status_ = 0;
      startDateTime_ = "";
      endDateTime_ = "";
      name_ = "";
      description_ = "";
      devices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      campaigns_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      advertisingChannelTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v17.resources.BiddingDataExclusionProto.internal_static_google_ads_googleads_v17_resources_BiddingDataExclusion_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.BiddingDataExclusion getDefaultInstanceForType() {
      return com.google.ads.googleads.v17.resources.BiddingDataExclusion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.BiddingDataExclusion build() {
      com.google.ads.googleads.v17.resources.BiddingDataExclusion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.BiddingDataExclusion buildPartial() {
      com.google.ads.googleads.v17.resources.BiddingDataExclusion result = new com.google.ads.googleads.v17.resources.BiddingDataExclusion(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v17.resources.BiddingDataExclusion result) {
      if (((bitField0_ & 0x00000100) != 0)) {
        devices_ = java.util.Collections.unmodifiableList(devices_);
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.devices_ = devices_;
      if (((bitField0_ & 0x00000400) != 0)) {
        advertisingChannelTypes_ = java.util.Collections.unmodifiableList(advertisingChannelTypes_);
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.advertisingChannelTypes_ = advertisingChannelTypes_;
    }

    private void buildPartial0(com.google.ads.googleads.v17.resources.BiddingDataExclusion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataExclusionId_ = dataExclusionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.scope_ = scope_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.startDateTime_ = startDateTime_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endDateTime_ = endDateTime_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        campaigns_.makeImmutable();
        result.campaigns_ = campaigns_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v17.resources.BiddingDataExclusion) {
        return mergeFrom((com.google.ads.googleads.v17.resources.BiddingDataExclusion)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v17.resources.BiddingDataExclusion other) {
      if (other == com.google.ads.googleads.v17.resources.BiddingDataExclusion.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getDataExclusionId() != 0L) {
        setDataExclusionId(other.getDataExclusionId());
      }
      if (other.scope_ != 0) {
        setScopeValue(other.getScopeValue());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getStartDateTime().isEmpty()) {
        startDateTime_ = other.startDateTime_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getEndDateTime().isEmpty()) {
        endDateTime_ = other.endDateTime_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.devices_.isEmpty()) {
        if (devices_.isEmpty()) {
          devices_ = other.devices_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureDevicesIsMutable();
          devices_.addAll(other.devices_);
        }
        onChanged();
      }
      if (!other.campaigns_.isEmpty()) {
        if (campaigns_.isEmpty()) {
          campaigns_ = other.campaigns_;
          bitField0_ |= 0x00000200;
        } else {
          ensureCampaignsIsMutable();
          campaigns_.addAll(other.campaigns_);
        }
        onChanged();
      }
      if (!other.advertisingChannelTypes_.isEmpty()) {
        if (advertisingChannelTypes_.isEmpty()) {
          advertisingChannelTypes_ = other.advertisingChannelTypes_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureAdvertisingChannelTypesIsMutable();
          advertisingChannelTypes_.addAll(other.advertisingChannelTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              dataExclusionId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              scope_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 32: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 42: {
              startDateTime_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            case 50: {
              endDateTime_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000020;
              break;
            } // case 50
            case 58: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000040;
              break;
            } // case 58
            case 66: {
              description_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 66
            case 72: {
              int tmpRaw = input.readEnum();
              ensureDevicesIsMutable();
              devices_.add(tmpRaw);
              break;
            } // case 72
            case 74: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int tmpRaw = input.readEnum();
                ensureDevicesIsMutable();
                devices_.add(tmpRaw);
              }
              input.popLimit(oldLimit);
              break;
            } // case 74
            case 82: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureCampaignsIsMutable();
              campaigns_.add(s);
              break;
            } // case 82
            case 88: {
              int tmpRaw = input.readEnum();
              ensureAdvertisingChannelTypesIsMutable();
              advertisingChannelTypes_.add(tmpRaw);
              break;
            } // case 88
            case 90: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int tmpRaw = input.readEnum();
                ensureAdvertisingChannelTypesIsMutable();
                advertisingChannelTypes_.add(tmpRaw);
              }
              input.popLimit(oldLimit);
              break;
            } // case 90
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the data exclusion.
     * Data exclusion resource names have the form:
     *
     * `customers/{customer_id}/biddingDataExclusions/{data_exclusion_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the data exclusion.
     * Data exclusion resource names have the form:
     *
     * `customers/{customer_id}/biddingDataExclusions/{data_exclusion_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the data exclusion.
     * Data exclusion resource names have the form:
     *
     * `customers/{customer_id}/biddingDataExclusions/{data_exclusion_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the data exclusion.
     * Data exclusion resource names have the form:
     *
     * `customers/{customer_id}/biddingDataExclusions/{data_exclusion_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the data exclusion.
     * Data exclusion resource names have the form:
     *
     * `customers/{customer_id}/biddingDataExclusions/{data_exclusion_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long dataExclusionId_ ;
    /**
     * <pre>
     * Output only. The ID of the data exclusion.
     * </pre>
     *
     * <code>int64 data_exclusion_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The dataExclusionId.
     */
    @java.lang.Override
    public long getDataExclusionId() {
      return dataExclusionId_;
    }
    /**
     * <pre>
     * Output only. The ID of the data exclusion.
     * </pre>
     *
     * <code>int64 data_exclusion_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The dataExclusionId to set.
     * @return This builder for chaining.
     */
    public Builder setDataExclusionId(long value) {

      dataExclusionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the data exclusion.
     * </pre>
     *
     * <code>int64 data_exclusion_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearDataExclusionId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dataExclusionId_ = 0L;
      onChanged();
      return this;
    }

    private int scope_ = 0;
    /**
     * <pre>
     * The scope of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope scope = 3;</code>
     * @return The enum numeric value on the wire for scope.
     */
    @java.lang.Override public int getScopeValue() {
      return scope_;
    }
    /**
     * <pre>
     * The scope of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope scope = 3;</code>
     * @param value The enum numeric value on the wire for scope to set.
     * @return This builder for chaining.
     */
    public Builder setScopeValue(int value) {
      scope_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The scope of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope scope = 3;</code>
     * @return The scope.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope getScope() {
      com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope result = com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope.forNumber(scope_);
      return result == null ? com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The scope of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope scope = 3;</code>
     * @param value The scope to set.
     * @return This builder for chaining.
     */
    public Builder setScope(com.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      scope_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The scope of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventScopeEnum.SeasonalityEventScope scope = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearScope() {
      bitField0_ = (bitField0_ & ~0x00000004);
      scope_ = 0;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Output only. The status of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Output only. The status of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus getStatus() {
      com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus result = com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The status of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of the data exclusion.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SeasonalityEventStatusEnum.SeasonalityEventStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object startDateTime_ = "";
    /**
     * <pre>
     * Required. The inclusive start time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * A data exclusion is backward looking and should be used for events that
     * start in the past and end either in the past or future.
     * </pre>
     *
     * <code>string start_date_time = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The startDateTime.
     */
    public java.lang.String getStartDateTime() {
      java.lang.Object ref = startDateTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startDateTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Required. The inclusive start time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * A data exclusion is backward looking and should be used for events that
     * start in the past and end either in the past or future.
     * </pre>
     *
     * <code>string start_date_time = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The bytes for startDateTime.
     */
    public com.google.protobuf.ByteString
        getStartDateTimeBytes() {
      java.lang.Object ref = startDateTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startDateTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Required. The inclusive start time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * A data exclusion is backward looking and should be used for events that
     * start in the past and end either in the past or future.
     * </pre>
     *
     * <code>string start_date_time = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The startDateTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartDateTime(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      startDateTime_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The inclusive start time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * A data exclusion is backward looking and should be used for events that
     * start in the past and end either in the past or future.
     * </pre>
     *
     * <code>string start_date_time = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return This builder for chaining.
     */
    public Builder clearStartDateTime() {
      startDateTime_ = getDefaultInstance().getStartDateTime();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The inclusive start time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * A data exclusion is backward looking and should be used for events that
     * start in the past and end either in the past or future.
     * </pre>
     *
     * <code>string start_date_time = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The bytes for startDateTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartDateTimeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      startDateTime_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object endDateTime_ = "";
    /**
     * <pre>
     * Required. The exclusive end time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * The length of [start_date_time, end_date_time) interval must be
     * within (0, 14 days].
     * </pre>
     *
     * <code>string end_date_time = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The endDateTime.
     */
    public java.lang.String getEndDateTime() {
      java.lang.Object ref = endDateTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endDateTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Required. The exclusive end time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * The length of [start_date_time, end_date_time) interval must be
     * within (0, 14 days].
     * </pre>
     *
     * <code>string end_date_time = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The bytes for endDateTime.
     */
    public com.google.protobuf.ByteString
        getEndDateTimeBytes() {
      java.lang.Object ref = endDateTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        endDateTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Required. The exclusive end time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * The length of [start_date_time, end_date_time) interval must be
     * within (0, 14 days].
     * </pre>
     *
     * <code>string end_date_time = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The endDateTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndDateTime(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      endDateTime_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The exclusive end time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * The length of [start_date_time, end_date_time) interval must be
     * within (0, 14 days].
     * </pre>
     *
     * <code>string end_date_time = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return This builder for chaining.
     */
    public Builder clearEndDateTime() {
      endDateTime_ = getDefaultInstance().getEndDateTime();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The exclusive end time of the data exclusion in yyyy-MM-dd
     * HH:mm:ss format.
     *
     * The length of [start_date_time, end_date_time) interval must be
     * within (0, 14 days].
     * </pre>
     *
     * <code>string end_date_time = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The bytes for endDateTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndDateTimeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      endDateTime_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The name of the data exclusion. The name can be at most 255
     * characters.
     * </pre>
     *
     * <code>string name = 7;</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the data exclusion. The name can be at most 255
     * characters.
     * </pre>
     *
     * <code>string name = 7;</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the data exclusion. The name can be at most 255
     * characters.
     * </pre>
     *
     * <code>string name = 7;</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the data exclusion. The name can be at most 255
     * characters.
     * </pre>
     *
     * <code>string name = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the data exclusion. The name can be at most 255
     * characters.
     * </pre>
     *
     * <code>string name = 7;</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * The description of the data exclusion. The description can be at
     * most 2048 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The description of the data exclusion. The description can be at
     * most 2048 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The description of the data exclusion. The description can be at
     * most 2048 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The description of the data exclusion. The description can be at
     * most 2048 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The description of the data exclusion. The description can be at
     * most 2048 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> devices_ =
      java.util.Collections.emptyList();
    private void ensureDevicesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        devices_ = new java.util.ArrayList<java.lang.Integer>(devices_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @return A list containing the devices.
     */
    public java.util.List<com.google.ads.googleads.v17.enums.DeviceEnum.Device> getDevicesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.ads.googleads.v17.enums.DeviceEnum.Device>(devices_, devices_converter_);
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @return The count of devices.
     */
    public int getDevicesCount() {
      return devices_.size();
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param index The index of the element to return.
     * @return The devices at the given index.
     */
    public com.google.ads.googleads.v17.enums.DeviceEnum.Device getDevices(int index) {
      return devices_converter_.convert(devices_.get(index));
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param index The index to set the value at.
     * @param value The devices to set.
     * @return This builder for chaining.
     */
    public Builder setDevices(
        int index, com.google.ads.googleads.v17.enums.DeviceEnum.Device value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDevicesIsMutable();
      devices_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param value The devices to add.
     * @return This builder for chaining.
     */
    public Builder addDevices(com.google.ads.googleads.v17.enums.DeviceEnum.Device value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDevicesIsMutable();
      devices_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param values The devices to add.
     * @return This builder for chaining.
     */
    public Builder addAllDevices(
        java.lang.Iterable<? extends com.google.ads.googleads.v17.enums.DeviceEnum.Device> values) {
      ensureDevicesIsMutable();
      for (com.google.ads.googleads.v17.enums.DeviceEnum.Device value : values) {
        devices_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @return This builder for chaining.
     */
    public Builder clearDevices() {
      devices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @return A list containing the enum numeric values on the wire for devices.
     */
    public java.util.List<java.lang.Integer>
    getDevicesValueList() {
      return java.util.Collections.unmodifiableList(devices_);
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of devices at the given index.
     */
    public int getDevicesValue(int index) {
      return devices_.get(index);
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for devices to set.
     * @return This builder for chaining.
     */
    public Builder setDevicesValue(
        int index, int value) {
      ensureDevicesIsMutable();
      devices_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param value The enum numeric value on the wire for devices to add.
     * @return This builder for chaining.
     */
    public Builder addDevicesValue(int value) {
      ensureDevicesIsMutable();
      devices_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If not specified, all devices will be included in this exclusion.
     * Otherwise, only the specified targeted devices will be included in this
     * exclusion.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.DeviceEnum.Device devices = 9;</code>
     * @param values The enum numeric values on the wire for devices to add.
     * @return This builder for chaining.
     */
    public Builder addAllDevicesValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureDevicesIsMutable();
      for (int value : values) {
        devices_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList campaigns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureCampaignsIsMutable() {
      if (!campaigns_.isModifiable()) {
        campaigns_ = new com.google.protobuf.LazyStringArrayList(campaigns_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @return A list containing the campaigns.
     */
    public com.google.protobuf.ProtocolStringList
        getCampaignsList() {
      campaigns_.makeImmutable();
      return campaigns_;
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @return The count of campaigns.
     */
    public int getCampaignsCount() {
      return campaigns_.size();
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @param index The index of the element to return.
     * @return The campaigns at the given index.
     */
    public java.lang.String getCampaigns(int index) {
      return campaigns_.get(index);
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @param index The index of the value to return.
     * @return The bytes of the campaigns at the given index.
     */
    public com.google.protobuf.ByteString
        getCampaignsBytes(int index) {
      return campaigns_.getByteString(index);
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @param index The index to set the value at.
     * @param value The campaigns to set.
     * @return This builder for chaining.
     */
    public Builder setCampaigns(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureCampaignsIsMutable();
      campaigns_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @param value The campaigns to add.
     * @return This builder for chaining.
     */
    public Builder addCampaigns(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureCampaignsIsMutable();
      campaigns_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @param values The campaigns to add.
     * @return This builder for chaining.
     */
    public Builder addAllCampaigns(
        java.lang.Iterable<java.lang.String> values) {
      ensureCampaignsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, campaigns_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCampaigns() {
      campaigns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data exclusion will apply to the campaigns listed when the scope of
     * this exclusion is CAMPAIGN. The maximum number of campaigns per event is
     * 2000.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated string campaigns = 10 [(.google.api.resource_reference) = { ... }</code>
     * @param value The bytes of the campaigns to add.
     * @return This builder for chaining.
     */
    public Builder addCampaignsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureCampaignsIsMutable();
      campaigns_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> advertisingChannelTypes_ =
      java.util.Collections.emptyList();
    private void ensureAdvertisingChannelTypesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        advertisingChannelTypes_ = new java.util.ArrayList<java.lang.Integer>(advertisingChannelTypes_);
        bitField0_ |= 0x00000400;
      }
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @return A list containing the advertisingChannelTypes.
     */
    public java.util.List<com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType> getAdvertisingChannelTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType>(advertisingChannelTypes_, advertisingChannelTypes_converter_);
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @return The count of advertisingChannelTypes.
     */
    public int getAdvertisingChannelTypesCount() {
      return advertisingChannelTypes_.size();
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param index The index of the element to return.
     * @return The advertisingChannelTypes at the given index.
     */
    public com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelTypes(int index) {
      return advertisingChannelTypes_converter_.convert(advertisingChannelTypes_.get(index));
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param index The index to set the value at.
     * @param value The advertisingChannelTypes to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertisingChannelTypes(
        int index, com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvertisingChannelTypesIsMutable();
      advertisingChannelTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param value The advertisingChannelTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAdvertisingChannelTypes(com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvertisingChannelTypesIsMutable();
      advertisingChannelTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param values The advertisingChannelTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvertisingChannelTypes(
        java.lang.Iterable<? extends com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType> values) {
      ensureAdvertisingChannelTypesIsMutable();
      for (com.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType value : values) {
        advertisingChannelTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearAdvertisingChannelTypes() {
      advertisingChannelTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @return A list containing the enum numeric values on the wire for advertisingChannelTypes.
     */
    public java.util.List<java.lang.Integer>
    getAdvertisingChannelTypesValueList() {
      return java.util.Collections.unmodifiableList(advertisingChannelTypes_);
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of advertisingChannelTypes at the given index.
     */
    public int getAdvertisingChannelTypesValue(int index) {
      return advertisingChannelTypes_.get(index);
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for advertisingChannelTypes to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertisingChannelTypesValue(
        int index, int value) {
      ensureAdvertisingChannelTypesIsMutable();
      advertisingChannelTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param value The enum numeric value on the wire for advertisingChannelTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAdvertisingChannelTypesValue(int value) {
      ensureAdvertisingChannelTypesIsMutable();
      advertisingChannelTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data_exclusion will apply to all the campaigns under the listed
     * channels retroactively as well as going forward when the scope of this
     * exclusion is CHANNEL.
     * The supported advertising channel types are DISPLAY, SEARCH and SHOPPING.
     * Note: a data exclusion with both advertising_channel_types and
     * campaign_ids is not supported.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_types = 11;</code>
     * @param values The enum numeric values on the wire for advertisingChannelTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvertisingChannelTypesValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureAdvertisingChannelTypesIsMutable();
      for (int value : values) {
        advertisingChannelTypes_.add(value);
      }
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v17.resources.BiddingDataExclusion)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v17.resources.BiddingDataExclusion)
  private static final com.google.ads.googleads.v17.resources.BiddingDataExclusion DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v17.resources.BiddingDataExclusion();
  }

  public static com.google.ads.googleads.v17.resources.BiddingDataExclusion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BiddingDataExclusion>
      PARSER = new com.google.protobuf.AbstractParser<BiddingDataExclusion>() {
    @java.lang.Override
    public BiddingDataExclusion parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<BiddingDataExclusion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BiddingDataExclusion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v17.resources.BiddingDataExclusion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

