// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v17/resources/campaign_simulation.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v17.resources;

/**
 * <pre>
 * A campaign simulation. Supported combinations of advertising
 * channel type, simulation type and simulation modification
 * method is detailed below respectively.
 *
 * * SEARCH - CPC_BID - UNIFORM
 * * SEARCH - CPC_BID - SCALING
 * * SEARCH - TARGET_CPA - UNIFORM
 * * SEARCH - TARGET_CPA - SCALING
 * * SEARCH - TARGET_ROAS - UNIFORM
 * * SEARCH - TARGET_IMPRESSION_SHARE - UNIFORM
 * * SEARCH - BUDGET - UNIFORM
 * * SHOPPING - BUDGET - UNIFORM
 * * SHOPPING - TARGET_ROAS - UNIFORM
 * * MULTI_CHANNEL - TARGET_CPA - UNIFORM
 * * MULTI_CHANNEL - TARGET_ROAS - UNIFORM
 * * DISCOVERY - TARGET_CPA - DEFAULT
 * * DISPLAY - TARGET_CPA - UNIFORM
 * * PERFORMANCE_MAX - TARGET_CPA - UNIFORM
 * * PERFORMANCE_MAX - TARGET_ROAS - UNIFORM
 * * PERFORMANCE_MAX - BUDGET - UNIFORM
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v17.resources.CampaignSimulation}
 */
public final class CampaignSimulation extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v17.resources.CampaignSimulation)
    CampaignSimulationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CampaignSimulation.newBuilder() to construct.
  private CampaignSimulation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CampaignSimulation() {
    resourceName_ = "";
    type_ = 0;
    modificationMethod_ = 0;
    startDate_ = "";
    endDate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new CampaignSimulation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v17.resources.CampaignSimulationProto.internal_static_google_ads_googleads_v17_resources_CampaignSimulation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v17.resources.CampaignSimulationProto.internal_static_google_ads_googleads_v17_resources_CampaignSimulation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v17.resources.CampaignSimulation.class, com.google.ads.googleads.v17.resources.CampaignSimulation.Builder.class);
  }

  private int pointListCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object pointList_;
  public enum PointListCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CPC_BID_POINT_LIST(7),
    TARGET_CPA_POINT_LIST(8),
    TARGET_ROAS_POINT_LIST(9),
    TARGET_IMPRESSION_SHARE_POINT_LIST(10),
    BUDGET_POINT_LIST(11),
    POINTLIST_NOT_SET(0);
    private final int value;
    private PointListCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PointListCase valueOf(int value) {
      return forNumber(value);
    }

    public static PointListCase forNumber(int value) {
      switch (value) {
        case 7: return CPC_BID_POINT_LIST;
        case 8: return TARGET_CPA_POINT_LIST;
        case 9: return TARGET_ROAS_POINT_LIST;
        case 10: return TARGET_IMPRESSION_SHARE_POINT_LIST;
        case 11: return BUDGET_POINT_LIST;
        case 0: return POINTLIST_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public PointListCase
  getPointListCase() {
    return PointListCase.forNumber(
        pointListCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Output only. The resource name of the campaign simulation.
   * Campaign simulation resource names have the form:
   *
   * `customers/{customer_id}/campaignSimulations/{campaign_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the campaign simulation.
   * Campaign simulation resource names have the form:
   *
   * `customers/{customer_id}/campaignSimulations/{campaign_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CAMPAIGN_ID_FIELD_NUMBER = 2;
  private long campaignId_ = 0L;
  /**
   * <pre>
   * Output only. Campaign id of the simulation.
   * </pre>
   *
   * <code>int64 campaign_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The campaignId.
   */
  @java.lang.Override
  public long getCampaignId() {
    return campaignId_;
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType getType() {
    com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
  }

  public static final int MODIFICATION_METHOD_FIELD_NUMBER = 4;
  private int modificationMethod_ = 0;
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for modificationMethod.
   */
  @java.lang.Override public int getModificationMethodValue() {
    return modificationMethod_;
  }
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The modificationMethod.
   */
  @java.lang.Override public com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
    com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod.forNumber(modificationMethod_);
    return result == null ? com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
  }

  public static final int START_DATE_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object startDate_ = "";
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The startDate.
   */
  @java.lang.Override
  public java.lang.String getStartDate() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for startDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getStartDateBytes() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      startDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_DATE_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private volatile java.lang.Object endDate_ = "";
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD
   * format
   * </pre>
   *
   * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The endDate.
   */
  @java.lang.Override
  public java.lang.String getEndDate() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD
   * format
   * </pre>
   *
   * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for endDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getEndDateBytes() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      endDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CPC_BID_POINT_LIST_FIELD_NUMBER = 7;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the cpcBidPointList field is set.
   */
  @java.lang.Override
  public boolean hasCpcBidPointList() {
    return pointListCase_ == 7;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The cpcBidPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.CpcBidSimulationPointList getCpcBidPointList() {
    if (pointListCase_ == 7) {
       return (com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.CpcBidSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.CpcBidSimulationPointListOrBuilder getCpcBidPointListOrBuilder() {
    if (pointListCase_ == 7) {
       return (com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.CpcBidSimulationPointList.getDefaultInstance();
  }

  public static final int TARGET_CPA_POINT_LIST_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the targetCpaPointList field is set.
   */
  @java.lang.Override
  public boolean hasTargetCpaPointList() {
    return pointListCase_ == 8;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The targetCpaPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.TargetCpaSimulationPointList getTargetCpaPointList() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.TargetCpaSimulationPointListOrBuilder getTargetCpaPointListOrBuilder() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.getDefaultInstance();
  }

  public static final int TARGET_ROAS_POINT_LIST_FIELD_NUMBER = 9;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the targetRoasPointList field is set.
   */
  @java.lang.Override
  public boolean hasTargetRoasPointList() {
    return pointListCase_ == 9;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The targetRoasPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.TargetRoasSimulationPointList getTargetRoasPointList() {
    if (pointListCase_ == 9) {
       return (com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.TargetRoasSimulationPointListOrBuilder getTargetRoasPointListOrBuilder() {
    if (pointListCase_ == 9) {
       return (com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.getDefaultInstance();
  }

  public static final int TARGET_IMPRESSION_SHARE_POINT_LIST_FIELD_NUMBER = 10;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is
   * TARGET_IMPRESSION_SHARE.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the targetImpressionSharePointList field is set.
   */
  @java.lang.Override
  public boolean hasTargetImpressionSharePointList() {
    return pointListCase_ == 10;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is
   * TARGET_IMPRESSION_SHARE.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The targetImpressionSharePointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList getTargetImpressionSharePointList() {
    if (pointListCase_ == 10) {
       return (com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is
   * TARGET_IMPRESSION_SHARE.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointListOrBuilder getTargetImpressionSharePointListOrBuilder() {
    if (pointListCase_ == 10) {
       return (com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.getDefaultInstance();
  }

  public static final int BUDGET_POINT_LIST_FIELD_NUMBER = 11;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is BUDGET.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the budgetPointList field is set.
   */
  @java.lang.Override
  public boolean hasBudgetPointList() {
    return pointListCase_ == 11;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is BUDGET.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The budgetPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.BudgetSimulationPointList getBudgetPointList() {
    if (pointListCase_ == 11) {
       return (com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.BudgetSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is BUDGET.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v17.common.BudgetSimulationPointListOrBuilder getBudgetPointListOrBuilder() {
    if (pointListCase_ == 11) {
       return (com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v17.common.BudgetSimulationPointList.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (campaignId_ != 0L) {
      output.writeInt64(2, campaignId_);
    }
    if (type_ != com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, modificationMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startDate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, startDate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endDate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, endDate_);
    }
    if (pointListCase_ == 7) {
      output.writeMessage(7, (com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_);
    }
    if (pointListCase_ == 8) {
      output.writeMessage(8, (com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_);
    }
    if (pointListCase_ == 9) {
      output.writeMessage(9, (com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_);
    }
    if (pointListCase_ == 10) {
      output.writeMessage(10, (com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_);
    }
    if (pointListCase_ == 11) {
      output.writeMessage(11, (com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (campaignId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, campaignId_);
    }
    if (type_ != com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, modificationMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startDate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, startDate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endDate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, endDate_);
    }
    if (pointListCase_ == 7) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, (com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_);
    }
    if (pointListCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_);
    }
    if (pointListCase_ == 9) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, (com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_);
    }
    if (pointListCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, (com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_);
    }
    if (pointListCase_ == 11) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, (com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v17.resources.CampaignSimulation)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v17.resources.CampaignSimulation other = (com.google.ads.googleads.v17.resources.CampaignSimulation) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (getCampaignId()
        != other.getCampaignId()) return false;
    if (type_ != other.type_) return false;
    if (modificationMethod_ != other.modificationMethod_) return false;
    if (!getStartDate()
        .equals(other.getStartDate())) return false;
    if (!getEndDate()
        .equals(other.getEndDate())) return false;
    if (!getPointListCase().equals(other.getPointListCase())) return false;
    switch (pointListCase_) {
      case 7:
        if (!getCpcBidPointList()
            .equals(other.getCpcBidPointList())) return false;
        break;
      case 8:
        if (!getTargetCpaPointList()
            .equals(other.getTargetCpaPointList())) return false;
        break;
      case 9:
        if (!getTargetRoasPointList()
            .equals(other.getTargetRoasPointList())) return false;
        break;
      case 10:
        if (!getTargetImpressionSharePointList()
            .equals(other.getTargetImpressionSharePointList())) return false;
        break;
      case 11:
        if (!getBudgetPointList()
            .equals(other.getBudgetPointList())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + CAMPAIGN_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getCampaignId());
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + MODIFICATION_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + modificationMethod_;
    hash = (37 * hash) + START_DATE_FIELD_NUMBER;
    hash = (53 * hash) + getStartDate().hashCode();
    hash = (37 * hash) + END_DATE_FIELD_NUMBER;
    hash = (53 * hash) + getEndDate().hashCode();
    switch (pointListCase_) {
      case 7:
        hash = (37 * hash) + CPC_BID_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getCpcBidPointList().hashCode();
        break;
      case 8:
        hash = (37 * hash) + TARGET_CPA_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getTargetCpaPointList().hashCode();
        break;
      case 9:
        hash = (37 * hash) + TARGET_ROAS_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getTargetRoasPointList().hashCode();
        break;
      case 10:
        hash = (37 * hash) + TARGET_IMPRESSION_SHARE_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getTargetImpressionSharePointList().hashCode();
        break;
      case 11:
        hash = (37 * hash) + BUDGET_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getBudgetPointList().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.CampaignSimulation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v17.resources.CampaignSimulation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A campaign simulation. Supported combinations of advertising
   * channel type, simulation type and simulation modification
   * method is detailed below respectively.
   *
   * * SEARCH - CPC_BID - UNIFORM
   * * SEARCH - CPC_BID - SCALING
   * * SEARCH - TARGET_CPA - UNIFORM
   * * SEARCH - TARGET_CPA - SCALING
   * * SEARCH - TARGET_ROAS - UNIFORM
   * * SEARCH - TARGET_IMPRESSION_SHARE - UNIFORM
   * * SEARCH - BUDGET - UNIFORM
   * * SHOPPING - BUDGET - UNIFORM
   * * SHOPPING - TARGET_ROAS - UNIFORM
   * * MULTI_CHANNEL - TARGET_CPA - UNIFORM
   * * MULTI_CHANNEL - TARGET_ROAS - UNIFORM
   * * DISCOVERY - TARGET_CPA - DEFAULT
   * * DISPLAY - TARGET_CPA - UNIFORM
   * * PERFORMANCE_MAX - TARGET_CPA - UNIFORM
   * * PERFORMANCE_MAX - TARGET_ROAS - UNIFORM
   * * PERFORMANCE_MAX - BUDGET - UNIFORM
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v17.resources.CampaignSimulation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v17.resources.CampaignSimulation)
      com.google.ads.googleads.v17.resources.CampaignSimulationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v17.resources.CampaignSimulationProto.internal_static_google_ads_googleads_v17_resources_CampaignSimulation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v17.resources.CampaignSimulationProto.internal_static_google_ads_googleads_v17_resources_CampaignSimulation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v17.resources.CampaignSimulation.class, com.google.ads.googleads.v17.resources.CampaignSimulation.Builder.class);
    }

    // Construct using com.google.ads.googleads.v17.resources.CampaignSimulation.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      campaignId_ = 0L;
      type_ = 0;
      modificationMethod_ = 0;
      startDate_ = "";
      endDate_ = "";
      if (cpcBidPointListBuilder_ != null) {
        cpcBidPointListBuilder_.clear();
      }
      if (targetCpaPointListBuilder_ != null) {
        targetCpaPointListBuilder_.clear();
      }
      if (targetRoasPointListBuilder_ != null) {
        targetRoasPointListBuilder_.clear();
      }
      if (targetImpressionSharePointListBuilder_ != null) {
        targetImpressionSharePointListBuilder_.clear();
      }
      if (budgetPointListBuilder_ != null) {
        budgetPointListBuilder_.clear();
      }
      pointListCase_ = 0;
      pointList_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v17.resources.CampaignSimulationProto.internal_static_google_ads_googleads_v17_resources_CampaignSimulation_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.CampaignSimulation getDefaultInstanceForType() {
      return com.google.ads.googleads.v17.resources.CampaignSimulation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.CampaignSimulation build() {
      com.google.ads.googleads.v17.resources.CampaignSimulation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.CampaignSimulation buildPartial() {
      com.google.ads.googleads.v17.resources.CampaignSimulation result = new com.google.ads.googleads.v17.resources.CampaignSimulation(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v17.resources.CampaignSimulation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.campaignId_ = campaignId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modificationMethod_ = modificationMethod_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.startDate_ = startDate_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endDate_ = endDate_;
      }
    }

    private void buildPartialOneofs(com.google.ads.googleads.v17.resources.CampaignSimulation result) {
      result.pointListCase_ = pointListCase_;
      result.pointList_ = this.pointList_;
      if (pointListCase_ == 7 &&
          cpcBidPointListBuilder_ != null) {
        result.pointList_ = cpcBidPointListBuilder_.build();
      }
      if (pointListCase_ == 8 &&
          targetCpaPointListBuilder_ != null) {
        result.pointList_ = targetCpaPointListBuilder_.build();
      }
      if (pointListCase_ == 9 &&
          targetRoasPointListBuilder_ != null) {
        result.pointList_ = targetRoasPointListBuilder_.build();
      }
      if (pointListCase_ == 10 &&
          targetImpressionSharePointListBuilder_ != null) {
        result.pointList_ = targetImpressionSharePointListBuilder_.build();
      }
      if (pointListCase_ == 11 &&
          budgetPointListBuilder_ != null) {
        result.pointList_ = budgetPointListBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v17.resources.CampaignSimulation) {
        return mergeFrom((com.google.ads.googleads.v17.resources.CampaignSimulation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v17.resources.CampaignSimulation other) {
      if (other == com.google.ads.googleads.v17.resources.CampaignSimulation.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getCampaignId() != 0L) {
        setCampaignId(other.getCampaignId());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.modificationMethod_ != 0) {
        setModificationMethodValue(other.getModificationMethodValue());
      }
      if (!other.getStartDate().isEmpty()) {
        startDate_ = other.startDate_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getEndDate().isEmpty()) {
        endDate_ = other.endDate_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getPointListCase()) {
        case CPC_BID_POINT_LIST: {
          mergeCpcBidPointList(other.getCpcBidPointList());
          break;
        }
        case TARGET_CPA_POINT_LIST: {
          mergeTargetCpaPointList(other.getTargetCpaPointList());
          break;
        }
        case TARGET_ROAS_POINT_LIST: {
          mergeTargetRoasPointList(other.getTargetRoasPointList());
          break;
        }
        case TARGET_IMPRESSION_SHARE_POINT_LIST: {
          mergeTargetImpressionSharePointList(other.getTargetImpressionSharePointList());
          break;
        }
        case BUDGET_POINT_LIST: {
          mergeBudgetPointList(other.getBudgetPointList());
          break;
        }
        case POINTLIST_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              campaignId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 32: {
              modificationMethod_ = input.readEnum();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 42: {
              startDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            case 50: {
              endDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000020;
              break;
            } // case 50
            case 58: {
              input.readMessage(
                  getCpcBidPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 7;
              break;
            } // case 58
            case 66: {
              input.readMessage(
                  getTargetCpaPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 8;
              break;
            } // case 66
            case 74: {
              input.readMessage(
                  getTargetRoasPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 9;
              break;
            } // case 74
            case 82: {
              input.readMessage(
                  getTargetImpressionSharePointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 10;
              break;
            } // case 82
            case 90: {
              input.readMessage(
                  getBudgetPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 11;
              break;
            } // case 90
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int pointListCase_ = 0;
    private java.lang.Object pointList_;
    public PointListCase
        getPointListCase() {
      return PointListCase.forNumber(
          pointListCase_);
    }

    public Builder clearPointList() {
      pointListCase_ = 0;
      pointList_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the campaign simulation.
     * Campaign simulation resource names have the form:
     *
     * `customers/{customer_id}/campaignSimulations/{campaign_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the campaign simulation.
     * Campaign simulation resource names have the form:
     *
     * `customers/{customer_id}/campaignSimulations/{campaign_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the campaign simulation.
     * Campaign simulation resource names have the form:
     *
     * `customers/{customer_id}/campaignSimulations/{campaign_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the campaign simulation.
     * Campaign simulation resource names have the form:
     *
     * `customers/{customer_id}/campaignSimulations/{campaign_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the campaign simulation.
     * Campaign simulation resource names have the form:
     *
     * `customers/{customer_id}/campaignSimulations/{campaign_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long campaignId_ ;
    /**
     * <pre>
     * Output only. Campaign id of the simulation.
     * </pre>
     *
     * <code>int64 campaign_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The campaignId.
     */
    @java.lang.Override
    public long getCampaignId() {
      return campaignId_;
    }
    /**
     * <pre>
     * Output only. Campaign id of the simulation.
     * </pre>
     *
     * <code>int64 campaign_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The campaignId to set.
     * @return This builder for chaining.
     */
    public Builder setCampaignId(long value) {

      campaignId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Campaign id of the simulation.
     * </pre>
     *
     * <code>int64 campaign_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCampaignId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      campaignId_ = 0L;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType getType() {
      com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private int modificationMethod_ = 0;
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for modificationMethod.
     */
    @java.lang.Override public int getModificationMethodValue() {
      return modificationMethod_;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethodValue(int value) {
      modificationMethod_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The modificationMethod.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
      com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod.forNumber(modificationMethod_);
      return result == null ? com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethod(com.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      modificationMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearModificationMethod() {
      bitField0_ = (bitField0_ & ~0x00000008);
      modificationMethod_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object startDate_ = "";
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The startDate.
     */
    public java.lang.String getStartDate() {
      java.lang.Object ref = startDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for startDate.
     */
    public com.google.protobuf.ByteString
        getStartDateBytes() {
      java.lang.Object ref = startDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      startDate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStartDate() {
      startDate_ = getDefaultInstance().getStartDate();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>string start_date = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      startDate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object endDate_ = "";
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endDate.
     */
    public java.lang.String getEndDate() {
      java.lang.Object ref = endDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for endDate.
     */
    public com.google.protobuf.ByteString
        getEndDateBytes() {
      java.lang.Object ref = endDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        endDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      endDate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearEndDate() {
      endDate_ = getDefaultInstance().getEndDate();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format
     * </pre>
     *
     * <code>string end_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      endDate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.CpcBidSimulationPointList, com.google.ads.googleads.v17.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v17.common.CpcBidSimulationPointListOrBuilder> cpcBidPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the cpcBidPointList field is set.
     */
    @java.lang.Override
    public boolean hasCpcBidPointList() {
      return pointListCase_ == 7;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The cpcBidPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.CpcBidSimulationPointList getCpcBidPointList() {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 7) {
          return (com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.CpcBidSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 7) {
          return cpcBidPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v17.common.CpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpcBidPointList(com.google.ads.googleads.v17.common.CpcBidSimulationPointList value) {
      if (cpcBidPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        cpcBidPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpcBidPointList(
        com.google.ads.googleads.v17.common.CpcBidSimulationPointList.Builder builderForValue) {
      if (cpcBidPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        cpcBidPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeCpcBidPointList(com.google.ads.googleads.v17.common.CpcBidSimulationPointList value) {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 7 &&
            pointList_ != com.google.ads.googleads.v17.common.CpcBidSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v17.common.CpcBidSimulationPointList.newBuilder((com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 7) {
          cpcBidPointListBuilder_.mergeFrom(value);
        } else {
          cpcBidPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearCpcBidPointList() {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 7) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 7) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        cpcBidPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v17.common.CpcBidSimulationPointList.Builder getCpcBidPointListBuilder() {
      return getCpcBidPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.CpcBidSimulationPointListOrBuilder getCpcBidPointListOrBuilder() {
      if ((pointListCase_ == 7) && (cpcBidPointListBuilder_ != null)) {
        return cpcBidPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 7) {
          return (com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.CpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.CpcBidSimulationPointList cpc_bid_point_list = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.CpcBidSimulationPointList, com.google.ads.googleads.v17.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v17.common.CpcBidSimulationPointListOrBuilder> 
        getCpcBidPointListFieldBuilder() {
      if (cpcBidPointListBuilder_ == null) {
        if (!(pointListCase_ == 7)) {
          pointList_ = com.google.ads.googleads.v17.common.CpcBidSimulationPointList.getDefaultInstance();
        }
        cpcBidPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v17.common.CpcBidSimulationPointList, com.google.ads.googleads.v17.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v17.common.CpcBidSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v17.common.CpcBidSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 7;
      onChanged();
      return cpcBidPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.TargetCpaSimulationPointList, com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetCpaSimulationPointListOrBuilder> targetCpaPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the targetCpaPointList field is set.
     */
    @java.lang.Override
    public boolean hasTargetCpaPointList() {
      return pointListCase_ == 8;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The targetCpaPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.TargetCpaSimulationPointList getTargetCpaPointList() {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 8) {
          return targetCpaPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetCpaPointList(com.google.ads.googleads.v17.common.TargetCpaSimulationPointList value) {
      if (targetCpaPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        targetCpaPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetCpaPointList(
        com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.Builder builderForValue) {
      if (targetCpaPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        targetCpaPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTargetCpaPointList(com.google.ads.googleads.v17.common.TargetCpaSimulationPointList value) {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 8 &&
            pointList_ != com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.newBuilder((com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 8) {
          targetCpaPointListBuilder_.mergeFrom(value);
        } else {
          targetCpaPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTargetCpaPointList() {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        targetCpaPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.Builder getTargetCpaPointListBuilder() {
      return getTargetCpaPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.TargetCpaSimulationPointListOrBuilder getTargetCpaPointListOrBuilder() {
      if ((pointListCase_ == 8) && (targetCpaPointListBuilder_ != null)) {
        return targetCpaPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetCpaSimulationPointList target_cpa_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.TargetCpaSimulationPointList, com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetCpaSimulationPointListOrBuilder> 
        getTargetCpaPointListFieldBuilder() {
      if (targetCpaPointListBuilder_ == null) {
        if (!(pointListCase_ == 8)) {
          pointList_ = com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.getDefaultInstance();
        }
        targetCpaPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v17.common.TargetCpaSimulationPointList, com.google.ads.googleads.v17.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetCpaSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v17.common.TargetCpaSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 8;
      onChanged();
      return targetCpaPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.TargetRoasSimulationPointList, com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetRoasSimulationPointListOrBuilder> targetRoasPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the targetRoasPointList field is set.
     */
    @java.lang.Override
    public boolean hasTargetRoasPointList() {
      return pointListCase_ == 9;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The targetRoasPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.TargetRoasSimulationPointList getTargetRoasPointList() {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 9) {
          return (com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 9) {
          return targetRoasPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetRoasPointList(com.google.ads.googleads.v17.common.TargetRoasSimulationPointList value) {
      if (targetRoasPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        targetRoasPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetRoasPointList(
        com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.Builder builderForValue) {
      if (targetRoasPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        targetRoasPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTargetRoasPointList(com.google.ads.googleads.v17.common.TargetRoasSimulationPointList value) {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 9 &&
            pointList_ != com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.newBuilder((com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 9) {
          targetRoasPointListBuilder_.mergeFrom(value);
        } else {
          targetRoasPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTargetRoasPointList() {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 9) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 9) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        targetRoasPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.Builder getTargetRoasPointListBuilder() {
      return getTargetRoasPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.TargetRoasSimulationPointListOrBuilder getTargetRoasPointListOrBuilder() {
      if ((pointListCase_ == 9) && (targetRoasPointListBuilder_ != null)) {
        return targetRoasPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 9) {
          return (com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetRoasSimulationPointList target_roas_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.TargetRoasSimulationPointList, com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetRoasSimulationPointListOrBuilder> 
        getTargetRoasPointListFieldBuilder() {
      if (targetRoasPointListBuilder_ == null) {
        if (!(pointListCase_ == 9)) {
          pointList_ = com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.getDefaultInstance();
        }
        targetRoasPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v17.common.TargetRoasSimulationPointList, com.google.ads.googleads.v17.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetRoasSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v17.common.TargetRoasSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 9;
      onChanged();
      return targetRoasPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList, com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointListOrBuilder> targetImpressionSharePointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the targetImpressionSharePointList field is set.
     */
    @java.lang.Override
    public boolean hasTargetImpressionSharePointList() {
      return pointListCase_ == 10;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The targetImpressionSharePointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList getTargetImpressionSharePointList() {
      if (targetImpressionSharePointListBuilder_ == null) {
        if (pointListCase_ == 10) {
          return (com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 10) {
          return targetImpressionSharePointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetImpressionSharePointList(com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList value) {
      if (targetImpressionSharePointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        targetImpressionSharePointListBuilder_.setMessage(value);
      }
      pointListCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetImpressionSharePointList(
        com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.Builder builderForValue) {
      if (targetImpressionSharePointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        targetImpressionSharePointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTargetImpressionSharePointList(com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList value) {
      if (targetImpressionSharePointListBuilder_ == null) {
        if (pointListCase_ == 10 &&
            pointList_ != com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.newBuilder((com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 10) {
          targetImpressionSharePointListBuilder_.mergeFrom(value);
        } else {
          targetImpressionSharePointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTargetImpressionSharePointList() {
      if (targetImpressionSharePointListBuilder_ == null) {
        if (pointListCase_ == 10) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 10) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        targetImpressionSharePointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.Builder getTargetImpressionSharePointListBuilder() {
      return getTargetImpressionSharePointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointListOrBuilder getTargetImpressionSharePointListOrBuilder() {
      if ((pointListCase_ == 10) && (targetImpressionSharePointListBuilder_ != null)) {
        return targetImpressionSharePointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 10) {
          return (com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is
     * TARGET_IMPRESSION_SHARE.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList target_impression_share_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList, com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointListOrBuilder> 
        getTargetImpressionSharePointListFieldBuilder() {
      if (targetImpressionSharePointListBuilder_ == null) {
        if (!(pointListCase_ == 10)) {
          pointList_ = com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.getDefaultInstance();
        }
        targetImpressionSharePointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList, com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList.Builder, com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v17.common.TargetImpressionShareSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 10;
      onChanged();
      return targetImpressionSharePointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.BudgetSimulationPointList, com.google.ads.googleads.v17.common.BudgetSimulationPointList.Builder, com.google.ads.googleads.v17.common.BudgetSimulationPointListOrBuilder> budgetPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the budgetPointList field is set.
     */
    @java.lang.Override
    public boolean hasBudgetPointList() {
      return pointListCase_ == 11;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The budgetPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.BudgetSimulationPointList getBudgetPointList() {
      if (budgetPointListBuilder_ == null) {
        if (pointListCase_ == 11) {
          return (com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.BudgetSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 11) {
          return budgetPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v17.common.BudgetSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setBudgetPointList(com.google.ads.googleads.v17.common.BudgetSimulationPointList value) {
      if (budgetPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        budgetPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setBudgetPointList(
        com.google.ads.googleads.v17.common.BudgetSimulationPointList.Builder builderForValue) {
      if (budgetPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        budgetPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeBudgetPointList(com.google.ads.googleads.v17.common.BudgetSimulationPointList value) {
      if (budgetPointListBuilder_ == null) {
        if (pointListCase_ == 11 &&
            pointList_ != com.google.ads.googleads.v17.common.BudgetSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v17.common.BudgetSimulationPointList.newBuilder((com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 11) {
          budgetPointListBuilder_.mergeFrom(value);
        } else {
          budgetPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearBudgetPointList() {
      if (budgetPointListBuilder_ == null) {
        if (pointListCase_ == 11) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 11) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        budgetPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v17.common.BudgetSimulationPointList.Builder getBudgetPointListBuilder() {
      return getBudgetPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.common.BudgetSimulationPointListOrBuilder getBudgetPointListOrBuilder() {
      if ((pointListCase_ == 11) && (budgetPointListBuilder_ != null)) {
        return budgetPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 11) {
          return (com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v17.common.BudgetSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is BUDGET.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.common.BudgetSimulationPointList budget_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v17.common.BudgetSimulationPointList, com.google.ads.googleads.v17.common.BudgetSimulationPointList.Builder, com.google.ads.googleads.v17.common.BudgetSimulationPointListOrBuilder> 
        getBudgetPointListFieldBuilder() {
      if (budgetPointListBuilder_ == null) {
        if (!(pointListCase_ == 11)) {
          pointList_ = com.google.ads.googleads.v17.common.BudgetSimulationPointList.getDefaultInstance();
        }
        budgetPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v17.common.BudgetSimulationPointList, com.google.ads.googleads.v17.common.BudgetSimulationPointList.Builder, com.google.ads.googleads.v17.common.BudgetSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v17.common.BudgetSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 11;
      onChanged();
      return budgetPointListBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v17.resources.CampaignSimulation)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v17.resources.CampaignSimulation)
  private static final com.google.ads.googleads.v17.resources.CampaignSimulation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v17.resources.CampaignSimulation();
  }

  public static com.google.ads.googleads.v17.resources.CampaignSimulation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CampaignSimulation>
      PARSER = new com.google.protobuf.AbstractParser<CampaignSimulation>() {
    @java.lang.Override
    public CampaignSimulation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<CampaignSimulation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CampaignSimulation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v17.resources.CampaignSimulation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

