/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.resources;

import com.google.ads.googleads.v17.common.AssetLinkPrimaryStatusDetails;
import com.google.ads.googleads.v17.common.AssetLinkPrimaryStatusDetailsOrBuilder;
import com.google.ads.googleads.v17.common.PolicySummary;
import com.google.ads.googleads.v17.common.PolicySummaryOrBuilder;
import com.google.ads.googleads.v17.enums.AssetFieldTypeEnum;
import com.google.ads.googleads.v17.enums.AssetLinkPrimaryStatusEnum;
import com.google.ads.googleads.v17.enums.AssetLinkPrimaryStatusReasonEnum;
import com.google.ads.googleads.v17.enums.AssetLinkStatusEnum;
import com.google.ads.googleads.v17.enums.AssetPerformanceLabelEnum;
import com.google.ads.googleads.v17.enums.AssetSourceEnum;
import com.google.ads.googleads.v17.resources.AssetGroupAssetOrBuilder;
import com.google.ads.googleads.v17.resources.AssetGroupAssetProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AssetGroupAsset
extends GeneratedMessageV3
implements AssetGroupAssetOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ASSET_GROUP_FIELD_NUMBER = 2;
    private volatile Object assetGroup_ = "";
    public static final int ASSET_FIELD_NUMBER = 3;
    private volatile Object asset_ = "";
    public static final int FIELD_TYPE_FIELD_NUMBER = 4;
    private int fieldType_ = 0;
    public static final int STATUS_FIELD_NUMBER = 5;
    private int status_ = 0;
    public static final int PRIMARY_STATUS_FIELD_NUMBER = 8;
    private int primaryStatus_ = 0;
    public static final int PRIMARY_STATUS_REASONS_FIELD_NUMBER = 9;
    private List<Integer> primaryStatusReasons_;
    private static final Internal.ListAdapter.Converter<Integer, AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> primaryStatusReasons_converter_ = new Internal.ListAdapter.Converter<Integer, AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason>(){

        public AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason convert(Integer from) {
            AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason result = AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason.forNumber(from);
            return result == null ? AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason.UNRECOGNIZED : result;
        }
    };
    private int primaryStatusReasonsMemoizedSerializedSize;
    public static final int PRIMARY_STATUS_DETAILS_FIELD_NUMBER = 10;
    private List<AssetLinkPrimaryStatusDetails> primaryStatusDetails_;
    public static final int PERFORMANCE_LABEL_FIELD_NUMBER = 6;
    private int performanceLabel_ = 0;
    public static final int POLICY_SUMMARY_FIELD_NUMBER = 7;
    private PolicySummary policySummary_;
    public static final int SOURCE_FIELD_NUMBER = 11;
    private int source_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AssetGroupAsset DEFAULT_INSTANCE = new AssetGroupAsset();
    private static final Parser<AssetGroupAsset> PARSER = new AbstractParser<AssetGroupAsset>(){

        public AssetGroupAsset parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AssetGroupAsset.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AssetGroupAsset(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AssetGroupAsset() {
        this.resourceName_ = "";
        this.assetGroup_ = "";
        this.asset_ = "";
        this.fieldType_ = 0;
        this.status_ = 0;
        this.primaryStatus_ = 0;
        this.primaryStatusReasons_ = Collections.emptyList();
        this.primaryStatusDetails_ = Collections.emptyList();
        this.performanceLabel_ = 0;
        this.source_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AssetGroupAsset();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetGroupAssetProto.internal_static_google_ads_googleads_v17_resources_AssetGroupAsset_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetGroupAssetProto.internal_static_google_ads_googleads_v17_resources_AssetGroupAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetGroupAsset.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getAssetGroup() {
        Object ref = this.assetGroup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.assetGroup_ = s;
        return s;
    }

    @Override
    public ByteString getAssetGroupBytes() {
        Object ref = this.assetGroup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.assetGroup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getAsset() {
        Object ref = this.asset_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.asset_ = s;
        return s;
    }

    @Override
    public ByteString getAssetBytes() {
        Object ref = this.asset_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.asset_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getFieldTypeValue() {
        return this.fieldType_;
    }

    @Override
    public AssetFieldTypeEnum.AssetFieldType getFieldType() {
        AssetFieldTypeEnum.AssetFieldType result = AssetFieldTypeEnum.AssetFieldType.forNumber(this.fieldType_);
        return result == null ? AssetFieldTypeEnum.AssetFieldType.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public AssetLinkStatusEnum.AssetLinkStatus getStatus() {
        AssetLinkStatusEnum.AssetLinkStatus result = AssetLinkStatusEnum.AssetLinkStatus.forNumber(this.status_);
        return result == null ? AssetLinkStatusEnum.AssetLinkStatus.UNRECOGNIZED : result;
    }

    @Override
    public int getPrimaryStatusValue() {
        return this.primaryStatus_;
    }

    @Override
    public AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus getPrimaryStatus() {
        AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus result = AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.forNumber(this.primaryStatus_);
        return result == null ? AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> getPrimaryStatusReasonsList() {
        return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
    }

    @Override
    public int getPrimaryStatusReasonsCount() {
        return this.primaryStatusReasons_.size();
    }

    @Override
    public AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason getPrimaryStatusReasons(int index) {
        return (AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
    }

    @Override
    public List<Integer> getPrimaryStatusReasonsValueList() {
        return this.primaryStatusReasons_;
    }

    @Override
    public int getPrimaryStatusReasonsValue(int index) {
        return this.primaryStatusReasons_.get(index);
    }

    @Override
    public List<AssetLinkPrimaryStatusDetails> getPrimaryStatusDetailsList() {
        return this.primaryStatusDetails_;
    }

    @Override
    public List<? extends AssetLinkPrimaryStatusDetailsOrBuilder> getPrimaryStatusDetailsOrBuilderList() {
        return this.primaryStatusDetails_;
    }

    @Override
    public int getPrimaryStatusDetailsCount() {
        return this.primaryStatusDetails_.size();
    }

    @Override
    public AssetLinkPrimaryStatusDetails getPrimaryStatusDetails(int index) {
        return this.primaryStatusDetails_.get(index);
    }

    @Override
    public AssetLinkPrimaryStatusDetailsOrBuilder getPrimaryStatusDetailsOrBuilder(int index) {
        return this.primaryStatusDetails_.get(index);
    }

    @Override
    public int getPerformanceLabelValue() {
        return this.performanceLabel_;
    }

    @Override
    public AssetPerformanceLabelEnum.AssetPerformanceLabel getPerformanceLabel() {
        AssetPerformanceLabelEnum.AssetPerformanceLabel result = AssetPerformanceLabelEnum.AssetPerformanceLabel.forNumber(this.performanceLabel_);
        return result == null ? AssetPerformanceLabelEnum.AssetPerformanceLabel.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasPolicySummary() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public PolicySummary getPolicySummary() {
        return this.policySummary_ == null ? PolicySummary.getDefaultInstance() : this.policySummary_;
    }

    @Override
    public PolicySummaryOrBuilder getPolicySummaryOrBuilder() {
        return this.policySummary_ == null ? PolicySummary.getDefaultInstance() : this.policySummary_;
    }

    @Override
    public int getSourceValue() {
        return this.source_;
    }

    @Override
    public AssetSourceEnum.AssetSource getSource() {
        AssetSourceEnum.AssetSource result = AssetSourceEnum.AssetSource.forNumber(this.source_);
        return result == null ? AssetSourceEnum.AssetSource.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.assetGroup_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.assetGroup_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.asset_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.asset_);
        }
        if (this.fieldType_ != AssetFieldTypeEnum.AssetFieldType.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.fieldType_);
        }
        if (this.status_ != AssetLinkStatusEnum.AssetLinkStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.status_);
        }
        if (this.performanceLabel_ != AssetPerformanceLabelEnum.AssetPerformanceLabel.UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.performanceLabel_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(7, (MessageLite)this.getPolicySummary());
        }
        if (this.primaryStatus_ != AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.primaryStatus_);
        }
        if (this.getPrimaryStatusReasonsList().size() > 0) {
            output.writeUInt32NoTag(74);
            output.writeUInt32NoTag(this.primaryStatusReasonsMemoizedSerializedSize);
        }
        for (i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            output.writeEnumNoTag(this.primaryStatusReasons_.get(i).intValue());
        }
        for (i = 0; i < this.primaryStatusDetails_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.primaryStatusDetails_.get(i));
        }
        if (this.source_ != AssetSourceEnum.AssetSource.UNSPECIFIED.getNumber()) {
            output.writeEnum(11, this.source_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.assetGroup_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.assetGroup_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.asset_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.asset_);
        }
        if (this.fieldType_ != AssetFieldTypeEnum.AssetFieldType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.fieldType_);
        }
        if (this.status_ != AssetLinkStatusEnum.AssetLinkStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.status_);
        }
        if (this.performanceLabel_ != AssetPerformanceLabelEnum.AssetPerformanceLabel.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.performanceLabel_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getPolicySummary());
        }
        if (this.primaryStatus_ != AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.primaryStatus_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.primaryStatusReasons_.get(i));
        }
        size += dataSize;
        if (!this.getPrimaryStatusReasonsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.primaryStatusReasonsMemoizedSerializedSize = dataSize;
        for (int i = 0; i < this.primaryStatusDetails_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.primaryStatusDetails_.get(i)));
        }
        if (this.source_ != AssetSourceEnum.AssetSource.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.source_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AssetGroupAsset)) {
            return super.equals(obj);
        }
        AssetGroupAsset other = (AssetGroupAsset)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (!this.getAssetGroup().equals(other.getAssetGroup())) {
            return false;
        }
        if (!this.getAsset().equals(other.getAsset())) {
            return false;
        }
        if (this.fieldType_ != other.fieldType_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.primaryStatus_ != other.primaryStatus_) {
            return false;
        }
        if (!this.primaryStatusReasons_.equals(other.primaryStatusReasons_)) {
            return false;
        }
        if (!this.getPrimaryStatusDetailsList().equals(other.getPrimaryStatusDetailsList())) {
            return false;
        }
        if (this.performanceLabel_ != other.performanceLabel_) {
            return false;
        }
        if (this.hasPolicySummary() != other.hasPolicySummary()) {
            return false;
        }
        if (this.hasPolicySummary() && !this.getPolicySummary().equals(other.getPolicySummary())) {
            return false;
        }
        if (this.source_ != other.source_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AssetGroupAsset.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getAssetGroup().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getAsset().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.fieldType_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 8;
        hash = 53 * hash + this.primaryStatus_;
        if (this.getPrimaryStatusReasonsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.primaryStatusReasons_.hashCode();
        }
        if (this.getPrimaryStatusDetailsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getPrimaryStatusDetailsList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.performanceLabel_;
        if (this.hasPolicySummary()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getPolicySummary().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.source_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AssetGroupAsset parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AssetGroupAsset)PARSER.parseFrom(data);
    }

    public static AssetGroupAsset parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetGroupAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetGroupAsset parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AssetGroupAsset)PARSER.parseFrom(data);
    }

    public static AssetGroupAsset parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetGroupAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetGroupAsset parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AssetGroupAsset)PARSER.parseFrom(data);
    }

    public static AssetGroupAsset parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetGroupAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetGroupAsset parseFrom(InputStream input) throws IOException {
        return (AssetGroupAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AssetGroupAsset parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetGroupAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AssetGroupAsset parseDelimitedFrom(InputStream input) throws IOException {
        return (AssetGroupAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AssetGroupAsset parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetGroupAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AssetGroupAsset parseFrom(CodedInputStream input) throws IOException {
        return (AssetGroupAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AssetGroupAsset parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetGroupAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AssetGroupAsset.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AssetGroupAsset prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AssetGroupAsset getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AssetGroupAsset> parser() {
        return PARSER;
    }

    public Parser<AssetGroupAsset> getParserForType() {
        return PARSER;
    }

    public AssetGroupAsset getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AssetGroupAssetOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private Object assetGroup_ = "";
        private Object asset_ = "";
        private int fieldType_ = 0;
        private int status_ = 0;
        private int primaryStatus_ = 0;
        private List<Integer> primaryStatusReasons_ = Collections.emptyList();
        private List<AssetLinkPrimaryStatusDetails> primaryStatusDetails_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AssetLinkPrimaryStatusDetails, AssetLinkPrimaryStatusDetails.Builder, AssetLinkPrimaryStatusDetailsOrBuilder> primaryStatusDetailsBuilder_;
        private int performanceLabel_ = 0;
        private PolicySummary policySummary_;
        private SingleFieldBuilderV3<PolicySummary, PolicySummary.Builder, PolicySummaryOrBuilder> policySummaryBuilder_;
        private int source_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetGroupAssetProto.internal_static_google_ads_googleads_v17_resources_AssetGroupAsset_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetGroupAssetProto.internal_static_google_ads_googleads_v17_resources_AssetGroupAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetGroupAsset.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getPrimaryStatusDetailsFieldBuilder();
                this.getPolicySummaryFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.assetGroup_ = "";
            this.asset_ = "";
            this.fieldType_ = 0;
            this.status_ = 0;
            this.primaryStatus_ = 0;
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.primaryStatusDetails_ = Collections.emptyList();
            } else {
                this.primaryStatusDetails_ = null;
                this.primaryStatusDetailsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFF7F;
            this.performanceLabel_ = 0;
            this.policySummary_ = null;
            if (this.policySummaryBuilder_ != null) {
                this.policySummaryBuilder_.dispose();
                this.policySummaryBuilder_ = null;
            }
            this.source_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetGroupAssetProto.internal_static_google_ads_googleads_v17_resources_AssetGroupAsset_descriptor;
        }

        public AssetGroupAsset getDefaultInstanceForType() {
            return AssetGroupAsset.getDefaultInstance();
        }

        public AssetGroupAsset build() {
            AssetGroupAsset result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AssetGroupAsset buildPartial() {
            AssetGroupAsset result = new AssetGroupAsset(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(AssetGroupAsset result) {
            if ((this.bitField0_ & 0x40) != 0) {
                this.primaryStatusReasons_ = Collections.unmodifiableList(this.primaryStatusReasons_);
                this.bitField0_ &= 0xFFFFFFBF;
            }
            result.primaryStatusReasons_ = this.primaryStatusReasons_;
            if (this.primaryStatusDetailsBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0) {
                    this.primaryStatusDetails_ = Collections.unmodifiableList(this.primaryStatusDetails_);
                    this.bitField0_ &= 0xFFFFFF7F;
                }
                result.primaryStatusDetails_ = this.primaryStatusDetails_;
            } else {
                result.primaryStatusDetails_ = this.primaryStatusDetailsBuilder_.build();
            }
        }

        private void buildPartial0(AssetGroupAsset result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.assetGroup_ = this.assetGroup_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.asset_ = this.asset_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.fieldType_ = this.fieldType_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.primaryStatus_ = this.primaryStatus_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.performanceLabel_ = this.performanceLabel_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x200) != 0) {
                result.policySummary_ = this.policySummaryBuilder_ == null ? this.policySummary_ : (PolicySummary)this.policySummaryBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.source_ = this.source_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AssetGroupAsset) {
                return this.mergeFrom((AssetGroupAsset)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AssetGroupAsset other) {
            if (other == AssetGroupAsset.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getAssetGroup().isEmpty()) {
                this.assetGroup_ = other.assetGroup_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getAsset().isEmpty()) {
                this.asset_ = other.asset_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.fieldType_ != 0) {
                this.setFieldTypeValue(other.getFieldTypeValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.primaryStatus_ != 0) {
                this.setPrimaryStatusValue(other.getPrimaryStatusValue());
            }
            if (!other.primaryStatusReasons_.isEmpty()) {
                if (this.primaryStatusReasons_.isEmpty()) {
                    this.primaryStatusReasons_ = other.primaryStatusReasons_;
                    this.bitField0_ &= 0xFFFFFFBF;
                } else {
                    this.ensurePrimaryStatusReasonsIsMutable();
                    this.primaryStatusReasons_.addAll(other.primaryStatusReasons_);
                }
                this.onChanged();
            }
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (!other.primaryStatusDetails_.isEmpty()) {
                    if (this.primaryStatusDetails_.isEmpty()) {
                        this.primaryStatusDetails_ = other.primaryStatusDetails_;
                        this.bitField0_ &= 0xFFFFFF7F;
                    } else {
                        this.ensurePrimaryStatusDetailsIsMutable();
                        this.primaryStatusDetails_.addAll(other.primaryStatusDetails_);
                    }
                    this.onChanged();
                }
            } else if (!other.primaryStatusDetails_.isEmpty()) {
                if (this.primaryStatusDetailsBuilder_.isEmpty()) {
                    this.primaryStatusDetailsBuilder_.dispose();
                    this.primaryStatusDetailsBuilder_ = null;
                    this.primaryStatusDetails_ = other.primaryStatusDetails_;
                    this.bitField0_ &= 0xFFFFFF7F;
                    this.primaryStatusDetailsBuilder_ = alwaysUseFieldBuilders ? this.getPrimaryStatusDetailsFieldBuilder() : null;
                } else {
                    this.primaryStatusDetailsBuilder_.addAllMessages((Iterable)other.primaryStatusDetails_);
                }
            }
            if (other.performanceLabel_ != 0) {
                this.setPerformanceLabelValue(other.getPerformanceLabelValue());
            }
            if (other.hasPolicySummary()) {
                this.mergePolicySummary(other.getPolicySummary());
            }
            if (other.source_ != 0) {
                this.setSourceValue(other.getSourceValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block20: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block20;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block20;
                        }
                        case 18: {
                            this.assetGroup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block20;
                        }
                        case 26: {
                            this.asset_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 32: {
                            this.fieldType_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block20;
                        }
                        case 40: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block20;
                        }
                        case 48: {
                            this.performanceLabel_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block20;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getPolicySummaryFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block20;
                        }
                        case 64: {
                            this.primaryStatus_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block20;
                        }
                        case 72: {
                            int tmpRaw = input.readEnum();
                            this.ensurePrimaryStatusReasonsIsMutable();
                            this.primaryStatusReasons_.add(tmpRaw);
                            continue block20;
                        }
                        case 74: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensurePrimaryStatusReasonsIsMutable();
                                this.primaryStatusReasons_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block20;
                        }
                        case 82: {
                            AssetLinkPrimaryStatusDetails m = (AssetLinkPrimaryStatusDetails)input.readMessage(AssetLinkPrimaryStatusDetails.parser(), extensionRegistry);
                            if (this.primaryStatusDetailsBuilder_ == null) {
                                this.ensurePrimaryStatusDetailsIsMutable();
                                this.primaryStatusDetails_.add(m);
                                continue block20;
                            }
                            this.primaryStatusDetailsBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 88: {
                            this.source_ = input.readEnum();
                            this.bitField0_ |= 0x400;
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = AssetGroupAsset.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroupAsset.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getAssetGroup() {
            Object ref = this.assetGroup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.assetGroup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAssetGroupBytes() {
            Object ref = this.assetGroup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.assetGroup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAssetGroup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.assetGroup_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearAssetGroup() {
            this.assetGroup_ = AssetGroupAsset.getDefaultInstance().getAssetGroup();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setAssetGroupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroupAsset.checkByteStringIsUtf8((ByteString)value);
            this.assetGroup_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getAsset() {
            Object ref = this.asset_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.asset_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAssetBytes() {
            Object ref = this.asset_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.asset_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAsset(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.asset_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearAsset() {
            this.asset_ = AssetGroupAsset.getDefaultInstance().getAsset();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setAssetBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroupAsset.checkByteStringIsUtf8((ByteString)value);
            this.asset_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getFieldTypeValue() {
            return this.fieldType_;
        }

        public Builder setFieldTypeValue(int value) {
            this.fieldType_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public AssetFieldTypeEnum.AssetFieldType getFieldType() {
            AssetFieldTypeEnum.AssetFieldType result = AssetFieldTypeEnum.AssetFieldType.forNumber(this.fieldType_);
            return result == null ? AssetFieldTypeEnum.AssetFieldType.UNRECOGNIZED : result;
        }

        public Builder setFieldType(AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.fieldType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearFieldType() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.fieldType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public AssetLinkStatusEnum.AssetLinkStatus getStatus() {
            AssetLinkStatusEnum.AssetLinkStatus result = AssetLinkStatusEnum.AssetLinkStatus.forNumber(this.status_);
            return result == null ? AssetLinkStatusEnum.AssetLinkStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(AssetLinkStatusEnum.AssetLinkStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPrimaryStatusValue() {
            return this.primaryStatus_;
        }

        public Builder setPrimaryStatusValue(int value) {
            this.primaryStatus_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus getPrimaryStatus() {
            AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus result = AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.forNumber(this.primaryStatus_);
            return result == null ? AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNRECOGNIZED : result;
        }

        public Builder setPrimaryStatus(AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.primaryStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatus() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.primaryStatus_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePrimaryStatusReasonsIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.primaryStatusReasons_ = new ArrayList<Integer>(this.primaryStatusReasons_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> getPrimaryStatusReasonsList() {
            return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
        }

        @Override
        public int getPrimaryStatusReasonsCount() {
            return this.primaryStatusReasons_.size();
        }

        @Override
        public AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason getPrimaryStatusReasons(int index) {
            return (AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
        }

        public Builder setPrimaryStatusReasons(int index, AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasons(AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasons(Iterable<? extends AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason assetLinkPrimaryStatusReason : values) {
                this.primaryStatusReasons_.add(assetLinkPrimaryStatusReason.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatusReasons() {
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPrimaryStatusReasonsValueList() {
            return Collections.unmodifiableList(this.primaryStatusReasons_);
        }

        @Override
        public int getPrimaryStatusReasonsValue(int index) {
            return this.primaryStatusReasons_.get(index);
        }

        public Builder setPrimaryStatusReasonsValue(int index, int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasonsValue(int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasonsValue(Iterable<Integer> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (int value : values) {
                this.primaryStatusReasons_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensurePrimaryStatusDetailsIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.primaryStatusDetails_ = new ArrayList<AssetLinkPrimaryStatusDetails>(this.primaryStatusDetails_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<AssetLinkPrimaryStatusDetails> getPrimaryStatusDetailsList() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return Collections.unmodifiableList(this.primaryStatusDetails_);
            }
            return this.primaryStatusDetailsBuilder_.getMessageList();
        }

        @Override
        public int getPrimaryStatusDetailsCount() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return this.primaryStatusDetails_.size();
            }
            return this.primaryStatusDetailsBuilder_.getCount();
        }

        @Override
        public AssetLinkPrimaryStatusDetails getPrimaryStatusDetails(int index) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return this.primaryStatusDetails_.get(index);
            }
            return (AssetLinkPrimaryStatusDetails)this.primaryStatusDetailsBuilder_.getMessage(index);
        }

        public Builder setPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails value) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.set(index, value);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails.Builder builderForValue) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(AssetLinkPrimaryStatusDetails value) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(value);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails value) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(index, value);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(AssetLinkPrimaryStatusDetails.Builder builderForValue) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails.Builder builderForValue) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPrimaryStatusDetails(Iterable<? extends AssetLinkPrimaryStatusDetails> values) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.primaryStatusDetails_);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPrimaryStatusDetails() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.primaryStatusDetails_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.clear();
            }
            return this;
        }

        public Builder removePrimaryStatusDetails(int index) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.remove(index);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.remove(index);
            }
            return this;
        }

        public AssetLinkPrimaryStatusDetails.Builder getPrimaryStatusDetailsBuilder(int index) {
            return (AssetLinkPrimaryStatusDetails.Builder)this.getPrimaryStatusDetailsFieldBuilder().getBuilder(index);
        }

        @Override
        public AssetLinkPrimaryStatusDetailsOrBuilder getPrimaryStatusDetailsOrBuilder(int index) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return this.primaryStatusDetails_.get(index);
            }
            return (AssetLinkPrimaryStatusDetailsOrBuilder)this.primaryStatusDetailsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AssetLinkPrimaryStatusDetailsOrBuilder> getPrimaryStatusDetailsOrBuilderList() {
            if (this.primaryStatusDetailsBuilder_ != null) {
                return this.primaryStatusDetailsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.primaryStatusDetails_);
        }

        public AssetLinkPrimaryStatusDetails.Builder addPrimaryStatusDetailsBuilder() {
            return (AssetLinkPrimaryStatusDetails.Builder)this.getPrimaryStatusDetailsFieldBuilder().addBuilder((AbstractMessage)AssetLinkPrimaryStatusDetails.getDefaultInstance());
        }

        public AssetLinkPrimaryStatusDetails.Builder addPrimaryStatusDetailsBuilder(int index) {
            return (AssetLinkPrimaryStatusDetails.Builder)this.getPrimaryStatusDetailsFieldBuilder().addBuilder(index, (AbstractMessage)AssetLinkPrimaryStatusDetails.getDefaultInstance());
        }

        public List<AssetLinkPrimaryStatusDetails.Builder> getPrimaryStatusDetailsBuilderList() {
            return this.getPrimaryStatusDetailsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AssetLinkPrimaryStatusDetails, AssetLinkPrimaryStatusDetails.Builder, AssetLinkPrimaryStatusDetailsOrBuilder> getPrimaryStatusDetailsFieldBuilder() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.primaryStatusDetailsBuilder_ = new RepeatedFieldBuilderV3(this.primaryStatusDetails_, (this.bitField0_ & 0x80) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.primaryStatusDetails_ = null;
            }
            return this.primaryStatusDetailsBuilder_;
        }

        @Override
        public int getPerformanceLabelValue() {
            return this.performanceLabel_;
        }

        public Builder setPerformanceLabelValue(int value) {
            this.performanceLabel_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public AssetPerformanceLabelEnum.AssetPerformanceLabel getPerformanceLabel() {
            AssetPerformanceLabelEnum.AssetPerformanceLabel result = AssetPerformanceLabelEnum.AssetPerformanceLabel.forNumber(this.performanceLabel_);
            return result == null ? AssetPerformanceLabelEnum.AssetPerformanceLabel.UNRECOGNIZED : result;
        }

        public Builder setPerformanceLabel(AssetPerformanceLabelEnum.AssetPerformanceLabel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.performanceLabel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPerformanceLabel() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.performanceLabel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPolicySummary() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public PolicySummary getPolicySummary() {
            if (this.policySummaryBuilder_ == null) {
                return this.policySummary_ == null ? PolicySummary.getDefaultInstance() : this.policySummary_;
            }
            return (PolicySummary)this.policySummaryBuilder_.getMessage();
        }

        public Builder setPolicySummary(PolicySummary value) {
            if (this.policySummaryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.policySummary_ = value;
            } else {
                this.policySummaryBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setPolicySummary(PolicySummary.Builder builderForValue) {
            if (this.policySummaryBuilder_ == null) {
                this.policySummary_ = builderForValue.build();
            } else {
                this.policySummaryBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergePolicySummary(PolicySummary value) {
            if (this.policySummaryBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.policySummary_ != null && this.policySummary_ != PolicySummary.getDefaultInstance()) {
                    this.getPolicySummaryBuilder().mergeFrom(value);
                } else {
                    this.policySummary_ = value;
                }
            } else {
                this.policySummaryBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.policySummary_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPolicySummary() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.policySummary_ = null;
            if (this.policySummaryBuilder_ != null) {
                this.policySummaryBuilder_.dispose();
                this.policySummaryBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public PolicySummary.Builder getPolicySummaryBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (PolicySummary.Builder)this.getPolicySummaryFieldBuilder().getBuilder();
        }

        @Override
        public PolicySummaryOrBuilder getPolicySummaryOrBuilder() {
            if (this.policySummaryBuilder_ != null) {
                return (PolicySummaryOrBuilder)this.policySummaryBuilder_.getMessageOrBuilder();
            }
            return this.policySummary_ == null ? PolicySummary.getDefaultInstance() : this.policySummary_;
        }

        private SingleFieldBuilderV3<PolicySummary, PolicySummary.Builder, PolicySummaryOrBuilder> getPolicySummaryFieldBuilder() {
            if (this.policySummaryBuilder_ == null) {
                this.policySummaryBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPolicySummary(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.policySummary_ = null;
            }
            return this.policySummaryBuilder_;
        }

        @Override
        public int getSourceValue() {
            return this.source_;
        }

        public Builder setSourceValue(int value) {
            this.source_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public AssetSourceEnum.AssetSource getSource() {
            AssetSourceEnum.AssetSource result = AssetSourceEnum.AssetSource.forNumber(this.source_);
            return result == null ? AssetSourceEnum.AssetSource.UNRECOGNIZED : result;
        }

        public Builder setSource(AssetSourceEnum.AssetSource value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x400;
            this.source_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSource() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.source_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

