/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignCustomizerName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_CUSTOMIZER_ATTRIBUTE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignCustomizers/{campaign_id}~{customizer_attribute_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String customizerAttributeId;

    @Deprecated
    protected CampaignCustomizerName() {
        this.customerId = null;
        this.campaignId = null;
        this.customizerAttributeId = null;
    }

    private CampaignCustomizerName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.customizerAttributeId = (String)Preconditions.checkNotNull((Object)builder.getCustomizerAttributeId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getCustomizerAttributeId() {
        return this.customizerAttributeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignCustomizerName of(String customerId, String campaignId, String customizerAttributeId) {
        return CampaignCustomizerName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setCustomizerAttributeId(customizerAttributeId).build();
    }

    public static String format(String customerId, String campaignId, String customizerAttributeId) {
        return CampaignCustomizerName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setCustomizerAttributeId(customizerAttributeId).build().toString();
    }

    public static CampaignCustomizerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_CUSTOMIZER_ATTRIBUTE_ID.validatedMatch(formattedString, "CampaignCustomizerName.parse: formattedString not in valid format");
        return CampaignCustomizerName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("customizer_attribute_id"));
    }

    public static List<CampaignCustomizerName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignCustomizerName> list = new ArrayList<CampaignCustomizerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignCustomizerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignCustomizerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignCustomizerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_CUSTOMIZER_ATTRIBUTE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignCustomizerName campaignCustomizerName = this;
            synchronized (campaignCustomizerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.customizerAttributeId != null) {
                        fieldMapBuilder.put((Object)"customizer_attribute_id", (Object)this.customizerAttributeId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_CUSTOMIZER_ATTRIBUTE_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "customizer_attribute_id", this.customizerAttributeId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignCustomizerName that = (CampaignCustomizerName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.customizerAttributeId, that.customizerAttributeId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customizerAttributeId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String customizerAttributeId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getCustomizerAttributeId() {
            return this.customizerAttributeId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setCustomizerAttributeId(String customizerAttributeId) {
            this.customizerAttributeId = customizerAttributeId;
            return this;
        }

        private Builder(CampaignCustomizerName campaignCustomizerName) {
            this.customerId = campaignCustomizerName.customerId;
            this.campaignId = campaignCustomizerName.campaignId;
            this.customizerAttributeId = campaignCustomizerName.customizerAttributeId;
        }

        public CampaignCustomizerName build() {
            return new CampaignCustomizerName(this);
        }
    }
}

