/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeedMappingName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_FEED_ID_FEED_MAPPING_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/feedMappings/{feed_id}~{feed_mapping_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String feedId;
    private final String feedMappingId;

    @Deprecated
    protected FeedMappingName() {
        this.customerId = null;
        this.feedId = null;
        this.feedMappingId = null;
    }

    private FeedMappingName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.feedId = (String)Preconditions.checkNotNull((Object)builder.getFeedId());
        this.feedMappingId = (String)Preconditions.checkNotNull((Object)builder.getFeedMappingId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getFeedMappingId() {
        return this.feedMappingId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeedMappingName of(String customerId, String feedId, String feedMappingId) {
        return FeedMappingName.newBuilder().setCustomerId(customerId).setFeedId(feedId).setFeedMappingId(feedMappingId).build();
    }

    public static String format(String customerId, String feedId, String feedMappingId) {
        return FeedMappingName.newBuilder().setCustomerId(customerId).setFeedId(feedId).setFeedMappingId(feedMappingId).build().toString();
    }

    public static FeedMappingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_FEED_ID_FEED_MAPPING_ID.validatedMatch(formattedString, "FeedMappingName.parse: formattedString not in valid format");
        return FeedMappingName.of((String)matchMap.get("customer_id"), (String)matchMap.get("feed_id"), (String)matchMap.get("feed_mapping_id"));
    }

    public static List<FeedMappingName> parseList(List<String> formattedStrings) {
        ArrayList<FeedMappingName> list = new ArrayList<FeedMappingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedMappingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedMappingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedMappingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_FEED_ID_FEED_MAPPING_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedMappingName feedMappingName = this;
            synchronized (feedMappingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.feedId != null) {
                        fieldMapBuilder.put((Object)"feed_id", (Object)this.feedId);
                    }
                    if (this.feedMappingId != null) {
                        fieldMapBuilder.put((Object)"feed_mapping_id", (Object)this.feedMappingId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_FEED_ID_FEED_MAPPING_ID.instantiate(new String[]{"customer_id", this.customerId, "feed_id", this.feedId, "feed_mapping_id", this.feedMappingId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeedMappingName that = (FeedMappingName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.feedId, that.feedId) && Objects.equals(this.feedMappingId, that.feedMappingId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.feedId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.feedMappingId);
    }

    public static class Builder {
        private String customerId;
        private String feedId;
        private String feedMappingId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public String getFeedMappingId() {
            return this.feedMappingId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setFeedId(String feedId) {
            this.feedId = feedId;
            return this;
        }

        public Builder setFeedMappingId(String feedMappingId) {
            this.feedMappingId = feedMappingId;
            return this;
        }

        private Builder(FeedMappingName feedMappingName) {
            this.customerId = feedMappingName.customerId;
            this.feedId = feedMappingName.feedId;
            this.feedMappingId = feedMappingName.feedMappingId;
        }

        public FeedMappingName build() {
            return new FeedMappingName(this);
        }
    }
}

