/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SharedSetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_SHARED_SET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/sharedSets/{shared_set_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String sharedSetId;

    @Deprecated
    protected SharedSetName() {
        this.customerId = null;
        this.sharedSetId = null;
    }

    private SharedSetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.sharedSetId = (String)Preconditions.checkNotNull((Object)builder.getSharedSetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getSharedSetId() {
        return this.sharedSetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SharedSetName of(String customerId, String sharedSetId) {
        return SharedSetName.newBuilder().setCustomerId(customerId).setSharedSetId(sharedSetId).build();
    }

    public static String format(String customerId, String sharedSetId) {
        return SharedSetName.newBuilder().setCustomerId(customerId).setSharedSetId(sharedSetId).build().toString();
    }

    public static SharedSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_SHARED_SET_ID.validatedMatch(formattedString, "SharedSetName.parse: formattedString not in valid format");
        return SharedSetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("shared_set_id"));
    }

    public static List<SharedSetName> parseList(List<String> formattedStrings) {
        ArrayList<SharedSetName> list = new ArrayList<SharedSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SharedSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SharedSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SharedSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_SHARED_SET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SharedSetName sharedSetName = this;
            synchronized (sharedSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.sharedSetId != null) {
                        fieldMapBuilder.put((Object)"shared_set_id", (Object)this.sharedSetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_SHARED_SET_ID.instantiate(new String[]{"customer_id", this.customerId, "shared_set_id", this.sharedSetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SharedSetName that = (SharedSetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.sharedSetId, that.sharedSetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.sharedSetId);
    }

    public static class Builder {
        private String customerId;
        private String sharedSetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getSharedSetId() {
            return this.sharedSetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setSharedSetId(String sharedSetId) {
            this.sharedSetId = sharedSetId;
            return this;
        }

        private Builder(SharedSetName sharedSetName) {
            this.customerId = sharedSetName.customerId;
            this.sharedSetId = sharedSetName.sharedSetId;
        }

        public SharedSetName build() {
            return new SharedSetName(this);
        }
    }
}

