/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.enums.ProductLinkInvitationStatusEnum;
import com.google.ads.googleads.v17.resources.ProductLinkInvitation;
import com.google.ads.googleads.v17.resources.ProductLinkInvitationName;
import com.google.ads.googleads.v17.services.CreateProductLinkInvitationRequest;
import com.google.ads.googleads.v17.services.CreateProductLinkInvitationResponse;
import com.google.ads.googleads.v17.services.ProductLinkInvitationServiceSettings;
import com.google.ads.googleads.v17.services.RemoveProductLinkInvitationRequest;
import com.google.ads.googleads.v17.services.RemoveProductLinkInvitationResponse;
import com.google.ads.googleads.v17.services.UpdateProductLinkInvitationRequest;
import com.google.ads.googleads.v17.services.UpdateProductLinkInvitationResponse;
import com.google.ads.googleads.v17.services.stub.ProductLinkInvitationServiceStub;
import com.google.ads.googleads.v17.services.stub.ProductLinkInvitationServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ProductLinkInvitationServiceClient
implements BackgroundResource {
    private final ProductLinkInvitationServiceSettings settings;
    private final ProductLinkInvitationServiceStub stub;

    public static final ProductLinkInvitationServiceClient create() throws IOException {
        return ProductLinkInvitationServiceClient.create(ProductLinkInvitationServiceSettings.newBuilder().build());
    }

    public static final ProductLinkInvitationServiceClient create(ProductLinkInvitationServiceSettings settings) throws IOException {
        return new ProductLinkInvitationServiceClient(settings);
    }

    public static final ProductLinkInvitationServiceClient create(ProductLinkInvitationServiceStub stub) {
        return new ProductLinkInvitationServiceClient(stub);
    }

    protected ProductLinkInvitationServiceClient(ProductLinkInvitationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProductLinkInvitationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ProductLinkInvitationServiceClient(ProductLinkInvitationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProductLinkInvitationServiceSettings getSettings() {
        return this.settings;
    }

    public ProductLinkInvitationServiceStub getStub() {
        return this.stub;
    }

    public final CreateProductLinkInvitationResponse createProductLinkInvitation(String customerId, ProductLinkInvitation productLinkInvitation) {
        CreateProductLinkInvitationRequest request = CreateProductLinkInvitationRequest.newBuilder().setCustomerId(customerId).setProductLinkInvitation(productLinkInvitation).build();
        return this.createProductLinkInvitation(request);
    }

    public final CreateProductLinkInvitationResponse createProductLinkInvitation(CreateProductLinkInvitationRequest request) {
        return (CreateProductLinkInvitationResponse)this.createProductLinkInvitationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductLinkInvitationRequest, CreateProductLinkInvitationResponse> createProductLinkInvitationCallable() {
        return this.stub.createProductLinkInvitationCallable();
    }

    public final UpdateProductLinkInvitationResponse updateProductLinkInvitation(String customerId, ProductLinkInvitationStatusEnum.ProductLinkInvitationStatus productLinkInvitationStatus, ProductLinkInvitationName resourceName) {
        UpdateProductLinkInvitationRequest request = UpdateProductLinkInvitationRequest.newBuilder().setCustomerId(customerId).setProductLinkInvitationStatus(productLinkInvitationStatus).setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.updateProductLinkInvitation(request);
    }

    public final UpdateProductLinkInvitationResponse updateProductLinkInvitation(String customerId, ProductLinkInvitationStatusEnum.ProductLinkInvitationStatus productLinkInvitationStatus, String resourceName) {
        UpdateProductLinkInvitationRequest request = UpdateProductLinkInvitationRequest.newBuilder().setCustomerId(customerId).setProductLinkInvitationStatus(productLinkInvitationStatus).setResourceName(resourceName).build();
        return this.updateProductLinkInvitation(request);
    }

    public final UpdateProductLinkInvitationResponse updateProductLinkInvitation(UpdateProductLinkInvitationRequest request) {
        return (UpdateProductLinkInvitationResponse)this.updateProductLinkInvitationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProductLinkInvitationRequest, UpdateProductLinkInvitationResponse> updateProductLinkInvitationCallable() {
        return this.stub.updateProductLinkInvitationCallable();
    }

    public final RemoveProductLinkInvitationResponse removeProductLinkInvitation(String customerId, ProductLinkInvitationName resourceName) {
        RemoveProductLinkInvitationRequest request = RemoveProductLinkInvitationRequest.newBuilder().setCustomerId(customerId).setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.removeProductLinkInvitation(request);
    }

    public final RemoveProductLinkInvitationResponse removeProductLinkInvitation(String customerId, String resourceName) {
        RemoveProductLinkInvitationRequest request = RemoveProductLinkInvitationRequest.newBuilder().setCustomerId(customerId).setResourceName(resourceName).build();
        return this.removeProductLinkInvitation(request);
    }

    public final RemoveProductLinkInvitationResponse removeProductLinkInvitation(RemoveProductLinkInvitationRequest request) {
        return (RemoveProductLinkInvitationResponse)this.removeProductLinkInvitationCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveProductLinkInvitationRequest, RemoveProductLinkInvitationResponse> removeProductLinkInvitationCallable() {
        return this.stub.removeProductLinkInvitationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

