/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services.stub;

import com.google.ads.googleads.v17.services.ListInvoicesRequest;
import com.google.ads.googleads.v17.services.ListInvoicesResponse;
import com.google.ads.googleads.v17.services.stub.GrpcInvoiceServiceCallableFactory;
import com.google.ads.googleads.v17.services.stub.InvoiceServiceStub;
import com.google.ads.googleads.v17.services.stub.InvoiceServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcInvoiceServiceStub
extends InvoiceServiceStub {
    private static final MethodDescriptor<ListInvoicesRequest, ListInvoicesResponse> listInvoicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v17.services.InvoiceService/ListInvoices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInvoicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInvoicesResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListInvoicesRequest, ListInvoicesResponse> listInvoicesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcInvoiceServiceStub create(InvoiceServiceStubSettings settings) throws IOException {
        return new GrpcInvoiceServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcInvoiceServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcInvoiceServiceStub(InvoiceServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcInvoiceServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcInvoiceServiceStub(InvoiceServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcInvoiceServiceStub(InvoiceServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcInvoiceServiceCallableFactory());
    }

    protected GrpcInvoiceServiceStub(InvoiceServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInvoicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInvoicesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.listInvoicesCallable = callableFactory.createUnaryCallable(listInvoicesTransportSettings, settings.listInvoicesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInvoicesRequest, ListInvoicesResponse> listInvoicesCallable() {
        return this.listInvoicesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

