// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v17/resources/hotel_reconciliation.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v17.resources;

/**
 * <pre>
 * A hotel reconciliation. It contains conversion information from Hotel
 * bookings to reconcile with advertiser records. These rows may be updated
 * or canceled before billing through Bulk Uploads.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v17.resources.HotelReconciliation}
 */
public final class HotelReconciliation extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v17.resources.HotelReconciliation)
    HotelReconciliationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use HotelReconciliation.newBuilder() to construct.
  private HotelReconciliation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HotelReconciliation() {
    resourceName_ = "";
    commissionId_ = "";
    orderId_ = "";
    campaign_ = "";
    hotelId_ = "";
    checkInDate_ = "";
    checkOutDate_ = "";
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new HotelReconciliation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v17.resources.HotelReconciliationProto.internal_static_google_ads_googleads_v17_resources_HotelReconciliation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v17.resources.HotelReconciliationProto.internal_static_google_ads_googleads_v17_resources_HotelReconciliation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v17.resources.HotelReconciliation.class, com.google.ads.googleads.v17.resources.HotelReconciliation.Builder.class);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the hotel reconciliation.
   * Hotel reconciliation resource names have the form:
   *
   * `customers/{customer_id}/hotelReconciliations/{commission_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the hotel reconciliation.
   * Hotel reconciliation resource names have the form:
   *
   * `customers/{customer_id}/hotelReconciliations/{commission_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMISSION_ID_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object commissionId_ = "";
  /**
   * <pre>
   * Required. Output only. The commission ID is Google's ID for this booking.
   * Every booking event is assigned a Commission ID to help you match it to a
   * guest stay.
   * </pre>
   *
   * <code>string commission_id = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The commissionId.
   */
  @java.lang.Override
  public java.lang.String getCommissionId() {
    java.lang.Object ref = commissionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      commissionId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Required. Output only. The commission ID is Google's ID for this booking.
   * Every booking event is assigned a Commission ID to help you match it to a
   * guest stay.
   * </pre>
   *
   * <code>string commission_id = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for commissionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCommissionIdBytes() {
    java.lang.Object ref = commissionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      commissionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_ID_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private volatile java.lang.Object orderId_ = "";
  /**
   * <pre>
   * Output only. The order ID is the identifier for this booking as provided in
   * the 'transaction_id' parameter of the conversion tracking tag.
   * </pre>
   *
   * <code>string order_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The orderId.
   */
  @java.lang.Override
  public java.lang.String getOrderId() {
    java.lang.Object ref = orderId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The order ID is the identifier for this booking as provided in
   * the 'transaction_id' parameter of the conversion tracking tag.
   * </pre>
   *
   * <code>string order_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for orderId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getOrderIdBytes() {
    java.lang.Object ref = orderId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      orderId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CAMPAIGN_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private volatile java.lang.Object campaign_ = "";
  /**
   * <pre>
   * Output only. The resource name for the Campaign associated with the
   * conversion.
   * </pre>
   *
   * <code>string campaign = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The campaign.
   */
  @java.lang.Override
  public java.lang.String getCampaign() {
    java.lang.Object ref = campaign_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      campaign_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name for the Campaign associated with the
   * conversion.
   * </pre>
   *
   * <code>string campaign = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for campaign.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCampaignBytes() {
    java.lang.Object ref = campaign_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      campaign_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOTEL_CENTER_ID_FIELD_NUMBER = 4;
  private long hotelCenterId_ = 0L;
  /**
   * <pre>
   * Output only. Identifier for the Hotel Center account which provides the
   * rates for the Hotel campaign.
   * </pre>
   *
   * <code>int64 hotel_center_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The hotelCenterId.
   */
  @java.lang.Override
  public long getHotelCenterId() {
    return hotelCenterId_;
  }

  public static final int HOTEL_ID_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object hotelId_ = "";
  /**
   * <pre>
   * Output only. Unique identifier for the booked property, as provided in the
   * Hotel Center feed. The hotel ID comes from the 'ID' parameter of the
   * conversion tracking tag.
   * </pre>
   *
   * <code>string hotel_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The hotelId.
   */
  @java.lang.Override
  public java.lang.String getHotelId() {
    java.lang.Object ref = hotelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hotelId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Unique identifier for the booked property, as provided in the
   * Hotel Center feed. The hotel ID comes from the 'ID' parameter of the
   * conversion tracking tag.
   * </pre>
   *
   * <code>string hotel_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for hotelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getHotelIdBytes() {
    java.lang.Object ref = hotelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      hotelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHECK_IN_DATE_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private volatile java.lang.Object checkInDate_ = "";
  /**
   * <pre>
   * Output only. Check-in date recorded when the booking is made. If the
   * check-in date is modified at reconciliation, the revised date will then
   * take the place of the original date in this column. Format is YYYY-MM-DD.
   * </pre>
   *
   * <code>string check_in_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The checkInDate.
   */
  @java.lang.Override
  public java.lang.String getCheckInDate() {
    java.lang.Object ref = checkInDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      checkInDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Check-in date recorded when the booking is made. If the
   * check-in date is modified at reconciliation, the revised date will then
   * take the place of the original date in this column. Format is YYYY-MM-DD.
   * </pre>
   *
   * <code>string check_in_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for checkInDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCheckInDateBytes() {
    java.lang.Object ref = checkInDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      checkInDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHECK_OUT_DATE_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private volatile java.lang.Object checkOutDate_ = "";
  /**
   * <pre>
   * Output only. Check-out date recorded when the booking is made. If the
   * check-in date is modified at reconciliation, the revised date will then
   * take the place of the original date in this column. Format is YYYY-MM-DD.
   * </pre>
   *
   * <code>string check_out_date = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The checkOutDate.
   */
  @java.lang.Override
  public java.lang.String getCheckOutDate() {
    java.lang.Object ref = checkOutDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      checkOutDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Check-out date recorded when the booking is made. If the
   * check-in date is modified at reconciliation, the revised date will then
   * take the place of the original date in this column. Format is YYYY-MM-DD.
   * </pre>
   *
   * <code>string check_out_date = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for checkOutDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCheckOutDateBytes() {
    java.lang.Object ref = checkOutDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      checkOutDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECONCILED_VALUE_MICROS_FIELD_NUMBER = 8;
  private long reconciledValueMicros_ = 0L;
  /**
   * <pre>
   * Required. Output only. Reconciled value is the final value of a booking as
   * paid by the guest. If original booking value changes for any reason, such
   * as itinerary changes or room upsells, the reconciled value should be the
   * full final amount collected. If a booking is canceled, the reconciled value
   * should include the value of any cancellation fees or non-refundable nights
   * charged. Value is in millionths of the base unit currency. For example,
   * $12.35 would be represented as 12350000. Currency unit is in the default
   * customer currency.
   * </pre>
   *
   * <code>int64 reconciled_value_micros = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The reconciledValueMicros.
   */
  @java.lang.Override
  public long getReconciledValueMicros() {
    return reconciledValueMicros_;
  }

  public static final int BILLED_FIELD_NUMBER = 9;
  private boolean billed_ = false;
  /**
   * <pre>
   * Output only. Whether a given booking has been billed. Once billed, a
   * booking can't be modified.
   * </pre>
   *
   * <code>bool billed = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The billed.
   */
  @java.lang.Override
  public boolean getBilled() {
    return billed_;
  }

  public static final int STATUS_FIELD_NUMBER = 10;
  private int status_ = 0;
  /**
   * <pre>
   * Required. Output only. Current status of a booking with regards to
   * reconciliation and billing. Bookings should be reconciled within 45 days
   * after the check-out date. Any booking not reconciled within 45 days will be
   * billed at its original value.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus status = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Required. Output only. Current status of a booking with regards to
   * reconciliation and billing. Bookings should be reconciled within 45 days
   * after the check-out date. Any booking not reconciled within 45 days will be
   * billed at its original value.
   * </pre>
   *
   * <code>.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus status = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus getStatus() {
    com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus result = com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commissionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, commissionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, orderId_);
    }
    if (hotelCenterId_ != 0L) {
      output.writeInt64(4, hotelCenterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hotelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, hotelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkInDate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, checkInDate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkOutDate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, checkOutDate_);
    }
    if (reconciledValueMicros_ != 0L) {
      output.writeInt64(8, reconciledValueMicros_);
    }
    if (billed_ != false) {
      output.writeBool(9, billed_);
    }
    if (status_ != com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(10, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(campaign_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, campaign_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commissionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, commissionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, orderId_);
    }
    if (hotelCenterId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(4, hotelCenterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hotelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, hotelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkInDate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, checkInDate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkOutDate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, checkOutDate_);
    }
    if (reconciledValueMicros_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(8, reconciledValueMicros_);
    }
    if (billed_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(9, billed_);
    }
    if (status_ != com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(10, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(campaign_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, campaign_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v17.resources.HotelReconciliation)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v17.resources.HotelReconciliation other = (com.google.ads.googleads.v17.resources.HotelReconciliation) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (!getCommissionId()
        .equals(other.getCommissionId())) return false;
    if (!getOrderId()
        .equals(other.getOrderId())) return false;
    if (!getCampaign()
        .equals(other.getCampaign())) return false;
    if (getHotelCenterId()
        != other.getHotelCenterId()) return false;
    if (!getHotelId()
        .equals(other.getHotelId())) return false;
    if (!getCheckInDate()
        .equals(other.getCheckInDate())) return false;
    if (!getCheckOutDate()
        .equals(other.getCheckOutDate())) return false;
    if (getReconciledValueMicros()
        != other.getReconciledValueMicros()) return false;
    if (getBilled()
        != other.getBilled()) return false;
    if (status_ != other.status_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + COMMISSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCommissionId().hashCode();
    hash = (37 * hash) + ORDER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOrderId().hashCode();
    hash = (37 * hash) + CAMPAIGN_FIELD_NUMBER;
    hash = (53 * hash) + getCampaign().hashCode();
    hash = (37 * hash) + HOTEL_CENTER_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getHotelCenterId());
    hash = (37 * hash) + HOTEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getHotelId().hashCode();
    hash = (37 * hash) + CHECK_IN_DATE_FIELD_NUMBER;
    hash = (53 * hash) + getCheckInDate().hashCode();
    hash = (37 * hash) + CHECK_OUT_DATE_FIELD_NUMBER;
    hash = (53 * hash) + getCheckOutDate().hashCode();
    hash = (37 * hash) + RECONCILED_VALUE_MICROS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getReconciledValueMicros());
    hash = (37 * hash) + BILLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getBilled());
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v17.resources.HotelReconciliation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v17.resources.HotelReconciliation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A hotel reconciliation. It contains conversion information from Hotel
   * bookings to reconcile with advertiser records. These rows may be updated
   * or canceled before billing through Bulk Uploads.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v17.resources.HotelReconciliation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v17.resources.HotelReconciliation)
      com.google.ads.googleads.v17.resources.HotelReconciliationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v17.resources.HotelReconciliationProto.internal_static_google_ads_googleads_v17_resources_HotelReconciliation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v17.resources.HotelReconciliationProto.internal_static_google_ads_googleads_v17_resources_HotelReconciliation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v17.resources.HotelReconciliation.class, com.google.ads.googleads.v17.resources.HotelReconciliation.Builder.class);
    }

    // Construct using com.google.ads.googleads.v17.resources.HotelReconciliation.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      commissionId_ = "";
      orderId_ = "";
      campaign_ = "";
      hotelCenterId_ = 0L;
      hotelId_ = "";
      checkInDate_ = "";
      checkOutDate_ = "";
      reconciledValueMicros_ = 0L;
      billed_ = false;
      status_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v17.resources.HotelReconciliationProto.internal_static_google_ads_googleads_v17_resources_HotelReconciliation_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.HotelReconciliation getDefaultInstanceForType() {
      return com.google.ads.googleads.v17.resources.HotelReconciliation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.HotelReconciliation build() {
      com.google.ads.googleads.v17.resources.HotelReconciliation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v17.resources.HotelReconciliation buildPartial() {
      com.google.ads.googleads.v17.resources.HotelReconciliation result = new com.google.ads.googleads.v17.resources.HotelReconciliation(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v17.resources.HotelReconciliation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.commissionId_ = commissionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.orderId_ = orderId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.campaign_ = campaign_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.hotelCenterId_ = hotelCenterId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.hotelId_ = hotelId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.checkInDate_ = checkInDate_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.checkOutDate_ = checkOutDate_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.reconciledValueMicros_ = reconciledValueMicros_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.billed_ = billed_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.status_ = status_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v17.resources.HotelReconciliation) {
        return mergeFrom((com.google.ads.googleads.v17.resources.HotelReconciliation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v17.resources.HotelReconciliation other) {
      if (other == com.google.ads.googleads.v17.resources.HotelReconciliation.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCommissionId().isEmpty()) {
        commissionId_ = other.commissionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getOrderId().isEmpty()) {
        orderId_ = other.orderId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getCampaign().isEmpty()) {
        campaign_ = other.campaign_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getHotelCenterId() != 0L) {
        setHotelCenterId(other.getHotelCenterId());
      }
      if (!other.getHotelId().isEmpty()) {
        hotelId_ = other.hotelId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getCheckInDate().isEmpty()) {
        checkInDate_ = other.checkInDate_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getCheckOutDate().isEmpty()) {
        checkOutDate_ = other.checkOutDate_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getReconciledValueMicros() != 0L) {
        setReconciledValueMicros(other.getReconciledValueMicros());
      }
      if (other.getBilled() != false) {
        setBilled(other.getBilled());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              commissionId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 26: {
              orderId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 26
            case 32: {
              hotelCenterId_ = input.readInt64();
              bitField0_ |= 0x00000010;
              break;
            } // case 32
            case 42: {
              hotelId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000020;
              break;
            } // case 42
            case 50: {
              checkInDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000040;
              break;
            } // case 50
            case 58: {
              checkOutDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 58
            case 64: {
              reconciledValueMicros_ = input.readInt64();
              bitField0_ |= 0x00000100;
              break;
            } // case 64
            case 72: {
              billed_ = input.readBool();
              bitField0_ |= 0x00000200;
              break;
            } // case 72
            case 80: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000400;
              break;
            } // case 80
            case 90: {
              campaign_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 90
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the hotel reconciliation.
     * Hotel reconciliation resource names have the form:
     *
     * `customers/{customer_id}/hotelReconciliations/{commission_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the hotel reconciliation.
     * Hotel reconciliation resource names have the form:
     *
     * `customers/{customer_id}/hotelReconciliations/{commission_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the hotel reconciliation.
     * Hotel reconciliation resource names have the form:
     *
     * `customers/{customer_id}/hotelReconciliations/{commission_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the hotel reconciliation.
     * Hotel reconciliation resource names have the form:
     *
     * `customers/{customer_id}/hotelReconciliations/{commission_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the hotel reconciliation.
     * Hotel reconciliation resource names have the form:
     *
     * `customers/{customer_id}/hotelReconciliations/{commission_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object commissionId_ = "";
    /**
     * <pre>
     * Required. Output only. The commission ID is Google's ID for this booking.
     * Every booking event is assigned a Commission ID to help you match it to a
     * guest stay.
     * </pre>
     *
     * <code>string commission_id = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The commissionId.
     */
    public java.lang.String getCommissionId() {
      java.lang.Object ref = commissionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        commissionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Required. Output only. The commission ID is Google's ID for this booking.
     * Every booking event is assigned a Commission ID to help you match it to a
     * guest stay.
     * </pre>
     *
     * <code>string commission_id = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for commissionId.
     */
    public com.google.protobuf.ByteString
        getCommissionIdBytes() {
      java.lang.Object ref = commissionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        commissionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Required. Output only. The commission ID is Google's ID for this booking.
     * Every booking event is assigned a Commission ID to help you match it to a
     * guest stay.
     * </pre>
     *
     * <code>string commission_id = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The commissionId to set.
     * @return This builder for chaining.
     */
    public Builder setCommissionId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      commissionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. Output only. The commission ID is Google's ID for this booking.
     * Every booking event is assigned a Commission ID to help you match it to a
     * guest stay.
     * </pre>
     *
     * <code>string commission_id = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCommissionId() {
      commissionId_ = getDefaultInstance().getCommissionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. Output only. The commission ID is Google's ID for this booking.
     * Every booking event is assigned a Commission ID to help you match it to a
     * guest stay.
     * </pre>
     *
     * <code>string commission_id = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for commissionId to set.
     * @return This builder for chaining.
     */
    public Builder setCommissionIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      commissionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object orderId_ = "";
    /**
     * <pre>
     * Output only. The order ID is the identifier for this booking as provided in
     * the 'transaction_id' parameter of the conversion tracking tag.
     * </pre>
     *
     * <code>string order_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The orderId.
     */
    public java.lang.String getOrderId() {
      java.lang.Object ref = orderId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The order ID is the identifier for this booking as provided in
     * the 'transaction_id' parameter of the conversion tracking tag.
     * </pre>
     *
     * <code>string order_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for orderId.
     */
    public com.google.protobuf.ByteString
        getOrderIdBytes() {
      java.lang.Object ref = orderId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        orderId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The order ID is the identifier for this booking as provided in
     * the 'transaction_id' parameter of the conversion tracking tag.
     * </pre>
     *
     * <code>string order_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The orderId to set.
     * @return This builder for chaining.
     */
    public Builder setOrderId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      orderId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The order ID is the identifier for this booking as provided in
     * the 'transaction_id' parameter of the conversion tracking tag.
     * </pre>
     *
     * <code>string order_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearOrderId() {
      orderId_ = getDefaultInstance().getOrderId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The order ID is the identifier for this booking as provided in
     * the 'transaction_id' parameter of the conversion tracking tag.
     * </pre>
     *
     * <code>string order_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for orderId to set.
     * @return This builder for chaining.
     */
    public Builder setOrderIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      orderId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object campaign_ = "";
    /**
     * <pre>
     * Output only. The resource name for the Campaign associated with the
     * conversion.
     * </pre>
     *
     * <code>string campaign = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The campaign.
     */
    public java.lang.String getCampaign() {
      java.lang.Object ref = campaign_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaign_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name for the Campaign associated with the
     * conversion.
     * </pre>
     *
     * <code>string campaign = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for campaign.
     */
    public com.google.protobuf.ByteString
        getCampaignBytes() {
      java.lang.Object ref = campaign_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaign_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name for the Campaign associated with the
     * conversion.
     * </pre>
     *
     * <code>string campaign = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The campaign to set.
     * @return This builder for chaining.
     */
    public Builder setCampaign(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      campaign_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name for the Campaign associated with the
     * conversion.
     * </pre>
     *
     * <code>string campaign = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCampaign() {
      campaign_ = getDefaultInstance().getCampaign();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name for the Campaign associated with the
     * conversion.
     * </pre>
     *
     * <code>string campaign = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for campaign to set.
     * @return This builder for chaining.
     */
    public Builder setCampaignBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      campaign_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long hotelCenterId_ ;
    /**
     * <pre>
     * Output only. Identifier for the Hotel Center account which provides the
     * rates for the Hotel campaign.
     * </pre>
     *
     * <code>int64 hotel_center_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The hotelCenterId.
     */
    @java.lang.Override
    public long getHotelCenterId() {
      return hotelCenterId_;
    }
    /**
     * <pre>
     * Output only. Identifier for the Hotel Center account which provides the
     * rates for the Hotel campaign.
     * </pre>
     *
     * <code>int64 hotel_center_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The hotelCenterId to set.
     * @return This builder for chaining.
     */
    public Builder setHotelCenterId(long value) {

      hotelCenterId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Identifier for the Hotel Center account which provides the
     * rates for the Hotel campaign.
     * </pre>
     *
     * <code>int64 hotel_center_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearHotelCenterId() {
      bitField0_ = (bitField0_ & ~0x00000010);
      hotelCenterId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object hotelId_ = "";
    /**
     * <pre>
     * Output only. Unique identifier for the booked property, as provided in the
     * Hotel Center feed. The hotel ID comes from the 'ID' parameter of the
     * conversion tracking tag.
     * </pre>
     *
     * <code>string hotel_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The hotelId.
     */
    public java.lang.String getHotelId() {
      java.lang.Object ref = hotelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hotelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Unique identifier for the booked property, as provided in the
     * Hotel Center feed. The hotel ID comes from the 'ID' parameter of the
     * conversion tracking tag.
     * </pre>
     *
     * <code>string hotel_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for hotelId.
     */
    public com.google.protobuf.ByteString
        getHotelIdBytes() {
      java.lang.Object ref = hotelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        hotelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Unique identifier for the booked property, as provided in the
     * Hotel Center feed. The hotel ID comes from the 'ID' parameter of the
     * conversion tracking tag.
     * </pre>
     *
     * <code>string hotel_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The hotelId to set.
     * @return This builder for chaining.
     */
    public Builder setHotelId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      hotelId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Unique identifier for the booked property, as provided in the
     * Hotel Center feed. The hotel ID comes from the 'ID' parameter of the
     * conversion tracking tag.
     * </pre>
     *
     * <code>string hotel_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearHotelId() {
      hotelId_ = getDefaultInstance().getHotelId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Unique identifier for the booked property, as provided in the
     * Hotel Center feed. The hotel ID comes from the 'ID' parameter of the
     * conversion tracking tag.
     * </pre>
     *
     * <code>string hotel_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for hotelId to set.
     * @return This builder for chaining.
     */
    public Builder setHotelIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      hotelId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object checkInDate_ = "";
    /**
     * <pre>
     * Output only. Check-in date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_in_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The checkInDate.
     */
    public java.lang.String getCheckInDate() {
      java.lang.Object ref = checkInDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        checkInDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Check-in date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_in_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for checkInDate.
     */
    public com.google.protobuf.ByteString
        getCheckInDateBytes() {
      java.lang.Object ref = checkInDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        checkInDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Check-in date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_in_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The checkInDate to set.
     * @return This builder for chaining.
     */
    public Builder setCheckInDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      checkInDate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Check-in date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_in_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCheckInDate() {
      checkInDate_ = getDefaultInstance().getCheckInDate();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Check-in date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_in_date = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for checkInDate to set.
     * @return This builder for chaining.
     */
    public Builder setCheckInDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      checkInDate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object checkOutDate_ = "";
    /**
     * <pre>
     * Output only. Check-out date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_out_date = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The checkOutDate.
     */
    public java.lang.String getCheckOutDate() {
      java.lang.Object ref = checkOutDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        checkOutDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Check-out date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_out_date = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for checkOutDate.
     */
    public com.google.protobuf.ByteString
        getCheckOutDateBytes() {
      java.lang.Object ref = checkOutDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        checkOutDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Check-out date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_out_date = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The checkOutDate to set.
     * @return This builder for chaining.
     */
    public Builder setCheckOutDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      checkOutDate_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Check-out date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_out_date = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCheckOutDate() {
      checkOutDate_ = getDefaultInstance().getCheckOutDate();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Check-out date recorded when the booking is made. If the
     * check-in date is modified at reconciliation, the revised date will then
     * take the place of the original date in this column. Format is YYYY-MM-DD.
     * </pre>
     *
     * <code>string check_out_date = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for checkOutDate to set.
     * @return This builder for chaining.
     */
    public Builder setCheckOutDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      checkOutDate_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private long reconciledValueMicros_ ;
    /**
     * <pre>
     * Required. Output only. Reconciled value is the final value of a booking as
     * paid by the guest. If original booking value changes for any reason, such
     * as itinerary changes or room upsells, the reconciled value should be the
     * full final amount collected. If a booking is canceled, the reconciled value
     * should include the value of any cancellation fees or non-refundable nights
     * charged. Value is in millionths of the base unit currency. For example,
     * $12.35 would be represented as 12350000. Currency unit is in the default
     * customer currency.
     * </pre>
     *
     * <code>int64 reconciled_value_micros = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The reconciledValueMicros.
     */
    @java.lang.Override
    public long getReconciledValueMicros() {
      return reconciledValueMicros_;
    }
    /**
     * <pre>
     * Required. Output only. Reconciled value is the final value of a booking as
     * paid by the guest. If original booking value changes for any reason, such
     * as itinerary changes or room upsells, the reconciled value should be the
     * full final amount collected. If a booking is canceled, the reconciled value
     * should include the value of any cancellation fees or non-refundable nights
     * charged. Value is in millionths of the base unit currency. For example,
     * $12.35 would be represented as 12350000. Currency unit is in the default
     * customer currency.
     * </pre>
     *
     * <code>int64 reconciled_value_micros = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The reconciledValueMicros to set.
     * @return This builder for chaining.
     */
    public Builder setReconciledValueMicros(long value) {

      reconciledValueMicros_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. Output only. Reconciled value is the final value of a booking as
     * paid by the guest. If original booking value changes for any reason, such
     * as itinerary changes or room upsells, the reconciled value should be the
     * full final amount collected. If a booking is canceled, the reconciled value
     * should include the value of any cancellation fees or non-refundable nights
     * charged. Value is in millionths of the base unit currency. For example,
     * $12.35 would be represented as 12350000. Currency unit is in the default
     * customer currency.
     * </pre>
     *
     * <code>int64 reconciled_value_micros = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearReconciledValueMicros() {
      bitField0_ = (bitField0_ & ~0x00000100);
      reconciledValueMicros_ = 0L;
      onChanged();
      return this;
    }

    private boolean billed_ ;
    /**
     * <pre>
     * Output only. Whether a given booking has been billed. Once billed, a
     * booking can't be modified.
     * </pre>
     *
     * <code>bool billed = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The billed.
     */
    @java.lang.Override
    public boolean getBilled() {
      return billed_;
    }
    /**
     * <pre>
     * Output only. Whether a given booking has been billed. Once billed, a
     * booking can't be modified.
     * </pre>
     *
     * <code>bool billed = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The billed to set.
     * @return This builder for chaining.
     */
    public Builder setBilled(boolean value) {

      billed_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Whether a given booking has been billed. Once billed, a
     * booking can't be modified.
     * </pre>
     *
     * <code>bool billed = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearBilled() {
      bitField0_ = (bitField0_ & ~0x00000200);
      billed_ = false;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Required. Output only. Current status of a booking with regards to
     * reconciliation and billing. Bookings should be reconciled within 45 days
     * after the check-out date. Any booking not reconciled within 45 days will be
     * billed at its original value.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus status = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Required. Output only. Current status of a booking with regards to
     * reconciliation and billing. Bookings should be reconciled within 45 days
     * after the check-out date. Any booking not reconciled within 45 days will be
     * billed at its original value.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus status = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. Output only. Current status of a booking with regards to
     * reconciliation and billing. Bookings should be reconciled within 45 days
     * after the check-out date. Any booking not reconciled within 45 days will be
     * billed at its original value.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus status = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus getStatus() {
      com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus result = com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Required. Output only. Current status of a booking with regards to
     * reconciliation and billing. Bookings should be reconciled within 45 days
     * after the check-out date. Any booking not reconciled within 45 days will be
     * billed at its original value.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus status = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. Output only. Current status of a booking with regards to
     * reconciliation and billing. Bookings should be reconciled within 45 days
     * after the check-out date. Any booking not reconciled within 45 days will be
     * billed at its original value.
     * </pre>
     *
     * <code>.google.ads.googleads.v17.enums.HotelReconciliationStatusEnum.HotelReconciliationStatus status = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000400);
      status_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v17.resources.HotelReconciliation)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v17.resources.HotelReconciliation)
  private static final com.google.ads.googleads.v17.resources.HotelReconciliation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v17.resources.HotelReconciliation();
  }

  public static com.google.ads.googleads.v17.resources.HotelReconciliation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HotelReconciliation>
      PARSER = new com.google.protobuf.AbstractParser<HotelReconciliation>() {
    @java.lang.Override
    public HotelReconciliation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<HotelReconciliation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HotelReconciliation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v17.resources.HotelReconciliation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

