/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.common.Consent;
import com.google.ads.googleads.v17.common.ConsentOrBuilder;
import com.google.ads.googleads.v17.common.UserIdentifier;
import com.google.ads.googleads.v17.common.UserIdentifierOrBuilder;
import com.google.ads.googleads.v17.enums.ConversionEnvironmentEnum;
import com.google.ads.googleads.v17.services.CartData;
import com.google.ads.googleads.v17.services.CartDataOrBuilder;
import com.google.ads.googleads.v17.services.ClickConversionOrBuilder;
import com.google.ads.googleads.v17.services.ConversionUploadServiceProto;
import com.google.ads.googleads.v17.services.CustomVariable;
import com.google.ads.googleads.v17.services.CustomVariableOrBuilder;
import com.google.ads.googleads.v17.services.ExternalAttributionData;
import com.google.ads.googleads.v17.services.ExternalAttributionDataOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ClickConversion
extends GeneratedMessageV3
implements ClickConversionOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int GCLID_FIELD_NUMBER = 9;
    private volatile Object gclid_ = "";
    public static final int GBRAID_FIELD_NUMBER = 18;
    private volatile Object gbraid_ = "";
    public static final int WBRAID_FIELD_NUMBER = 19;
    private volatile Object wbraid_ = "";
    public static final int CONVERSION_ACTION_FIELD_NUMBER = 10;
    private volatile Object conversionAction_ = "";
    public static final int CONVERSION_DATE_TIME_FIELD_NUMBER = 11;
    private volatile Object conversionDateTime_ = "";
    public static final int CONVERSION_VALUE_FIELD_NUMBER = 12;
    private double conversionValue_ = 0.0;
    public static final int CURRENCY_CODE_FIELD_NUMBER = 13;
    private volatile Object currencyCode_ = "";
    public static final int ORDER_ID_FIELD_NUMBER = 14;
    private volatile Object orderId_ = "";
    public static final int EXTERNAL_ATTRIBUTION_DATA_FIELD_NUMBER = 7;
    private ExternalAttributionData externalAttributionData_;
    public static final int CUSTOM_VARIABLES_FIELD_NUMBER = 15;
    private List<CustomVariable> customVariables_;
    public static final int CART_DATA_FIELD_NUMBER = 16;
    private CartData cartData_;
    public static final int USER_IDENTIFIERS_FIELD_NUMBER = 17;
    private List<UserIdentifier> userIdentifiers_;
    public static final int CONVERSION_ENVIRONMENT_FIELD_NUMBER = 20;
    private int conversionEnvironment_ = 0;
    public static final int CONSENT_FIELD_NUMBER = 23;
    private Consent consent_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ClickConversion DEFAULT_INSTANCE = new ClickConversion();
    private static final Parser<ClickConversion> PARSER = new AbstractParser<ClickConversion>(){

        public ClickConversion parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ClickConversion.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ClickConversion(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ClickConversion() {
        this.gclid_ = "";
        this.gbraid_ = "";
        this.wbraid_ = "";
        this.conversionAction_ = "";
        this.conversionDateTime_ = "";
        this.currencyCode_ = "";
        this.orderId_ = "";
        this.customVariables_ = Collections.emptyList();
        this.userIdentifiers_ = Collections.emptyList();
        this.conversionEnvironment_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ClickConversion();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ConversionUploadServiceProto.internal_static_google_ads_googleads_v17_services_ClickConversion_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ConversionUploadServiceProto.internal_static_google_ads_googleads_v17_services_ClickConversion_fieldAccessorTable.ensureFieldAccessorsInitialized(ClickConversion.class, Builder.class);
    }

    @Override
    public boolean hasGclid() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getGclid() {
        Object ref = this.gclid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.gclid_ = s;
        return s;
    }

    @Override
    public ByteString getGclidBytes() {
        Object ref = this.gclid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.gclid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getGbraid() {
        Object ref = this.gbraid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.gbraid_ = s;
        return s;
    }

    @Override
    public ByteString getGbraidBytes() {
        Object ref = this.gbraid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.gbraid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getWbraid() {
        Object ref = this.wbraid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.wbraid_ = s;
        return s;
    }

    @Override
    public ByteString getWbraidBytes() {
        Object ref = this.wbraid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.wbraid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasConversionAction() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getConversionAction() {
        Object ref = this.conversionAction_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.conversionAction_ = s;
        return s;
    }

    @Override
    public ByteString getConversionActionBytes() {
        Object ref = this.conversionAction_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.conversionAction_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasConversionDateTime() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getConversionDateTime() {
        Object ref = this.conversionDateTime_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.conversionDateTime_ = s;
        return s;
    }

    @Override
    public ByteString getConversionDateTimeBytes() {
        Object ref = this.conversionDateTime_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.conversionDateTime_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasConversionValue() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public double getConversionValue() {
        return this.conversionValue_;
    }

    @Override
    public boolean hasCurrencyCode() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public String getCurrencyCode() {
        Object ref = this.currencyCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.currencyCode_ = s;
        return s;
    }

    @Override
    public ByteString getCurrencyCodeBytes() {
        Object ref = this.currencyCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.currencyCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasOrderId() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public String getOrderId() {
        Object ref = this.orderId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orderId_ = s;
        return s;
    }

    @Override
    public ByteString getOrderIdBytes() {
        Object ref = this.orderId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orderId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasExternalAttributionData() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public ExternalAttributionData getExternalAttributionData() {
        return this.externalAttributionData_ == null ? ExternalAttributionData.getDefaultInstance() : this.externalAttributionData_;
    }

    @Override
    public ExternalAttributionDataOrBuilder getExternalAttributionDataOrBuilder() {
        return this.externalAttributionData_ == null ? ExternalAttributionData.getDefaultInstance() : this.externalAttributionData_;
    }

    @Override
    public List<CustomVariable> getCustomVariablesList() {
        return this.customVariables_;
    }

    @Override
    public List<? extends CustomVariableOrBuilder> getCustomVariablesOrBuilderList() {
        return this.customVariables_;
    }

    @Override
    public int getCustomVariablesCount() {
        return this.customVariables_.size();
    }

    @Override
    public CustomVariable getCustomVariables(int index) {
        return this.customVariables_.get(index);
    }

    @Override
    public CustomVariableOrBuilder getCustomVariablesOrBuilder(int index) {
        return this.customVariables_.get(index);
    }

    @Override
    public boolean hasCartData() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public CartData getCartData() {
        return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
    }

    @Override
    public CartDataOrBuilder getCartDataOrBuilder() {
        return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
    }

    @Override
    public List<UserIdentifier> getUserIdentifiersList() {
        return this.userIdentifiers_;
    }

    @Override
    public List<? extends UserIdentifierOrBuilder> getUserIdentifiersOrBuilderList() {
        return this.userIdentifiers_;
    }

    @Override
    public int getUserIdentifiersCount() {
        return this.userIdentifiers_.size();
    }

    @Override
    public UserIdentifier getUserIdentifiers(int index) {
        return this.userIdentifiers_.get(index);
    }

    @Override
    public UserIdentifierOrBuilder getUserIdentifiersOrBuilder(int index) {
        return this.userIdentifiers_.get(index);
    }

    @Override
    public int getConversionEnvironmentValue() {
        return this.conversionEnvironment_;
    }

    @Override
    public ConversionEnvironmentEnum.ConversionEnvironment getConversionEnvironment() {
        ConversionEnvironmentEnum.ConversionEnvironment result = ConversionEnvironmentEnum.ConversionEnvironment.forNumber(this.conversionEnvironment_);
        return result == null ? ConversionEnvironmentEnum.ConversionEnvironment.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasConsent() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public Consent getConsent() {
        return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
    }

    @Override
    public ConsentOrBuilder getConsentOrBuilder() {
        return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(7, (MessageLite)this.getExternalAttributionData());
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.gclid_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.conversionAction_);
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.conversionDateTime_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeDouble(12, this.conversionValue_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.currencyCode_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.orderId_);
        }
        for (i = 0; i < this.customVariables_.size(); ++i) {
            output.writeMessage(15, (MessageLite)this.customVariables_.get(i));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(16, (MessageLite)this.getCartData());
        }
        for (i = 0; i < this.userIdentifiers_.size(); ++i) {
            output.writeMessage(17, (MessageLite)this.userIdentifiers_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.gbraid_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.gbraid_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.wbraid_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.wbraid_);
        }
        if (this.conversionEnvironment_ != ConversionEnvironmentEnum.ConversionEnvironment.UNSPECIFIED.getNumber()) {
            output.writeEnum(20, this.conversionEnvironment_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeMessage(23, (MessageLite)this.getConsent());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getExternalAttributionData());
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.gclid_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.conversionAction_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.conversionDateTime_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)12, (double)this.conversionValue_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.currencyCode_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.orderId_);
        }
        for (i = 0; i < this.customVariables_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)((MessageLite)this.customVariables_.get(i)));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)16, (MessageLite)this.getCartData());
        }
        for (i = 0; i < this.userIdentifiers_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)((MessageLite)this.userIdentifiers_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.gbraid_)) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.gbraid_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.wbraid_)) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.wbraid_);
        }
        if (this.conversionEnvironment_ != ConversionEnvironmentEnum.ConversionEnvironment.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)20, (int)this.conversionEnvironment_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeMessageSize((int)23, (MessageLite)this.getConsent());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClickConversion)) {
            return super.equals(obj);
        }
        ClickConversion other = (ClickConversion)obj;
        if (this.hasGclid() != other.hasGclid()) {
            return false;
        }
        if (this.hasGclid() && !this.getGclid().equals(other.getGclid())) {
            return false;
        }
        if (!this.getGbraid().equals(other.getGbraid())) {
            return false;
        }
        if (!this.getWbraid().equals(other.getWbraid())) {
            return false;
        }
        if (this.hasConversionAction() != other.hasConversionAction()) {
            return false;
        }
        if (this.hasConversionAction() && !this.getConversionAction().equals(other.getConversionAction())) {
            return false;
        }
        if (this.hasConversionDateTime() != other.hasConversionDateTime()) {
            return false;
        }
        if (this.hasConversionDateTime() && !this.getConversionDateTime().equals(other.getConversionDateTime())) {
            return false;
        }
        if (this.hasConversionValue() != other.hasConversionValue()) {
            return false;
        }
        if (this.hasConversionValue() && Double.doubleToLongBits(this.getConversionValue()) != Double.doubleToLongBits(other.getConversionValue())) {
            return false;
        }
        if (this.hasCurrencyCode() != other.hasCurrencyCode()) {
            return false;
        }
        if (this.hasCurrencyCode() && !this.getCurrencyCode().equals(other.getCurrencyCode())) {
            return false;
        }
        if (this.hasOrderId() != other.hasOrderId()) {
            return false;
        }
        if (this.hasOrderId() && !this.getOrderId().equals(other.getOrderId())) {
            return false;
        }
        if (this.hasExternalAttributionData() != other.hasExternalAttributionData()) {
            return false;
        }
        if (this.hasExternalAttributionData() && !this.getExternalAttributionData().equals(other.getExternalAttributionData())) {
            return false;
        }
        if (!this.getCustomVariablesList().equals(other.getCustomVariablesList())) {
            return false;
        }
        if (this.hasCartData() != other.hasCartData()) {
            return false;
        }
        if (this.hasCartData() && !this.getCartData().equals(other.getCartData())) {
            return false;
        }
        if (!this.getUserIdentifiersList().equals(other.getUserIdentifiersList())) {
            return false;
        }
        if (this.conversionEnvironment_ != other.conversionEnvironment_) {
            return false;
        }
        if (this.hasConsent() != other.hasConsent()) {
            return false;
        }
        if (this.hasConsent() && !this.getConsent().equals(other.getConsent())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ClickConversion.getDescriptor().hashCode();
        if (this.hasGclid()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getGclid().hashCode();
        }
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getGbraid().hashCode();
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getWbraid().hashCode();
        if (this.hasConversionAction()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getConversionAction().hashCode();
        }
        if (this.hasConversionDateTime()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getConversionDateTime().hashCode();
        }
        if (this.hasConversionValue()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getConversionValue()));
        }
        if (this.hasCurrencyCode()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getCurrencyCode().hashCode();
        }
        if (this.hasOrderId()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getOrderId().hashCode();
        }
        if (this.hasExternalAttributionData()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getExternalAttributionData().hashCode();
        }
        if (this.getCustomVariablesCount() > 0) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getCustomVariablesList().hashCode();
        }
        if (this.hasCartData()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getCartData().hashCode();
        }
        if (this.getUserIdentifiersCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getUserIdentifiersList().hashCode();
        }
        hash = 37 * hash + 20;
        hash = 53 * hash + this.conversionEnvironment_;
        if (this.hasConsent()) {
            hash = 37 * hash + 23;
            hash = 53 * hash + this.getConsent().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ClickConversion parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ClickConversion)PARSER.parseFrom(data);
    }

    public static ClickConversion parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ClickConversion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ClickConversion parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ClickConversion)PARSER.parseFrom(data);
    }

    public static ClickConversion parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ClickConversion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ClickConversion parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ClickConversion)PARSER.parseFrom(data);
    }

    public static ClickConversion parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ClickConversion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ClickConversion parseFrom(InputStream input) throws IOException {
        return (ClickConversion)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ClickConversion parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ClickConversion)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ClickConversion parseDelimitedFrom(InputStream input) throws IOException {
        return (ClickConversion)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ClickConversion parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ClickConversion)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ClickConversion parseFrom(CodedInputStream input) throws IOException {
        return (ClickConversion)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ClickConversion parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ClickConversion)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ClickConversion.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ClickConversion prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ClickConversion getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ClickConversion> parser() {
        return PARSER;
    }

    public Parser<ClickConversion> getParserForType() {
        return PARSER;
    }

    public ClickConversion getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ClickConversionOrBuilder {
        private int bitField0_;
        private Object gclid_ = "";
        private Object gbraid_ = "";
        private Object wbraid_ = "";
        private Object conversionAction_ = "";
        private Object conversionDateTime_ = "";
        private double conversionValue_;
        private Object currencyCode_ = "";
        private Object orderId_ = "";
        private ExternalAttributionData externalAttributionData_;
        private SingleFieldBuilderV3<ExternalAttributionData, ExternalAttributionData.Builder, ExternalAttributionDataOrBuilder> externalAttributionDataBuilder_;
        private List<CustomVariable> customVariables_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<CustomVariable, CustomVariable.Builder, CustomVariableOrBuilder> customVariablesBuilder_;
        private CartData cartData_;
        private SingleFieldBuilderV3<CartData, CartData.Builder, CartDataOrBuilder> cartDataBuilder_;
        private List<UserIdentifier> userIdentifiers_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<UserIdentifier, UserIdentifier.Builder, UserIdentifierOrBuilder> userIdentifiersBuilder_;
        private int conversionEnvironment_ = 0;
        private Consent consent_;
        private SingleFieldBuilderV3<Consent, Consent.Builder, ConsentOrBuilder> consentBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ConversionUploadServiceProto.internal_static_google_ads_googleads_v17_services_ClickConversion_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ConversionUploadServiceProto.internal_static_google_ads_googleads_v17_services_ClickConversion_fieldAccessorTable.ensureFieldAccessorsInitialized(ClickConversion.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getExternalAttributionDataFieldBuilder();
                this.getCustomVariablesFieldBuilder();
                this.getCartDataFieldBuilder();
                this.getUserIdentifiersFieldBuilder();
                this.getConsentFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.gclid_ = "";
            this.gbraid_ = "";
            this.wbraid_ = "";
            this.conversionAction_ = "";
            this.conversionDateTime_ = "";
            this.conversionValue_ = 0.0;
            this.currencyCode_ = "";
            this.orderId_ = "";
            this.externalAttributionData_ = null;
            if (this.externalAttributionDataBuilder_ != null) {
                this.externalAttributionDataBuilder_.dispose();
                this.externalAttributionDataBuilder_ = null;
            }
            if (this.customVariablesBuilder_ == null) {
                this.customVariables_ = Collections.emptyList();
            } else {
                this.customVariables_ = null;
                this.customVariablesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.cartData_ = null;
            if (this.cartDataBuilder_ != null) {
                this.cartDataBuilder_.dispose();
                this.cartDataBuilder_ = null;
            }
            if (this.userIdentifiersBuilder_ == null) {
                this.userIdentifiers_ = Collections.emptyList();
            } else {
                this.userIdentifiers_ = null;
                this.userIdentifiersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFF7FF;
            this.conversionEnvironment_ = 0;
            this.consent_ = null;
            if (this.consentBuilder_ != null) {
                this.consentBuilder_.dispose();
                this.consentBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ConversionUploadServiceProto.internal_static_google_ads_googleads_v17_services_ClickConversion_descriptor;
        }

        public ClickConversion getDefaultInstanceForType() {
            return ClickConversion.getDefaultInstance();
        }

        public ClickConversion build() {
            ClickConversion result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ClickConversion buildPartial() {
            ClickConversion result = new ClickConversion(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ClickConversion result) {
            if (this.customVariablesBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.customVariables_ = Collections.unmodifiableList(this.customVariables_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.customVariables_ = this.customVariables_;
            } else {
                result.customVariables_ = this.customVariablesBuilder_.build();
            }
            if (this.userIdentifiersBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0) {
                    this.userIdentifiers_ = Collections.unmodifiableList(this.userIdentifiers_);
                    this.bitField0_ &= 0xFFFFF7FF;
                }
                result.userIdentifiers_ = this.userIdentifiers_;
            } else {
                result.userIdentifiers_ = this.userIdentifiersBuilder_.build();
            }
        }

        private void buildPartial0(ClickConversion result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.gclid_ = this.gclid_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.gbraid_ = this.gbraid_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.wbraid_ = this.wbraid_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.conversionAction_ = this.conversionAction_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.conversionDateTime_ = this.conversionDateTime_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.conversionValue_ = this.conversionValue_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.currencyCode_ = this.currencyCode_;
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.orderId_ = this.orderId_;
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.externalAttributionData_ = this.externalAttributionDataBuilder_ == null ? this.externalAttributionData_ : (ExternalAttributionData)this.externalAttributionDataBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.cartData_ = this.cartDataBuilder_ == null ? this.cartData_ : (CartData)this.cartDataBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.conversionEnvironment_ = this.conversionEnvironment_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.consent_ = this.consentBuilder_ == null ? this.consent_ : (Consent)this.consentBuilder_.build();
                to_bitField0_ |= 0x100;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ClickConversion) {
                return this.mergeFrom((ClickConversion)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ClickConversion other) {
            if (other == ClickConversion.getDefaultInstance()) {
                return this;
            }
            if (other.hasGclid()) {
                this.gclid_ = other.gclid_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getGbraid().isEmpty()) {
                this.gbraid_ = other.gbraid_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getWbraid().isEmpty()) {
                this.wbraid_ = other.wbraid_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.hasConversionAction()) {
                this.conversionAction_ = other.conversionAction_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.hasConversionDateTime()) {
                this.conversionDateTime_ = other.conversionDateTime_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasConversionValue()) {
                this.setConversionValue(other.getConversionValue());
            }
            if (other.hasCurrencyCode()) {
                this.currencyCode_ = other.currencyCode_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.hasOrderId()) {
                this.orderId_ = other.orderId_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (other.hasExternalAttributionData()) {
                this.mergeExternalAttributionData(other.getExternalAttributionData());
            }
            if (this.customVariablesBuilder_ == null) {
                if (!other.customVariables_.isEmpty()) {
                    if (this.customVariables_.isEmpty()) {
                        this.customVariables_ = other.customVariables_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureCustomVariablesIsMutable();
                        this.customVariables_.addAll(other.customVariables_);
                    }
                    this.onChanged();
                }
            } else if (!other.customVariables_.isEmpty()) {
                if (this.customVariablesBuilder_.isEmpty()) {
                    this.customVariablesBuilder_.dispose();
                    this.customVariablesBuilder_ = null;
                    this.customVariables_ = other.customVariables_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.customVariablesBuilder_ = alwaysUseFieldBuilders ? this.getCustomVariablesFieldBuilder() : null;
                } else {
                    this.customVariablesBuilder_.addAllMessages((Iterable)other.customVariables_);
                }
            }
            if (other.hasCartData()) {
                this.mergeCartData(other.getCartData());
            }
            if (this.userIdentifiersBuilder_ == null) {
                if (!other.userIdentifiers_.isEmpty()) {
                    if (this.userIdentifiers_.isEmpty()) {
                        this.userIdentifiers_ = other.userIdentifiers_;
                        this.bitField0_ &= 0xFFFFF7FF;
                    } else {
                        this.ensureUserIdentifiersIsMutable();
                        this.userIdentifiers_.addAll(other.userIdentifiers_);
                    }
                    this.onChanged();
                }
            } else if (!other.userIdentifiers_.isEmpty()) {
                if (this.userIdentifiersBuilder_.isEmpty()) {
                    this.userIdentifiersBuilder_.dispose();
                    this.userIdentifiersBuilder_ = null;
                    this.userIdentifiers_ = other.userIdentifiers_;
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.userIdentifiersBuilder_ = alwaysUseFieldBuilders ? this.getUserIdentifiersFieldBuilder() : null;
                } else {
                    this.userIdentifiersBuilder_.addAllMessages((Iterable)other.userIdentifiers_);
                }
            }
            if (other.conversionEnvironment_ != 0) {
                this.setConversionEnvironmentValue(other.getConversionEnvironmentValue());
            }
            if (other.hasConsent()) {
                this.mergeConsent(other.getConsent());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getExternalAttributionDataFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block22;
                        }
                        case 74: {
                            this.gclid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block22;
                        }
                        case 82: {
                            this.conversionAction_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block22;
                        }
                        case 90: {
                            this.conversionDateTime_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 97: {
                            this.conversionValue_ = input.readDouble();
                            this.bitField0_ |= 0x20;
                            continue block22;
                        }
                        case 106: {
                            this.currencyCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block22;
                        }
                        case 114: {
                            this.orderId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block22;
                        }
                        case 122: {
                            GeneratedMessageV3 m = (CustomVariable)input.readMessage(CustomVariable.parser(), extensionRegistry);
                            if (this.customVariablesBuilder_ == null) {
                                this.ensureCustomVariablesIsMutable();
                                this.customVariables_.add((CustomVariable)m);
                                continue block22;
                            }
                            this.customVariablesBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                        case 130: {
                            input.readMessage((MessageLite.Builder)this.getCartDataFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block22;
                        }
                        case 138: {
                            GeneratedMessageV3 m = (UserIdentifier)input.readMessage(UserIdentifier.parser(), extensionRegistry);
                            if (this.userIdentifiersBuilder_ == null) {
                                this.ensureUserIdentifiersIsMutable();
                                this.userIdentifiers_.add((UserIdentifier)m);
                                continue block22;
                            }
                            this.userIdentifiersBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                        case 146: {
                            this.gbraid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block22;
                        }
                        case 154: {
                            this.wbraid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block22;
                        }
                        case 160: {
                            this.conversionEnvironment_ = input.readEnum();
                            this.bitField0_ |= 0x1000;
                            continue block22;
                        }
                        case 186: {
                            input.readMessage((MessageLite.Builder)this.getConsentFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasGclid() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getGclid() {
            Object ref = this.gclid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.gclid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getGclidBytes() {
            Object ref = this.gclid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.gclid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setGclid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.gclid_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearGclid() {
            this.gclid_ = ClickConversion.getDefaultInstance().getGclid();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setGclidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ClickConversion.checkByteStringIsUtf8((ByteString)value);
            this.gclid_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getGbraid() {
            Object ref = this.gbraid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.gbraid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getGbraidBytes() {
            Object ref = this.gbraid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.gbraid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setGbraid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.gbraid_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearGbraid() {
            this.gbraid_ = ClickConversion.getDefaultInstance().getGbraid();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setGbraidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ClickConversion.checkByteStringIsUtf8((ByteString)value);
            this.gbraid_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getWbraid() {
            Object ref = this.wbraid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.wbraid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getWbraidBytes() {
            Object ref = this.wbraid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.wbraid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setWbraid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.wbraid_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearWbraid() {
            this.wbraid_ = ClickConversion.getDefaultInstance().getWbraid();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setWbraidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ClickConversion.checkByteStringIsUtf8((ByteString)value);
            this.wbraid_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasConversionAction() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public String getConversionAction() {
            Object ref = this.conversionAction_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.conversionAction_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getConversionActionBytes() {
            Object ref = this.conversionAction_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.conversionAction_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setConversionAction(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.conversionAction_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearConversionAction() {
            this.conversionAction_ = ClickConversion.getDefaultInstance().getConversionAction();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setConversionActionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ClickConversion.checkByteStringIsUtf8((ByteString)value);
            this.conversionAction_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasConversionDateTime() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public String getConversionDateTime() {
            Object ref = this.conversionDateTime_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.conversionDateTime_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getConversionDateTimeBytes() {
            Object ref = this.conversionDateTime_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.conversionDateTime_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setConversionDateTime(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.conversionDateTime_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearConversionDateTime() {
            this.conversionDateTime_ = ClickConversion.getDefaultInstance().getConversionDateTime();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setConversionDateTimeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ClickConversion.checkByteStringIsUtf8((ByteString)value);
            this.conversionDateTime_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasConversionValue() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public double getConversionValue() {
            return this.conversionValue_;
        }

        public Builder setConversionValue(double value) {
            this.conversionValue_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearConversionValue() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.conversionValue_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCurrencyCode() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public String getCurrencyCode() {
            Object ref = this.currencyCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.currencyCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCurrencyCodeBytes() {
            Object ref = this.currencyCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.currencyCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCurrencyCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.currencyCode_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearCurrencyCode() {
            this.currencyCode_ = ClickConversion.getDefaultInstance().getCurrencyCode();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setCurrencyCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ClickConversion.checkByteStringIsUtf8((ByteString)value);
            this.currencyCode_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasOrderId() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public String getOrderId() {
            Object ref = this.orderId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orderId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrderIdBytes() {
            Object ref = this.orderId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orderId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrderId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orderId_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearOrderId() {
            this.orderId_ = ClickConversion.getDefaultInstance().getOrderId();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setOrderIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ClickConversion.checkByteStringIsUtf8((ByteString)value);
            this.orderId_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExternalAttributionData() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public ExternalAttributionData getExternalAttributionData() {
            if (this.externalAttributionDataBuilder_ == null) {
                return this.externalAttributionData_ == null ? ExternalAttributionData.getDefaultInstance() : this.externalAttributionData_;
            }
            return (ExternalAttributionData)this.externalAttributionDataBuilder_.getMessage();
        }

        public Builder setExternalAttributionData(ExternalAttributionData value) {
            if (this.externalAttributionDataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.externalAttributionData_ = value;
            } else {
                this.externalAttributionDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setExternalAttributionData(ExternalAttributionData.Builder builderForValue) {
            if (this.externalAttributionDataBuilder_ == null) {
                this.externalAttributionData_ = builderForValue.build();
            } else {
                this.externalAttributionDataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeExternalAttributionData(ExternalAttributionData value) {
            if (this.externalAttributionDataBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.externalAttributionData_ != null && this.externalAttributionData_ != ExternalAttributionData.getDefaultInstance()) {
                    this.getExternalAttributionDataBuilder().mergeFrom(value);
                } else {
                    this.externalAttributionData_ = value;
                }
            } else {
                this.externalAttributionDataBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.externalAttributionData_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExternalAttributionData() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.externalAttributionData_ = null;
            if (this.externalAttributionDataBuilder_ != null) {
                this.externalAttributionDataBuilder_.dispose();
                this.externalAttributionDataBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ExternalAttributionData.Builder getExternalAttributionDataBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (ExternalAttributionData.Builder)this.getExternalAttributionDataFieldBuilder().getBuilder();
        }

        @Override
        public ExternalAttributionDataOrBuilder getExternalAttributionDataOrBuilder() {
            if (this.externalAttributionDataBuilder_ != null) {
                return (ExternalAttributionDataOrBuilder)this.externalAttributionDataBuilder_.getMessageOrBuilder();
            }
            return this.externalAttributionData_ == null ? ExternalAttributionData.getDefaultInstance() : this.externalAttributionData_;
        }

        private SingleFieldBuilderV3<ExternalAttributionData, ExternalAttributionData.Builder, ExternalAttributionDataOrBuilder> getExternalAttributionDataFieldBuilder() {
            if (this.externalAttributionDataBuilder_ == null) {
                this.externalAttributionDataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExternalAttributionData(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.externalAttributionData_ = null;
            }
            return this.externalAttributionDataBuilder_;
        }

        private void ensureCustomVariablesIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.customVariables_ = new ArrayList<CustomVariable>(this.customVariables_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<CustomVariable> getCustomVariablesList() {
            if (this.customVariablesBuilder_ == null) {
                return Collections.unmodifiableList(this.customVariables_);
            }
            return this.customVariablesBuilder_.getMessageList();
        }

        @Override
        public int getCustomVariablesCount() {
            if (this.customVariablesBuilder_ == null) {
                return this.customVariables_.size();
            }
            return this.customVariablesBuilder_.getCount();
        }

        @Override
        public CustomVariable getCustomVariables(int index) {
            if (this.customVariablesBuilder_ == null) {
                return this.customVariables_.get(index);
            }
            return (CustomVariable)this.customVariablesBuilder_.getMessage(index);
        }

        public Builder setCustomVariables(int index, CustomVariable value) {
            if (this.customVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.set(index, value);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setCustomVariables(int index, CustomVariable.Builder builderForValue) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.customVariablesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCustomVariables(CustomVariable value) {
            if (this.customVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(value);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addCustomVariables(int index, CustomVariable value) {
            if (this.customVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(index, value);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addCustomVariables(CustomVariable.Builder builderForValue) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCustomVariables(int index, CustomVariable.Builder builderForValue) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllCustomVariables(Iterable<? extends CustomVariable> values) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.customVariables_);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearCustomVariables() {
            if (this.customVariablesBuilder_ == null) {
                this.customVariables_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.customVariablesBuilder_.clear();
            }
            return this;
        }

        public Builder removeCustomVariables(int index) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.remove(index);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.remove(index);
            }
            return this;
        }

        public CustomVariable.Builder getCustomVariablesBuilder(int index) {
            return (CustomVariable.Builder)this.getCustomVariablesFieldBuilder().getBuilder(index);
        }

        @Override
        public CustomVariableOrBuilder getCustomVariablesOrBuilder(int index) {
            if (this.customVariablesBuilder_ == null) {
                return this.customVariables_.get(index);
            }
            return (CustomVariableOrBuilder)this.customVariablesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends CustomVariableOrBuilder> getCustomVariablesOrBuilderList() {
            if (this.customVariablesBuilder_ != null) {
                return this.customVariablesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.customVariables_);
        }

        public CustomVariable.Builder addCustomVariablesBuilder() {
            return (CustomVariable.Builder)this.getCustomVariablesFieldBuilder().addBuilder((AbstractMessage)CustomVariable.getDefaultInstance());
        }

        public CustomVariable.Builder addCustomVariablesBuilder(int index) {
            return (CustomVariable.Builder)this.getCustomVariablesFieldBuilder().addBuilder(index, (AbstractMessage)CustomVariable.getDefaultInstance());
        }

        public List<CustomVariable.Builder> getCustomVariablesBuilderList() {
            return this.getCustomVariablesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<CustomVariable, CustomVariable.Builder, CustomVariableOrBuilder> getCustomVariablesFieldBuilder() {
            if (this.customVariablesBuilder_ == null) {
                this.customVariablesBuilder_ = new RepeatedFieldBuilderV3(this.customVariables_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.customVariables_ = null;
            }
            return this.customVariablesBuilder_;
        }

        @Override
        public boolean hasCartData() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public CartData getCartData() {
            if (this.cartDataBuilder_ == null) {
                return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
            }
            return (CartData)this.cartDataBuilder_.getMessage();
        }

        public Builder setCartData(CartData value) {
            if (this.cartDataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.cartData_ = value;
            } else {
                this.cartDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setCartData(CartData.Builder builderForValue) {
            if (this.cartDataBuilder_ == null) {
                this.cartData_ = builderForValue.build();
            } else {
                this.cartDataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeCartData(CartData value) {
            if (this.cartDataBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.cartData_ != null && this.cartData_ != CartData.getDefaultInstance()) {
                    this.getCartDataBuilder().mergeFrom(value);
                } else {
                    this.cartData_ = value;
                }
            } else {
                this.cartDataBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.cartData_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCartData() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.cartData_ = null;
            if (this.cartDataBuilder_ != null) {
                this.cartDataBuilder_.dispose();
                this.cartDataBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public CartData.Builder getCartDataBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (CartData.Builder)this.getCartDataFieldBuilder().getBuilder();
        }

        @Override
        public CartDataOrBuilder getCartDataOrBuilder() {
            if (this.cartDataBuilder_ != null) {
                return (CartDataOrBuilder)this.cartDataBuilder_.getMessageOrBuilder();
            }
            return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
        }

        private SingleFieldBuilderV3<CartData, CartData.Builder, CartDataOrBuilder> getCartDataFieldBuilder() {
            if (this.cartDataBuilder_ == null) {
                this.cartDataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCartData(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.cartData_ = null;
            }
            return this.cartDataBuilder_;
        }

        private void ensureUserIdentifiersIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.userIdentifiers_ = new ArrayList<UserIdentifier>(this.userIdentifiers_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<UserIdentifier> getUserIdentifiersList() {
            if (this.userIdentifiersBuilder_ == null) {
                return Collections.unmodifiableList(this.userIdentifiers_);
            }
            return this.userIdentifiersBuilder_.getMessageList();
        }

        @Override
        public int getUserIdentifiersCount() {
            if (this.userIdentifiersBuilder_ == null) {
                return this.userIdentifiers_.size();
            }
            return this.userIdentifiersBuilder_.getCount();
        }

        @Override
        public UserIdentifier getUserIdentifiers(int index) {
            if (this.userIdentifiersBuilder_ == null) {
                return this.userIdentifiers_.get(index);
            }
            return (UserIdentifier)this.userIdentifiersBuilder_.getMessage(index);
        }

        public Builder setUserIdentifiers(int index, UserIdentifier value) {
            if (this.userIdentifiersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureUserIdentifiersIsMutable();
                this.userIdentifiers_.set(index, value);
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setUserIdentifiers(int index, UserIdentifier.Builder builderForValue) {
            if (this.userIdentifiersBuilder_ == null) {
                this.ensureUserIdentifiersIsMutable();
                this.userIdentifiers_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addUserIdentifiers(UserIdentifier value) {
            if (this.userIdentifiersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureUserIdentifiersIsMutable();
                this.userIdentifiers_.add(value);
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addUserIdentifiers(int index, UserIdentifier value) {
            if (this.userIdentifiersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureUserIdentifiersIsMutable();
                this.userIdentifiers_.add(index, value);
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addUserIdentifiers(UserIdentifier.Builder builderForValue) {
            if (this.userIdentifiersBuilder_ == null) {
                this.ensureUserIdentifiersIsMutable();
                this.userIdentifiers_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addUserIdentifiers(int index, UserIdentifier.Builder builderForValue) {
            if (this.userIdentifiersBuilder_ == null) {
                this.ensureUserIdentifiersIsMutable();
                this.userIdentifiers_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllUserIdentifiers(Iterable<? extends UserIdentifier> values) {
            if (this.userIdentifiersBuilder_ == null) {
                this.ensureUserIdentifiersIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.userIdentifiers_);
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearUserIdentifiers() {
            if (this.userIdentifiersBuilder_ == null) {
                this.userIdentifiers_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.clear();
            }
            return this;
        }

        public Builder removeUserIdentifiers(int index) {
            if (this.userIdentifiersBuilder_ == null) {
                this.ensureUserIdentifiersIsMutable();
                this.userIdentifiers_.remove(index);
                this.onChanged();
            } else {
                this.userIdentifiersBuilder_.remove(index);
            }
            return this;
        }

        public UserIdentifier.Builder getUserIdentifiersBuilder(int index) {
            return (UserIdentifier.Builder)this.getUserIdentifiersFieldBuilder().getBuilder(index);
        }

        @Override
        public UserIdentifierOrBuilder getUserIdentifiersOrBuilder(int index) {
            if (this.userIdentifiersBuilder_ == null) {
                return this.userIdentifiers_.get(index);
            }
            return (UserIdentifierOrBuilder)this.userIdentifiersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends UserIdentifierOrBuilder> getUserIdentifiersOrBuilderList() {
            if (this.userIdentifiersBuilder_ != null) {
                return this.userIdentifiersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.userIdentifiers_);
        }

        public UserIdentifier.Builder addUserIdentifiersBuilder() {
            return (UserIdentifier.Builder)this.getUserIdentifiersFieldBuilder().addBuilder((AbstractMessage)UserIdentifier.getDefaultInstance());
        }

        public UserIdentifier.Builder addUserIdentifiersBuilder(int index) {
            return (UserIdentifier.Builder)this.getUserIdentifiersFieldBuilder().addBuilder(index, (AbstractMessage)UserIdentifier.getDefaultInstance());
        }

        public List<UserIdentifier.Builder> getUserIdentifiersBuilderList() {
            return this.getUserIdentifiersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<UserIdentifier, UserIdentifier.Builder, UserIdentifierOrBuilder> getUserIdentifiersFieldBuilder() {
            if (this.userIdentifiersBuilder_ == null) {
                this.userIdentifiersBuilder_ = new RepeatedFieldBuilderV3(this.userIdentifiers_, (this.bitField0_ & 0x800) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.userIdentifiers_ = null;
            }
            return this.userIdentifiersBuilder_;
        }

        @Override
        public int getConversionEnvironmentValue() {
            return this.conversionEnvironment_;
        }

        public Builder setConversionEnvironmentValue(int value) {
            this.conversionEnvironment_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public ConversionEnvironmentEnum.ConversionEnvironment getConversionEnvironment() {
            ConversionEnvironmentEnum.ConversionEnvironment result = ConversionEnvironmentEnum.ConversionEnvironment.forNumber(this.conversionEnvironment_);
            return result == null ? ConversionEnvironmentEnum.ConversionEnvironment.UNRECOGNIZED : result;
        }

        public Builder setConversionEnvironment(ConversionEnvironmentEnum.ConversionEnvironment value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x1000;
            this.conversionEnvironment_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearConversionEnvironment() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.conversionEnvironment_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasConsent() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public Consent getConsent() {
            if (this.consentBuilder_ == null) {
                return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
            }
            return (Consent)this.consentBuilder_.getMessage();
        }

        public Builder setConsent(Consent value) {
            if (this.consentBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.consent_ = value;
            } else {
                this.consentBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setConsent(Consent.Builder builderForValue) {
            if (this.consentBuilder_ == null) {
                this.consent_ = builderForValue.build();
            } else {
                this.consentBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeConsent(Consent value) {
            if (this.consentBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.consent_ != null && this.consent_ != Consent.getDefaultInstance()) {
                    this.getConsentBuilder().mergeFrom(value);
                } else {
                    this.consent_ = value;
                }
            } else {
                this.consentBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.consent_ != null) {
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearConsent() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.consent_ = null;
            if (this.consentBuilder_ != null) {
                this.consentBuilder_.dispose();
                this.consentBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Consent.Builder getConsentBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (Consent.Builder)this.getConsentFieldBuilder().getBuilder();
        }

        @Override
        public ConsentOrBuilder getConsentOrBuilder() {
            if (this.consentBuilder_ != null) {
                return (ConsentOrBuilder)this.consentBuilder_.getMessageOrBuilder();
            }
            return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
        }

        private SingleFieldBuilderV3<Consent, Consent.Builder, ConsentOrBuilder> getConsentFieldBuilder() {
            if (this.consentBuilder_ == null) {
                this.consentBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getConsent(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.consent_ = null;
            }
            return this.consentBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

