/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.services.FeedItemOperation;
import com.google.ads.googleads.v17.services.FeedItemServiceSettings;
import com.google.ads.googleads.v17.services.MutateFeedItemsRequest;
import com.google.ads.googleads.v17.services.MutateFeedItemsResponse;
import com.google.ads.googleads.v17.services.stub.FeedItemServiceStub;
import com.google.ads.googleads.v17.services.stub.FeedItemServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FeedItemServiceClient
implements BackgroundResource {
    private final FeedItemServiceSettings settings;
    private final FeedItemServiceStub stub;

    public static final FeedItemServiceClient create() throws IOException {
        return FeedItemServiceClient.create(FeedItemServiceSettings.newBuilder().build());
    }

    public static final FeedItemServiceClient create(FeedItemServiceSettings settings) throws IOException {
        return new FeedItemServiceClient(settings);
    }

    public static final FeedItemServiceClient create(FeedItemServiceStub stub) {
        return new FeedItemServiceClient(stub);
    }

    protected FeedItemServiceClient(FeedItemServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedItemServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected FeedItemServiceClient(FeedItemServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedItemServiceSettings getSettings() {
        return this.settings;
    }

    public FeedItemServiceStub getStub() {
        return this.stub;
    }

    public final MutateFeedItemsResponse mutateFeedItems(String customerId, List<FeedItemOperation> operations) {
        MutateFeedItemsRequest request = MutateFeedItemsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateFeedItems(request);
    }

    public final MutateFeedItemsResponse mutateFeedItems(MutateFeedItemsRequest request) {
        return (MutateFeedItemsResponse)this.mutateFeedItemsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateFeedItemsRequest, MutateFeedItemsResponse> mutateFeedItemsCallable() {
        return this.stub.mutateFeedItemsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

