/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services.stub;

import com.google.ads.googleads.v17.resources.OfflineUserDataJobMetadata;
import com.google.ads.googleads.v17.services.AddOfflineUserDataJobOperationsRequest;
import com.google.ads.googleads.v17.services.AddOfflineUserDataJobOperationsResponse;
import com.google.ads.googleads.v17.services.CreateOfflineUserDataJobRequest;
import com.google.ads.googleads.v17.services.CreateOfflineUserDataJobResponse;
import com.google.ads.googleads.v17.services.RunOfflineUserDataJobRequest;
import com.google.ads.googleads.v17.services.stub.GrpcOfflineUserDataJobServiceStub;
import com.google.ads.googleads.v17.services.stub.OfflineUserDataJobServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class OfflineUserDataJobServiceStubSettings
extends StubSettings<OfflineUserDataJobServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<CreateOfflineUserDataJobRequest, CreateOfflineUserDataJobResponse> createOfflineUserDataJobSettings;
    private final UnaryCallSettings<AddOfflineUserDataJobOperationsRequest, AddOfflineUserDataJobOperationsResponse> addOfflineUserDataJobOperationsSettings;
    private final UnaryCallSettings<RunOfflineUserDataJobRequest, Operation> runOfflineUserDataJobSettings;
    private final OperationCallSettings<RunOfflineUserDataJobRequest, Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobOperationSettings;

    public UnaryCallSettings<CreateOfflineUserDataJobRequest, CreateOfflineUserDataJobResponse> createOfflineUserDataJobSettings() {
        return this.createOfflineUserDataJobSettings;
    }

    public UnaryCallSettings<AddOfflineUserDataJobOperationsRequest, AddOfflineUserDataJobOperationsResponse> addOfflineUserDataJobOperationsSettings() {
        return this.addOfflineUserDataJobOperationsSettings;
    }

    public UnaryCallSettings<RunOfflineUserDataJobRequest, Operation> runOfflineUserDataJobSettings() {
        return this.runOfflineUserDataJobSettings;
    }

    public OperationCallSettings<RunOfflineUserDataJobRequest, Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobOperationSettings() {
        return this.runOfflineUserDataJobOperationSettings;
    }

    public OfflineUserDataJobServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcOfflineUserDataJobServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "googleads";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OfflineUserDataJobServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OfflineUserDataJobServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OfflineUserDataJobServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createOfflineUserDataJobSettings = settingsBuilder.createOfflineUserDataJobSettings().build();
        this.addOfflineUserDataJobOperationsSettings = settingsBuilder.addOfflineUserDataJobOperationsSettings().build();
        this.runOfflineUserDataJobSettings = settingsBuilder.runOfflineUserDataJobSettings().build();
        this.runOfflineUserDataJobOperationSettings = settingsBuilder.runOfflineUserDataJobOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OfflineUserDataJobServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateOfflineUserDataJobRequest, CreateOfflineUserDataJobResponse> createOfflineUserDataJobSettings;
        private final UnaryCallSettings.Builder<AddOfflineUserDataJobOperationsRequest, AddOfflineUserDataJobOperationsResponse> addOfflineUserDataJobOperationsSettings;
        private final UnaryCallSettings.Builder<RunOfflineUserDataJobRequest, Operation> runOfflineUserDataJobSettings;
        private final OperationCallSettings.Builder<RunOfflineUserDataJobRequest, Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createOfflineUserDataJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addOfflineUserDataJobOperationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runOfflineUserDataJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runOfflineUserDataJobOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createOfflineUserDataJobSettings, this.addOfflineUserDataJobOperationsSettings, this.runOfflineUserDataJobSettings);
            Builder.initDefaults(this);
        }

        protected Builder(OfflineUserDataJobServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createOfflineUserDataJobSettings = settings.createOfflineUserDataJobSettings.toBuilder();
            this.addOfflineUserDataJobOperationsSettings = settings.addOfflineUserDataJobOperationsSettings.toBuilder();
            this.runOfflineUserDataJobSettings = settings.runOfflineUserDataJobSettings.toBuilder();
            this.runOfflineUserDataJobOperationSettings = settings.runOfflineUserDataJobOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createOfflineUserDataJobSettings, this.addOfflineUserDataJobOperationsSettings, this.runOfflineUserDataJobSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OfflineUserDataJobServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OfflineUserDataJobServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OfflineUserDataJobServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OfflineUserDataJobServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createOfflineUserDataJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.addOfflineUserDataJobOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runOfflineUserDataJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runOfflineUserDataJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OfflineUserDataJobMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)300000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)3600000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)43200000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateOfflineUserDataJobRequest, CreateOfflineUserDataJobResponse> createOfflineUserDataJobSettings() {
            return this.createOfflineUserDataJobSettings;
        }

        public UnaryCallSettings.Builder<AddOfflineUserDataJobOperationsRequest, AddOfflineUserDataJobOperationsResponse> addOfflineUserDataJobOperationsSettings() {
            return this.addOfflineUserDataJobOperationsSettings;
        }

        public UnaryCallSettings.Builder<RunOfflineUserDataJobRequest, Operation> runOfflineUserDataJobSettings() {
            return this.runOfflineUserDataJobSettings;
        }

        public OperationCallSettings.Builder<RunOfflineUserDataJobRequest, Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobOperationSettings() {
            return this.runOfflineUserDataJobOperationSettings;
        }

        public OfflineUserDataJobServiceStubSettings build() throws IOException {
            return new OfflineUserDataJobServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

