/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.common.LocationInfo;
import com.google.ads.googleads.v17.enums.AudienceInsightsDimensionEnum;
import com.google.ads.googleads.v17.services.AudienceInsightsAttribute;
import com.google.ads.googleads.v17.services.AudienceInsightsServiceSettings;
import com.google.ads.googleads.v17.services.BasicInsightsAudience;
import com.google.ads.googleads.v17.services.GenerateAudienceCompositionInsightsRequest;
import com.google.ads.googleads.v17.services.GenerateAudienceCompositionInsightsResponse;
import com.google.ads.googleads.v17.services.GenerateAudienceOverlapInsightsRequest;
import com.google.ads.googleads.v17.services.GenerateAudienceOverlapInsightsResponse;
import com.google.ads.googleads.v17.services.GenerateInsightsFinderReportRequest;
import com.google.ads.googleads.v17.services.GenerateInsightsFinderReportResponse;
import com.google.ads.googleads.v17.services.GenerateSuggestedTargetingInsightsRequest;
import com.google.ads.googleads.v17.services.GenerateSuggestedTargetingInsightsResponse;
import com.google.ads.googleads.v17.services.InsightsAudience;
import com.google.ads.googleads.v17.services.ListAudienceInsightsAttributesRequest;
import com.google.ads.googleads.v17.services.ListAudienceInsightsAttributesResponse;
import com.google.ads.googleads.v17.services.ListInsightsEligibleDatesRequest;
import com.google.ads.googleads.v17.services.ListInsightsEligibleDatesResponse;
import com.google.ads.googleads.v17.services.stub.AudienceInsightsServiceStub;
import com.google.ads.googleads.v17.services.stub.AudienceInsightsServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AudienceInsightsServiceClient
implements BackgroundResource {
    private final AudienceInsightsServiceSettings settings;
    private final AudienceInsightsServiceStub stub;

    public static final AudienceInsightsServiceClient create() throws IOException {
        return AudienceInsightsServiceClient.create(AudienceInsightsServiceSettings.newBuilder().build());
    }

    public static final AudienceInsightsServiceClient create(AudienceInsightsServiceSettings settings) throws IOException {
        return new AudienceInsightsServiceClient(settings);
    }

    public static final AudienceInsightsServiceClient create(AudienceInsightsServiceStub stub) {
        return new AudienceInsightsServiceClient(stub);
    }

    protected AudienceInsightsServiceClient(AudienceInsightsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AudienceInsightsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AudienceInsightsServiceClient(AudienceInsightsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AudienceInsightsServiceSettings getSettings() {
        return this.settings;
    }

    public AudienceInsightsServiceStub getStub() {
        return this.stub;
    }

    public final GenerateInsightsFinderReportResponse generateInsightsFinderReport(String customerId, BasicInsightsAudience baselineAudience, BasicInsightsAudience specificAudience) {
        GenerateInsightsFinderReportRequest request = GenerateInsightsFinderReportRequest.newBuilder().setCustomerId(customerId).setBaselineAudience(baselineAudience).setSpecificAudience(specificAudience).build();
        return this.generateInsightsFinderReport(request);
    }

    public final GenerateInsightsFinderReportResponse generateInsightsFinderReport(GenerateInsightsFinderReportRequest request) {
        return (GenerateInsightsFinderReportResponse)this.generateInsightsFinderReportCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateInsightsFinderReportRequest, GenerateInsightsFinderReportResponse> generateInsightsFinderReportCallable() {
        return this.stub.generateInsightsFinderReportCallable();
    }

    public final ListAudienceInsightsAttributesResponse listAudienceInsightsAttributes(String customerId, List<AudienceInsightsDimensionEnum.AudienceInsightsDimension> dimensions, String queryText) {
        ListAudienceInsightsAttributesRequest request = ListAudienceInsightsAttributesRequest.newBuilder().setCustomerId(customerId).addAllDimensions(dimensions).setQueryText(queryText).build();
        return this.listAudienceInsightsAttributes(request);
    }

    public final ListAudienceInsightsAttributesResponse listAudienceInsightsAttributes(ListAudienceInsightsAttributesRequest request) {
        return (ListAudienceInsightsAttributesResponse)this.listAudienceInsightsAttributesCallable().call((Object)request);
    }

    public final UnaryCallable<ListAudienceInsightsAttributesRequest, ListAudienceInsightsAttributesResponse> listAudienceInsightsAttributesCallable() {
        return this.stub.listAudienceInsightsAttributesCallable();
    }

    public final ListInsightsEligibleDatesResponse listInsightsEligibleDates(ListInsightsEligibleDatesRequest request) {
        return (ListInsightsEligibleDatesResponse)this.listInsightsEligibleDatesCallable().call((Object)request);
    }

    public final UnaryCallable<ListInsightsEligibleDatesRequest, ListInsightsEligibleDatesResponse> listInsightsEligibleDatesCallable() {
        return this.stub.listInsightsEligibleDatesCallable();
    }

    public final GenerateAudienceCompositionInsightsResponse generateAudienceCompositionInsights(String customerId, InsightsAudience audience, List<AudienceInsightsDimensionEnum.AudienceInsightsDimension> dimensions) {
        GenerateAudienceCompositionInsightsRequest request = GenerateAudienceCompositionInsightsRequest.newBuilder().setCustomerId(customerId).setAudience(audience).addAllDimensions(dimensions).build();
        return this.generateAudienceCompositionInsights(request);
    }

    public final GenerateAudienceCompositionInsightsResponse generateAudienceCompositionInsights(GenerateAudienceCompositionInsightsRequest request) {
        return (GenerateAudienceCompositionInsightsResponse)this.generateAudienceCompositionInsightsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAudienceCompositionInsightsRequest, GenerateAudienceCompositionInsightsResponse> generateAudienceCompositionInsightsCallable() {
        return this.stub.generateAudienceCompositionInsightsCallable();
    }

    public final GenerateSuggestedTargetingInsightsResponse generateSuggestedTargetingInsights(String customerId, InsightsAudience audience) {
        GenerateSuggestedTargetingInsightsRequest request = GenerateSuggestedTargetingInsightsRequest.newBuilder().setCustomerId(customerId).setAudience(audience).build();
        return this.generateSuggestedTargetingInsights(request);
    }

    public final GenerateSuggestedTargetingInsightsResponse generateSuggestedTargetingInsights(GenerateSuggestedTargetingInsightsRequest request) {
        return (GenerateSuggestedTargetingInsightsResponse)this.generateSuggestedTargetingInsightsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateSuggestedTargetingInsightsRequest, GenerateSuggestedTargetingInsightsResponse> generateSuggestedTargetingInsightsCallable() {
        return this.stub.generateSuggestedTargetingInsightsCallable();
    }

    public final GenerateAudienceOverlapInsightsResponse generateAudienceOverlapInsights(String customerId, LocationInfo countryLocation, AudienceInsightsAttribute primaryAttribute, List<AudienceInsightsDimensionEnum.AudienceInsightsDimension> dimensions) {
        GenerateAudienceOverlapInsightsRequest request = GenerateAudienceOverlapInsightsRequest.newBuilder().setCustomerId(customerId).setCountryLocation(countryLocation).setPrimaryAttribute(primaryAttribute).addAllDimensions(dimensions).build();
        return this.generateAudienceOverlapInsights(request);
    }

    public final GenerateAudienceOverlapInsightsResponse generateAudienceOverlapInsights(GenerateAudienceOverlapInsightsRequest request) {
        return (GenerateAudienceOverlapInsightsResponse)this.generateAudienceOverlapInsightsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAudienceOverlapInsightsRequest, GenerateAudienceOverlapInsightsResponse> generateAudienceOverlapInsightsCallable() {
        return this.stub.generateAudienceOverlapInsightsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

