/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.services.ConversionActionOperation;
import com.google.ads.googleads.v17.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v17.services.MutateConversionActionsRequest;
import com.google.ads.googleads.v17.services.MutateConversionActionsResponse;
import com.google.ads.googleads.v17.services.stub.ConversionActionServiceStub;
import com.google.ads.googleads.v17.services.stub.ConversionActionServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConversionActionServiceClient
implements BackgroundResource {
    private final ConversionActionServiceSettings settings;
    private final ConversionActionServiceStub stub;

    public static final ConversionActionServiceClient create() throws IOException {
        return ConversionActionServiceClient.create(ConversionActionServiceSettings.newBuilder().build());
    }

    public static final ConversionActionServiceClient create(ConversionActionServiceSettings settings) throws IOException {
        return new ConversionActionServiceClient(settings);
    }

    public static final ConversionActionServiceClient create(ConversionActionServiceStub stub) {
        return new ConversionActionServiceClient(stub);
    }

    protected ConversionActionServiceClient(ConversionActionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversionActionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConversionActionServiceClient(ConversionActionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversionActionServiceSettings getSettings() {
        return this.settings;
    }

    public ConversionActionServiceStub getStub() {
        return this.stub;
    }

    public final MutateConversionActionsResponse mutateConversionActions(String customerId, List<ConversionActionOperation> operations) {
        MutateConversionActionsRequest request = MutateConversionActionsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateConversionActions(request);
    }

    public final MutateConversionActionsResponse mutateConversionActions(MutateConversionActionsRequest request) {
        return (MutateConversionActionsResponse)this.mutateConversionActionsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateConversionActionsRequest, MutateConversionActionsResponse> mutateConversionActionsCallable() {
        return this.stub.mutateConversionActionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

