/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.common.DeviceInfo;
import com.google.ads.googleads.v17.common.DeviceInfoOrBuilder;
import com.google.ads.googleads.v17.common.GenderInfo;
import com.google.ads.googleads.v17.common.GenderInfoOrBuilder;
import com.google.ads.googleads.v17.enums.ReachPlanAgeRangeEnum;
import com.google.ads.googleads.v17.enums.ReachPlanNetworkEnum;
import com.google.ads.googleads.v17.services.AudienceTargeting;
import com.google.ads.googleads.v17.services.AudienceTargetingOrBuilder;
import com.google.ads.googleads.v17.services.ReachPlanServiceProto;
import com.google.ads.googleads.v17.services.TargetingOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Targeting
extends GeneratedMessageV3
implements TargetingOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int PLANNABLE_LOCATION_ID_FIELD_NUMBER = 6;
    private volatile Object plannableLocationId_ = "";
    public static final int PLANNABLE_LOCATION_IDS_FIELD_NUMBER = 8;
    private LazyStringArrayList plannableLocationIds_ = LazyStringArrayList.emptyList();
    public static final int AGE_RANGE_FIELD_NUMBER = 2;
    private int ageRange_ = 0;
    public static final int GENDERS_FIELD_NUMBER = 3;
    private List<GenderInfo> genders_;
    public static final int DEVICES_FIELD_NUMBER = 4;
    private List<DeviceInfo> devices_;
    public static final int NETWORK_FIELD_NUMBER = 5;
    private int network_ = 0;
    public static final int AUDIENCE_TARGETING_FIELD_NUMBER = 7;
    private AudienceTargeting audienceTargeting_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Targeting DEFAULT_INSTANCE = new Targeting();
    private static final Parser<Targeting> PARSER = new AbstractParser<Targeting>(){

        public Targeting parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Targeting.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Targeting(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Targeting() {
        this.plannableLocationId_ = "";
        this.plannableLocationIds_ = LazyStringArrayList.emptyList();
        this.ageRange_ = 0;
        this.genders_ = Collections.emptyList();
        this.devices_ = Collections.emptyList();
        this.network_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Targeting();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ReachPlanServiceProto.internal_static_google_ads_googleads_v17_services_Targeting_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ReachPlanServiceProto.internal_static_google_ads_googleads_v17_services_Targeting_fieldAccessorTable.ensureFieldAccessorsInitialized(Targeting.class, Builder.class);
    }

    @Override
    public boolean hasPlannableLocationId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getPlannableLocationId() {
        Object ref = this.plannableLocationId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.plannableLocationId_ = s;
        return s;
    }

    @Override
    public ByteString getPlannableLocationIdBytes() {
        Object ref = this.plannableLocationId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.plannableLocationId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getPlannableLocationIdsList() {
        return this.plannableLocationIds_;
    }

    @Override
    public int getPlannableLocationIdsCount() {
        return this.plannableLocationIds_.size();
    }

    @Override
    public String getPlannableLocationIds(int index) {
        return this.plannableLocationIds_.get(index);
    }

    @Override
    public ByteString getPlannableLocationIdsBytes(int index) {
        return this.plannableLocationIds_.getByteString(index);
    }

    @Override
    public int getAgeRangeValue() {
        return this.ageRange_;
    }

    @Override
    public ReachPlanAgeRangeEnum.ReachPlanAgeRange getAgeRange() {
        ReachPlanAgeRangeEnum.ReachPlanAgeRange result = ReachPlanAgeRangeEnum.ReachPlanAgeRange.forNumber(this.ageRange_);
        return result == null ? ReachPlanAgeRangeEnum.ReachPlanAgeRange.UNRECOGNIZED : result;
    }

    @Override
    public List<GenderInfo> getGendersList() {
        return this.genders_;
    }

    @Override
    public List<? extends GenderInfoOrBuilder> getGendersOrBuilderList() {
        return this.genders_;
    }

    @Override
    public int getGendersCount() {
        return this.genders_.size();
    }

    @Override
    public GenderInfo getGenders(int index) {
        return this.genders_.get(index);
    }

    @Override
    public GenderInfoOrBuilder getGendersOrBuilder(int index) {
        return this.genders_.get(index);
    }

    @Override
    public List<DeviceInfo> getDevicesList() {
        return this.devices_;
    }

    @Override
    public List<? extends DeviceInfoOrBuilder> getDevicesOrBuilderList() {
        return this.devices_;
    }

    @Override
    public int getDevicesCount() {
        return this.devices_.size();
    }

    @Override
    public DeviceInfo getDevices(int index) {
        return this.devices_.get(index);
    }

    @Override
    public DeviceInfoOrBuilder getDevicesOrBuilder(int index) {
        return this.devices_.get(index);
    }

    @Override
    public int getNetworkValue() {
        return this.network_;
    }

    @Override
    public ReachPlanNetworkEnum.ReachPlanNetwork getNetwork() {
        ReachPlanNetworkEnum.ReachPlanNetwork result = ReachPlanNetworkEnum.ReachPlanNetwork.forNumber(this.network_);
        return result == null ? ReachPlanNetworkEnum.ReachPlanNetwork.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasAudienceTargeting() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public AudienceTargeting getAudienceTargeting() {
        return this.audienceTargeting_ == null ? AudienceTargeting.getDefaultInstance() : this.audienceTargeting_;
    }

    @Override
    public AudienceTargetingOrBuilder getAudienceTargetingOrBuilder() {
        return this.audienceTargeting_ == null ? AudienceTargeting.getDefaultInstance() : this.audienceTargeting_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.ageRange_ != ReachPlanAgeRangeEnum.ReachPlanAgeRange.UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.ageRange_);
        }
        for (i = 0; i < this.genders_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.genders_.get(i));
        }
        for (i = 0; i < this.devices_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.devices_.get(i));
        }
        if (this.network_ != ReachPlanNetworkEnum.ReachPlanNetwork.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.network_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.plannableLocationId_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(7, (MessageLite)this.getAudienceTargeting());
        }
        for (i = 0; i < this.plannableLocationIds_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.plannableLocationIds_.getRaw(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.ageRange_ != ReachPlanAgeRangeEnum.ReachPlanAgeRange.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.ageRange_);
        }
        for (i = 0; i < this.genders_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.genders_.get(i)));
        }
        for (i = 0; i < this.devices_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.devices_.get(i)));
        }
        if (this.network_ != ReachPlanNetworkEnum.ReachPlanNetwork.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.network_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.plannableLocationId_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getAudienceTargeting());
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.plannableLocationIds_.size(); ++i2) {
            dataSize += Targeting.computeStringSizeNoTag((Object)this.plannableLocationIds_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getPlannableLocationIdsList().size();
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Targeting)) {
            return super.equals(obj);
        }
        Targeting other = (Targeting)obj;
        if (this.hasPlannableLocationId() != other.hasPlannableLocationId()) {
            return false;
        }
        if (this.hasPlannableLocationId() && !this.getPlannableLocationId().equals(other.getPlannableLocationId())) {
            return false;
        }
        if (!this.getPlannableLocationIdsList().equals(other.getPlannableLocationIdsList())) {
            return false;
        }
        if (this.ageRange_ != other.ageRange_) {
            return false;
        }
        if (!this.getGendersList().equals(other.getGendersList())) {
            return false;
        }
        if (!this.getDevicesList().equals(other.getDevicesList())) {
            return false;
        }
        if (this.network_ != other.network_) {
            return false;
        }
        if (this.hasAudienceTargeting() != other.hasAudienceTargeting()) {
            return false;
        }
        if (this.hasAudienceTargeting() && !this.getAudienceTargeting().equals(other.getAudienceTargeting())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Targeting.getDescriptor().hashCode();
        if (this.hasPlannableLocationId()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getPlannableLocationId().hashCode();
        }
        if (this.getPlannableLocationIdsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getPlannableLocationIdsList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.ageRange_;
        if (this.getGendersCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getGendersList().hashCode();
        }
        if (this.getDevicesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getDevicesList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.network_;
        if (this.hasAudienceTargeting()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getAudienceTargeting().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Targeting parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Targeting)PARSER.parseFrom(data);
    }

    public static Targeting parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Targeting)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Targeting parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Targeting)PARSER.parseFrom(data);
    }

    public static Targeting parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Targeting)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Targeting parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Targeting)PARSER.parseFrom(data);
    }

    public static Targeting parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Targeting)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Targeting parseFrom(InputStream input) throws IOException {
        return (Targeting)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Targeting parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Targeting)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Targeting parseDelimitedFrom(InputStream input) throws IOException {
        return (Targeting)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Targeting parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Targeting)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Targeting parseFrom(CodedInputStream input) throws IOException {
        return (Targeting)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Targeting parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Targeting)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Targeting.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Targeting prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Targeting getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Targeting> parser() {
        return PARSER;
    }

    public Parser<Targeting> getParserForType() {
        return PARSER;
    }

    public Targeting getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TargetingOrBuilder {
        private int bitField0_;
        private Object plannableLocationId_ = "";
        private LazyStringArrayList plannableLocationIds_ = LazyStringArrayList.emptyList();
        private int ageRange_ = 0;
        private List<GenderInfo> genders_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<GenderInfo, GenderInfo.Builder, GenderInfoOrBuilder> gendersBuilder_;
        private List<DeviceInfo> devices_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<DeviceInfo, DeviceInfo.Builder, DeviceInfoOrBuilder> devicesBuilder_;
        private int network_ = 0;
        private AudienceTargeting audienceTargeting_;
        private SingleFieldBuilderV3<AudienceTargeting, AudienceTargeting.Builder, AudienceTargetingOrBuilder> audienceTargetingBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ReachPlanServiceProto.internal_static_google_ads_googleads_v17_services_Targeting_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ReachPlanServiceProto.internal_static_google_ads_googleads_v17_services_Targeting_fieldAccessorTable.ensureFieldAccessorsInitialized(Targeting.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getGendersFieldBuilder();
                this.getDevicesFieldBuilder();
                this.getAudienceTargetingFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.plannableLocationId_ = "";
            this.plannableLocationIds_ = LazyStringArrayList.emptyList();
            this.ageRange_ = 0;
            if (this.gendersBuilder_ == null) {
                this.genders_ = Collections.emptyList();
            } else {
                this.genders_ = null;
                this.gendersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            if (this.devicesBuilder_ == null) {
                this.devices_ = Collections.emptyList();
            } else {
                this.devices_ = null;
                this.devicesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFEF;
            this.network_ = 0;
            this.audienceTargeting_ = null;
            if (this.audienceTargetingBuilder_ != null) {
                this.audienceTargetingBuilder_.dispose();
                this.audienceTargetingBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ReachPlanServiceProto.internal_static_google_ads_googleads_v17_services_Targeting_descriptor;
        }

        public Targeting getDefaultInstanceForType() {
            return Targeting.getDefaultInstance();
        }

        public Targeting build() {
            Targeting result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Targeting buildPartial() {
            Targeting result = new Targeting(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Targeting result) {
            if (this.gendersBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.genders_ = Collections.unmodifiableList(this.genders_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.genders_ = this.genders_;
            } else {
                result.genders_ = this.gendersBuilder_.build();
            }
            if (this.devicesBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.devices_ = Collections.unmodifiableList(this.devices_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.devices_ = this.devices_;
            } else {
                result.devices_ = this.devicesBuilder_.build();
            }
        }

        private void buildPartial0(Targeting result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.plannableLocationId_ = this.plannableLocationId_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                this.plannableLocationIds_.makeImmutable();
                result.plannableLocationIds_ = this.plannableLocationIds_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.ageRange_ = this.ageRange_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.network_ = this.network_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.audienceTargeting_ = this.audienceTargetingBuilder_ == null ? this.audienceTargeting_ : (AudienceTargeting)this.audienceTargetingBuilder_.build();
                to_bitField0_ |= 2;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Targeting) {
                return this.mergeFrom((Targeting)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Targeting other) {
            if (other == Targeting.getDefaultInstance()) {
                return this;
            }
            if (other.hasPlannableLocationId()) {
                this.plannableLocationId_ = other.plannableLocationId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.plannableLocationIds_.isEmpty()) {
                if (this.plannableLocationIds_.isEmpty()) {
                    this.plannableLocationIds_ = other.plannableLocationIds_;
                    this.bitField0_ |= 2;
                } else {
                    this.ensurePlannableLocationIdsIsMutable();
                    this.plannableLocationIds_.addAll((Collection)other.plannableLocationIds_);
                }
                this.onChanged();
            }
            if (other.ageRange_ != 0) {
                this.setAgeRangeValue(other.getAgeRangeValue());
            }
            if (this.gendersBuilder_ == null) {
                if (!other.genders_.isEmpty()) {
                    if (this.genders_.isEmpty()) {
                        this.genders_ = other.genders_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureGendersIsMutable();
                        this.genders_.addAll(other.genders_);
                    }
                    this.onChanged();
                }
            } else if (!other.genders_.isEmpty()) {
                if (this.gendersBuilder_.isEmpty()) {
                    this.gendersBuilder_.dispose();
                    this.gendersBuilder_ = null;
                    this.genders_ = other.genders_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.gendersBuilder_ = alwaysUseFieldBuilders ? this.getGendersFieldBuilder() : null;
                } else {
                    this.gendersBuilder_.addAllMessages((Iterable)other.genders_);
                }
            }
            if (this.devicesBuilder_ == null) {
                if (!other.devices_.isEmpty()) {
                    if (this.devices_.isEmpty()) {
                        this.devices_ = other.devices_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensureDevicesIsMutable();
                        this.devices_.addAll(other.devices_);
                    }
                    this.onChanged();
                }
            } else if (!other.devices_.isEmpty()) {
                if (this.devicesBuilder_.isEmpty()) {
                    this.devicesBuilder_.dispose();
                    this.devicesBuilder_ = null;
                    this.devices_ = other.devices_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.devicesBuilder_ = alwaysUseFieldBuilders ? this.getDevicesFieldBuilder() : null;
                } else {
                    this.devicesBuilder_.addAllMessages((Iterable)other.devices_);
                }
            }
            if (other.network_ != 0) {
                this.setNetworkValue(other.getNetworkValue());
            }
            if (other.hasAudienceTargeting()) {
                this.mergeAudienceTargeting(other.getAudienceTargeting());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 16: {
                            this.ageRange_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block15;
                        }
                        case 26: {
                            GeneratedMessageV3 m = (GenderInfo)input.readMessage(GenderInfo.parser(), extensionRegistry);
                            if (this.gendersBuilder_ == null) {
                                this.ensureGendersIsMutable();
                                this.genders_.add((GenderInfo)m);
                                continue block15;
                            }
                            this.gendersBuilder_.addMessage((AbstractMessage)m);
                            continue block15;
                        }
                        case 34: {
                            GeneratedMessageV3 m = (DeviceInfo)input.readMessage(DeviceInfo.parser(), extensionRegistry);
                            if (this.devicesBuilder_ == null) {
                                this.ensureDevicesIsMutable();
                                this.devices_.add((DeviceInfo)m);
                                continue block15;
                            }
                            this.devicesBuilder_.addMessage((AbstractMessage)m);
                            continue block15;
                        }
                        case 40: {
                            this.network_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block15;
                        }
                        case 50: {
                            this.plannableLocationId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block15;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getAudienceTargetingFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block15;
                        }
                        case 66: {
                            String s = input.readStringRequireUtf8();
                            this.ensurePlannableLocationIdsIsMutable();
                            this.plannableLocationIds_.add((Object)s);
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasPlannableLocationId() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getPlannableLocationId() {
            Object ref = this.plannableLocationId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.plannableLocationId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPlannableLocationIdBytes() {
            Object ref = this.plannableLocationId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.plannableLocationId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPlannableLocationId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.plannableLocationId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearPlannableLocationId() {
            this.plannableLocationId_ = Targeting.getDefaultInstance().getPlannableLocationId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setPlannableLocationIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Targeting.checkByteStringIsUtf8((ByteString)value);
            this.plannableLocationId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensurePlannableLocationIdsIsMutable() {
            if (!this.plannableLocationIds_.isModifiable()) {
                this.plannableLocationIds_ = new LazyStringArrayList((LazyStringList)this.plannableLocationIds_);
            }
            this.bitField0_ |= 2;
        }

        public ProtocolStringList getPlannableLocationIdsList() {
            this.plannableLocationIds_.makeImmutable();
            return this.plannableLocationIds_;
        }

        @Override
        public int getPlannableLocationIdsCount() {
            return this.plannableLocationIds_.size();
        }

        @Override
        public String getPlannableLocationIds(int index) {
            return this.plannableLocationIds_.get(index);
        }

        @Override
        public ByteString getPlannableLocationIdsBytes(int index) {
            return this.plannableLocationIds_.getByteString(index);
        }

        public Builder setPlannableLocationIds(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePlannableLocationIdsIsMutable();
            this.plannableLocationIds_.set(index, value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addPlannableLocationIds(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePlannableLocationIdsIsMutable();
            this.plannableLocationIds_.add((Object)value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addAllPlannableLocationIds(Iterable<String> values) {
            this.ensurePlannableLocationIdsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.plannableLocationIds_);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearPlannableLocationIds() {
            this.plannableLocationIds_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addPlannableLocationIdsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Targeting.checkByteStringIsUtf8((ByteString)value);
            this.ensurePlannableLocationIdsIsMutable();
            this.plannableLocationIds_.add(value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getAgeRangeValue() {
            return this.ageRange_;
        }

        public Builder setAgeRangeValue(int value) {
            this.ageRange_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public ReachPlanAgeRangeEnum.ReachPlanAgeRange getAgeRange() {
            ReachPlanAgeRangeEnum.ReachPlanAgeRange result = ReachPlanAgeRangeEnum.ReachPlanAgeRange.forNumber(this.ageRange_);
            return result == null ? ReachPlanAgeRangeEnum.ReachPlanAgeRange.UNRECOGNIZED : result;
        }

        public Builder setAgeRange(ReachPlanAgeRangeEnum.ReachPlanAgeRange value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.ageRange_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAgeRange() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.ageRange_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureGendersIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.genders_ = new ArrayList<GenderInfo>(this.genders_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<GenderInfo> getGendersList() {
            if (this.gendersBuilder_ == null) {
                return Collections.unmodifiableList(this.genders_);
            }
            return this.gendersBuilder_.getMessageList();
        }

        @Override
        public int getGendersCount() {
            if (this.gendersBuilder_ == null) {
                return this.genders_.size();
            }
            return this.gendersBuilder_.getCount();
        }

        @Override
        public GenderInfo getGenders(int index) {
            if (this.gendersBuilder_ == null) {
                return this.genders_.get(index);
            }
            return (GenderInfo)this.gendersBuilder_.getMessage(index);
        }

        public Builder setGenders(int index, GenderInfo value) {
            if (this.gendersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGendersIsMutable();
                this.genders_.set(index, value);
                this.onChanged();
            } else {
                this.gendersBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setGenders(int index, GenderInfo.Builder builderForValue) {
            if (this.gendersBuilder_ == null) {
                this.ensureGendersIsMutable();
                this.genders_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.gendersBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addGenders(GenderInfo value) {
            if (this.gendersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGendersIsMutable();
                this.genders_.add(value);
                this.onChanged();
            } else {
                this.gendersBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addGenders(int index, GenderInfo value) {
            if (this.gendersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGendersIsMutable();
                this.genders_.add(index, value);
                this.onChanged();
            } else {
                this.gendersBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addGenders(GenderInfo.Builder builderForValue) {
            if (this.gendersBuilder_ == null) {
                this.ensureGendersIsMutable();
                this.genders_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.gendersBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addGenders(int index, GenderInfo.Builder builderForValue) {
            if (this.gendersBuilder_ == null) {
                this.ensureGendersIsMutable();
                this.genders_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.gendersBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllGenders(Iterable<? extends GenderInfo> values) {
            if (this.gendersBuilder_ == null) {
                this.ensureGendersIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.genders_);
                this.onChanged();
            } else {
                this.gendersBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearGenders() {
            if (this.gendersBuilder_ == null) {
                this.genders_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.gendersBuilder_.clear();
            }
            return this;
        }

        public Builder removeGenders(int index) {
            if (this.gendersBuilder_ == null) {
                this.ensureGendersIsMutable();
                this.genders_.remove(index);
                this.onChanged();
            } else {
                this.gendersBuilder_.remove(index);
            }
            return this;
        }

        public GenderInfo.Builder getGendersBuilder(int index) {
            return (GenderInfo.Builder)this.getGendersFieldBuilder().getBuilder(index);
        }

        @Override
        public GenderInfoOrBuilder getGendersOrBuilder(int index) {
            if (this.gendersBuilder_ == null) {
                return this.genders_.get(index);
            }
            return (GenderInfoOrBuilder)this.gendersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends GenderInfoOrBuilder> getGendersOrBuilderList() {
            if (this.gendersBuilder_ != null) {
                return this.gendersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.genders_);
        }

        public GenderInfo.Builder addGendersBuilder() {
            return (GenderInfo.Builder)this.getGendersFieldBuilder().addBuilder((AbstractMessage)GenderInfo.getDefaultInstance());
        }

        public GenderInfo.Builder addGendersBuilder(int index) {
            return (GenderInfo.Builder)this.getGendersFieldBuilder().addBuilder(index, (AbstractMessage)GenderInfo.getDefaultInstance());
        }

        public List<GenderInfo.Builder> getGendersBuilderList() {
            return this.getGendersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<GenderInfo, GenderInfo.Builder, GenderInfoOrBuilder> getGendersFieldBuilder() {
            if (this.gendersBuilder_ == null) {
                this.gendersBuilder_ = new RepeatedFieldBuilderV3(this.genders_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.genders_ = null;
            }
            return this.gendersBuilder_;
        }

        private void ensureDevicesIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.devices_ = new ArrayList<DeviceInfo>(this.devices_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<DeviceInfo> getDevicesList() {
            if (this.devicesBuilder_ == null) {
                return Collections.unmodifiableList(this.devices_);
            }
            return this.devicesBuilder_.getMessageList();
        }

        @Override
        public int getDevicesCount() {
            if (this.devicesBuilder_ == null) {
                return this.devices_.size();
            }
            return this.devicesBuilder_.getCount();
        }

        @Override
        public DeviceInfo getDevices(int index) {
            if (this.devicesBuilder_ == null) {
                return this.devices_.get(index);
            }
            return (DeviceInfo)this.devicesBuilder_.getMessage(index);
        }

        public Builder setDevices(int index, DeviceInfo value) {
            if (this.devicesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDevicesIsMutable();
                this.devices_.set(index, value);
                this.onChanged();
            } else {
                this.devicesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setDevices(int index, DeviceInfo.Builder builderForValue) {
            if (this.devicesBuilder_ == null) {
                this.ensureDevicesIsMutable();
                this.devices_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.devicesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDevices(DeviceInfo value) {
            if (this.devicesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDevicesIsMutable();
                this.devices_.add(value);
                this.onChanged();
            } else {
                this.devicesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addDevices(int index, DeviceInfo value) {
            if (this.devicesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDevicesIsMutable();
                this.devices_.add(index, value);
                this.onChanged();
            } else {
                this.devicesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addDevices(DeviceInfo.Builder builderForValue) {
            if (this.devicesBuilder_ == null) {
                this.ensureDevicesIsMutable();
                this.devices_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.devicesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDevices(int index, DeviceInfo.Builder builderForValue) {
            if (this.devicesBuilder_ == null) {
                this.ensureDevicesIsMutable();
                this.devices_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.devicesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDevices(Iterable<? extends DeviceInfo> values) {
            if (this.devicesBuilder_ == null) {
                this.ensureDevicesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.devices_);
                this.onChanged();
            } else {
                this.devicesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDevices() {
            if (this.devicesBuilder_ == null) {
                this.devices_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.devicesBuilder_.clear();
            }
            return this;
        }

        public Builder removeDevices(int index) {
            if (this.devicesBuilder_ == null) {
                this.ensureDevicesIsMutable();
                this.devices_.remove(index);
                this.onChanged();
            } else {
                this.devicesBuilder_.remove(index);
            }
            return this;
        }

        public DeviceInfo.Builder getDevicesBuilder(int index) {
            return (DeviceInfo.Builder)this.getDevicesFieldBuilder().getBuilder(index);
        }

        @Override
        public DeviceInfoOrBuilder getDevicesOrBuilder(int index) {
            if (this.devicesBuilder_ == null) {
                return this.devices_.get(index);
            }
            return (DeviceInfoOrBuilder)this.devicesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends DeviceInfoOrBuilder> getDevicesOrBuilderList() {
            if (this.devicesBuilder_ != null) {
                return this.devicesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.devices_);
        }

        public DeviceInfo.Builder addDevicesBuilder() {
            return (DeviceInfo.Builder)this.getDevicesFieldBuilder().addBuilder((AbstractMessage)DeviceInfo.getDefaultInstance());
        }

        public DeviceInfo.Builder addDevicesBuilder(int index) {
            return (DeviceInfo.Builder)this.getDevicesFieldBuilder().addBuilder(index, (AbstractMessage)DeviceInfo.getDefaultInstance());
        }

        public List<DeviceInfo.Builder> getDevicesBuilderList() {
            return this.getDevicesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<DeviceInfo, DeviceInfo.Builder, DeviceInfoOrBuilder> getDevicesFieldBuilder() {
            if (this.devicesBuilder_ == null) {
                this.devicesBuilder_ = new RepeatedFieldBuilderV3(this.devices_, (this.bitField0_ & 0x10) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.devices_ = null;
            }
            return this.devicesBuilder_;
        }

        @Override
        public int getNetworkValue() {
            return this.network_;
        }

        public Builder setNetworkValue(int value) {
            this.network_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public ReachPlanNetworkEnum.ReachPlanNetwork getNetwork() {
            ReachPlanNetworkEnum.ReachPlanNetwork result = ReachPlanNetworkEnum.ReachPlanNetwork.forNumber(this.network_);
            return result == null ? ReachPlanNetworkEnum.ReachPlanNetwork.UNRECOGNIZED : result;
        }

        public Builder setNetwork(ReachPlanNetworkEnum.ReachPlanNetwork value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.network_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearNetwork() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.network_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAudienceTargeting() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public AudienceTargeting getAudienceTargeting() {
            if (this.audienceTargetingBuilder_ == null) {
                return this.audienceTargeting_ == null ? AudienceTargeting.getDefaultInstance() : this.audienceTargeting_;
            }
            return (AudienceTargeting)this.audienceTargetingBuilder_.getMessage();
        }

        public Builder setAudienceTargeting(AudienceTargeting value) {
            if (this.audienceTargetingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.audienceTargeting_ = value;
            } else {
                this.audienceTargetingBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setAudienceTargeting(AudienceTargeting.Builder builderForValue) {
            if (this.audienceTargetingBuilder_ == null) {
                this.audienceTargeting_ = builderForValue.build();
            } else {
                this.audienceTargetingBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeAudienceTargeting(AudienceTargeting value) {
            if (this.audienceTargetingBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.audienceTargeting_ != null && this.audienceTargeting_ != AudienceTargeting.getDefaultInstance()) {
                    this.getAudienceTargetingBuilder().mergeFrom(value);
                } else {
                    this.audienceTargeting_ = value;
                }
            } else {
                this.audienceTargetingBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.audienceTargeting_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAudienceTargeting() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.audienceTargeting_ = null;
            if (this.audienceTargetingBuilder_ != null) {
                this.audienceTargetingBuilder_.dispose();
                this.audienceTargetingBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AudienceTargeting.Builder getAudienceTargetingBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (AudienceTargeting.Builder)this.getAudienceTargetingFieldBuilder().getBuilder();
        }

        @Override
        public AudienceTargetingOrBuilder getAudienceTargetingOrBuilder() {
            if (this.audienceTargetingBuilder_ != null) {
                return (AudienceTargetingOrBuilder)this.audienceTargetingBuilder_.getMessageOrBuilder();
            }
            return this.audienceTargeting_ == null ? AudienceTargeting.getDefaultInstance() : this.audienceTargeting_;
        }

        private SingleFieldBuilderV3<AudienceTargeting, AudienceTargeting.Builder, AudienceTargetingOrBuilder> getAudienceTargetingFieldBuilder() {
            if (this.audienceTargetingBuilder_ == null) {
                this.audienceTargetingBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAudienceTargeting(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.audienceTargeting_ = null;
            }
            return this.audienceTargetingBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

