/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.common;

import com.google.ads.googleads.v17.common.AdScheduleInfo;
import com.google.ads.googleads.v17.common.AdScheduleInfoOrBuilder;
import com.google.ads.googleads.v17.common.AssetTypesProto;
import com.google.ads.googleads.v17.common.CallAssetOrBuilder;
import com.google.ads.googleads.v17.enums.CallConversionReportingStateEnum;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CallAsset
extends GeneratedMessageV3
implements CallAssetOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int COUNTRY_CODE_FIELD_NUMBER = 1;
    private volatile Object countryCode_ = "";
    public static final int PHONE_NUMBER_FIELD_NUMBER = 2;
    private volatile Object phoneNumber_ = "";
    public static final int CALL_CONVERSION_REPORTING_STATE_FIELD_NUMBER = 3;
    private int callConversionReportingState_ = 0;
    public static final int CALL_CONVERSION_ACTION_FIELD_NUMBER = 4;
    private volatile Object callConversionAction_ = "";
    public static final int AD_SCHEDULE_TARGETS_FIELD_NUMBER = 5;
    private List<AdScheduleInfo> adScheduleTargets_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CallAsset DEFAULT_INSTANCE = new CallAsset();
    private static final Parser<CallAsset> PARSER = new AbstractParser<CallAsset>(){

        public CallAsset parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = CallAsset.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private CallAsset(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CallAsset() {
        this.countryCode_ = "";
        this.phoneNumber_ = "";
        this.callConversionReportingState_ = 0;
        this.callConversionAction_ = "";
        this.adScheduleTargets_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CallAsset();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetTypesProto.internal_static_google_ads_googleads_v17_common_CallAsset_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetTypesProto.internal_static_google_ads_googleads_v17_common_CallAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(CallAsset.class, Builder.class);
    }

    @Override
    public String getCountryCode() {
        Object ref = this.countryCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.countryCode_ = s;
        return s;
    }

    @Override
    public ByteString getCountryCodeBytes() {
        Object ref = this.countryCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.countryCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPhoneNumber() {
        Object ref = this.phoneNumber_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.phoneNumber_ = s;
        return s;
    }

    @Override
    public ByteString getPhoneNumberBytes() {
        Object ref = this.phoneNumber_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.phoneNumber_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getCallConversionReportingStateValue() {
        return this.callConversionReportingState_;
    }

    @Override
    public CallConversionReportingStateEnum.CallConversionReportingState getCallConversionReportingState() {
        CallConversionReportingStateEnum.CallConversionReportingState result = CallConversionReportingStateEnum.CallConversionReportingState.forNumber(this.callConversionReportingState_);
        return result == null ? CallConversionReportingStateEnum.CallConversionReportingState.UNRECOGNIZED : result;
    }

    @Override
    public String getCallConversionAction() {
        Object ref = this.callConversionAction_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.callConversionAction_ = s;
        return s;
    }

    @Override
    public ByteString getCallConversionActionBytes() {
        Object ref = this.callConversionAction_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.callConversionAction_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AdScheduleInfo> getAdScheduleTargetsList() {
        return this.adScheduleTargets_;
    }

    @Override
    public List<? extends AdScheduleInfoOrBuilder> getAdScheduleTargetsOrBuilderList() {
        return this.adScheduleTargets_;
    }

    @Override
    public int getAdScheduleTargetsCount() {
        return this.adScheduleTargets_.size();
    }

    @Override
    public AdScheduleInfo getAdScheduleTargets(int index) {
        return this.adScheduleTargets_.get(index);
    }

    @Override
    public AdScheduleInfoOrBuilder getAdScheduleTargetsOrBuilder(int index) {
        return this.adScheduleTargets_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.countryCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.countryCode_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.phoneNumber_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.phoneNumber_);
        }
        if (this.callConversionReportingState_ != CallConversionReportingStateEnum.CallConversionReportingState.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.callConversionReportingState_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.callConversionAction_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.callConversionAction_);
        }
        for (int i = 0; i < this.adScheduleTargets_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.adScheduleTargets_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.countryCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.countryCode_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.phoneNumber_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.phoneNumber_);
        }
        if (this.callConversionReportingState_ != CallConversionReportingStateEnum.CallConversionReportingState.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.callConversionReportingState_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.callConversionAction_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.callConversionAction_);
        }
        for (int i = 0; i < this.adScheduleTargets_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.adScheduleTargets_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CallAsset)) {
            return super.equals(obj);
        }
        CallAsset other = (CallAsset)obj;
        if (!this.getCountryCode().equals(other.getCountryCode())) {
            return false;
        }
        if (!this.getPhoneNumber().equals(other.getPhoneNumber())) {
            return false;
        }
        if (this.callConversionReportingState_ != other.callConversionReportingState_) {
            return false;
        }
        if (!this.getCallConversionAction().equals(other.getCallConversionAction())) {
            return false;
        }
        if (!this.getAdScheduleTargetsList().equals(other.getAdScheduleTargetsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CallAsset.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCountryCode().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getPhoneNumber().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.callConversionReportingState_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getCallConversionAction().hashCode();
        if (this.getAdScheduleTargetsCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getAdScheduleTargetsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static CallAsset parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CallAsset)PARSER.parseFrom(data);
    }

    public static CallAsset parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CallAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CallAsset parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CallAsset)PARSER.parseFrom(data);
    }

    public static CallAsset parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CallAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CallAsset parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CallAsset)PARSER.parseFrom(data);
    }

    public static CallAsset parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CallAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CallAsset parseFrom(InputStream input) throws IOException {
        return (CallAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CallAsset parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CallAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CallAsset parseDelimitedFrom(InputStream input) throws IOException {
        return (CallAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CallAsset parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CallAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CallAsset parseFrom(CodedInputStream input) throws IOException {
        return (CallAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CallAsset parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CallAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CallAsset.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CallAsset prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CallAsset getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CallAsset> parser() {
        return PARSER;
    }

    public Parser<CallAsset> getParserForType() {
        return PARSER;
    }

    public CallAsset getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CallAssetOrBuilder {
        private int bitField0_;
        private Object countryCode_ = "";
        private Object phoneNumber_ = "";
        private int callConversionReportingState_ = 0;
        private Object callConversionAction_ = "";
        private List<AdScheduleInfo> adScheduleTargets_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AdScheduleInfo, AdScheduleInfo.Builder, AdScheduleInfoOrBuilder> adScheduleTargetsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetTypesProto.internal_static_google_ads_googleads_v17_common_CallAsset_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetTypesProto.internal_static_google_ads_googleads_v17_common_CallAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(CallAsset.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.countryCode_ = "";
            this.phoneNumber_ = "";
            this.callConversionReportingState_ = 0;
            this.callConversionAction_ = "";
            if (this.adScheduleTargetsBuilder_ == null) {
                this.adScheduleTargets_ = Collections.emptyList();
            } else {
                this.adScheduleTargets_ = null;
                this.adScheduleTargetsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFEF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetTypesProto.internal_static_google_ads_googleads_v17_common_CallAsset_descriptor;
        }

        public CallAsset getDefaultInstanceForType() {
            return CallAsset.getDefaultInstance();
        }

        public CallAsset build() {
            CallAsset result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CallAsset buildPartial() {
            CallAsset result = new CallAsset(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(CallAsset result) {
            if (this.adScheduleTargetsBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.adScheduleTargets_ = Collections.unmodifiableList(this.adScheduleTargets_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.adScheduleTargets_ = this.adScheduleTargets_;
            } else {
                result.adScheduleTargets_ = this.adScheduleTargetsBuilder_.build();
            }
        }

        private void buildPartial0(CallAsset result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.countryCode_ = this.countryCode_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.phoneNumber_ = this.phoneNumber_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.callConversionReportingState_ = this.callConversionReportingState_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.callConversionAction_ = this.callConversionAction_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CallAsset) {
                return this.mergeFrom((CallAsset)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CallAsset other) {
            if (other == CallAsset.getDefaultInstance()) {
                return this;
            }
            if (!other.getCountryCode().isEmpty()) {
                this.countryCode_ = other.countryCode_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getPhoneNumber().isEmpty()) {
                this.phoneNumber_ = other.phoneNumber_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.callConversionReportingState_ != 0) {
                this.setCallConversionReportingStateValue(other.getCallConversionReportingStateValue());
            }
            if (!other.getCallConversionAction().isEmpty()) {
                this.callConversionAction_ = other.callConversionAction_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (this.adScheduleTargetsBuilder_ == null) {
                if (!other.adScheduleTargets_.isEmpty()) {
                    if (this.adScheduleTargets_.isEmpty()) {
                        this.adScheduleTargets_ = other.adScheduleTargets_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensureAdScheduleTargetsIsMutable();
                        this.adScheduleTargets_.addAll(other.adScheduleTargets_);
                    }
                    this.onChanged();
                }
            } else if (!other.adScheduleTargets_.isEmpty()) {
                if (this.adScheduleTargetsBuilder_.isEmpty()) {
                    this.adScheduleTargetsBuilder_.dispose();
                    this.adScheduleTargetsBuilder_ = null;
                    this.adScheduleTargets_ = other.adScheduleTargets_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.adScheduleTargetsBuilder_ = alwaysUseFieldBuilders ? this.getAdScheduleTargetsFieldBuilder() : null;
                } else {
                    this.adScheduleTargetsBuilder_.addAllMessages((Iterable)other.adScheduleTargets_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 10: {
                            this.countryCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block13;
                        }
                        case 18: {
                            this.phoneNumber_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block13;
                        }
                        case 24: {
                            this.callConversionReportingState_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block13;
                        }
                        case 34: {
                            this.callConversionAction_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block13;
                        }
                        case 42: {
                            AdScheduleInfo m = (AdScheduleInfo)input.readMessage(AdScheduleInfo.parser(), extensionRegistry);
                            if (this.adScheduleTargetsBuilder_ == null) {
                                this.ensureAdScheduleTargetsIsMutable();
                                this.adScheduleTargets_.add(m);
                                continue block13;
                            }
                            this.adScheduleTargetsBuilder_.addMessage((AbstractMessage)m);
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCountryCode() {
            Object ref = this.countryCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.countryCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCountryCodeBytes() {
            Object ref = this.countryCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.countryCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCountryCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.countryCode_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCountryCode() {
            this.countryCode_ = CallAsset.getDefaultInstance().getCountryCode();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCountryCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CallAsset.checkByteStringIsUtf8((ByteString)value);
            this.countryCode_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getPhoneNumber() {
            Object ref = this.phoneNumber_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.phoneNumber_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPhoneNumberBytes() {
            Object ref = this.phoneNumber_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.phoneNumber_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPhoneNumber(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.phoneNumber_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearPhoneNumber() {
            this.phoneNumber_ = CallAsset.getDefaultInstance().getPhoneNumber();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setPhoneNumberBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CallAsset.checkByteStringIsUtf8((ByteString)value);
            this.phoneNumber_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getCallConversionReportingStateValue() {
            return this.callConversionReportingState_;
        }

        public Builder setCallConversionReportingStateValue(int value) {
            this.callConversionReportingState_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public CallConversionReportingStateEnum.CallConversionReportingState getCallConversionReportingState() {
            CallConversionReportingStateEnum.CallConversionReportingState result = CallConversionReportingStateEnum.CallConversionReportingState.forNumber(this.callConversionReportingState_);
            return result == null ? CallConversionReportingStateEnum.CallConversionReportingState.UNRECOGNIZED : result;
        }

        public Builder setCallConversionReportingState(CallConversionReportingStateEnum.CallConversionReportingState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.callConversionReportingState_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCallConversionReportingState() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.callConversionReportingState_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getCallConversionAction() {
            Object ref = this.callConversionAction_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.callConversionAction_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCallConversionActionBytes() {
            Object ref = this.callConversionAction_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.callConversionAction_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCallConversionAction(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.callConversionAction_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearCallConversionAction() {
            this.callConversionAction_ = CallAsset.getDefaultInstance().getCallConversionAction();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setCallConversionActionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CallAsset.checkByteStringIsUtf8((ByteString)value);
            this.callConversionAction_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private void ensureAdScheduleTargetsIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.adScheduleTargets_ = new ArrayList<AdScheduleInfo>(this.adScheduleTargets_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<AdScheduleInfo> getAdScheduleTargetsList() {
            if (this.adScheduleTargetsBuilder_ == null) {
                return Collections.unmodifiableList(this.adScheduleTargets_);
            }
            return this.adScheduleTargetsBuilder_.getMessageList();
        }

        @Override
        public int getAdScheduleTargetsCount() {
            if (this.adScheduleTargetsBuilder_ == null) {
                return this.adScheduleTargets_.size();
            }
            return this.adScheduleTargetsBuilder_.getCount();
        }

        @Override
        public AdScheduleInfo getAdScheduleTargets(int index) {
            if (this.adScheduleTargetsBuilder_ == null) {
                return this.adScheduleTargets_.get(index);
            }
            return (AdScheduleInfo)this.adScheduleTargetsBuilder_.getMessage(index);
        }

        public Builder setAdScheduleTargets(int index, AdScheduleInfo value) {
            if (this.adScheduleTargetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdScheduleTargetsIsMutable();
                this.adScheduleTargets_.set(index, value);
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdScheduleTargets(int index, AdScheduleInfo.Builder builderForValue) {
            if (this.adScheduleTargetsBuilder_ == null) {
                this.ensureAdScheduleTargetsIsMutable();
                this.adScheduleTargets_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdScheduleTargets(AdScheduleInfo value) {
            if (this.adScheduleTargetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdScheduleTargetsIsMutable();
                this.adScheduleTargets_.add(value);
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdScheduleTargets(int index, AdScheduleInfo value) {
            if (this.adScheduleTargetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdScheduleTargetsIsMutable();
                this.adScheduleTargets_.add(index, value);
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdScheduleTargets(AdScheduleInfo.Builder builderForValue) {
            if (this.adScheduleTargetsBuilder_ == null) {
                this.ensureAdScheduleTargetsIsMutable();
                this.adScheduleTargets_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdScheduleTargets(int index, AdScheduleInfo.Builder builderForValue) {
            if (this.adScheduleTargetsBuilder_ == null) {
                this.ensureAdScheduleTargetsIsMutable();
                this.adScheduleTargets_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdScheduleTargets(Iterable<? extends AdScheduleInfo> values) {
            if (this.adScheduleTargetsBuilder_ == null) {
                this.ensureAdScheduleTargetsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.adScheduleTargets_);
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdScheduleTargets() {
            if (this.adScheduleTargetsBuilder_ == null) {
                this.adScheduleTargets_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdScheduleTargets(int index) {
            if (this.adScheduleTargetsBuilder_ == null) {
                this.ensureAdScheduleTargetsIsMutable();
                this.adScheduleTargets_.remove(index);
                this.onChanged();
            } else {
                this.adScheduleTargetsBuilder_.remove(index);
            }
            return this;
        }

        public AdScheduleInfo.Builder getAdScheduleTargetsBuilder(int index) {
            return (AdScheduleInfo.Builder)this.getAdScheduleTargetsFieldBuilder().getBuilder(index);
        }

        @Override
        public AdScheduleInfoOrBuilder getAdScheduleTargetsOrBuilder(int index) {
            if (this.adScheduleTargetsBuilder_ == null) {
                return this.adScheduleTargets_.get(index);
            }
            return (AdScheduleInfoOrBuilder)this.adScheduleTargetsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AdScheduleInfoOrBuilder> getAdScheduleTargetsOrBuilderList() {
            if (this.adScheduleTargetsBuilder_ != null) {
                return this.adScheduleTargetsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.adScheduleTargets_);
        }

        public AdScheduleInfo.Builder addAdScheduleTargetsBuilder() {
            return (AdScheduleInfo.Builder)this.getAdScheduleTargetsFieldBuilder().addBuilder((AbstractMessage)AdScheduleInfo.getDefaultInstance());
        }

        public AdScheduleInfo.Builder addAdScheduleTargetsBuilder(int index) {
            return (AdScheduleInfo.Builder)this.getAdScheduleTargetsFieldBuilder().addBuilder(index, (AbstractMessage)AdScheduleInfo.getDefaultInstance());
        }

        public List<AdScheduleInfo.Builder> getAdScheduleTargetsBuilderList() {
            return this.getAdScheduleTargetsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AdScheduleInfo, AdScheduleInfo.Builder, AdScheduleInfoOrBuilder> getAdScheduleTargetsFieldBuilder() {
            if (this.adScheduleTargetsBuilder_ == null) {
                this.adScheduleTargetsBuilder_ = new RepeatedFieldBuilderV3(this.adScheduleTargets_, (this.bitField0_ & 0x10) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.adScheduleTargets_ = null;
            }
            return this.adScheduleTargetsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

