/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.common;

import com.google.ads.googleads.v17.common.AssetTypesProto;
import com.google.ads.googleads.v17.common.BusinessProfileLocation;
import com.google.ads.googleads.v17.common.BusinessProfileLocationOrBuilder;
import com.google.ads.googleads.v17.common.LocationAssetOrBuilder;
import com.google.ads.googleads.v17.enums.LocationOwnershipTypeEnum;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LocationAsset
extends GeneratedMessageV3
implements LocationAssetOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int PLACE_ID_FIELD_NUMBER = 1;
    private volatile Object placeId_ = "";
    public static final int BUSINESS_PROFILE_LOCATIONS_FIELD_NUMBER = 2;
    private List<BusinessProfileLocation> businessProfileLocations_;
    public static final int LOCATION_OWNERSHIP_TYPE_FIELD_NUMBER = 3;
    private int locationOwnershipType_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final LocationAsset DEFAULT_INSTANCE = new LocationAsset();
    private static final Parser<LocationAsset> PARSER = new AbstractParser<LocationAsset>(){

        public LocationAsset parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = LocationAsset.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private LocationAsset(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private LocationAsset() {
        this.placeId_ = "";
        this.businessProfileLocations_ = Collections.emptyList();
        this.locationOwnershipType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new LocationAsset();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetTypesProto.internal_static_google_ads_googleads_v17_common_LocationAsset_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetTypesProto.internal_static_google_ads_googleads_v17_common_LocationAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationAsset.class, Builder.class);
    }

    @Override
    public String getPlaceId() {
        Object ref = this.placeId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.placeId_ = s;
        return s;
    }

    @Override
    public ByteString getPlaceIdBytes() {
        Object ref = this.placeId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.placeId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<BusinessProfileLocation> getBusinessProfileLocationsList() {
        return this.businessProfileLocations_;
    }

    @Override
    public List<? extends BusinessProfileLocationOrBuilder> getBusinessProfileLocationsOrBuilderList() {
        return this.businessProfileLocations_;
    }

    @Override
    public int getBusinessProfileLocationsCount() {
        return this.businessProfileLocations_.size();
    }

    @Override
    public BusinessProfileLocation getBusinessProfileLocations(int index) {
        return this.businessProfileLocations_.get(index);
    }

    @Override
    public BusinessProfileLocationOrBuilder getBusinessProfileLocationsOrBuilder(int index) {
        return this.businessProfileLocations_.get(index);
    }

    @Override
    public int getLocationOwnershipTypeValue() {
        return this.locationOwnershipType_;
    }

    @Override
    public LocationOwnershipTypeEnum.LocationOwnershipType getLocationOwnershipType() {
        LocationOwnershipTypeEnum.LocationOwnershipType result = LocationOwnershipTypeEnum.LocationOwnershipType.forNumber(this.locationOwnershipType_);
        return result == null ? LocationOwnershipTypeEnum.LocationOwnershipType.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.placeId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.placeId_);
        }
        for (int i = 0; i < this.businessProfileLocations_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.businessProfileLocations_.get(i));
        }
        if (this.locationOwnershipType_ != LocationOwnershipTypeEnum.LocationOwnershipType.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.locationOwnershipType_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.placeId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.placeId_);
        }
        for (int i = 0; i < this.businessProfileLocations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.businessProfileLocations_.get(i)));
        }
        if (this.locationOwnershipType_ != LocationOwnershipTypeEnum.LocationOwnershipType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.locationOwnershipType_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocationAsset)) {
            return super.equals(obj);
        }
        LocationAsset other = (LocationAsset)obj;
        if (!this.getPlaceId().equals(other.getPlaceId())) {
            return false;
        }
        if (!this.getBusinessProfileLocationsList().equals(other.getBusinessProfileLocationsList())) {
            return false;
        }
        if (this.locationOwnershipType_ != other.locationOwnershipType_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + LocationAsset.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getPlaceId().hashCode();
        if (this.getBusinessProfileLocationsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getBusinessProfileLocationsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.locationOwnershipType_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static LocationAsset parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (LocationAsset)PARSER.parseFrom(data);
    }

    public static LocationAsset parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (LocationAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static LocationAsset parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (LocationAsset)PARSER.parseFrom(data);
    }

    public static LocationAsset parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (LocationAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static LocationAsset parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (LocationAsset)PARSER.parseFrom(data);
    }

    public static LocationAsset parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (LocationAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static LocationAsset parseFrom(InputStream input) throws IOException {
        return (LocationAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static LocationAsset parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (LocationAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static LocationAsset parseDelimitedFrom(InputStream input) throws IOException {
        return (LocationAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static LocationAsset parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (LocationAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static LocationAsset parseFrom(CodedInputStream input) throws IOException {
        return (LocationAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static LocationAsset parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (LocationAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return LocationAsset.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(LocationAsset prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static LocationAsset getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<LocationAsset> parser() {
        return PARSER;
    }

    public Parser<LocationAsset> getParserForType() {
        return PARSER;
    }

    public LocationAsset getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements LocationAssetOrBuilder {
        private int bitField0_;
        private Object placeId_ = "";
        private List<BusinessProfileLocation> businessProfileLocations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<BusinessProfileLocation, BusinessProfileLocation.Builder, BusinessProfileLocationOrBuilder> businessProfileLocationsBuilder_;
        private int locationOwnershipType_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetTypesProto.internal_static_google_ads_googleads_v17_common_LocationAsset_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetTypesProto.internal_static_google_ads_googleads_v17_common_LocationAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationAsset.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.placeId_ = "";
            if (this.businessProfileLocationsBuilder_ == null) {
                this.businessProfileLocations_ = Collections.emptyList();
            } else {
                this.businessProfileLocations_ = null;
                this.businessProfileLocationsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.locationOwnershipType_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetTypesProto.internal_static_google_ads_googleads_v17_common_LocationAsset_descriptor;
        }

        public LocationAsset getDefaultInstanceForType() {
            return LocationAsset.getDefaultInstance();
        }

        public LocationAsset build() {
            LocationAsset result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public LocationAsset buildPartial() {
            LocationAsset result = new LocationAsset(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(LocationAsset result) {
            if (this.businessProfileLocationsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.businessProfileLocations_ = Collections.unmodifiableList(this.businessProfileLocations_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.businessProfileLocations_ = this.businessProfileLocations_;
            } else {
                result.businessProfileLocations_ = this.businessProfileLocationsBuilder_.build();
            }
        }

        private void buildPartial0(LocationAsset result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.placeId_ = this.placeId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.locationOwnershipType_ = this.locationOwnershipType_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof LocationAsset) {
                return this.mergeFrom((LocationAsset)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(LocationAsset other) {
            if (other == LocationAsset.getDefaultInstance()) {
                return this;
            }
            if (!other.getPlaceId().isEmpty()) {
                this.placeId_ = other.placeId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (this.businessProfileLocationsBuilder_ == null) {
                if (!other.businessProfileLocations_.isEmpty()) {
                    if (this.businessProfileLocations_.isEmpty()) {
                        this.businessProfileLocations_ = other.businessProfileLocations_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureBusinessProfileLocationsIsMutable();
                        this.businessProfileLocations_.addAll(other.businessProfileLocations_);
                    }
                    this.onChanged();
                }
            } else if (!other.businessProfileLocations_.isEmpty()) {
                if (this.businessProfileLocationsBuilder_.isEmpty()) {
                    this.businessProfileLocationsBuilder_.dispose();
                    this.businessProfileLocationsBuilder_ = null;
                    this.businessProfileLocations_ = other.businessProfileLocations_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.businessProfileLocationsBuilder_ = alwaysUseFieldBuilders ? this.getBusinessProfileLocationsFieldBuilder() : null;
                } else {
                    this.businessProfileLocationsBuilder_.addAllMessages((Iterable)other.businessProfileLocations_);
                }
            }
            if (other.locationOwnershipType_ != 0) {
                this.setLocationOwnershipTypeValue(other.getLocationOwnershipTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            this.placeId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 18: {
                            BusinessProfileLocation m = (BusinessProfileLocation)input.readMessage(BusinessProfileLocation.parser(), extensionRegistry);
                            if (this.businessProfileLocationsBuilder_ == null) {
                                this.ensureBusinessProfileLocationsIsMutable();
                                this.businessProfileLocations_.add(m);
                                continue block11;
                            }
                            this.businessProfileLocationsBuilder_.addMessage((AbstractMessage)m);
                            continue block11;
                        }
                        case 24: {
                            this.locationOwnershipType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getPlaceId() {
            Object ref = this.placeId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.placeId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPlaceIdBytes() {
            Object ref = this.placeId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.placeId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPlaceId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.placeId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearPlaceId() {
            this.placeId_ = LocationAsset.getDefaultInstance().getPlaceId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setPlaceIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            LocationAsset.checkByteStringIsUtf8((ByteString)value);
            this.placeId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureBusinessProfileLocationsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.businessProfileLocations_ = new ArrayList<BusinessProfileLocation>(this.businessProfileLocations_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<BusinessProfileLocation> getBusinessProfileLocationsList() {
            if (this.businessProfileLocationsBuilder_ == null) {
                return Collections.unmodifiableList(this.businessProfileLocations_);
            }
            return this.businessProfileLocationsBuilder_.getMessageList();
        }

        @Override
        public int getBusinessProfileLocationsCount() {
            if (this.businessProfileLocationsBuilder_ == null) {
                return this.businessProfileLocations_.size();
            }
            return this.businessProfileLocationsBuilder_.getCount();
        }

        @Override
        public BusinessProfileLocation getBusinessProfileLocations(int index) {
            if (this.businessProfileLocationsBuilder_ == null) {
                return this.businessProfileLocations_.get(index);
            }
            return (BusinessProfileLocation)this.businessProfileLocationsBuilder_.getMessage(index);
        }

        public Builder setBusinessProfileLocations(int index, BusinessProfileLocation value) {
            if (this.businessProfileLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureBusinessProfileLocationsIsMutable();
                this.businessProfileLocations_.set(index, value);
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setBusinessProfileLocations(int index, BusinessProfileLocation.Builder builderForValue) {
            if (this.businessProfileLocationsBuilder_ == null) {
                this.ensureBusinessProfileLocationsIsMutable();
                this.businessProfileLocations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addBusinessProfileLocations(BusinessProfileLocation value) {
            if (this.businessProfileLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureBusinessProfileLocationsIsMutable();
                this.businessProfileLocations_.add(value);
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addBusinessProfileLocations(int index, BusinessProfileLocation value) {
            if (this.businessProfileLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureBusinessProfileLocationsIsMutable();
                this.businessProfileLocations_.add(index, value);
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addBusinessProfileLocations(BusinessProfileLocation.Builder builderForValue) {
            if (this.businessProfileLocationsBuilder_ == null) {
                this.ensureBusinessProfileLocationsIsMutable();
                this.businessProfileLocations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addBusinessProfileLocations(int index, BusinessProfileLocation.Builder builderForValue) {
            if (this.businessProfileLocationsBuilder_ == null) {
                this.ensureBusinessProfileLocationsIsMutable();
                this.businessProfileLocations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllBusinessProfileLocations(Iterable<? extends BusinessProfileLocation> values) {
            if (this.businessProfileLocationsBuilder_ == null) {
                this.ensureBusinessProfileLocationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.businessProfileLocations_);
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearBusinessProfileLocations() {
            if (this.businessProfileLocationsBuilder_ == null) {
                this.businessProfileLocations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.clear();
            }
            return this;
        }

        public Builder removeBusinessProfileLocations(int index) {
            if (this.businessProfileLocationsBuilder_ == null) {
                this.ensureBusinessProfileLocationsIsMutable();
                this.businessProfileLocations_.remove(index);
                this.onChanged();
            } else {
                this.businessProfileLocationsBuilder_.remove(index);
            }
            return this;
        }

        public BusinessProfileLocation.Builder getBusinessProfileLocationsBuilder(int index) {
            return (BusinessProfileLocation.Builder)this.getBusinessProfileLocationsFieldBuilder().getBuilder(index);
        }

        @Override
        public BusinessProfileLocationOrBuilder getBusinessProfileLocationsOrBuilder(int index) {
            if (this.businessProfileLocationsBuilder_ == null) {
                return this.businessProfileLocations_.get(index);
            }
            return (BusinessProfileLocationOrBuilder)this.businessProfileLocationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends BusinessProfileLocationOrBuilder> getBusinessProfileLocationsOrBuilderList() {
            if (this.businessProfileLocationsBuilder_ != null) {
                return this.businessProfileLocationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.businessProfileLocations_);
        }

        public BusinessProfileLocation.Builder addBusinessProfileLocationsBuilder() {
            return (BusinessProfileLocation.Builder)this.getBusinessProfileLocationsFieldBuilder().addBuilder((AbstractMessage)BusinessProfileLocation.getDefaultInstance());
        }

        public BusinessProfileLocation.Builder addBusinessProfileLocationsBuilder(int index) {
            return (BusinessProfileLocation.Builder)this.getBusinessProfileLocationsFieldBuilder().addBuilder(index, (AbstractMessage)BusinessProfileLocation.getDefaultInstance());
        }

        public List<BusinessProfileLocation.Builder> getBusinessProfileLocationsBuilderList() {
            return this.getBusinessProfileLocationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<BusinessProfileLocation, BusinessProfileLocation.Builder, BusinessProfileLocationOrBuilder> getBusinessProfileLocationsFieldBuilder() {
            if (this.businessProfileLocationsBuilder_ == null) {
                this.businessProfileLocationsBuilder_ = new RepeatedFieldBuilderV3(this.businessProfileLocations_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.businessProfileLocations_ = null;
            }
            return this.businessProfileLocationsBuilder_;
        }

        @Override
        public int getLocationOwnershipTypeValue() {
            return this.locationOwnershipType_;
        }

        public Builder setLocationOwnershipTypeValue(int value) {
            this.locationOwnershipType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public LocationOwnershipTypeEnum.LocationOwnershipType getLocationOwnershipType() {
            LocationOwnershipTypeEnum.LocationOwnershipType result = LocationOwnershipTypeEnum.LocationOwnershipType.forNumber(this.locationOwnershipType_);
            return result == null ? LocationOwnershipTypeEnum.LocationOwnershipType.UNRECOGNIZED : result;
        }

        public Builder setLocationOwnershipType(LocationOwnershipTypeEnum.LocationOwnershipType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.locationOwnershipType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearLocationOwnershipType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.locationOwnershipType_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

